/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.util.EditorScrollingPositionKeeper;
import com.intellij.openapi.editor.impl.ImaginaryEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.MathUtil;
import com.jetbrains.cidr.lang.parser.OCLexerTokenTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCatchSection;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCStatementWithExpression;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCBraceToggleBaseIntentionAction
extends PsiElementBaseIntentionAction {
    @NonNls
    protected String myKeywordName = "";

    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            OCBraceToggleBaseIntentionAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    protected PsiElement getBodyElement(@NotNull OCStatement statement, @NotNull PsiElement element) {
        if (statement == null) {
            OCBraceToggleBaseIntentionAction.$$$reportNull$$$0(1);
        }
        if (element == null) {
            OCBraceToggleBaseIntentionAction.$$$reportNull$$$0(2);
        }
        OCStatement expr = null;
        if (statement instanceof OCStatementWithExpression) {
            OCStatementWithExpression stmtWithExpr = (OCStatementWithExpression)statement;
            if (!(statement instanceof OCCatchSection)) {
                return stmtWithExpr.getBody();
            }
        }
        if (!(statement instanceof OCIfStatement)) return expr;
        OCIfStatement ifStatement = (OCIfStatement)statement;
        return OCBraceToggleBaseIntentionAction.isAfterElse(ifStatement, element) ? ifStatement.getElseBranch() : ifStatement.getThenBranch();
    }

    @NonNls
    @NotNull
    protected String getStatementName() {
        String string = this.myKeywordName;
        if (string == null) {
            OCBraceToggleBaseIntentionAction.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        OCStatement statement;
        if (project == null) {
            OCBraceToggleBaseIntentionAction.$$$reportNull$$$0(4);
        }
        if (element == null) {
            OCBraceToggleBaseIntentionAction.$$$reportNull$$$0(5);
        }
        if ((statement = OCBraceToggleBaseIntentionAction.getParentStatement(element)) == null || statement instanceof OCCatchSection) {
            return false;
        }
        this.myKeywordName = OCBraceToggleBaseIntentionAction.getKeywordName(statement, element);
        return this.isValidElement(statement, element);
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            OCBraceToggleBaseIntentionAction.$$$reportNull$$$0(6);
        }
        if (element == null) {
            OCBraceToggleBaseIntentionAction.$$$reportNull$$$0(7);
        }
        if (editor instanceof ImaginaryEditor) {
            this.doRun(project, editor, element);
        } else {
            EditorScrollingPositionKeeper.perform((Editor)editor, (boolean)false, () -> this.doRun(project, editor, element));
        }
    }

    protected abstract boolean isValidElement(@NotNull OCStatement var1, @NotNull PsiElement var2);

    protected abstract void doRun(@NotNull Project var1, Editor var2, @NotNull PsiElement var3) throws IncorrectOperationException;

    @NotNull
    protected static PsiElement getMacroOrElement(@NotNull PsiElement elem) {
        if (elem == null) {
            OCBraceToggleBaseIntentionAction.$$$reportNull$$$0(8);
        }
        return OCBraceToggleBaseIntentionAction.getMacroOrElement(elem, elem.getPrevSibling());
    }

    @NotNull
    protected static PsiElement getMacroOrElement(@NotNull PsiElement element, @Nullable PsiElement prevSibling) {
        if (element == null) {
            OCBraceToggleBaseIntentionAction.$$$reportNull$$$0(9);
        }
        PsiElement psiElement = prevSibling instanceof OCMacroCall ? prevSibling : element;
        if (psiElement == null) {
            OCBraceToggleBaseIntentionAction.$$$reportNull$$$0(10);
        }
        return psiElement;
    }

    private static boolean isAfterElse(@NotNull OCIfStatement ifStmt, @NotNull PsiElement start) {
        if (ifStmt == null) {
            OCBraceToggleBaseIntentionAction.$$$reportNull$$$0(11);
        }
        if (start == null) {
            OCBraceToggleBaseIntentionAction.$$$reportNull$$$0(12);
        }
        if (start.getNode().getElementType() == OCTokenTypes.ELSE_KEYWORD) {
            return true;
        }
        ASTNode elseKeyword = ifStmt.getElseKeyword();
        if (elseKeyword == null) {
            return false;
        }
        int elseOffset = elseKeyword.getStartOffset();
        return start.getTextOffset() >= elseOffset;
    }

    @NotNull
    private static String getKeywordName(@NotNull OCStatement statement, @NotNull PsiElement element) {
        if (statement == null) {
            OCBraceToggleBaseIntentionAction.$$$reportNull$$$0(13);
        }
        if (element == null) {
            OCBraceToggleBaseIntentionAction.$$$reportNull$$$0(14);
        }
        if (statement instanceof OCStatementWithExpression) {
            OCStatementWithExpression stmtWithExpr = (OCStatementWithExpression)statement;
            String string = stmtWithExpr.getKeywordType().getName();
            if (string == null) {
                OCBraceToggleBaseIntentionAction.$$$reportNull$$$0(15);
            }
            return string;
        }
        if (statement instanceof OCIfStatement) {
            OCIfStatement ifStmt = (OCIfStatement)statement;
            String string = OCBraceToggleBaseIntentionAction.isAfterElse(ifStmt, element) ? OCTokenTypes.ELSE_KEYWORD.getName() : OCTokenTypes.IF_KEYWORD.getName();
            if (string == null) {
                OCBraceToggleBaseIntentionAction.$$$reportNull$$$0(16);
            }
            return string;
        }
        return "";
    }

    @Nullable
    protected static OCStatement getParentStatement(@NotNull PsiElement element) {
        if (element == null) {
            OCBraceToggleBaseIntentionAction.$$$reportNull$$$0(17);
        }
        return (OCStatement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{OCStatementWithExpression.class, OCIfStatement.class});
    }

    @NotNull
    protected static PsiElement getRightMostMacroCallOrWhiteSpaceSibling(@NotNull PsiElement element) {
        if (element == null) {
            OCBraceToggleBaseIntentionAction.$$$reportNull$$$0(18);
        }
        PsiElement result = element;
        while (result.getNextSibling() != null && OCBraceToggleBaseIntentionAction.isMacroCallOrWhiteSpace(result.getNextSibling())) {
            result = result.getNextSibling();
        }
        PsiElement psiElement = result;
        if (psiElement == null) {
            OCBraceToggleBaseIntentionAction.$$$reportNull$$$0(19);
        }
        return psiElement;
    }

    @NotNull
    protected static PsiElement getLeftMostMacroCallOrWhiteSpaceSibling(@NotNull PsiElement element) {
        if (element == null) {
            OCBraceToggleBaseIntentionAction.$$$reportNull$$$0(20);
        }
        PsiElement result = element;
        while (result.getPrevSibling() != null && OCBraceToggleBaseIntentionAction.isMacroCallOrWhiteSpace(result.getPrevSibling())) {
            result = result.getPrevSibling();
        }
        PsiElement psiElement = result;
        if (psiElement == null) {
            OCBraceToggleBaseIntentionAction.$$$reportNull$$$0(21);
        }
        return psiElement;
    }

    private static boolean isMacroCallOrWhiteSpace(@NotNull PsiElement element) {
        if (element == null) {
            OCBraceToggleBaseIntentionAction.$$$reportNull$$$0(22);
        }
        return element instanceof OCMacroCall || OCLexerTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(OCElementUtil.getElementType(element));
    }

    @NotNull
    protected static PsiElement getFirstMacroElement(@NotNull PsiElement elem) {
        if (elem == null) {
            OCBraceToggleBaseIntentionAction.$$$reportNull$$$0(23);
        }
        PsiElement cur = elem;
        while (cur.getPrevSibling() instanceof OCMacroCall) {
            cur = cur.getPrevSibling();
        }
        PsiElement psiElement = cur;
        if (psiElement == null) {
            OCBraceToggleBaseIntentionAction.$$$reportNull$$$0(24);
        }
        return psiElement;
    }

    protected static int getCaretAdjustment(@NotNull CaretModel caretModel, @NotNull PsiElement element) {
        if (caretModel == null) {
            OCBraceToggleBaseIntentionAction.$$$reportNull$$$0(25);
        }
        if (element == null) {
            OCBraceToggleBaseIntentionAction.$$$reportNull$$$0(26);
        }
        PsiElement offsetAnchor = OCBraceToggleBaseIntentionAction.getFirstMacroElement(element);
        int caretOffset = caretModel.getOffset();
        return Math.max(0, caretOffset - offsetAnchor.getTextOffset());
    }

    protected static void moveCaret(@NotNull CaretModel caretModel, int moveCaretBy, @NotNull PsiElement insertedElem) {
        if (caretModel == null) {
            OCBraceToggleBaseIntentionAction.$$$reportNull$$$0(27);
        }
        if (insertedElem == null) {
            OCBraceToggleBaseIntentionAction.$$$reportNull$$$0(28);
        }
        if (caretModel.getCaretCount() != 1) {
            return;
        }
        PsiElement offsetAnchor = OCBraceToggleBaseIntentionAction.getFirstMacroElement(insertedElem);
        TextRange elemRange = offsetAnchor.getTextRange();
        int startOffset = elemRange.getStartOffset();
        int endOffset = elemRange.getEndOffset();
        int newCaretOffset = MathUtil.clamp((int)(startOffset + moveCaretBy), (int)startOffset, (int)endOffset);
        caretModel.moveToOffset(newCaretOffset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void reformat(@NotNull Project project, @NotNull Document document, @NotNull OCStatement statement) {
        if (project == null) {
            OCBraceToggleBaseIntentionAction.$$$reportNull$$$0(29);
        }
        if (document == null) {
            OCBraceToggleBaseIntentionAction.$$$reportNull$$$0(30);
        }
        if (statement == null) {
            OCBraceToggleBaseIntentionAction.$$$reportNull$$$0(31);
        }
        RangeMarker formatRange = document.createRangeMarker(statement.getTextRange());
        try {
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
            OCFile file = statement.getContainingOCFile();
            PsiDocumentManager.getInstance((Project)project).commitDocument(document);
            OCChangeUtil.processPostponedFormatIfNeed(file);
            if (formatRange.isValid()) {
                codeStyleManager.reformatText((PsiFile)file, formatRange.getStartOffset(), formatRange.getEndOffset());
            }
        }
        finally {
            formatRange.dispose();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 4, 5, 6, 7, 8, 9, 11, 12, 13, 14, 17, 18, 20, 22, 23, 25, 26, 27, 28, 29, 30, 31 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/intentions/OCBraceToggleBaseIntentionAction";
                break;
            }
            case 1: 
            case 13: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 14: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 6: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elem";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ifStmt";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretModel";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insertedElem";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/intentions/OCBraceToggleBaseIntentionAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatementName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getMacroOrElement";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeywordName";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getRightMostMacroCallOrWhiteSpaceSibling";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getLeftMostMacroCallOrWhiteSpaceSibling";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getFirstMacroElement";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getBodyElement";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getMacroOrElement";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isAfterElse";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getKeywordName";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getParentStatement";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getRightMostMacroCallOrWhiteSpaceSibling";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getLeftMostMacroCallOrWhiteSpaceSibling";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isMacroCallOrWhiteSpace";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getFirstMacroElement";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getCaretAdjustment";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "moveCaret";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "reformat";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 4, 5, 6, 7, 8, 9, 11, 12, 13, 14, 17, 18, 20, 22, 23, 25, 26, 27, 28, 29, 30, 31 -> new IllegalArgumentException(string);
        };
    }
}

