/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.hierarchy.structureVIew;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.jetbrains.cidr.lang.hierarchy.structureVIew.OCMark;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCEnum;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCPragma;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCAliasUsingSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCElementNameUtil {
    @NlsSafe
    private static final String UNKNOWN = "<unknown>";
    public static final String QSEP = "::";
    public static final String IDSEP = " : ";

    @Nullable
    public static OCSymbol getSymbolIfAny(@Nullable PsiElement element) {
        return element != null && FileSymbolTablesCache.getInstance(element.getProject()).areSymbolsLoaded() && element instanceof OCSymbolDeclarator && element.isValid() ? (OCSymbol)((OCSymbolDeclarator)element).getSymbol() : null;
    }

    @NotNull
    public static Pair<String, Boolean> getPresentableNameAndQNOwnership(@Nullable PsiElement element, boolean showQualifiedNames) {
        OCSymbol symbol = OCElementNameUtil.getSymbolIfAny(element);
        if (symbol instanceof OCMacroSymbol) {
            Pair<String, Boolean> pair = OCElementNameUtil.ignoreQNOwnership(((OCMacroSymbol)symbol).getPresentableSignature());
            if (pair == null) {
                OCElementNameUtil.$$$reportNull$$$0(0);
            }
            return pair;
        }
        if (symbol instanceof OCFunctionSymbol) {
            Pair<String, Boolean> pair = OCElementNameUtil.checkQNOwnership(OCElementNameUtil.getFunctionName((OCFunctionSymbol)symbol, element, showQualifiedNames));
            if (pair == null) {
                OCElementNameUtil.$$$reportNull$$$0(1);
            }
            return pair;
        }
        if (symbol instanceof OCDeclaratorSymbol) {
            Pair<String, Boolean> pair = OCElementNameUtil.checkQNOwnership(OCElementNameUtil.getPresentableText((OCDeclaratorSymbol)symbol, element, showQualifiedNames));
            if (pair == null) {
                OCElementNameUtil.$$$reportNull$$$0(2);
            }
            return pair;
        }
        if (symbol instanceof OCStructSymbol) {
            Pair<String, Boolean> pair = OCElementNameUtil.ignoreQNOwnership(OCElementNameUtil.getStructName((OCStructSymbol)symbol, element, showQualifiedNames));
            if (pair == null) {
                OCElementNameUtil.$$$reportNull$$$0(3);
            }
            return pair;
        }
        if (element instanceof PsiFile) {
            Pair<String, Boolean> pair = OCElementNameUtil.ignoreQNOwnership(((PsiFile)element).getName());
            if (pair == null) {
                OCElementNameUtil.$$$reportNull$$$0(4);
            }
            return pair;
        }
        if (element instanceof OCMethod) {
            Pair<String, Boolean> pair = OCElementNameUtil.ignoreQNOwnership(((OCMethod)element).getSelector());
            if (pair == null) {
                OCElementNameUtil.$$$reportNull$$$0(5);
            }
            return pair;
        }
        if (symbol instanceof OCAliasUsingSymbol) {
            Pair<String, Boolean> pair = OCElementNameUtil.ignoreQNOwnership(OCElementNameUtil.getPresentableText((OCAliasUsingSymbol)symbol, element));
            if (pair == null) {
                OCElementNameUtil.$$$reportNull$$$0(6);
            }
            return pair;
        }
        if (element instanceof OCClassDeclaration) {
            OCClassDeclaration cls = (OCClassDeclaration)element;
            String name = cls.getName();
            if (name == null) {
                Pair<String, Boolean> pair = OCElementNameUtil.ignoreQNOwnership("<unnamed>");
                if (pair == null) {
                    OCElementNameUtil.$$$reportNull$$$0(7);
                }
                return pair;
            }
            Pair<String, Boolean> pair = OCElementNameUtil.ignoreQNOwnership(OCCodeInsightUtil.getClassNameWithCategory(name, cls.getCategory()));
            if (pair == null) {
                OCElementNameUtil.$$$reportNull$$$0(8);
            }
            return pair;
        }
        if (OCElementNameUtil.isMark(element)) {
            OCMark mark = OCMark.createFromElement(element);
            Pair<String, Boolean> pair = OCElementNameUtil.ignoreQNOwnership(mark != null && mark.getText() != null ? mark.getText() : "<unnamed>");
            if (pair == null) {
                OCElementNameUtil.$$$reportNull$$$0(9);
            }
            return pair;
        }
        if (element instanceof PsiNameIdentifierOwner) {
            String name = ((PsiNameIdentifierOwner)element).getName();
            if (name == null && element instanceof OCEnum) {
                @NlsSafe StringBuilder builder2 = new StringBuilder("enum {");
                boolean first = true;
                for (OCDeclaration field : ((OCEnum)element).getFields()) {
                    if (first) {
                        first = false;
                    } else {
                        builder2.append(", ");
                    }
                    if (builder2.length() > 30) {
                        builder2.append("...");
                        break;
                    }
                    builder2.append(field.getDeclarators().get(0).getName());
                }
                builder2.append("}");
                Pair<String, Boolean> pair = OCElementNameUtil.ignoreQNOwnership(builder2.toString());
                if (pair == null) {
                    OCElementNameUtil.$$$reportNull$$$0(10);
                }
                return pair;
            }
            Pair<String, Boolean> pair = OCElementNameUtil.ignoreQNOwnership(name == null ? "<unnamed>" : name);
            if (pair == null) {
                OCElementNameUtil.$$$reportNull$$$0(11);
            }
            return pair;
        }
        Pair<String, Boolean> pair = OCElementNameUtil.ignoreQNOwnership(UNKNOWN);
        if (pair == null) {
            OCElementNameUtil.$$$reportNull$$$0(12);
        }
        return pair;
    }

    private static Pair<String, Boolean> checkQNOwnership(@NotNull String name) {
        if (name == null) {
            OCElementNameUtil.$$$reportNull$$$0(13);
        }
        return Pair.create((Object)name, (Object)(name.lastIndexOf(QSEP) >= 0 ? 1 : 0));
    }

    private static Pair<String, Boolean> ignoreQNOwnership(@NotNull String name) {
        if (name == null) {
            OCElementNameUtil.$$$reportNull$$$0(14);
        }
        return Pair.create((Object)name, (Object)false);
    }

    @NotNull
    static String getFunctionName(@NotNull OCFunctionSymbol symbol, @NotNull PsiElement element, boolean showQualifiedNames) {
        OCNamespaceSymbol nsSymbol;
        PsiElement gparent;
        PsiElement parent;
        if (symbol == null) {
            OCElementNameUtil.$$$reportNull$$$0(15);
        }
        if (element == null) {
            OCElementNameUtil.$$$reportNull$$$0(16);
        }
        if ((parent = element) instanceof OCDeclarator) {
            parent = parent.getParent();
        }
        if ((gparent = parent.getParent()) instanceof OCStructLike) {
            String string = symbol.getSignatureWithoutParamNames();
            if (string == null) {
                OCElementNameUtil.$$$reportNull$$$0(17);
            }
            return string;
        }
        String fullQName = symbol.getSignatureWithoutParamNames(true, true, OCResolveContext.forPsi(element));
        if (gparent instanceof OCCppNamespace && (nsSymbol = (OCNamespaceSymbol)((OCCppNamespace)gparent).getSymbol()) != null) {
            String nsPrefix = nsSymbol.getName() + QSEP;
            fullQName = StringUtil.trimStart((String)fullQName, (String)nsPrefix);
        }
        return OCElementNameUtil.convertNameByOptions(showQualifiedNames, fullQName);
    }

    @NotNull
    static String getStructName(@NotNull OCStructSymbol symbol, @NotNull PsiElement element, boolean showQualifiedNames) {
        if (symbol == null) {
            OCElementNameUtil.$$$reportNull$$$0(18);
        }
        if (element == null) {
            OCElementNameUtil.$$$reportNull$$$0(19);
        }
        StringBuilder result = new StringBuilder(OCElementNameUtil.convertNameByOptions(showQualifiedNames, symbol.getQualifiedName().toString()));
        List<OCTypeArgument> specialization = symbol.getTemplateSpecialization();
        if (specialization != null && !specialization.isEmpty()) {
            boolean first = true;
            result.append('<');
            for (OCTypeArgument argument : specialization) {
                if (first) {
                    first = false;
                } else {
                    result.append(", ");
                }
                result.append(argument.getShortName(0));
            }
            result.append('>');
        } else {
            List<OCTypeParameterSymbol> parameters = symbol.getTemplateParameters();
            if (!parameters.isEmpty()) {
                boolean first = true;
                result.append('<');
                for (OCTypeParameterSymbol parameter : parameters) {
                    if (first) {
                        first = false;
                    } else {
                        result.append(", ");
                    }
                    result.append(parameter.getName());
                }
                result.append('>');
            }
        }
        String string = result.toString();
        if (string == null) {
            OCElementNameUtil.$$$reportNull$$$0(20);
        }
        return string;
    }

    @NotNull
    private static String getPresentableText(@NotNull OCAliasUsingSymbol symbol, @Nullable PsiElement element) {
        if (symbol == null) {
            OCElementNameUtil.$$$reportNull$$$0(21);
        }
        StringBuilder buffer = new StringBuilder();
        String symbolName = element != null ? symbol.getQualifiedName().getFullName(OCResolveContext.forPsi(element)) : symbol.getQualifiedName().getNameWithParent();
        String typeName = symbol.getType().getName();
        buffer.append(symbolName).append(IDSEP).append(typeName);
        String string = buffer.toString();
        if (string == null) {
            OCElementNameUtil.$$$reportNull$$$0(22);
        }
        return string;
    }

    @NotNull
    static String getPresentableText(@NotNull OCDeclaratorSymbol symbol, @NotNull PsiElement element, boolean showQualifiedNames) {
        String typeName;
        if (symbol == null) {
            OCElementNameUtil.$$$reportNull$$$0(23);
        }
        if (element == null) {
            OCElementNameUtil.$$$reportNull$$$0(24);
        }
        StringBuilder buffer = new StringBuilder();
        OCResolveContext context = OCResolveContext.forPsi(element);
        String symbolName = symbol.getQualifiedName().getFullName(context);
        buffer.append(OCElementNameUtil.convertNameByOptions(showQualifiedNames, symbolName));
        if (symbol.getKind() != OCSymbolKind.ENUM_CONST && !Objects.equals(typeName = symbol.getType().getName(context), symbolName)) {
            buffer.append(IDSEP).append(typeName);
        }
        String string = buffer.toString();
        if (string == null) {
            OCElementNameUtil.$$$reportNull$$$0(25);
        }
        return string;
    }

    static boolean isMark(PsiElement element) {
        return element instanceof OCPragma || element instanceof PsiComment;
    }

    @NotNull
    static String convertNameByOptions(boolean showQualifiedNames, @NotNull String fullQName) {
        if (fullQName == null) {
            OCElementNameUtil.$$$reportNull$$$0(26);
        }
        if (showQualifiedNames) {
            String string = fullQName;
            if (string == null) {
                OCElementNameUtil.$$$reportNull$$$0(27);
            }
            return string;
        }
        int pos = fullQName.lastIndexOf(QSEP);
        if (pos < 0) {
            String string = fullQName;
            if (string == null) {
                OCElementNameUtil.$$$reportNull$$$0(28);
            }
            return string;
        }
        String string = fullQName.substring(pos + QSEP.length());
        if (string == null) {
            OCElementNameUtil.$$$reportNull$$$0(29);
        }
        return string;
    }

    @NotNull
    public static String stripLastID(@NotNull String fullQNameWithID) {
        int pos;
        if (fullQNameWithID == null) {
            OCElementNameUtil.$$$reportNull$$$0(30);
        }
        if ((pos = fullQNameWithID.lastIndexOf(QSEP)) < 0) {
            String string = fullQNameWithID;
            if (string == null) {
                OCElementNameUtil.$$$reportNull$$$0(31);
            }
            return string;
        }
        String string = fullQNameWithID.substring(0, pos + QSEP.length());
        if (string == null) {
            OCElementNameUtil.$$$reportNull$$$0(32);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 13, 14, 15, 16, 18, 19, 21, 23, 24, 26, 30 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/hierarchy/structureVIew/OCElementNameUtil";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 15: 
            case 18: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 16: 
            case 19: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullQName";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullQNameWithID";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableNameAndQNOwnership";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/hierarchy/structureVIew/OCElementNameUtil";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionName";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getStructName";
                break;
            }
            case 22: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableText";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "convertNameByOptions";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "stripLastID";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "checkQNOwnership";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "ignoreQNOwnership";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionName";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getStructName";
                break;
            }
            case 21: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableText";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "convertNameByOptions";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "stripLastID";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 13, 14, 15, 16, 18, 19, 21, 23, 24, 26, 30 -> new IllegalArgumentException(string);
        };
    }
}

