/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.hierarchy.include;

import com.intellij.icons.AllIcons;
import com.intellij.ide.hierarchy.ChangeHierarchyViewActionBase;
import com.intellij.ide.hierarchy.HierarchyBrowserBaseEx;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.ide.util.treeView.AlphaComparator;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.ui.PopupHandler;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.hierarchy.OCClassHierarchyNodeDescriptor;
import com.jetbrains.cidr.lang.hierarchy.include.OCImportSubHierarchyTreeStructure;
import com.jetbrains.cidr.lang.hierarchy.include.OCImportSuperHierarchyTreeStructure;
import com.jetbrains.cidr.lang.preprocessor.OCRootKind;
import com.jetbrains.cidr.lang.psi.OCFile;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCIncludeHierarchyBrowser
extends HierarchyBrowserBaseEx {
    private static final Logger LOG = Logger.getInstance(OCIncludeHierarchyBrowser.class);
    public static final String INCLUDING_HIERARCHY_TYPE = OCBundle.message("navigation.import.hierarchy.including.title", new Object[0]);
    public static final String INCLUDED_BY_HIERARCHY_TYPE = OCBundle.message("navigation.import.hierarchy.included.title", new Object[0]);
    private boolean myIsImplementation;

    public OCIncludeHierarchyBrowser(@NotNull Project project, @NotNull OCFile file) {
        if (project == null) {
            OCIncludeHierarchyBrowser.$$$reportNull$$$0(0);
        }
        if (file == null) {
            OCIncludeHierarchyBrowser.$$$reportNull$$$0(1);
        }
        super(project, (PsiElement)file);
    }

    public boolean isImplementation() {
        return this.myIsImplementation;
    }

    protected void setHierarchyBase(@NotNull PsiElement element) {
        if (element == null) {
            OCIncludeHierarchyBrowser.$$$reportNull$$$0(2);
        }
        super.setHierarchyBase(element);
        this.myIsImplementation = element instanceof OCFile && OCRootKind.getRootKind((OCFile)element) == OCRootKind.Root;
    }

    @Nullable
    protected PsiElement getElementFromDescriptor(@NotNull HierarchyNodeDescriptor descriptor) {
        if (descriptor == null) {
            OCIncludeHierarchyBrowser.$$$reportNull$$$0(3);
        }
        if (!(descriptor instanceof OCClassHierarchyNodeDescriptor)) {
            return null;
        }
        return ((OCClassHierarchyNodeDescriptor)descriptor).getType();
    }

    @NotNull
    protected String getPrevOccurenceActionNameImpl() {
        String string = OCBundle.message("navigation.import.hierarchy.previous.occurence", new Object[0]);
        if (string == null) {
            OCIncludeHierarchyBrowser.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    protected String getNextOccurenceActionNameImpl() {
        String string = OCBundle.message("navigation.import.hierarchy.next.occurence", new Object[0]);
        if (string == null) {
            OCIncludeHierarchyBrowser.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    protected String getActionPlace() {
        return "TypeHierarchyViewToolbar";
    }

    protected boolean isApplicableElement(@NotNull PsiElement element) {
        if (element == null) {
            OCIncludeHierarchyBrowser.$$$reportNull$$$0(6);
        }
        return element instanceof OCFile;
    }

    @Nullable
    protected Comparator<NodeDescriptor<?>> getComparator() {
        return AlphaComparator.getInstance();
    }

    @Nullable
    protected HierarchyTreeStructure createHierarchyTreeStructure(@NotNull String typeName, @NotNull PsiElement element) {
        if (typeName == null) {
            OCIncludeHierarchyBrowser.$$$reportNull$$$0(7);
        }
        if (element == null) {
            OCIncludeHierarchyBrowser.$$$reportNull$$$0(8);
        }
        if (element instanceof OCFile) {
            if (OCIncludeHierarchyBrowser.getIncludedByHierarchyType().equals(typeName)) {
                return new OCImportSubHierarchyTreeStructure(this.myProject, (OCFile)element);
            }
            return new OCImportSuperHierarchyTreeStructure(this.myProject, (OCFile)element);
        }
        LOG.error("unexpected type: " + typeName);
        return null;
    }

    @Nullable
    protected JPanel createLegendPanel() {
        return null;
    }

    protected void createTrees(@NotNull Map<? super @Nls String, ? super JTree> trees) {
        if (trees == null) {
            OCIncludeHierarchyBrowser.$$$reportNull$$$0(9);
        }
        DefaultActionGroup group = new DefaultActionGroup();
        JTree tree1 = this.createTree(true);
        PopupHandler.installPopupMenu((JComponent)tree1, (ActionGroup)group, (String)"TypeHierarchyViewPopup");
        trees.put(OCIncludeHierarchyBrowser.getIncludingHierarchyType(), tree1);
        JTree tree2 = this.createTree(true);
        PopupHandler.installPopupMenu((JComponent)tree2, (ActionGroup)group, (String)"TypeHierarchyViewPopup");
        trees.put(OCIncludeHierarchyBrowser.getIncludedByHierarchyType(), tree2);
    }

    @NotNull
    protected Map<String, Supplier<String>> getPresentableNameMap() {
        HashMap<String, Supplier<String>> map2 = new HashMap<String, Supplier<String>>();
        map2.put(INCLUDING_HIERARCHY_TYPE, OCIncludeHierarchyBrowser::getIncludingHierarchyType);
        map2.put(INCLUDED_BY_HIERARCHY_TYPE, OCIncludeHierarchyBrowser::getIncludedByHierarchyType);
        HashMap<String, Supplier<String>> hashMap = map2;
        if (hashMap == null) {
            OCIncludeHierarchyBrowser.$$$reportNull$$$0(10);
        }
        return hashMap;
    }

    protected void prependActions(@NotNull DefaultActionGroup actionGroup) {
        if (actionGroup == null) {
            OCIncludeHierarchyBrowser.$$$reportNull$$$0(11);
        }
        actionGroup.add((AnAction)new ViewIncludedHierarchyAction());
        actionGroup.add((AnAction)new ViewIncludingHierarchyAction());
        super.prependActions(actionGroup);
    }

    @Nls
    public static String getIncludingHierarchyType() {
        return OCBundle.message("navigation.import.hierarchy.including.title", new Object[0]);
    }

    @Nls
    public static String getIncludedByHierarchyType() {
        return OCBundle.message("navigation.import.hierarchy.included.title", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 4: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/hierarchy/include/OCIncludeHierarchyBrowser";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trees";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/hierarchy/include/OCIncludeHierarchyBrowser";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrevOccurenceActionNameImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNextOccurenceActionNameImpl";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableNameMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setHierarchyBase";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getElementFromDescriptor";
                break;
            }
            case 4: 
            case 5: 
            case 10: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableElement";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createHierarchyTreeStructure";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createTrees";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "prependActions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 10 -> new IllegalStateException(string);
        };
    }

    static class ViewIncludedHierarchyAction
    extends ChangeViewAction {
        ViewIncludedHierarchyAction() {
            super(OCBundle.messagePointer("navigation.import.hierarchy.included.action", new Object[0]), OCBundle.messagePointer("navigation.import.hierarchy.included.action.description", new Object[0]), AllIcons.Hierarchy.Subtypes);
        }

        @Nls
        protected String getTypeName() {
            return OCIncludeHierarchyBrowser.getIncludedByHierarchyType();
        }
    }

    static class ViewIncludingHierarchyAction
    extends ChangeViewAction {
        ViewIncludingHierarchyAction() {
            super(OCBundle.messagePointer("navigation.import.hierarchy.including.action", new Object[0]), OCBundle.messagePointer("navigation.import.hierarchy.including.action.description", new Object[0]), AllIcons.Hierarchy.Supertypes);
        }

        @Nls
        protected String getTypeName() {
            return OCIncludeHierarchyBrowser.getIncludingHierarchyType();
        }
    }

    private static abstract class ChangeViewAction
    extends ChangeHierarchyViewActionBase {
        ChangeViewAction(@NotNull Supplier<String> dynamicText, @NotNull Supplier<String> dynamicDescription, Icon icon2) {
            if (dynamicText == null) {
                ChangeViewAction.$$$reportNull$$$0(0);
            }
            if (dynamicDescription == null) {
                ChangeViewAction.$$$reportNull$$$0(1);
            }
            super(dynamicText, dynamicDescription, icon2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dynamicText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dynamicDescription";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/lang/hierarchy/include/OCIncludeHierarchyBrowser$ChangeViewAction";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

