/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.handlers;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.OCGenerateBundle;
import com.jetbrains.cidr.lang.generate.actions.OCGenerateMethodActionContext;
import com.jetbrains.cidr.lang.generate.handlers.OCGenerateMethodHandler;
import com.jetbrains.cidr.lang.psi.OCInterface;
import com.jetbrains.cidr.lang.settings.OCBooleanOption;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.settings.OCOption;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCallableUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCGenerateDescriptionHandler
extends OCGenerateMethodHandler {
    private static final OCBooleanOption INCLUDE_MEMBER_NAMES = new OCBooleanOption(OCGenerateBundle.message("generate.description.handler.include.member.names", new Object[0]));

    @Override
    @NotNull
    protected String getActionTitle() {
        @NlsSafe String descriptionMethod = "-description";
        String string = OCGenerateBundle.message("generate.description.handler.action.title", "-description");
        if (string == null) {
            OCGenerateDescriptionHandler.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NlsSafe
    protected String[] getMethodNames() {
        return new String[]{"description"};
    }

    @Override
    protected boolean allowEmptySelection(OCGenerateMethodActionContext context) {
        return true;
    }

    protected boolean defaultIncludeMemberNames(@Nullable OCCodeStyleSettings settings) {
        return settings == null || settings.DESCRIPTION_INCLUDE_MEMBER_NAMES;
    }

    @Override
    protected void loadOptions(PsiFile file, Editor editor, @NotNull OCGenerateMethodActionContext actionContext, @Nullable OCCodeStyleSettings settings, @NotNull List<Pair<OCOption, Object>> options) {
        if (actionContext == null) {
            OCGenerateDescriptionHandler.$$$reportNull$$$0(1);
        }
        if (options == null) {
            OCGenerateDescriptionHandler.$$$reportNull$$$0(2);
        }
        options.add((Pair<OCOption, Object>)new Pair((Object)INCLUDE_MEMBER_NAMES, (Object)this.defaultIncludeMemberNames(settings)));
        super.loadOptions(file, editor, actionContext, settings, options);
    }

    @Override
    protected void saveOptions(PsiFile file, @NotNull OCCodeStyleSettings settings, Map<OCOption, Object> optionValues) {
        if (settings == null) {
            OCGenerateDescriptionHandler.$$$reportNull$$$0(3);
        }
        settings.DESCRIPTION_INCLUDE_MEMBER_NAMES = OCGenerateDescriptionHandler.getOption(optionValues, INCLUDE_MEMBER_NAMES);
        super.saveOptions(file, settings, optionValues);
    }

    @Override
    @NotNull
    protected String getInsertText(@NotNull PsiElement element, @Nullable PsiElement at, @NotNull List<OCInstanceVariableSymbol> ivars, @NotNull OCGenerateMethodActionContext actionContext) {
        OCImplementationSymbol oCImplementationSymbol;
        if (element == null) {
            OCGenerateDescriptionHandler.$$$reportNull$$$0(4);
        }
        if (ivars == null) {
            OCGenerateDescriptionHandler.$$$reportNull$$$0(5);
        }
        if (actionContext == null) {
            OCGenerateDescriptionHandler.$$$reportNull$$$0(6);
        }
        if (element instanceof OCInterface) {
            String string = OCCallableUtil.methodSignature(actionContext.getBaseMethod(), element, actionContext.createResolveContext()) + ";";
            if (string == null) {
                OCGenerateDescriptionHandler.$$$reportNull$$$0(7);
            }
            return string;
        }
        boolean includeMemberNames = this.getOption(actionContext, INCLUDE_MEMBER_NAMES);
        ArrayList<Pair<String, String>> strings = new ArrayList<Pair<String, String>>();
        @NlsSafe StringBuilder body = new StringBuilder();
        boolean isFirst = true;
        OCResolveContext context = OCResolveContext.forPsi(element);
        for (OCInstanceVariableSymbol oCInstanceVariableSymbol : ivars) {
            OCPropertySymbol property = oCInstanceVariableSymbol.getAssociatedProperty(actionContext.getProject());
            OCType type = oCInstanceVariableSymbol.getType().resolve(element, true);
            OCGenerateDescriptionHandler.appendMember(strings, (String)(property != null ? "self." + property.getName() : oCInstanceVariableSymbol.getName()), type, includeMemberNames, context);
        }
        for (Pair pair : strings) {
            body.append("[description appendFormat: @\"");
            if (!isFirst) {
                body.append(", ");
            }
            body.append((String)pair.getFirst()).append("\", ").append((String)pair.getSecond()).append("];\n");
            isFirst = false;
        }
        OCObjectType superType = actionContext.getType().getSuperType();
        OCImplementationSymbol oCImplementationSymbol2 = oCImplementationSymbol = superType != null ? superType.getImplementation() : null;
        String templateName = oCImplementationSymbol != null && !oCImplementationSymbol.processMembersInAllCategories("description", OCMethodSymbol.class, new CommonProcessors.FindFirstProcessor(), true, actionContext.getProject()) ? "OC Overridden Description Body 1.m" : (strings.size() > 0 ? "OC Overridden Description Body 2.m" : "OC Overridden Description Body 3.m");
        String string = OCCallableUtil.methodFromTemplate(actionContext.getBaseMethod(), templateName, body.toString().trim(), element);
        if (string == null) {
            OCGenerateDescriptionHandler.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static void appendMember(List<Pair<String, String>> strings, @NlsSafe String memberName, OCType type, boolean includeMemberNames, @NotNull OCResolveContext context) {
        if (context == null) {
            OCGenerateDescriptionHandler.$$$reportNull$$$0(9);
        }
        if (type instanceof OCStructType && !type.isScalar()) {
            if (!OCGenerateDescriptionHandler.processStructFields(type, (Processor<OCDeclaratorSymbol>)((Processor)field -> {
                OCGenerateDescriptionHandler.appendMember(strings, memberName + "." + field.getName(), field.getResolvedType(context), includeMemberNames, context);
                return true;
            }), context)) {
                strings.add((Pair<String, String>)Pair.create((Object)(includeMemberNames ? memberName + "=%s" : "%s"), (Object)("(const char*)" + memberName)));
            }
        } else {
            strings.add((Pair<String, String>)Pair.create((Object)(includeMemberNames ? memberName + "=" + type.getFormatString() : type.getFormatString()), (Object)memberName));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 9 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/generate/handlers/OCGenerateDescriptionHandler";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ivars";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionTitle";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/generate/handlers/OCGenerateDescriptionHandler";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getInsertText";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadOptions";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "saveOptions";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getInsertText";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "appendMember";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 9 -> new IllegalArgumentException(string);
        };
    }
}

