/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.handlers;

import com.intellij.codeInsight.generation.MemberChooserObject;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCGenerateBundle;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.generate.OCCheckboxMemberChooser;
import com.jetbrains.cidr.lang.generate.OCMemberChooser;
import com.jetbrains.cidr.lang.generate.OCMemberChooserObject;
import com.jetbrains.cidr.lang.generate.handlers.OCClassActionHandlerBase;
import com.jetbrains.cidr.lang.generate.handlers.OCDeclareActionContext;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCProperty;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.refactoring.util.OCNormalizeUtil;
import com.jetbrains.cidr.lang.settings.OCOption;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.util.OCCallableUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCDeclareMembersHandler
extends OCClassActionHandlerBase<OCClassSymbol, OCMemberSymbol, OCDeclareActionContext> {
    @Override
    @NotNull
    @NlsContexts.Command
    protected String getActionTitle() {
        String string = OCGenerateBundle.message("declare.members.handler.action.title", new Object[0]);
        if (string == null) {
            OCDeclareMembersHandler.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NlsContexts.DialogTitle
    protected String getMembersChooserTitle() {
        return OCGenerateBundle.message("declare.members.handler.members.chooser.title", new Object[0]);
    }

    @Override
    @NlsContexts.DialogMessage
    protected String getNoMembersMessage(@NotNull OCDeclareActionContext context) {
        if (context == null) {
            OCDeclareMembersHandler.$$$reportNull$$$0(1);
        }
        String parentName = context.getParentNameUppercase();
        return OCGenerateBundle.message("declare.members.handler.no.members.message", parentName);
    }

    @Override
    protected Class<? extends OCSymbolDeclarator> getParentClass() {
        return OCClassDeclaration.class;
    }

    @Override
    @Nullable
    protected OCDeclareActionContext evaluateActionContext(OCClassSymbol parent, @NotNull PsiElement element) {
        if (element == null) {
            OCDeclareMembersHandler.$$$reportNull$$$0(2);
        }
        Project project = element.getProject();
        OCObjectType type = parent.getResolvedType(OCResolveContext.forPsi(element), true);
        PsiElement definition = parent.locateDefinition(project);
        if (!(definition instanceof OCClassDeclaration)) {
            return null;
        }
        OCClassDeclaration classDeclaration = (OCClassDeclaration)definition;
        OCDeclareActionContext actionContext = new OCDeclareActionContext(parent, classDeclaration, type);
        OCDeclareActionContext.Target defaultTarget = parent instanceof OCImplementationSymbol || "".equals(parent.getCategoryName()) ? OCDeclareActionContext.Target.INTERFACE : (parent.getCategoryName() != null ? OCDeclareActionContext.Target.IMPLEMENTATION : OCDeclareActionContext.Target.PRIVATE_CATEGORY);
        actionContext.setTarget(defaultTarget);
        return actionContext;
    }

    @Override
    protected void performAction(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file, @NotNull OCDeclareActionContext actionContext, @NotNull List<OCMemberSymbol> chosenCandidates) {
        class AddMember {
            PsiElement anchor;
            PsiElement member;
            OCMemberSymbol symbol;

            AddMember(PsiElement anchor, PsiElement member, OCMemberSymbol symbol) {
                this.anchor = anchor;
                this.member = member;
                this.symbol = symbol;
            }
        }
        if (project == null) {
            OCDeclareMembersHandler.$$$reportNull$$$0(3);
        }
        if (file == null) {
            OCDeclareMembersHandler.$$$reportNull$$$0(4);
        }
        if (actionContext == null) {
            OCDeclareMembersHandler.$$$reportNull$$$0(5);
        }
        if (chosenCandidates == null) {
            OCDeclareMembersHandler.$$$reportNull$$$0(6);
        }
        ArrayList<PsiElement> elementsToDelete = new ArrayList<PsiElement>();
        ArrayList membersToAdd = new ArrayList();
        OCClassSymbol targetSymbol = actionContext.getTargetSymbol();
        OCClassDeclaration targetDeclFinal = targetSymbol != null ? (OCClassDeclaration)targetSymbol.locateDefinition(project) : null;
        OCInterfaceSymbol privateCategory = actionContext.getPrivateCategory();
        HashSet membersOfPrivateCategory = new HashSet();
        if (privateCategory != null) {
            privateCategory.processMembers(OCMemberSymbol.class, symbol -> {
                if (!symbol.isSynthetic()) {
                    membersOfPrivateCategory.add(symbol);
                }
                return true;
            });
        }
        boolean privateCategoryWasEmpty = membersOfPrivateCategory.isEmpty();
        ApplicationManager.getApplication().runWriteAction(() -> {
            for (OCMemberSymbol member : chosenCandidates) {
                OCMemberSymbol definitionSymbol = (OCMemberSymbol)member.getDefinitionSymbol(project);
                if (definitionSymbol != null) {
                    member = definitionSymbol;
                }
                PsiElement memberElement = member.locateDefinition(project);
                OCMemberSymbol declaration = member instanceof OCMethodSymbol ? member.getAssociatedSymbol(project) : member;
                declaration = declaration != null ? declaration : member;
                OCClassSymbol declarationParent = declaration.getParent();
                membersOfPrivateCategory.remove(declaration);
                if (declarationParent.equals(targetSymbol)) continue;
                if (member instanceof OCMethodSymbol && declarationParent instanceof OCInterfaceSymbol && ((OCClassSymbol)actionContext.getParent()).getName().equals(declarationParent.getName())) {
                    elementsToDelete.add(declaration.locateDefinition(project));
                }
                if (targetSymbol != null && member instanceof OCPropertySymbol) {
                    CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
                    targetSymbol.processMembers(member.getName(), OCPropertySymbol.class, finder);
                    elementsToDelete.add(finder.isFound() ? ((OCPropertySymbol)finder.getFoundValue()).locateDefinition(project) : null);
                }
                if (!(member instanceof OCInstanceVariableSymbol) && actionContext.getTarget() == OCDeclareActionContext.Target.IMPLEMENTATION) continue;
                PsiElement anchor = targetDeclFinal != null ? targetDeclFinal.getBestMemberPlace(member) : null;
                PsiElement newElement = memberElement;
                if (member instanceof OCMethodSymbol) {
                    String signature2 = OCCallableUtil.methodSignature((OCMethodSymbol)member, actionContext.getContext(), actionContext.createResolveContext());
                    newElement = OCElementFactory.methodFromSignature(signature2, actionContext.getContext(), false, true);
                }
                membersToAdd.add(new AddMember(anchor, newElement, member));
            }
        });
        if (privateCategory != null && targetSymbol != privateCategory && membersOfPrivateCategory.isEmpty() && !privateCategoryWasEmpty) {
            int code;
            int n = code = ApplicationManager.getApplication().isUnitTestMode() ? 0 : Messages.showYesNoCancelDialog((String)OCInspectionsBundle.message((String)"intentions.remove.private.category.message", (Object[])new Object[0]), (String)OCInspectionsBundle.message((String)"intentions.remove.private.category.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
            if (code == 2) {
                return;
            }
            if (code == 0) {
                elementsToDelete.add(privateCategory.locateDefinition(project));
            }
        }
        WriteCommandAction.writeCommandAction((Project)project).withName(this.getActionTitle()).run(() -> {
            PsiElement implementation;
            OCClassDeclaration targetDecl = targetDeclFinal;
            if (actionContext.getTarget() == OCDeclareActionContext.Target.PRIVATE_CATEGORY && targetSymbol == null && (implementation = actionContext.getImplementationSymbol().locateDefinition(project)) != null) {
                targetDecl = OCElementFactory.interfaceByName(((OCClassSymbol)actionContext.getParent()).getName() + "()", implementation);
                targetDecl = OCChangeUtil.addBefore(implementation.getParent(), targetDecl, implementation);
            }
            if (targetDecl == null) {
                return;
            }
            for (AddMember add : membersToAdd) {
                PsiElement newElement;
                if (add.symbol instanceof OCMethodSymbol) {
                    newElement = OCChangeUtil.addBefore(targetDecl, add.member, add.anchor != null && add.anchor.isValid() ? add.anchor : null);
                } else {
                    OCDeclaration newDeclaration = OCNormalizeUtil.normalizeDeclarator((OCDeclarator)add.member);
                    if (add.symbol instanceof OCPropertySymbol) {
                        newDeclaration = newDeclaration.getParent();
                        assert (newDeclaration instanceof OCProperty);
                    }
                    newElement = this.moveDeclaration(add.symbol instanceof OCInstanceVariableSymbol ? targetDecl.getInstanceVariablesList() : targetDecl, newDeclaration);
                }
                OCImportSymbolFix.fixAllSymbolsRecursively(newElement);
            }
            for (PsiElement element : elementsToDelete) {
                if (element == null || !element.isValid()) continue;
                OCChangeUtil.delete(element);
            }
        });
    }

    @Override
    protected OCMemberChooser createMemberChooser(Project project, List<Pair<OCOption, Object>> options, final OCDeclareActionContext actionContext, List<OCMemberSymbol> candidates) {
        final Map<OCSymbol, OCSymbol> parentsMap = actionContext.createParentsMap((Collection<OCMemberSymbol>)candidates);
        MemberChooserHeaderPanel panel = new MemberChooserHeaderPanel(actionContext.getAvailableTargets(), actionContext.getTarget());
        OCCheckboxMemberChooser chooser = new OCCheckboxMemberChooser(new OCMemberChooserObject[0], options, project, this.allowEmptySelection(actionContext), this.allowMultiSelection(actionContext), panel){

            @Override
            protected boolean isMemberEnabled(OCMemberChooserObject member) {
                OCDeclareActionContext.Target target = actionContext.getTarget();
                OCClassSymbol targetSymbol = actionContext.getTargetSymbol();
                OCSymbol symbol = member.getSymbol();
                if (targetSymbol != null && (targetSymbol.equals(symbol) || targetSymbol.equals(parentsMap.get(symbol)))) {
                    return false;
                }
                if (target == OCDeclareActionContext.Target.IMPLEMENTATION && symbol instanceof OCPropertySymbol) {
                    return false;
                }
                return target != OCDeclareActionContext.Target.PRIVATE_CATEGORY || !(symbol instanceof OCInstanceVariableSymbol) || OCCompilerFeaturesHelper.supportsIvarsInCategories();
            }
        };
        panel.addTargetChangeListener((Processor<OCDeclareActionContext.Target>)((Processor)target -> {
            actionContext.setTarget((OCDeclareActionContext.Target)((Object)target));
            chooser.refreshChosenMembers();
            chooser.repaint();
            return true;
        }));
        chooser.refreshChosenMembers();
        return chooser;
    }

    protected PsiElement moveDeclaration(PsiElement parent, PsiElement declaration) {
        PsiElement newDeclaration = OCChangeUtil.add(parent, declaration);
        OCChangeUtil.delete(declaration);
        return newDeclaration;
    }

    @Override
    protected OCMemberChooserObject[] getChooserNodes(OCMemberChooser chooser, Collection<OCMemberSymbol> candidates, OCDeclareActionContext actionContext, int moreNodesLevel) {
        final Map<OCSymbol, OCSymbol> parentsMap = actionContext.createParentsMap(candidates);
        return (OCMemberChooserObject[])ContainerUtil.map2Array(candidates, OCMemberChooserObject.class, symbol -> new OCMemberChooserObject((OCSymbol)symbol, parentsMap, actionContext.getProject(), (OCMemberSymbol)symbol, actionContext){
            final /* synthetic */ OCMemberSymbol val$symbol;
            final /* synthetic */ OCDeclareActionContext val$actionContext;
            {
                this.val$symbol = oCMemberSymbol;
                this.val$actionContext = oCDeclareActionContext;
                super(symbol, parentsMap2, project);
            }

            @Override
            @Nullable
            public MemberChooserObject getParentNodeDelegate() {
                OCClassSymbol parent = (OCClassSymbol)parentsMap.get(this.val$symbol);
                OCDeclareActionContext.Target target = parent instanceof OCImplementationSymbol ? OCDeclareActionContext.Target.IMPLEMENTATION : ("".equals(parent.getCategoryName()) ? OCDeclareActionContext.Target.PRIVATE_CATEGORY : OCDeclareActionContext.Target.INTERFACE);
                String targetName = target == OCDeclareActionContext.Target.IMPLEMENTATION ? OCBundle.message("oc.declare.members.implementation.undeclared", new Object[0]) : target.getName();
                return new OCMemberChooserObject((OCSymbol)parent, targetName, parent.getIcon(this.val$actionContext.getProject()), this.val$actionContext.getProject());
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/generate/handlers/OCDeclareMembersHandler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionContext";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chosenCandidates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionTitle";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/generate/handlers/OCDeclareMembersHandler";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getNoMembersMessage";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "evaluateActionContext";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "performAction";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6 -> new IllegalArgumentException(string);
        };
    }

    public static class MemberChooserHeaderPanel
    extends JPanel {
        private final JComboBox<OCDeclareActionContext.Target> comboBox;

        public MemberChooserHeaderPanel(OCDeclareActionContext.Target[] targets, OCDeclareActionContext.Target defaultTarget) {
            super(new BorderLayout());
            this.comboBox = new ComboBox((Object[])targets);
            this.add(this.comboBox, "Center");
            this.comboBox.setRenderer((ListCellRenderer<OCDeclareActionContext.Target>)SimpleListCellRenderer.create((label, target, index) -> {
                label.setText(target.getName());
                label.setIcon(target.getIcon());
            }));
            this.comboBox.setSelectedItem((Object)defaultTarget);
            JLabel templatesLabel = new JLabel(OCInspectionsBundle.message((String)"intentions.declare.member.in", (Object[])new Object[0]));
            templatesLabel.setDisplayedMnemonic(84);
            templatesLabel.setLabelFor(this.comboBox);
            this.add((Component)templatesLabel, "West");
        }

        protected void addTargetChangeListener(final Processor<OCDeclareActionContext.Target> listener) {
            this.comboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    listener.process((Object)((OCDeclareActionContext.Target)((Object)comboBox.getSelectedItem())));
                }
            });
        }
    }
}

