/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ObjectUtils;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public final class OCNewCppFunctionsLocator {
    @NotNull
    public static TextRange getValidLocationRange(@NotNull OCStructLike struct) {
        if (struct == null) {
            OCNewCppFunctionsLocator.$$$reportNull$$$0(0);
        }
        Optional<Integer> begin = Optional.empty();
        Optional<Integer> end = Optional.empty();
        for (PsiElement child = struct.getFirstChild(); child != null; child = child.getNextSibling()) {
            IElementType type = OCElementUtil.getElementType(child);
            if (type == OCTokenTypes.LBRACE) {
                begin = Optional.of(child.getTextRange().getEndOffset());
                continue;
            }
            if (type != OCTokenTypes.RBRACE) continue;
            end = Optional.of(child.getTextRange().getStartOffset() + 1);
        }
        TextRange textRange = TextRange.create((int)begin.orElseGet(() -> {
            PsiElement nameIdentifier = struct.getNameIdentifier();
            return nameIdentifier != null ? nameIdentifier.getTextRange().getEndOffset() : struct.getTextRange().getEndOffset();
        }), (int)end.orElseGet(() -> struct.getTextRange().getEndOffset()));
        if (textRange == null) {
            OCNewCppFunctionsLocator.$$$reportNull$$$0(1);
        }
        return textRange;
    }

    public static int locateNewFunction(@NotNull OCStructLike struct, @NotNull OCFunctionSymbol newFunction) {
        if (struct == null) {
            OCNewCppFunctionsLocator.$$$reportNull$$$0(2);
        }
        if (newFunction == null) {
            OCNewCppFunctionsLocator.$$$reportNull$$$0(3);
        }
        Visitor v = OCNewCppFunctionsLocator.getVisitor(struct, newFunction);
        for (PsiElement child = struct.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof OCFunctionDeclaration)) continue;
            OCVisibility vis = (OCVisibility)((Object)ObjectUtils.notNull((Object)((Object)OCVisibility.getVisibilityAtOffset(struct, child.getTextOffset())), (Object)((Object)OCVisibility.HACK_MORE_VISIBLE_THAN_PUBLIC)));
            v.visitFunction((OCFunctionDeclaration)child, vis);
        }
        return v.getResult();
    }

    @NotNull
    private static Visitor getVisitor(@NotNull OCStructLike struct, @NotNull OCFunctionSymbol function) {
        if (struct == null) {
            OCNewCppFunctionsLocator.$$$reportNull$$$0(4);
        }
        if (function == null) {
            OCNewCppFunctionsLocator.$$$reportNull$$$0(5);
        }
        if (function.isCppConstructor()) {
            return new CtorVisitor(struct, function);
        }
        return new FuncVisitor(struct, function);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "struct";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/generate/OCNewCppFunctionsLocator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFunction";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/generate/OCNewCppFunctionsLocator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getValidLocationRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getValidLocationRange";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "locateNewFunction";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static interface Visitor {
        public void visitFunction(@NotNull OCFunctionDeclaration var1, @NotNull OCVisibility var2);

        public int getResult();
    }

    private static final class CtorVisitor
    implements Visitor {
        private final OCStructLike myStruct;
        private final OCFunctionSymbol myCtor;
        private Pair<OCFunctionDeclaration, OCVisibility> myBestConstructorToInsertAfter;
        private Pair<OCFunctionDeclaration, OCVisibility> myBestFunctionToInsertBefore;

        private CtorVisitor(OCStructLike struct, OCFunctionSymbol ctor) {
            this.myStruct = struct;
            this.myCtor = ctor;
        }

        @Override
        public void visitFunction(@NotNull OCFunctionDeclaration func, @NotNull OCVisibility visibility) {
            if (func == null) {
                CtorVisitor.$$$reportNull$$$0(0);
            }
            if (visibility == null) {
                CtorVisitor.$$$reportNull$$$0(1);
            }
            OCVisibility myVis = (OCVisibility)((Object)ObjectUtils.notNull((Object)((Object)this.myCtor.getVisibility()), (Object)((Object)OCVisibility.HACK_MORE_VISIBLE_THAN_PUBLIC)));
            if (this.myCtor.getName().equals(func.getName())) {
                if (this.myBestConstructorToInsertAfter == null) {
                    this.myBestConstructorToInsertAfter = Pair.create((Object)func, (Object)((Object)visibility));
                } else {
                    int bestVisibilityDelta = Math.abs(((OCVisibility)((Object)this.myBestConstructorToInsertAfter.second)).ordinal() - myVis.ordinal());
                    int curVisibilityDelta = Math.abs(visibility.ordinal() - myVis.ordinal());
                    int curOffset = func.getTextRange().getEndOffset();
                    int bestOffset = ((OCFunctionDeclaration)this.myBestConstructorToInsertAfter.first).getTextRange().getEndOffset();
                    if (bestVisibilityDelta > curVisibilityDelta || bestVisibilityDelta == curVisibilityDelta && curOffset > bestOffset) {
                        this.myBestConstructorToInsertAfter = Pair.create((Object)func, (Object)((Object)visibility));
                    }
                }
            } else if (this.myBestFunctionToInsertBefore == null) {
                this.myBestFunctionToInsertBefore = Pair.create((Object)func, (Object)((Object)visibility));
            } else {
                int bestVisibilityDelta = Math.abs(((OCVisibility)((Object)this.myBestFunctionToInsertBefore.second)).ordinal() - myVis.ordinal());
                int curVisibilityDelta = Math.abs(visibility.ordinal() - myVis.ordinal());
                int curOffset = func.getTextRange().getStartOffset();
                int bestOffset = ((OCFunctionDeclaration)this.myBestFunctionToInsertBefore.first).getTextRange().getStartOffset();
                if (bestVisibilityDelta > curVisibilityDelta || bestVisibilityDelta == curVisibilityDelta && curOffset < bestOffset) {
                    this.myBestFunctionToInsertBefore = Pair.create((Object)func, (Object)((Object)visibility));
                }
            }
        }

        @Override
        public int getResult() {
            if (this.myBestConstructorToInsertAfter != null) {
                if (this.myBestFunctionToInsertBefore != null) {
                    OCVisibility myVis = (OCVisibility)((Object)ObjectUtils.notNull((Object)((Object)this.myCtor.getVisibility()), (Object)((Object)OCVisibility.HACK_MORE_VISIBLE_THAN_PUBLIC)));
                    int ctorVisDelta = Math.abs(myVis.ordinal() - ((OCVisibility)((Object)this.myBestConstructorToInsertAfter.second)).ordinal());
                    int funcVisDelta = Math.abs(myVis.ordinal() - ((OCVisibility)((Object)this.myBestFunctionToInsertBefore.second)).ordinal());
                    if (funcVisDelta < ctorVisDelta) {
                        return ((OCFunctionDeclaration)this.myBestFunctionToInsertBefore.first).getTextRange().getStartOffset();
                    }
                }
                return ((OCFunctionDeclaration)this.myBestConstructorToInsertAfter.first).getTextRange().getEndOffset();
            }
            if (this.myBestFunctionToInsertBefore != null) {
                return ((OCFunctionDeclaration)this.myBestFunctionToInsertBefore.first).getTextRange().getStartOffset();
            }
            return OCNewCppFunctionsLocator.getValidLocationRange(this.myStruct).getStartOffset();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "func";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "visibility";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/lang/generate/OCNewCppFunctionsLocator$CtorVisitor";
            objectArray[2] = "visitFunction";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class FuncVisitor
    implements Visitor {
        private final OCStructLike myStruct;
        private final OCFunctionSymbol myFunc;
        private Pair<OCFunctionDeclaration, OCVisibility> myBestFunctionToInsertAfter;

        private FuncVisitor(OCStructLike struct, OCFunctionSymbol func) {
            this.myStruct = struct;
            this.myFunc = func;
        }

        @Override
        public void visitFunction(@NotNull OCFunctionDeclaration func, @NotNull OCVisibility visibility) {
            if (func == null) {
                FuncVisitor.$$$reportNull$$$0(0);
            }
            if (visibility == null) {
                FuncVisitor.$$$reportNull$$$0(1);
            }
            OCVisibility myVis = (OCVisibility)((Object)ObjectUtils.notNull((Object)((Object)this.myFunc.getVisibility()), (Object)((Object)OCVisibility.HACK_MORE_VISIBLE_THAN_PUBLIC)));
            if (this.myBestFunctionToInsertAfter == null) {
                this.myBestFunctionToInsertAfter = Pair.create((Object)func, (Object)((Object)visibility));
            } else {
                int bestVisibilityDelta = Math.abs(((OCVisibility)((Object)this.myBestFunctionToInsertAfter.second)).ordinal() - myVis.ordinal());
                int curVisibilityDelta = Math.abs(visibility.ordinal() - myVis.ordinal());
                int curOffset = func.getTextRange().getEndOffset();
                int bestOffset = ((OCFunctionDeclaration)this.myBestFunctionToInsertAfter.first).getTextRange().getEndOffset();
                if (bestVisibilityDelta > curVisibilityDelta || bestVisibilityDelta == curVisibilityDelta && curOffset > bestOffset) {
                    this.myBestFunctionToInsertAfter = Pair.create((Object)func, (Object)((Object)visibility));
                }
            }
        }

        @Override
        public int getResult() {
            if (this.myBestFunctionToInsertAfter != null) {
                return ((OCFunctionDeclaration)this.myBestFunctionToInsertAfter.first).getTextRange().getEndOffset();
            }
            return OCNewCppFunctionsLocator.getValidLocationRange(this.myStruct).getStartOffset();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "func";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "visibility";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/lang/generate/OCNewCppFunctionsLocator$FuncVisitor";
            objectArray[2] = "visitFunction";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

