/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.MathUtil;
import com.intellij.util.ObjectUtils;
import com.jetbrains.cidr.lang.generate.OCGenerateUtil;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCCaretLocation {
    @NotNull
    private final PsiFile myFile;
    @Nullable
    private final PsiElement myElement;
    private final int myOffsetInElement;

    @NotNull
    public static OCCaretLocation byEditor(@NotNull PsiFile file, @Nullable Editor editor) {
        if (file == null) {
            OCCaretLocation.$$$reportNull$$$0(0);
        }
        PsiElement element = editor == null ? null : OCGenerateUtil.getElementAt(editor, file);
        int offset = editor == null ? -1 : Math.max(0, editor.getCaretModel().getOffset() - element.getTextRange().getStartOffset());
        return new OCCaretLocation(file, element, offset);
    }

    @NotNull
    public static OCCaretLocation byOffset(@NotNull PsiFile file, int offsetInFile) {
        if (file == null) {
            OCCaretLocation.$$$reportNull$$$0(1);
        }
        PsiElement element = (PsiElement)ObjectUtils.notNull((Object)file.findElementAt(offsetInFile), (Object)file);
        return new OCCaretLocation(file, element, MathUtil.clamp((int)(offsetInFile - element.getTextRange().getStartOffset()), (int)0, (int)element.getTextRange().getLength()));
    }

    public static OCCaretLocation byFile(@NotNull PsiFile file) {
        if (file == null) {
            OCCaretLocation.$$$reportNull$$$0(2);
        }
        return new OCCaretLocation(file, null, -1);
    }

    private OCCaretLocation(@NotNull PsiFile file, @Nullable PsiElement element, int offsetInElement) {
        if (file == null) {
            OCCaretLocation.$$$reportNull$$$0(3);
        }
        this.myFile = file;
        this.myElement = element;
        this.myOffsetInElement = offsetInElement;
    }

    @Nullable
    public PsiElement getElement() {
        return this.myElement;
    }

    @Nullable
    public Integer getOffsetInFile() {
        return this.myElement == null ? null : Integer.valueOf(this.myElement.getTextRange().getStartOffset() + this.myOffsetInElement);
    }

    @NotNull
    public PsiFile getFile() {
        PsiFile psiFile2 = this.myFile;
        if (psiFile2 == null) {
            OCCaretLocation.$$$reportNull$$$0(4);
        }
        return psiFile2;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myFile.getProject();
        if (project == null) {
            OCCaretLocation.$$$reportNull$$$0(5);
        }
        return project;
    }

    @NotNull
    public OCResolveContext createContext() {
        OCResolveContext oCResolveContext = OCResolveContext.forPsi((PsiElement)ObjectUtils.notNull((Object)this.myElement, (Object)this.myFile));
        if (oCResolveContext == null) {
            OCCaretLocation.$$$reportNull$$$0(6);
        }
        return oCResolveContext;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/generate/OCCaretLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/generate/OCCaretLocation";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "byEditor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "byOffset";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "byFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

