/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.formatting;

import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.formatting.OCFormatterUtil;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import java.util.ArrayList;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class OCPreprocessorFormatterData {
    public int directiveNestLevel = 0;
    public ArrayList<OCIndentInfo> directiveIndent = new ArrayList();

    @NotNull
    public OCIndentInfo getIndentAtLevel() {
        assert (this.directiveNestLevel >= 0 && this.directiveNestLevel < this.directiveIndent.size());
        OCIndentInfo oCIndentInfo = this.directiveIndent.get(this.directiveNestLevel);
        if (oCIndentInfo == null) {
            OCPreprocessorFormatterData.$$$reportNull$$$0(0);
        }
        return oCIndentInfo;
    }

    public void setIndentAtLevel(OCIndentInfo indents) {
        assert (this.directiveNestLevel >= 0);
        if (this.directiveNestLevel >= this.directiveIndent.size()) {
            this.directiveIndent.add(this.directiveNestLevel, indents);
        } else {
            this.directiveIndent.set(this.directiveNestLevel, indents);
        }
    }

    public OCIndentInfo getIndents(boolean resetCodeIndent, IElementType tokenType, OCCodeStyleSettings ocCodeStyleSettings, boolean fromFirst) {
        OCIndentInfo indents;
        OCIndentInfo level;
        OffsetType baseIndentType = null;
        int curIndentSizeInSpaces = 0;
        int ifNestLevel = 0;
        if (OCTokenTypes.END_IF_DIRECTIVES.contains(tokenType)) {
            --this.directiveNestLevel;
            if (this.directiveNestLevel < 0) {
                this.directiveNestLevel = 0;
            } else {
                level = this.getIndentAtLevel();
                curIndentSizeInSpaces = level.ifIndentSizeInSpaces;
                baseIndentType = level.baseIndentType;
                ifNestLevel = level.ifNestLevel;
            }
        }
        if (baseIndentType == null) {
            if (ocCodeStyleSettings.KEEP_DIRECTIVE_AT_FIRST_COLUMN && fromFirst) {
                baseIndentType = OffsetType.DIRECTIVE_ABSOLUTE;
                ifNestLevel = this.directiveNestLevel;
            } else if (this.directiveNestLevel == 0) {
                baseIndentType = ocCodeStyleSettings.INDENT_DIRECTIVE_AS_CODE ? OffsetType.DIRECTIVE_RELATIVE_CODE : OffsetType.DIRECTIVE_ABSOLUTE;
                ifNestLevel = 0;
                curIndentSizeInSpaces = 0;
            } else {
                --this.directiveNestLevel;
                level = this.getIndentAtLevel();
                baseIndentType = level.baseIndentType;
                ifNestLevel = level.ifNestLevel;
                ++this.directiveNestLevel;
                int n = curIndentSizeInSpaces = resetCodeIndent ? 0 : level.ifIndentSizeInSpaces + ocCodeStyleSettings.INDENT_PREPROCESSOR_DIRECTIVE;
            }
        }
        if ((indents = new OCIndentInfo(baseIndentType, curIndentSizeInSpaces, ifNestLevel, tokenType)).isIndentStarter()) {
            this.setIndentAtLevel(indents);
            ++this.directiveNestLevel;
        }
        return indents;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/formatting/OCPreprocessorFormatterData", "getIndentAtLevel"));
    }

    public static class OCIndentInfo {
        public OffsetType baseIndentType;
        public final int ifIndentSizeInSpaces;
        public final int ifNestLevel;
        public final IElementType tokenType;

        public OCIndentInfo(@NotNull OffsetType baseIndentType, int ifIndentSizeInSpaces, int ifNestLevel, IElementType tokenType) {
            if (baseIndentType == null) {
                OCIndentInfo.$$$reportNull$$$0(0);
            }
            this.baseIndentType = baseIndentType;
            this.ifIndentSizeInSpaces = ifIndentSizeInSpaces;
            this.ifNestLevel = ifNestLevel;
            this.tokenType = tokenType;
        }

        public boolean isIndentStarter() {
            return OCFormatterUtil.FORMAT_DIRECTIVES_INCREASE_INDENT.contains(this.tokenType);
        }

        public boolean resetIndentInDirectiveSequence() {
            assert (this.baseIndentType == OffsetType.DIRECTIVE_POSTPONE);
            return this.ifIndentSizeInSpaces == 0;
        }

        @NotNull
        @Contract(value="_, _ -> new", pure=true)
        public static OCIndentInfo createCodeInfo(@NotNull OffsetType baseIndentType, int ifIndentSizeInSpaces) {
            if (baseIndentType == null) {
                OCIndentInfo.$$$reportNull$$$0(1);
            }
            return new OCIndentInfo(baseIndentType, ifIndentSizeInSpaces, -1, null);
        }

        @NotNull
        @Contract(value="_, _ -> new", pure=true)
        public static OCIndentInfo createPostponedDirectiveInfo(@NotNull IElementType tokenType, boolean resetIndentInDirectiveSequence) {
            if (tokenType == null) {
                OCIndentInfo.$$$reportNull$$$0(2);
            }
            return new OCIndentInfo(OffsetType.DIRECTIVE_POSTPONE, resetIndentInDirectiveSequence ? 0 : -1, -1, tokenType);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "baseIndentType";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tokenType";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/lang/formatting/OCPreprocessorFormatterData$OCIndentInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createCodeInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createPostponedDirectiveInfo";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static enum OffsetType {
        CODE_RELATIVE_PREV,
        CODE_AS_IS,
        DIRECTIVE_POSTPONE,
        DIRECTIVE_RELATIVE_CODE,
        DIRECTIVE_ABSOLUTE;

    }
}

