/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor;

import com.intellij.codeInsight.editorActions.DefaultTypingActionsExtension;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.Strings;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.ExternalFormatProcessor;
import com.intellij.psi.codeStyle.lineIndent.LineIndentProvider;
import com.intellij.psi.codeStyle.lineIndent.LineIndentProviderEP;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.OCLanguageUtilsBase;
import com.jetbrains.cidr.lang.formatting.OCMultilineNodeFormatter;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCPsiFile;
import org.jetbrains.annotations.NotNull;

public final class OCTypingActionsExtension
extends DefaultTypingActionsExtension {
    private static final String CLION_CF_ID = "ClangFormat";

    public void startCopy(@NotNull Project project, @NotNull Editor editor) {
        if (project == null) {
            OCTypingActionsExtension.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            OCTypingActionsExtension.$$$reportNull$$$0(1);
        }
        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
    }

    public boolean isSuitableContext(@NotNull Project project, @NotNull Editor editor) {
        if (project == null) {
            OCTypingActionsExtension.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            OCTypingActionsExtension.$$$reportNull$$$0(3);
        }
        return Registry.is((String)"cidr.enable.typingActionsExtension") && PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument()) instanceof OCPsiFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void format(@NotNull Project project, @NotNull Editor editor, int howtoReformat, int startOffset, int endOffset, int anchorColumn, boolean indentBeforeReformat, boolean isInjected) {
        boolean skipCommitMode;
        if (project == null) {
            OCTypingActionsExtension.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            OCTypingActionsExtension.$$$reportNull$$$0(5);
        }
        Document document = editor.getDocument();
        boolean bl = skipCommitMode = OCLanguageUtilsBase.INSIDE_TYPING_ACTION_HINT.get((UserDataHolder)editor.getDocument()) == Boolean.TRUE;
        if (!skipCommitMode) {
            OCLanguageUtilsBase.INSIDE_TYPING_ACTION_HINT.set((UserDataHolder)editor.getDocument(), (Object)Boolean.TRUE);
        }
        try {
            super.format(project, editor, howtoReformat, startOffset, endOffset, anchorColumn, indentBeforeReformat, isInjected);
        }
        finally {
            if (!skipCommitMode) {
                OCLanguageUtilsBase.INSIDE_TYPING_ACTION_HINT.set((UserDataHolder)editor.getDocument(), null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void adjustLineIndent(@NotNull Project project, @NotNull Editor editor, int startOffset, int endOffset) {
        ExternalFormatProcessor efp;
        if (project == null) {
            OCTypingActionsExtension.$$$reportNull$$$0(6);
        }
        if (editor == null) {
            OCTypingActionsExtension.$$$reportNull$$$0(7);
        }
        Document document = editor.getDocument();
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (file != null && (efp = ExternalFormatProcessor.activeExternalFormatProcessor((PsiFile)file)) != null && CLION_CF_ID.equals(efp.getId())) {
            RangeMarker bounds = document.createRangeMarker(startOffset, endOffset);
            try {
                OCLanguageUtilsBase.INDENTATION_ONLY_HINT.set((UserDataHolder)document, (Object)Boolean.TRUE);
                efp.format(file, TextRange.create((int)startOffset, (int)endOffset), true, true, true, -1);
                OCTypingActionsExtension.indentCorrection(file, document, efp, bounds);
                return;
            }
            finally {
                OCLanguageUtilsBase.INDENTATION_ONLY_HINT.set((UserDataHolder)document, null);
                bounds.dispose();
            }
        }
        super.adjustLineIndent(project, editor, startOffset, endOffset);
    }

    private static void adjustLineIndentWithLexer(@NotNull Project project, @NotNull Editor editor, int startOffset, int endOffset) {
        if (project == null) {
            OCTypingActionsExtension.$$$reportNull$$$0(8);
        }
        if (editor == null) {
            OCTypingActionsExtension.$$$reportNull$$$0(9);
        }
        Document document = editor.getDocument();
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        OCLanguage language = OCLanguage.getInstance();
        LineIndentProvider lineIndentProvider = LineIndentProviderEP.findLineIndentProvider((Language)language);
        if (lineIndentProvider != null && file != null) {
            HighlighterIterator it = editor.getHighlighter().createIterator(startOffset);
            OCMultilineNodeFormatter multilineNodeFormatter = OCMultilineNodeFormatter.create(file);
            CharSequence fileText = document.getCharsSequence();
            int currentLine = -1;
            RangeMarker actionRange = document.createRangeMarker(startOffset, endOffset);
            while (!it.atEnd() && it.getStart() <= actionRange.getEndOffset()) {
                int startLine;
                if (it.getTokenType() != TokenType.WHITE_SPACE && (startLine = document.getLineNumber(it.getStart())) > currentLine) {
                    currentLine = startLine;
                    int startIndent = document.getLineStartOffset(startLine);
                    int endIndent = CharArrayUtil.shiftForward((CharSequence)fileText, (int)startIndent, (String)" \t");
                    String newIndentString = lineIndentProvider.getLineIndent(project, editor, (Language)language, startIndent);
                    if (newIndentString != null && !Strings.areSameInstance((String)newIndentString, (String)LineIndentProvider.DO_NOT_ADJUST)) {
                        int shiftMultilineToken = 0;
                        RangeMarker marker = document.createRangeMarker(it.getStart(), it.getEnd());
                        if (it.getTokenType() == OCTokenTypes.BLOCK_COMMENT && startLine != document.getLineNumber(it.getEnd())) {
                            shiftMultilineToken = multilineNodeFormatter.indent(newIndentString) - multilineNodeFormatter.indent(fileText.subSequence(startIndent, endIndent));
                        }
                        document.replaceString(startIndent, endIndent, (CharSequence)newIndentString);
                        if (shiftMultilineToken != 0) {
                            document.replaceString(marker.getStartOffset(), marker.getEndOffset(), (CharSequence)multilineNodeFormatter.getShiftedLeafText(shiftMultilineToken, fileText.subSequence(marker.getStartOffset(), marker.getEndOffset())));
                        }
                        it = editor.getHighlighter().createIterator(marker.getEndOffset());
                        marker.dispose();
                        continue;
                    }
                }
                it.advance();
            }
            actionRange.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void adjustLineIndent(@NotNull Project project, @NotNull Editor editor, int offset) {
        ExternalFormatProcessor efp;
        if (project == null) {
            OCTypingActionsExtension.$$$reportNull$$$0(10);
        }
        if (editor == null) {
            OCTypingActionsExtension.$$$reportNull$$$0(11);
        }
        Document document = editor.getDocument();
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (file != null && (efp = ExternalFormatProcessor.activeExternalFormatProcessor((PsiFile)file)) != null && CLION_CF_ID.equals(efp.getId())) {
            try {
                OCLanguageUtilsBase.INDENTATION_ONLY_HINT.set((UserDataHolder)document, (Object)Boolean.TRUE);
                int lineStartOffset = document.getLineStartOffset(document.getLineNumber(offset));
                String indent = efp.indent(file, offset);
                if (indent != null) {
                    document.replaceString(lineStartOffset, offset, (CharSequence)indent);
                } else {
                    efp.format(file, TextRange.create((int)lineStartOffset, (int)offset), true, false, true, -1);
                }
                return;
            }
            finally {
                OCLanguageUtilsBase.INDENTATION_ONLY_HINT.set((UserDataHolder)document, null);
            }
        }
        super.adjustLineIndent(project, editor, offset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reformatRange(@NotNull Project project, @NotNull Editor editor, int startOffset, int endOffset) {
        ExternalFormatProcessor efp;
        if (project == null) {
            OCTypingActionsExtension.$$$reportNull$$$0(12);
        }
        if (editor == null) {
            OCTypingActionsExtension.$$$reportNull$$$0(13);
        }
        Document document = editor.getDocument();
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (file != null && (efp = ExternalFormatProcessor.activeExternalFormatProcessor((PsiFile)file)) != null && CLION_CF_ID.equals(efp.getId())) {
            RangeMarker bounds = document.createRangeMarker(startOffset, endOffset);
            try {
                efp.format(file, TextRange.create((int)startOffset, (int)endOffset), true, false, true, -1);
                OCTypingActionsExtension.indentCorrection(file, document, efp, bounds);
            }
            finally {
                bounds.dispose();
            }
            return;
        }
        super.reformatRange(project, editor, startOffset, endOffset);
    }

    private static void indentCorrection(@NotNull PsiFile file, @NotNull Document document, @NotNull ExternalFormatProcessor efp, @NotNull RangeMarker range) {
        char ch;
        int i;
        if (file == null) {
            OCTypingActionsExtension.$$$reportNull$$$0(14);
        }
        if (document == null) {
            OCTypingActionsExtension.$$$reportNull$$$0(15);
        }
        if (efp == null) {
            OCTypingActionsExtension.$$$reportNull$$$0(16);
        }
        if (range == null) {
            OCTypingActionsExtension.$$$reportNull$$$0(17);
        }
        CharSequence text = document.getCharsSequence();
        int startAnchorIndent = -1;
        for (i = range.getStartOffset() - 1; i >= 0; --i) {
            ch = text.charAt(i);
            if (ch == '\n') {
                startAnchorIndent = i;
                break;
            }
            if ("\t ".indexOf(ch) < 0) break;
        }
        if (startAnchorIndent < 0) {
            for (i = range.getStartOffset(); i < range.getEndOffset(); ++i) {
                ch = text.charAt(i);
                if (ch == '\n') {
                    startAnchorIndent = i;
                    continue;
                }
                if (startAnchorIndent >= 0 && "\t ".indexOf(ch) < 0) break;
            }
        }
        if (startAnchorIndent < 0) {
            return;
        }
        int endAnchorIndent = CharArrayUtil.shiftForward((CharSequence)text, (int)(++startAnchorIndent), (String)" \t");
        String origIndent = text.subSequence(startAnchorIndent, endAnchorIndent).toString();
        String relativeIndent = efp.indent(file, endAnchorIndent);
        if (relativeIndent == null) {
            return;
        }
        OCMultilineNodeFormatter multilineNodeFormatter = OCMultilineNodeFormatter.create(file);
        int shift = multilineNodeFormatter.indent(relativeIndent) - multilineNodeFormatter.indent(origIndent);
        if (shift != 0) {
            document.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)multilineNodeFormatter.getShiftedLeafText(shift, text.subSequence(range.getStartOffset(), range.getEndOffset())));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "efp";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/editor/OCTypingActionsExtension";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "startCopy";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isSuitableContext";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "format";
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "adjustLineIndent";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "adjustLineIndentWithLexer";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "reformatRange";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "indentCorrection";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

