/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor;

import com.intellij.codeInsight.editorActions.JavaLikeQuoteHandler;
import com.intellij.codeInsight.editorActions.SimpleTokenSetQuoteHandler;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import org.jetbrains.annotations.NotNull;

public final class OCQuoteHandler
extends SimpleTokenSetQuoteHandler
implements JavaLikeQuoteHandler {
    private static final TokenSet CONCATENATABLE_STRING = TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.STRING_LITERAL});

    public OCQuoteHandler() {
        super(new IElementType[]{OCTokenTypes.STRING_LITERAL, OCTokenTypes.CHARACTER_LITERAL});
    }

    public boolean isOpeningQuote(HighlighterIterator iterator2, int offset) {
        if (OCQuoteHandler.isInsideNumericLiteral(iterator2)) {
            return false;
        }
        boolean openingQuote = super.isOpeningQuote(iterator2, offset);
        if (openingQuote && !iterator2.atEnd()) {
            iterator2.retreat();
            if (!iterator2.atEnd() && StringEscapesTokenTypes.STRING_LITERAL_ESCAPES.contains(iterator2.getTokenType())) {
                openingQuote = false;
            }
            iterator2.advance();
        }
        return openingQuote;
    }

    public boolean isClosingQuote(HighlighterIterator iterator2, int offset) {
        if (OCQuoteHandler.isInsideNumericLiteral(iterator2)) {
            return false;
        }
        boolean closingQuote = super.isClosingQuote(iterator2, offset);
        if (closingQuote && !iterator2.atEnd()) {
            iterator2.advance();
            if (!iterator2.atEnd() && StringEscapesTokenTypes.STRING_LITERAL_ESCAPES.contains(iterator2.getTokenType())) {
                closingQuote = false;
            }
            iterator2.retreat();
        }
        return closingQuote;
    }

    private static boolean isInsideNumericLiteral(HighlighterIterator iterator2) {
        boolean insideNumeric = false;
        if (iterator2.getStart() > 0) {
            iterator2.retreat();
            insideNumeric = OCTokenTypes.ALL_NUMERIC.contains(iterator2.getTokenType());
            iterator2.advance();
        }
        return insideNumeric;
    }

    @NotNull
    public TokenSet getConcatenatableStringTokenTypes() {
        TokenSet tokenSet = TokenSet.EMPTY;
        if (tokenSet == null) {
            OCQuoteHandler.$$$reportNull$$$0(0);
        }
        return tokenSet;
    }

    public String getStringConcatenationOperatorRepresentation() {
        return "";
    }

    public TokenSet getStringTokenTypes() {
        return CONCATENATABLE_STRING;
    }

    public boolean isAppropriateElementTypeForLiteral(@NotNull IElementType tokenType) {
        if (tokenType == null) {
            OCQuoteHandler.$$$reportNull$$$0(1);
        }
        return OCQuoteHandler.isAppropriateElementTypeForLiteralStatic(tokenType);
    }

    public static boolean isAppropriateElementTypeForLiteralStatic(IElementType tokenType) {
        return OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(tokenType) || tokenType == OCTokenTypes.SEMICOLON || tokenType == OCTokenTypes.COMMA || tokenType == OCTokenTypes.RPAR || tokenType == OCTokenTypes.RBRACKET || tokenType == OCTokenTypes.RBRACE || tokenType == OCTokenTypes.STRING_LITERAL || tokenType == OCTokenTypes.CHARACTER_LITERAL;
    }

    public boolean needParenthesesAroundConcatenation(PsiElement element) {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/editor/OCQuoteHandler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConcatenatableStringTokenTypes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/editor/OCQuoteHandler";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAppropriateElementTypeForLiteral";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

