/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor;

import com.intellij.codeInsight.editorActions.BackspaceHandlerDelegate;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.editor.OCTypedHandlerDelegate;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import org.jetbrains.annotations.NotNull;

public final class OCBackspaceHandlerDelegate
extends BackspaceHandlerDelegate {
    public void beforeCharDeleted(char c, @NotNull PsiFile file, @NotNull Editor editor) {
        if (file == null) {
            OCBackspaceHandlerDelegate.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            OCBackspaceHandlerDelegate.$$$reportNull$$$0(1);
        }
    }

    public boolean charDeleted(char c, @NotNull PsiFile file, @NotNull Editor editor) {
        HighlighterIterator it;
        if (file == null) {
            OCBackspaceHandlerDelegate.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            OCBackspaceHandlerDelegate.$$$reportNull$$$0(3);
        }
        if (!OCLanguageUtils.isSupported(file)) {
            return false;
        }
        Document document = editor.getDocument();
        CharSequence text = document.getCharsSequence();
        int offset = editor.getCaretModel().getOffset();
        if (c == '{' && offset + 1 < text.length() && text.charAt(offset) == '}' && text.charAt(offset + 1) == ';' && OCTypedHandlerDelegate.needSemicolonAtContextEnd(it = editor.getHighlighter().createIterator(offset - 1))) {
            document.deleteString(offset, offset + 2);
            return true;
        }
        if (OCBackspaceHandlerDelegate.atEmptyIncludeDirectiveContents(c, editor, text, offset)) {
            document.deleteString(offset, offset + 1);
            return true;
        }
        return false;
    }

    private static boolean atEmptyIncludeDirectiveContents(char c, @NotNull Editor editor, @NotNull CharSequence text, int offset) {
        if (editor == null) {
            OCBackspaceHandlerDelegate.$$$reportNull$$$0(4);
        }
        if (text == null) {
            OCBackspaceHandlerDelegate.$$$reportNull$$$0(5);
        }
        if (c != '\"' && c != '<') {
            return false;
        }
        if (offset < 1 || offset >= text.length()) {
            return false;
        }
        char nextC = text.charAt(offset);
        if (c == '\"' && nextC != '\"' || c == '<' && nextC != '>') {
            return false;
        }
        int lineNumber = editor.getDocument().getLineNumber(offset);
        HighlighterIterator it = editor.getHighlighter().createIterator(offset - 1);
        while (!it.atEnd() && editor.getDocument().getLineNumber(it.getStart()) == lineNumber) {
            IElementType tt = it.getTokenType();
            if (OCTokenTypes.FILE_REF_DIRECTIVES.contains(tt)) {
                return true;
            }
            if (!OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(tt)) {
                return false;
            }
            it.retreat();
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/editor/OCBackspaceHandlerDelegate";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeCharDeleted";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "charDeleted";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "atEmptyIncludeDirectiveContents";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

