/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.actions.switchHeaderSource;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.ide.util.gotoByName.GotoFileCellRenderer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.GenericListComponentUpdater;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.IPopupChooserBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Alarm;
import com.intellij.util.ui.JBUI;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.actions.switchHeaderSource.OCSwitchHSHandler;
import com.jetbrains.cidr.lang.actions.switchHeaderSource.OCSwitchHSListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001:\u0001#B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0017\u001a\u00020\u0013H\u0002J\b\u0010\u0018\u001a\u00020\u0016H\u0002J\b\u0010\u0019\u001a\u00020\u0013H\u0002J\u0012\u0010\u001a\u001a\u00020\u00132\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u0013H\u0016J\b\u0010\u001e\u001a\u00020\u0013H\u0016J\u0010\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u001cH\u0016J\b\u0010!\u001a\u00020\u0013H\u0002J\b\u0010\"\u001a\u00020\u0013H\u0002R\u0013\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\f\u001a\t\u0018\u00010\r\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/jetbrains/cidr/lang/actions/switchHeaderSource/OCSwitchHSPopup;", "Lcom/jetbrains/cidr/lang/actions/switchHeaderSource/OCSwitchHSListener;", "project", "Lcom/intellij/openapi/project/Project;", "handler", "Lcom/jetbrains/cidr/lang/actions/switchHeaderSource/OCSwitchHSHandler;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/cidr/lang/actions/switchHeaderSource/OCSwitchHSHandler;Lcom/intellij/openapi/actionSystem/DataContext;)V", "balloonPosition", "Lcom/intellij/ui/awt/RelativePoint;", "Lorg/jetbrains/annotations/NotNull;", "editor", "Lcom/intellij/openapi/editor/Editor;", "Lorg/jetbrains/annotations/Nullable;", "items", "", "Lcom/intellij/psi/PsiFile;", "lock", "", "Lkotlin/Unit;", "ui", "Lcom/jetbrains/cidr/lang/actions/switchHeaderSource/OCSwitchHSPopup$UI;", "closePopup", "createPopupAndUpdater", "createUIIfNeeded", "gotoFile", "target", "Lcom/intellij/openapi/vfs/VirtualFile;", "onComputationFinished", "onComputationStarted", "onItemAdded", "item", "showNotFoundBalloon", "updateUI", "UI", "intellij.c"})
@SourceDebugExtension(value={"SMAP\nOCSwitchHSPopup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OCSwitchHSPopup.kt\ncom/jetbrains/cidr/lang/actions/switchHeaderSource/OCSwitchHSPopup\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,149:1\n1#2:150\n*E\n"})
public final class OCSwitchHSPopup
implements OCSwitchHSListener {
    @NotNull
    private final Project project;
    @NotNull
    private final OCSwitchHSHandler handler;
    @NotNull
    private final Unit lock;
    @Nullable
    private final Editor editor;
    @NotNull
    private final RelativePoint balloonPosition;
    @NotNull
    private final List<PsiFile> items;
    @Nullable
    private UI ui;

    public OCSwitchHSPopup(@NotNull Project project, @NotNull OCSwitchHSHandler handler, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        this.project = project;
        this.handler = handler;
        this.lock = Unit.INSTANCE;
        this.editor = (Editor)dataContext.getData(CommonDataKeys.EDITOR);
        RelativePoint relativePoint = JBPopupFactory.getInstance().guessBestPopupLocation(dataContext);
        Intrinsics.checkNotNullExpressionValue((Object)relativePoint, (String)"guessBestPopupLocation(...)");
        this.balloonPosition = relativePoint;
        this.items = new ArrayList();
    }

    @Override
    public void onComputationStarted() {
        ActionsKt.invokeLater$default(null, (Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ OCSwitchHSPopup this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                try {
                    OCSwitchHSPopup.access$getHandler$p(this.this$0).future().get(500L, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException e) {
                    OCSwitchHSPopup.access$createUIIfNeeded(this.this$0);
                }
            }
        }), (int)1, null);
    }

    @Override
    public void onComputationFinished() {
        ActionsKt.invokeLater$default(null, (Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ OCSwitchHSPopup this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                OCSwitchHSPopup.access$getLock$p(this.this$0);
                Unit unit = Unit.INSTANCE;
                OCSwitchHSPopup oCSwitchHSPopup = this.this$0;
                Unit unit2 = unit;
                synchronized (unit2) {
                    boolean bl = false;
                    switch (OCSwitchHSPopup.access$getItems$p(oCSwitchHSPopup).size()) {
                        case 0: {
                            OCSwitchHSPopup.access$closePopup(oCSwitchHSPopup);
                            OCSwitchHSPopup.access$showNotFoundBalloon(oCSwitchHSPopup);
                            break;
                        }
                        case 1: {
                            OCSwitchHSPopup.access$gotoFile(oCSwitchHSPopup, ((PsiFile)CollectionsKt.single((List)OCSwitchHSPopup.access$getItems$p(oCSwitchHSPopup))).getVirtualFile());
                            break;
                        }
                        default: {
                            OCSwitchHSPopup.access$createUIIfNeeded(oCSwitchHSPopup);
                        }
                    }
                    Unit unit3 = Unit.INSTANCE;
                }
            }
        }), (int)1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onItemAdded(@NotNull VirtualFile item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        PsiFile psiFile2 = (PsiFile)ActionsKt.runReadAction((Function0)((Function0)new Function0<PsiFile>(this, item){
            final /* synthetic */ OCSwitchHSPopup this$0;
            final /* synthetic */ VirtualFile $item;
            {
                this.this$0 = $receiver;
                this.$item = $item;
                super(0);
            }

            @Nullable
            public final PsiFile invoke() {
                return PsiManager.getInstance((Project)OCSwitchHSPopup.access$getProject$p(this.this$0)).findFile(this.$item);
            }
        }));
        if (psiFile2 != null) {
            Unit unit = this.lock;
            synchronized (unit) {
                Unit unit2;
                boolean bl = false;
                this.items.add(psiFile2);
                UI uI = this.ui;
                if (uI != null && (uI = uI.getAlarm()) != null) {
                    UI it = uI;
                    boolean bl2 = false;
                    it.cancelAllRequests();
                    it.addRequest(this::updateUI, 50);
                    unit2 = Unit.INSTANCE;
                } else {
                    unit2 = null;
                }
                Unit unit3 = unit2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void createUIIfNeeded() {
        Unit unit = this.lock;
        synchronized (unit) {
            boolean bl = false;
            if (this.ui == null) {
                this.ui = this.createPopupAndUpdater();
            }
            this.updateUI();
            Unit unit2 = Unit.INSTANCE;
        }
    }

    private final UI createPopupAndUpdater() {
        Object object = WindowManagerEx.getInstanceEx().getFrame(this.project);
        int maxWidth = object != null && (object = object.getSize()) != null ? object.width : 500;
        GotoFileCellRenderer renderer = new GotoFileCellRenderer(maxWidth);
        IPopupChooserBuilder builder2 = JBPopupFactory.getInstance().createPopupChooserBuilder(this.items).setTitle(OCBundle.message("switch.header.source.popup.title", new Object[0])).setMovable(true).setFont(EditorUtil.getEditorFont()).setRenderer((ListCellRenderer)renderer).withHintUpdateSupply().setResizable(true).setItemsChosenCallback(arg_0 -> OCSwitchHSPopup.createPopupAndUpdater$lambda$3((Function1)new Function1<Set<? extends PsiFile>, Unit>(this){
            final /* synthetic */ OCSwitchHSPopup this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(Set<? extends PsiFile> it) {
                Intrinsics.checkNotNull(it);
                PsiFile psiFile2 = (PsiFile)CollectionsKt.firstOrNull((Iterable)it);
                OCSwitchHSPopup.access$gotoFile(this.this$0, (VirtualFile)(psiFile2 != null ? psiFile2.getVirtualFile() : null));
            }
        }, arg_0)).setCancelCallback(() -> OCSwitchHSPopup.createPopupAndUpdater$lambda$4(this));
        renderer.installSpeedSearch(builder2);
        JBPopup jBPopup = builder2.createPopup();
        Intrinsics.checkNotNullExpressionValue((Object)jBPopup, (String)"createPopup(...)");
        GenericListComponentUpdater genericListComponentUpdater = builder2.getBackgroundUpdater();
        Intrinsics.checkNotNullExpressionValue((Object)genericListComponentUpdater, (String)"getBackgroundUpdater(...)");
        UI ui = new UI(jBPopup, (GenericListComponentUpdater<PsiFile>)genericListComponentUpdater);
        Disposer.register((Disposable)((Disposable)this.project), (Disposable)((Disposable)ui.getPopup()));
        if (this.editor != null) {
            ui.getPopup().showInBestPositionFor(this.editor);
        } else {
            ui.getPopup().showInFocusCenter();
        }
        return ui;
    }

    private final void gotoFile(VirtualFile target) {
        this.handler.cancel();
        if (target != null) {
            FileEditorManager.getInstance((Project)this.project).openTextEditor(new OpenFileDescriptor(this.project, target), true);
            this.handler.notifyTargetChosen(target);
        }
    }

    private final void closePopup() {
        block0: {
            this.handler.cancel();
            UI uI = this.ui;
            if (uI == null) break block0;
            UI it = uI;
            boolean bl = false;
            Disposer.dispose((Disposable)((Disposable)it.getPopup()));
        }
    }

    private final void showNotFoundBalloon() {
        JComponent jComponent = HintUtil.createErrorLabel((String)OCBundle.message("switch.header.source.no.results", new Object[0]));
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"createErrorLabel(...)");
        JComponent label = jComponent;
        label.setBorder((Border)JBUI.Borders.empty((int)2, (int)7));
        JBPopupFactory.getInstance().createBalloonBuilder(label).setFadeoutTime(3000L).setFillColor(HintUtil.getErrorColor()).createBalloon().show(this.balloonPosition, Balloon.Position.above);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void updateUI() {
        Unit unit = this.lock;
        synchronized (unit) {
            Unit unit2;
            boolean bl = false;
            UI uI = this.ui;
            if (uI != null) {
                UI it = uI;
                boolean bl2 = false;
                it.getPopupUpdater().paintBusy(!this.handler.future().isDone());
                it.getPopupUpdater().replaceModel(this.items);
                it.getPopup().pack(true, true);
                unit2 = Unit.INSTANCE;
            } else {
                unit2 = null;
            }
            Unit unit3 = unit2;
        }
    }

    private static final void createPopupAndUpdater$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final Boolean createPopupAndUpdater$lambda$4(OCSwitchHSPopup this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.handler.cancel();
        return true;
    }

    public static final /* synthetic */ OCSwitchHSHandler access$getHandler$p(OCSwitchHSPopup $this) {
        return $this.handler;
    }

    public static final /* synthetic */ void access$createUIIfNeeded(OCSwitchHSPopup $this) {
        $this.createUIIfNeeded();
    }

    public static final /* synthetic */ void access$getLock$p(OCSwitchHSPopup $this) {
        Unit cfr_ignored_0 = $this.lock;
    }

    public static final /* synthetic */ List access$getItems$p(OCSwitchHSPopup $this) {
        return $this.items;
    }

    public static final /* synthetic */ void access$closePopup(OCSwitchHSPopup $this) {
        $this.closePopup();
    }

    public static final /* synthetic */ void access$showNotFoundBalloon(OCSwitchHSPopup $this) {
        $this.showNotFoundBalloon();
    }

    public static final /* synthetic */ void access$gotoFile(OCSwitchHSPopup $this, VirtualFile target) {
        $this.gotoFile(target);
    }

    public static final /* synthetic */ Project access$getProject$p(OCSwitchHSPopup $this) {
        return $this.project;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/cidr/lang/actions/switchHeaderSource/OCSwitchHSPopup$UI;", "", "popup", "Lcom/intellij/openapi/ui/popup/JBPopup;", "popupUpdater", "Lcom/intellij/openapi/ui/GenericListComponentUpdater;", "Lcom/intellij/psi/PsiFile;", "(Lcom/intellij/openapi/ui/popup/JBPopup;Lcom/intellij/openapi/ui/GenericListComponentUpdater;)V", "alarm", "Lcom/intellij/util/Alarm;", "getAlarm", "()Lcom/intellij/util/Alarm;", "getPopup", "()Lcom/intellij/openapi/ui/popup/JBPopup;", "getPopupUpdater", "()Lcom/intellij/openapi/ui/GenericListComponentUpdater;", "intellij.c"})
    private static final class UI {
        @NotNull
        private final JBPopup popup;
        @NotNull
        private final GenericListComponentUpdater<PsiFile> popupUpdater;
        @NotNull
        private final Alarm alarm;

        public UI(@NotNull JBPopup popup, @NotNull GenericListComponentUpdater<PsiFile> popupUpdater) {
            Intrinsics.checkNotNullParameter((Object)popup, (String)"popup");
            Intrinsics.checkNotNullParameter(popupUpdater, (String)"popupUpdater");
            this.popup = popup;
            this.popupUpdater = popupUpdater;
            this.alarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this.popup);
        }

        @NotNull
        public final JBPopup getPopup() {
            return this.popup;
        }

        @NotNull
        public final GenericListComponentUpdater<PsiFile> getPopupUpdater() {
            return this.popupUpdater;
        }

        @NotNull
        public final Alarm getAlarm() {
            return this.alarm;
        }
    }
}

