/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.actions.newFile;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiFile;
import com.intellij.util.ui.FormBuilder;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCFileType;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileActionBase;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.settings.OCNewClassSettings;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesHelper;
import icons.CidrLangIcons;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Properties;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComboBox;
import org.jetbrains.annotations.NotNull;

public class OCNewClassAction<T extends CreateClassDialog>
extends OCNewFileActionBase<T> {
    private static final String PUT_IVARS_TO_IMPLEMENTATION_TEMPLATE_PROPERTY = "PUT_IVARS_TO_IMPLEMENTATION";
    public static final String DEFAULT_M_EXT = ".m";
    public static final String DEFAULT_MM_EXT = ".mm";
    public static final String DEFAULT_H_EXT = ".h";

    public OCNewClassAction() {
        this(OCBundle.message("create.class.title", new Object[0]), OCBundle.message("create.class.description", new Object[0]), CidrLangIcons.CodeAssistantClass);
    }

    public OCNewClassAction(@NlsActions.ActionText String text, @NlsActions.ActionDescription String description, Icon icon2) {
        super((FileType)OCFileType.INSTANCE, text, description, icon2);
    }

    public OCNewClassAction(@NotNull Supplier<@NlsActions.ActionText String> dynamicText, @NotNull Supplier<@NlsActions.ActionDescription String> dynamicDescription, Icon icon2) {
        if (dynamicText == null) {
            OCNewClassAction.$$$reportNull$$$0(0);
        }
        if (dynamicDescription == null) {
            OCNewClassAction.$$$reportNull$$$0(1);
        }
        super((FileType)OCFileType.INSTANCE, dynamicText, dynamicDescription, icon2);
    }

    @NotNull
    protected String getDefaultName() {
        String string = this.getDefaultClassPrefix();
        if (string == null) {
            OCNewClassAction.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    protected OCNewFileActionBase.NewFileNames getNewFileNames(String selectedName) {
        return new OCNewFileActionBase.NewFileNames(selectedName + ((CreateClassDialog)this.getState().dialogPeer).getImplementationExtension(), selectedName + DEFAULT_H_EXT);
    }

    @NotNull
    protected OCNewFileActionBase.NewFileNames getNewFileNames(String selectedName, @NotNull PsiFile sampleFile) {
        if (sampleFile == null) {
            OCNewClassAction.$$$reportNull$$$0(3);
        }
        OCFile implFile = ((OCFile)sampleFile).isHeader() ? ((OCFile)sampleFile).getAssociatedFile() : (OCFile)sampleFile;
        String extension = implFile != null && implFile.getName().endsWith(DEFAULT_MM_EXT) ? DEFAULT_MM_EXT : DEFAULT_M_EXT;
        return new OCNewFileActionBase.NewFileNames(selectedName + extension, selectedName + DEFAULT_H_EXT);
    }

    protected String getFileTemplate(String fileName) {
        if (fileName.endsWith(DEFAULT_M_EXT) || fileName.endsWith(DEFAULT_MM_EXT)) {
            return "Objective-C Class.m";
        }
        if (fileName.endsWith(DEFAULT_H_EXT)) {
            return "Objective-C Header File.h";
        }
        assert (false);
        return null;
    }

    protected void setAdditionalProperties(Properties properties, String fileName, PsiFile sampleFile, Project project) {
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyle.getSettings((Project)project).getCustomSettings(OCCodeStyleSettings.class);
        properties.setProperty("HEADER_FILENAME", this.mySelectedName + DEFAULT_H_EXT);
        boolean putToImplementation = OCCompilerFeaturesHelper.supportsIvarsInImplementation() && settings.PUT_IVARS_TO_IMPLEMENTATION;
        properties.setProperty(PUT_IVARS_TO_IMPLEMENTATION_TEMPLATE_PROPERTY, putToImplementation ? "true" : "false");
    }

    @NotNull
    protected T createDialog(@NotNull @NlsContexts.Label String defaultName) {
        if (defaultName == null) {
            OCNewClassAction.$$$reportNull$$$0(4);
        }
        return (T)((Object)new CreateClassDialog(defaultName));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dynamicText";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dynamicDescription";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/actions/newFile/OCNewClassAction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sampleFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/actions/newFile/OCNewClassAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getNewFileNames";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createDialog";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    protected class CreateClassDialog
    extends OCNewFileActionBase.CreateFileDialogBase {
        private JComboBox<String> myLanguageCombo;

        public CreateClassDialog(String defaultName) {
            super((OCNewFileActionBase)OCNewClassAction.this, OCBundle.message("create.class.dialog.title", new Object[0]), defaultName, null);
        }

        public CreateClassDialog(@NlsContexts.Label String title, String nameFieldTitle, String defaultName) {
            super((OCNewFileActionBase)OCNewClassAction.this, title, nameFieldTitle, defaultName, null);
        }

        public void fillGenericControls(FormBuilder formBuilder) {
            super.fillGenericControls(formBuilder);
            this.myLanguageCombo = new ComboBox((Object[])new String[]{OCBundle.message("create.class.objc", new Object[0]), OCBundle.message("create.class.objcpp", new Object[0])});
            formBuilder.addLabeledComponent(OCBundle.message("create.field.language", new Object[0]), this.myLanguageCombo);
            this.myLanguageCombo.setSelectedIndex(OCNewClassSettings.getInstance().myLanguageIndex);
            this.myLanguageCombo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    OCNewClassSettings.getInstance().myLanguageIndex = CreateClassDialog.this.myLanguageCombo.getSelectedIndex();
                    CreateClassDialog.this.validateOkAction();
                }
            });
        }

        protected String getImplementationExtension() {
            return this.myLanguageCombo.getSelectedIndex() == 0 ? OCNewClassAction.DEFAULT_M_EXT : OCNewClassAction.DEFAULT_MM_EXT;
        }
    }
}

