/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelper;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.SpecificNameItemProcessor;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.PathUtil;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.CustomHeaderProvider;
import com.jetbrains.cidr.lang.OCIncludeHelper;
import com.jetbrains.cidr.lang.OCIncludeHelpersKt;
import com.jetbrains.cidr.lang.autoImport.OCAutoImportHelper;
import com.jetbrains.cidr.lang.preprocessor.OCResolveRootAndConfiguration;
import com.jetbrains.cidr.lang.symbols.cpp.OCIncludeSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCNamesInterner;
import com.jetbrains.cidr.lang.toolchains.CidrFileSeparators;
import com.jetbrains.cidr.lang.workspace.OCCompilerSettings;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceModificationTrackers;
import com.jetbrains.cidr.lang.workspace.headerRoots.AppleFramework;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoots;
import com.jetbrains.cidr.lang.workspace.headerRoots.RealFramework;
import com.jetbrains.cidr.lang.workspace.headerRoots.SurrogateSearchRoot;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.Unmodifiable;

public final class OCIncludeHelpers {
    private static final char[] VFS_SEPARATOR_CHAR_ARRAY = new char[]{'/'};
    private static boolean ourAllowFilesystemAccess = true;

    public static List<OCIncludeHelper> getIncludeHelpers() {
        return OCIncludeHelper.EP_NAME.getExtensionList();
    }

    public static ShowInCompletion showInCompletion(@Nullable PsiFileSystemItem item) {
        if (item == null) {
            return ShowInCompletion.DEFAULT;
        }
        ShowInCompletion result = ShowInCompletion.DEFAULT;
        for (OCIncludeHelper each : OCIncludeHelpers.getIncludeHelpers()) {
            ShowInCompletion eachResult = each.showInCompletion(item);
            if (eachResult == ShowInCompletion.DEFAULT) continue;
            if (eachResult == ShowInCompletion.SHOW) {
                return ShowInCompletion.SHOW;
            }
            result = eachResult;
        }
        if (result == ShowInCompletion.DEFAULT && item instanceof AppleFramework) {
            return ShowInCompletion.SHOW;
        }
        return result;
    }

    @Nullable
    public static VirtualFile resolveIncludedFile(@Nullable OCResolveRootAndConfiguration rootAndConfiguration, @Nullable VirtualFile context, @NotNull OCIncludeSymbol.IncludePath include, @NotNull Project project) {
        if (include == null) {
            OCIncludeHelpers.$$$reportNull$$$0(0);
        }
        if (project == null) {
            OCIncludeHelpers.$$$reportNull$$$0(1);
        }
        Ref result = new Ref();
        OCIncludeHelpers.resolveNextIncludedFile(rootAndConfiguration, context, null, include, project, (Ref<VirtualFile>)result);
        return (VirtualFile)result.get();
    }

    @TestOnly
    public static void banLocalFilesystemAccess(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            OCIncludeHelpers.$$$reportNull$$$0(2);
        }
        boolean old = ourAllowFilesystemAccess;
        ourAllowFilesystemAccess = false;
        Disposer.register((Disposable)parentDisposable, () -> {
            ourAllowFilesystemAccess = old;
        });
    }

    public static void resolveNextIncludedFile(@Nullable OCResolveRootAndConfiguration rootAndConfiguration, @Nullable VirtualFile context, @Nullable VirtualFile after2, @NotNull OCIncludeSymbol.IncludePath include, @NotNull Project project, @NotNull Ref<VirtualFile> result) {
        VirtualFile customHeaderBeforeFrameworks;
        Collection possibleFiles;
        List<PsiFileSystemItem> firstSegmentElements;
        PsiFileSystemItem item;
        String path;
        String normalizedPath;
        List pathElements;
        if (include == null) {
            OCIncludeHelpers.$$$reportNull$$$0(3);
        }
        if (project == null) {
            OCIncludeHelpers.$$$reportNull$$$0(4);
        }
        if (result == null) {
            OCIncludeHelpers.$$$reportNull$$$0(5);
        }
        if (project.isDisposed()) {
            return;
        }
        if (context == null || !context.isValid()) {
            return;
        }
        if (!ourAllowFilesystemAccess) {
            return;
        }
        CidrFileSeparators separators = OCResolveConfiguration.DEFAULT_FILE_SEPARATORS;
        OCResolveConfiguration configuration = null;
        if (rootAndConfiguration != null && (configuration = rootAndConfiguration.getConfiguration()) != null) {
            separators = configuration.getFileSeparators();
            OCCompilerSettings compilerSettings = OCIncludeHelpers.getHeadersSearchRoots(configuration, rootAndConfiguration);
            VirtualFile mappedInclude = compilerSettings.getMappedInclude(include.getPath());
            if (mappedInclude != null) {
                result.set((Object)mappedInclude);
                return;
            }
        }
        if ((pathElements = StringsKt.split((CharSequence)(normalizedPath = OCIncludeHelpers.setDefaultDelimiter(path = include.getPath(), separators)), (char[])VFS_SEPARATOR_CHAR_ARRAY, (boolean)false, (int)0)).size() == 0) {
            return;
        }
        CustomHeaderProvider.Helper customHeaderProviders = CustomHeaderProvider.getProviders(path, rootAndConfiguration);
        VirtualFile customHeaderBeforeStart = customHeaderProviders.getCustomHeader(CustomHeaderProvider.HeaderSearchStage.BEFORE_START);
        if (customHeaderBeforeStart != null) {
            result.set((Object)customHeaderBeforeStart);
            return;
        }
        String first = (String)pathElements.get(0);
        if (OCIncludeHelpers.findAbsoluteHeader(path, first, result)) {
            return;
        }
        VirtualFile customHeaderBeforeCurrent = customHeaderProviders.getCustomHeader(CustomHeaderProvider.HeaderSearchStage.BEFORE_CURRENT);
        if (customHeaderBeforeCurrent != null) {
            result.set((Object)customHeaderBeforeCurrent);
            return;
        }
        boolean searchInCurrent = after2 == null && !include.isAngleBrackets() && !FileUtil.namesEqual((String)context.getName(), (String)path);
        Ref afterDirRef = new Ref((Object)(after2 == null ? null : after2.getParent()));
        if (searchInCurrent && (item = FileReferenceHelper.getPsiFileSystemItem((PsiManager)PsiManager.getInstance((Project)project), (VirtualFile)context)) != null && item.getParent() != null && OCIncludeHelpers.findHeader(firstSegmentElements = OCIncludeHelpers.findChild(item.getParent(), first), pathElements, (Ref<VirtualFile>)afterDirRef, result)) {
            return;
        }
        Processor containingFrameworkProcessor = framework -> {
            if (framework.getName().equals(first) && OCIncludeHelpers.findHeader(Collections.singletonList(framework), pathElements, (Ref<VirtualFile>)afterDirRef, result)) {
                return false;
            }
            return !OCIncludeHelpers.findHeader(OCIncludeHelpers.findChild(framework, first), pathElements, (Ref<VirtualFile>)afterDirRef, result);
        };
        if (!include.isAngleBrackets() && !OCIncludeHelpers.processContainingFramework(project, context, (Processor<PsiFileSystemItem>)containingFrameworkProcessor)) {
            return;
        }
        VirtualFile customHeaderBeforeLibraries = customHeaderProviders.getCustomHeader(CustomHeaderProvider.HeaderSearchStage.BEFORE_LIBRARIES);
        if (customHeaderBeforeLibraries != null) {
            result.set((Object)customHeaderBeforeLibraries);
            return;
        }
        if (configuration != null) {
            HeadersSearchRoots roots2 = OCIncludeHelpers.getHeadersSearchRoots(configuration, rootAndConfiguration).getHeadersSearchRoots();
            if (!include.isAngleBrackets() && OCIncludeHelpersKt.findHeaderUsingSegmentCache(rootAndConfiguration, HeaderRootsSegmentCache.getQuoteHeaderRootsCache(project), roots2.getUserHeaderRoots(), pathElements, normalizedPath, (Ref<VirtualFile>)afterDirRef, result)) {
                return;
            }
            if (OCIncludeHelpersKt.findHeaderUsingSegmentCache(rootAndConfiguration, HeaderRootsSegmentCache.getHeaderRootsCache(project), roots2.getLibraryRoots(), pathElements, normalizedPath, (Ref<VirtualFile>)afterDirRef, result)) {
                return;
            }
        } else if (!include.isAngleBrackets() && Registry.is((String)"clion.search.header.paths") && !(possibleFiles = FilenameIndex.getVirtualFilesByName((String)PathUtil.getFileName((String)normalizedPath), (GlobalSearchScope)GlobalSearchScope.allScope((Project)project))).isEmpty()) {
            result.set((Object)((VirtualFile)possibleFiles.stream().toList().get(0)));
        }
        if ((customHeaderBeforeFrameworks = customHeaderProviders.getCustomHeader(CustomHeaderProvider.HeaderSearchStage.BEFORE_FRAMEWORKS)) != null) {
            result.set((Object)customHeaderBeforeFrameworks);
            return;
        }
        if (include.isAngleBrackets() && !OCIncludeHelpers.processContainingFramework(project, context, (Processor<PsiFileSystemItem>)containingFrameworkProcessor)) {
            return;
        }
        VirtualFile customHeaderAfterEnd = customHeaderProviders.getCustomHeader(CustomHeaderProvider.HeaderSearchStage.AFTER_END);
        if (customHeaderAfterEnd != null) {
            result.set((Object)customHeaderAfterEnd);
        }
    }

    @NotNull
    private static OCCompilerSettings getHeadersSearchRoots(@NotNull OCResolveConfiguration configuration, @NotNull OCResolveRootAndConfiguration rootAndConfiguration) {
        OCCompilerSettings customSettings;
        if (configuration == null) {
            OCIncludeHelpers.$$$reportNull$$$0(6);
        }
        if (rootAndConfiguration == null) {
            OCIncludeHelpers.$$$reportNull$$$0(7);
        }
        if ((customSettings = CustomHeaderProvider.getCustomCompilerSettings(configuration, rootAndConfiguration)) != null) {
            OCCompilerSettings oCCompilerSettings = customSettings;
            if (oCCompilerSettings == null) {
                OCIncludeHelpers.$$$reportNull$$$0(8);
            }
            return oCCompilerSettings;
        }
        OCCompilerSettings oCCompilerSettings = configuration.getCompilerSettings(rootAndConfiguration.getKind(), rootAndConfiguration.getRootFile());
        if (oCCompilerSettings == null) {
            OCIncludeHelpers.$$$reportNull$$$0(9);
        }
        return oCCompilerSettings;
    }

    @NotNull
    static String setDefaultDelimiter(@NotNull String path, @NotNull CidrFileSeparators separators) {
        if (path == null) {
            OCIncludeHelpers.$$$reportNull$$$0(10);
        }
        if (separators == null) {
            OCIncludeHelpers.$$$reportNull$$$0(11);
        }
        String string = switch (separators) {
            default -> throw new IncompatibleClassChangeError();
            case CidrFileSeparators.UNIX -> path;
            case CidrFileSeparators.WINDOWS_UNIX -> FileUtil.toSystemIndependentName((String)path);
        };
        if (string == null) {
            OCIncludeHelpers.$$$reportNull$$$0(12);
        }
        return string;
    }

    static boolean findAbsoluteHeader(@NotNull String path, @NotNull String first, @NotNull Ref<VirtualFile> result) {
        if (path == null) {
            OCIncludeHelpers.$$$reportNull$$$0(13);
        }
        if (first == null) {
            OCIncludeHelpers.$$$reportNull$$$0(14);
        }
        if (result == null) {
            OCIncludeHelpers.$$$reportNull$$$0(15);
        }
        if (first.isEmpty() || FileUtil.isWindowsAbsolutePath((String)path)) {
            VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path);
            result.set(file == null || file.isDirectory() ? null : file);
            return true;
        }
        return false;
    }

    static boolean findHeader(@NotNull List<PsiFileSystemItem> firstSegmentElements, @NotNull List<String> pathElements, @NotNull Ref<VirtualFile> afterDirRef, @NotNull Ref<VirtualFile> result) {
        if (firstSegmentElements == null) {
            OCIncludeHelpers.$$$reportNull$$$0(16);
        }
        if (pathElements == null) {
            OCIncludeHelpers.$$$reportNull$$$0(17);
        }
        if (afterDirRef == null) {
            OCIncludeHelpers.$$$reportNull$$$0(18);
        }
        if (result == null) {
            OCIncludeHelpers.$$$reportNull$$$0(19);
        }
        for (PsiFileSystemItem segment : firstSegmentElements) {
            VirtualFile file;
            PsiFile candidate = null;
            if (pathElements.size() != 1) {
                candidate = OCIncludeHelpers.find(segment, pathElements, 1);
            } else if (segment instanceof PsiFile) {
                candidate = (PsiFile)segment;
            }
            if (candidate == null || (file = candidate.getVirtualFile()) == null) continue;
            VirtualFile after2 = (VirtualFile)afterDirRef.get();
            if (after2 == null) {
                result.set((Object)file);
                return true;
            }
            if (Comparing.equal((Object)file.getParent(), (Object)after2)) {
                afterDirRef.set(null);
                continue;
            }
            if (firstSegmentElements.size() != 1) continue;
            result.set((Object)file);
            return true;
        }
        return false;
    }

    public static boolean processContainingFramework(@NotNull Project project, @Nullable VirtualFile forFile, @NotNull Processor<PsiFileSystemItem> processor2) {
        if (project == null) {
            OCIncludeHelpers.$$$reportNull$$$0(20);
        }
        if (processor2 == null) {
            OCIncludeHelpers.$$$reportNull$$$0(21);
        }
        if (forFile == null) {
            return true;
        }
        for (OCIncludeHelper each : OCIncludeHelpers.getIncludeHelpers()) {
            if (each.processContainingFramework(project, forFile, processor2)) continue;
            return false;
        }
        for (VirtualFile parent = forFile; parent != null; parent = parent.getParent()) {
            if (!parent.getName().endsWith(".framework") || processor2.process((Object)new RealFramework(project, parent, null))) continue;
            return false;
        }
        return true;
    }

    public static boolean processImportSpecifications(@NotNull Project project, @NotNull OCResolveRootAndConfiguration rootAndConfiguration, @Nullable VirtualFile targetFile, @NotNull VirtualFile fileToImport, @NotNull Processor<OCAutoImportHelper.ImportSpecification> processor2) {
        if (project == null) {
            OCIncludeHelpers.$$$reportNull$$$0(22);
        }
        if (rootAndConfiguration == null) {
            OCIncludeHelpers.$$$reportNull$$$0(23);
        }
        if (fileToImport == null) {
            OCIncludeHelpers.$$$reportNull$$$0(24);
        }
        if (processor2 == null) {
            OCIncludeHelpers.$$$reportNull$$$0(25);
        }
        for (OCAutoImportHelper each : OCAutoImportHelper.EP_NAME.getExtensionList()) {
            if (!each.supports(rootAndConfiguration) || each.processPathSpecificationToInclude(project, targetFile, fileToImport, rootAndConfiguration, processor2)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private static PsiFile find(PsiFileSystemItem root, List<String> pathElements, int cur) {
        if (root == null || cur >= pathElements.size()) {
            return null;
        }
        String name = pathElements.get(cur);
        if (name.isEmpty()) {
            return OCIncludeHelpers.find(root, pathElements, cur + 1);
        }
        for (PsiFileSystemItem item : OCIncludeHelpers.findChild(root, name)) {
            if (cur == pathElements.size() - 1) {
                if (!(item instanceof PsiFile)) continue;
                return (PsiFile)item;
            }
            PsiFile element = OCIncludeHelpers.find(item, pathElements, cur + 1);
            if (element == null) continue;
            return element;
        }
        return null;
    }

    @NotNull
    private static List<PsiFileSystemItem> findChild(PsiFileSystemItem parent, String childName) {
        if (parent == null || !parent.isValid()) {
            List<PsiFileSystemItem> list = Collections.emptyList();
            if (list == null) {
                OCIncludeHelpers.$$$reportNull$$$0(26);
            }
            return list;
        }
        if ("..".equals(childName)) {
            if (parent instanceof SurrogateSearchRoot) {
                List<PsiFileSystemItem> list = Collections.emptyList();
                if (list == null) {
                    OCIncludeHelpers.$$$reportNull$$$0(27);
                }
                return list;
            }
            VirtualFile vFile = parent.getVirtualFile();
            if (parent instanceof AppleFramework) {
                VirtualFile headersRoot;
                VirtualFile virtualFile = headersRoot = vFile != null ? vFile.findChild("Headers") : null;
                if (headersRoot != null) {
                    vFile = headersRoot;
                }
            }
            if (vFile == null) {
                List<PsiFileSystemItem> list = Collections.emptyList();
                if (list == null) {
                    OCIncludeHelpers.$$$reportNull$$$0(28);
                }
                return list;
            }
            VirtualFile vParent = vFile.getParent();
            if (vParent == null) {
                List<PsiFileSystemItem> list = Collections.emptyList();
                if (list == null) {
                    OCIncludeHelpers.$$$reportNull$$$0(29);
                }
                return list;
            }
            PsiDirectory directory = parent.getManager().findDirectory(vParent);
            List list = ContainerUtil.createMaybeSingletonList((Object)directory);
            if (list == null) {
                OCIncludeHelpers.$$$reportNull$$$0(30);
            }
            return list;
        }
        if (".".equals(childName)) {
            List<PsiFileSystemItem> list = Collections.singletonList(parent);
            if (list == null) {
                OCIncludeHelpers.$$$reportNull$$$0(31);
            }
            return list;
        }
        if (parent instanceof PsiDirectory) {
            return OCIncludeHelpers.findInDir((PsiDirectory)parent, childName);
        }
        final SmartList result = new SmartList();
        parent.processChildren((PsiElementProcessor)new SpecificNameItemProcessor(childName){

            public boolean execute(@NotNull PsiFileSystemItem element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                result.add((Object)element);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/OCIncludeHelpers$1", "execute"));
            }
        });
        SmartList smartList = result;
        if (smartList == null) {
            OCIncludeHelpers.$$$reportNull$$$0(32);
        }
        return smartList;
    }

    @NotNull
    private static List<PsiFileSystemItem> findInDir(@NotNull PsiDirectory dir, @NotNull String childName) {
        PsiFile found;
        if (dir == null) {
            OCIncludeHelpers.$$$reportNull$$$0(33);
        }
        if (childName == null) {
            OCIncludeHelpers.$$$reportNull$$$0(34);
        }
        if ((found = dir.findFile(childName)) == null) {
            found = dir.findSubdirectory(childName);
        }
        List list = ContainerUtil.createMaybeSingletonList((Object)found);
        if (list == null) {
            OCIncludeHelpers.$$$reportNull$$$0(35);
        }
        return list;
    }

    @NotNull
    public static String adjustHeaderName(@NotNull String headerName) {
        if (headerName == null) {
            OCIncludeHelpers.$$$reportNull$$$0(36);
        }
        if ((headerName = headerName.trim()).startsWith("./")) {
            while (headerName.startsWith("./")) {
                int count;
                for (count = 1; count < headerName.length() && headerName.charAt(count) == '/'; ++count) {
                }
                headerName = headerName.substring(count);
            }
        } else {
            headerName = StringUtil.trimStart((String)headerName, (String)"//");
        }
        String string = headerName;
        if (string == null) {
            OCIncludeHelpers.$$$reportNull$$$0(37);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 12, 26, 27, 28, 29, 30, 31, 32, 35, 37 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "include";
                break;
            }
            case 1: 
            case 4: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 5: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 7: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootAndConfiguration";
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/OCIncludeHelpers";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separators";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstSegmentElements";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathElements";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterDirRef";
                break;
            }
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToImport";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childName";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "headerName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/OCIncludeHelpers";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeadersSearchRoots";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "setDefaultDelimiter";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "findChild";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "findInDir";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustHeaderName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveIncludedFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "banLocalFilesystemAccess";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "resolveNextIncludedFile";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getHeadersSearchRoots";
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 35: 
            case 37: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultDelimiter";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findAbsoluteHeader";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findHeader";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "processContainingFramework";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "processImportSpecifications";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "findInDir";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "adjustHeaderName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 12, 26, 27, 28, 29, 30, 31, 32, 35, 37 -> new IllegalStateException(string);
        };
    }

    public static enum ShowInCompletion {
        SHOW,
        DON_NOT_SHOW,
        DEFAULT;

    }

    static final class HeaderRootsSegmentCache {
        private static final NotNullLazyKey<CachedValue<HeaderRootsSegmentCache>, Project> RESOLVE_QUOTE_INCLUDE_CACHE = HeaderRootsSegmentCache.createCacheKey("RESOLVE_QUOTE_INCLUDE_CACHE");
        private static final NotNullLazyKey<CachedValue<HeaderRootsSegmentCache>, Project> RESOLVE_INCLUDE_CACHE = HeaderRootsSegmentCache.createCacheKey("RESOLVE_INCLUDE_CACHE");
        private final @NotNull ConcurrentMap<@Unmodifiable List<? extends HeadersSearchRoot>, FirstSegmentCache> myCache = new ConcurrentHashMap<List<? extends HeadersSearchRoot>, FirstSegmentCache>();

        private HeaderRootsSegmentCache() {
        }

        static HeaderRootsSegmentCache getQuoteHeaderRootsCache(@NotNull Project project) {
            if (project == null) {
                HeaderRootsSegmentCache.$$$reportNull$$$0(0);
            }
            return (HeaderRootsSegmentCache)((CachedValue)RESOLVE_QUOTE_INCLUDE_CACHE.getValue((UserDataHolder)project)).getValue();
        }

        static HeaderRootsSegmentCache getHeaderRootsCache(@NotNull Project project) {
            if (project == null) {
                HeaderRootsSegmentCache.$$$reportNull$$$0(1);
            }
            return (HeaderRootsSegmentCache)((CachedValue)RESOLVE_INCLUDE_CACHE.getValue((UserDataHolder)project)).getValue();
        }

        FirstSegmentCache getFirstSegmentCache(@NotNull @Unmodifiable List<? extends HeadersSearchRoot> roots2) {
            if (roots2 == null) {
                HeaderRootsSegmentCache.$$$reportNull$$$0(2);
            }
            return this.myCache.computeIfAbsent(roots2, FirstSegmentCache::new);
        }

        private static NotNullLazyKey<CachedValue<HeaderRootsSegmentCache>, Project> createCacheKey(@NotNull String name) {
            if (name == null) {
                HeaderRootsSegmentCache.$$$reportNull$$$0(3);
            }
            return NotNullLazyKey.createLazyKey((String)name, project -> CachedValuesManager.getManager((Project)project).createCachedValue(() -> {
                OCWorkspaceModificationTrackers tracker = OCWorkspace.getInstance((Project)project).getModificationTrackers();
                return new CachedValueProvider.Result((Object)new HeaderRootsSegmentCache(), new Object[]{tracker.getResolveConfigurationsTracker(), tracker.getSourceFilesTracker(), tracker.getCompilerSettingsTracker(), tracker.getSelectedResolveConfigurationTracker()});
            }, false));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "roots";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/lang/OCIncludeHelpers$HeaderRootsSegmentCache";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getQuoteHeaderRootsCache";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getHeaderRootsCache";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getFirstSegmentCache";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createCacheKey";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class FirstSegmentCache {
        @NotNull
        private final @Unmodifiable List<? extends HeadersSearchRoot> myRoots;
        private Map<String, List<PsiFileSystemItem>> myCache;

        private FirstSegmentCache(@NotNull @Unmodifiable List<? extends HeadersSearchRoot> roots2) {
            if (roots2 == null) {
                FirstSegmentCache.$$$reportNull$$$0(0);
            }
            this.myRoots = roots2;
        }

        private void prepareCache() {
            if (this.myCache != null) {
                return;
            }
            this.myCache = CollectionFactory.createFilePathMap();
            for (PsiFileSystemItem psiFileSystemItem : this.myRoots) {
                if (!psiFileSystemItem.isValid()) continue;
                psiFileSystemItem.processChildren(element -> this.myCache.computeIfAbsent(OCNamesInterner.intern((String)element.getName()), segment -> new ArrayList()).add(element));
            }
        }

        @NotNull
        synchronized List<PsiFileSystemItem> getFiles(@NotNull String segment) {
            if (segment == null) {
                FirstSegmentCache.$$$reportNull$$$0(1);
            }
            this.prepareCache();
            List list = this.myCache.computeIfAbsent(segment, child -> {
                ArrayList<PsiFileSystemItem> items = new ArrayList<PsiFileSystemItem>();
                for (PsiFileSystemItem psiFileSystemItem : this.myRoots) {
                    if (!psiFileSystemItem.isValid()) continue;
                    items.addAll(OCIncludeHelpers.findChild(psiFileSystemItem, child));
                }
                return items;
            });
            if (list == null) {
                FirstSegmentCache.$$$reportNull$$$0(2);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "roots";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "segment";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/OCIncludeHelpers$FirstSegmentCache";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/OCIncludeHelpers$FirstSegmentCache";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFiles";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getFiles";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

