/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.webUi.handlers;

import com.intellij.openapi.project.Project;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.HttpRequestHandler;
import org.jetbrains.qodana.QodanaWebUiSources;
import org.jetbrains.qodana.coroutines.QodanaDispatchersKt;
import org.jetbrains.qodana.registry.QodanaRegistry;
import org.jetbrains.qodana.webUi.ActiveWebUi;
import org.jetbrains.qodana.webUi.handlers.HandlerKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u0004H\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J \u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/qodana/webUi/handlers/QodanaWebUiSourcesHandler;", "Lorg/jetbrains/ide/HttpRequestHandler;", "()V", "getRequestedSourceFile", "", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "getSourceInputStream", "Ljava/io/InputStream;", "sourceFile", "isSupported", "", "process", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "context", "Lio/netty/channel/ChannelHandlerContext;", "intellij.qodana"})
public final class QodanaWebUiSourcesHandler
extends HttpRequestHandler {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isSupported(@NotNull FullHttpRequest request2) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        if (!super.isSupported(request2)) return false;
        String string = request2.uri();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uri(...)");
        if (!StringsKt.startsWith$default((String)string, (String)"/qodana.ide", (boolean)false, (int)2, null)) return false;
        return true;
    }

    public boolean process(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request2, @NotNull ChannelHandlerContext context) {
        Intrinsics.checkNotNullParameter((Object)urlDecoder, (String)"urlDecoder");
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        HandlerKt.processQodanaWebUiRequestAsync(request2, context, false, (Function3<? super Project, ? super ActiveWebUi, ? super Continuation<? super Boolean>, ? extends Object>)((Function3)new Function3<Project, ActiveWebUi, Continuation<? super Boolean>, Object>(this, request2, context, null){
            int label;
            final /* synthetic */ QodanaWebUiSourcesHandler this$0;
            final /* synthetic */ FullHttpRequest $request;
            final /* synthetic */ ChannelHandlerContext $context;
            {
                this.this$0 = $receiver;
                this.$request = $request;
                this.$context = $context;
                super(3, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        String string = QodanaWebUiSourcesHandler.access$getRequestedSourceFile(this.this$0, this.$request);
                        if (string == null) {
                            return Boxing.boxBoolean((boolean)false);
                        }
                        String requestedSourceFile = string;
                        this.label = 1;
                        Object object3 = BuildersKt.withContext((CoroutineContext)QodanaDispatchersKt.getQodanaDispatchers().getIO(), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(this.this$0, requestedSourceFile, this.$request, this.$context, null){
                            int label;
                            final /* synthetic */ QodanaWebUiSourcesHandler this$0;
                            final /* synthetic */ String $requestedSourceFile;
                            final /* synthetic */ FullHttpRequest $request;
                            final /* synthetic */ ChannelHandlerContext $context;
                            {
                                this.this$0 = $receiver;
                                this.$requestedSourceFile = $requestedSourceFile;
                                this.$request = $request;
                                this.$context = $context;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        byte[] byArray;
                                        ResultKt.throwOnFailure((Object)object);
                                        InputStream inputStream = QodanaWebUiSourcesHandler.access$getSourceInputStream(this.this$0, this.$requestedSourceFile);
                                        if (inputStream == null) {
                                            return Boxing.boxBoolean((boolean)false);
                                        }
                                        InputStream sourceInputStream = inputStream;
                                        Closeable closeable = sourceInputStream;
                                        Throwable throwable = null;
                                        try {
                                            InputStream it = (InputStream)closeable;
                                            boolean bl = false;
                                            byArray = it.readAllBytes();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable = throwable2;
                                            throw throwable2;
                                        }
                                        finally {
                                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                                        }
                                        byte[] data = byArray;
                                        Intrinsics.checkNotNull((Object)data);
                                        Channel channel = this.$context.channel();
                                        Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"channel(...)");
                                        EmptyHttpHeaders emptyHttpHeaders = EmptyHttpHeaders.INSTANCE;
                                        Intrinsics.checkNotNullExpressionValue((Object)emptyHttpHeaders, (String)"INSTANCE");
                                        QodanaWebUiSourcesHandler.access$sendData(this.this$0, data, this.$requestedSourceFile, this.$request, channel, (HttpHeaders)emptyHttpHeaders);
                                        return Boxing.boxBoolean((boolean)true);
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Boolean> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @Nullable
            public final Object invoke(@NotNull Project p1, @NotNull ActiveWebUi p2, @Nullable Continuation<? super Boolean> p3) {
                return new /* invalid duplicate definition of identical inner class */.invokeSuspend(Unit.INSTANCE);
            }
        }));
        return true;
    }

    private final String getRequestedSourceFile(FullHttpRequest request2) {
        String uri = new URI(request2.uri()).getPath();
        Intrinsics.checkNotNull((Object)uri);
        if (!StringsKt.startsWith$default((String)uri, (String)"/qodana.ide", (boolean)false, (int)2, null)) {
            return null;
        }
        String string = uri.substring(11);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        char[] cArray = new char[]{'/'};
        String sourceFile = StringsKt.trimStart((String)string, (char[])cArray);
        if (((CharSequence)sourceFile).length() == 0) {
            return null;
        }
        if (StringsKt.contains$default((CharSequence)sourceFile, (CharSequence)"..", (boolean)false, (int)2, null)) {
            return null;
        }
        return sourceFile;
    }

    private final InputStream getSourceInputStream(String sourceFile) {
        String sourcesPathInRegistry = QodanaRegistry.INSTANCE.getWebUiSourcesPath();
        if (((CharSequence)sourcesPathInRegistry).length() > 0) {
            String[] stringArray = new String[]{sourceFile};
            Path path = Paths.get(sourcesPathInRegistry, Arrays.copyOf(stringArray, stringArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            return new FileInputStream(path.toFile());
        }
        return QodanaWebUiSources.INSTANCE.getSource(sourceFile);
    }

    public static final /* synthetic */ String access$getRequestedSourceFile(QodanaWebUiSourcesHandler $this, FullHttpRequest request2) {
        return $this.getRequestedSourceFile(request2);
    }

    public static final /* synthetic */ InputStream access$getSourceInputStream(QodanaWebUiSourcesHandler $this, String sourceFile) {
        return $this.getSourceInputStream(sourceFile);
    }

    public static final /* synthetic */ boolean access$sendData(QodanaWebUiSourcesHandler $this, byte[] content, String name, FullHttpRequest request2, Channel channel, HttpHeaders extraHeaders) {
        return $this.sendData(content, name, request2, channel, extraHeaders);
    }
}

