/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.sarif.textFormat;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xml.util.XmlStringUtil;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.html2md.converter.FlexmarkHtmlConverter;
import com.vladsch.flexmark.html2md.converter.HtmlNodeRenderer;
import com.vladsch.flexmark.html2md.converter.HtmlNodeRendererFactory;
import com.vladsch.flexmark.html2md.converter.HtmlNodeRendererHandler;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataKey;
import com.vladsch.flexmark.util.data.MutableDataHolder;
import com.vladsch.flexmark.util.data.MutableDataSet;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.qodana.staticAnalysis.sarif.textFormat.PreElementHtmlRenderer;
import org.jetbrains.qodana.staticAnalysis.sarif.textFormat.Text_formatKt;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\f\u001a\b\u0010\u0011\u001a\u00020\u0001H\u0002\u001a\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0013H\u0000\u001a\u0018\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0013H\u0000\u001a\u000e\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0013\u001a\u000e\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0013\u001a\u000e\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u0013\u001a\u0010\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u0013H\u0002\"\u001b\u0010\u0000\u001a\u00020\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0005\u001a\u0004\b\u0002\u0010\u0003\" \u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\u0005\u001a\u0004\b\t\u0010\n\" \u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0005\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001f"}, d2={"htmlToMarkdownConverter", "Lcom/vladsch/flexmark/html2md/converter/FlexmarkHtmlConverter;", "getHtmlToMarkdownConverter", "()Lcom/vladsch/flexmark/html2md/converter/FlexmarkHtmlConverter;", "htmlToMarkdownConverter$delegate", "Lkotlin/Lazy;", "markdownToHtmlParser", "Lcom/vladsch/flexmark/parser/Parser;", "Lorg/jetbrains/annotations/NotNull;", "getMarkdownToHtmlParser", "()Lcom/vladsch/flexmark/parser/Parser;", "markdownToHtmlParser$delegate", "markdownToHtmlRenderer", "Lcom/vladsch/flexmark/html/HtmlRenderer;", "getMarkdownToHtmlRenderer", "()Lcom/vladsch/flexmark/html/HtmlRenderer;", "markdownToHtmlRenderer$delegate", "createHtmlToMarkdownConverter", "escapeContentInTag", "", "data", "tagName", "escapeExceptTag", "input", "htmlToMarkdown", "html", "htmlToPlainText", "markdownToHtml", "markdown", "unescape", "text", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\ntext-format.kt\nKotlin\n*S Kotlin\n*F\n+ 1 text-format.kt\norg/jetbrains/qodana/staticAnalysis/sarif/textFormat/Text_formatKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,95:1\n1855#2,2:96\n1855#2,2:98\n1313#3,2:100\n*S KotlinDebug\n*F\n+ 1 text-format.kt\norg/jetbrains/qodana/staticAnalysis/sarif/textFormat/Text_formatKt\n*L\n39#1:96,2\n45#1:98,2\n69#1:100,2\n*E\n"})
public final class Text_formatKt {
    @NotNull
    private static final Lazy htmlToMarkdownConverter$delegate = LazyKt.lazy((Function0)htmlToMarkdownConverter.2.INSTANCE);
    @NotNull
    private static final Lazy markdownToHtmlParser$delegate = LazyKt.lazy((Function0)markdownToHtmlParser.2.INSTANCE);
    @NotNull
    private static final Lazy markdownToHtmlRenderer$delegate = LazyKt.lazy((Function0)markdownToHtmlRenderer.2.INSTANCE);

    private static final FlexmarkHtmlConverter getHtmlToMarkdownConverter() {
        Lazy lazy = htmlToMarkdownConverter$delegate;
        return (FlexmarkHtmlConverter)lazy.getValue();
    }

    private static final Parser getMarkdownToHtmlParser() {
        Lazy lazy = markdownToHtmlParser$delegate;
        return (Parser)lazy.getValue();
    }

    private static final HtmlRenderer getMarkdownToHtmlRenderer() {
        Lazy lazy = markdownToHtmlRenderer$delegate;
        return (HtmlRenderer)lazy.getValue();
    }

    private static final FlexmarkHtmlConverter createHtmlToMarkdownConverter() {
        MutableDataHolder mutableDataHolder = new MutableDataSet().set((DataKey)FlexmarkHtmlConverter.BR_AS_EXTRA_BLANK_LINES, (Object)false);
        Intrinsics.checkNotNullExpressionValue((Object)mutableDataHolder, (String)"set(...)");
        MutableDataHolder options = mutableDataHolder;
        PreElementHtmlRenderer preElementHtmlRenderer = new PreElementHtmlRenderer(options);
        FlexmarkHtmlConverter flexmarkHtmlConverter = FlexmarkHtmlConverter.builder(options).htmlNodeRendererFactory(new HtmlNodeRendererFactory(preElementHtmlRenderer){
            final /* synthetic */ PreElementHtmlRenderer $preElementHtmlRenderer;
            {
                this.$preElementHtmlRenderer = $preElementHtmlRenderer;
            }

            public final HtmlNodeRenderer apply(DataHolder it) {
                return new HtmlNodeRenderer(this.$preElementHtmlRenderer){
                    final /* synthetic */ PreElementHtmlRenderer $preElementHtmlRenderer;
                    {
                        this.$preElementHtmlRenderer = $preElementHtmlRenderer;
                    }

                    public final Set<HtmlNodeRendererHandler<?>> getHtmlNodeRendererHandlers() {
                        return SetsKt.setOf(new HtmlNodeRendererHandler<Element>("pre", Element.class, this.$preElementHtmlRenderer));
                    }
                };
            }
        }).build();
        Intrinsics.checkNotNullExpressionValue((Object)flexmarkHtmlConverter, (String)"build(...)");
        return flexmarkHtmlConverter;
    }

    @NotNull
    public static final String htmlToMarkdown(@NotNull String html) {
        Intrinsics.checkNotNullParameter((Object)html, (String)"html");
        String string = Text_formatKt.getHtmlToMarkdownConverter().convert(html, -1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"convert(...)");
        return string;
    }

    @NotNull
    public static final String htmlToPlainText(@NotNull String html) {
        Intrinsics.checkNotNullParameter((Object)html, (String)"html");
        org.jsoup.nodes.Document htmlElement = Jsoup.parse((String)html);
        Elements codes = htmlElement.select("code");
        Intrinsics.checkNotNull((Object)codes);
        Iterable $this$forEach$iv = (Iterable)codes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Element it = (Element)element$iv;
            boolean bl = false;
            String text2 = it.text();
            it.text("'" + text2 + "'");
        }
        Elements paragraphs = htmlElement.select("p");
        Intrinsics.checkNotNull((Object)paragraphs);
        Iterable $this$forEach$iv2 = (Iterable)paragraphs;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            Element it = (Element)element$iv;
            boolean bl = false;
            String text3 = it.text();
            it.text(System.lineSeparator() + text3 + System.lineSeparator());
        }
        String string = htmlElement.text();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text(...)");
        return string;
    }

    @NotNull
    public static final String markdownToHtml(@NotNull String markdown) {
        org.jsoup.nodes.Document document2;
        Intrinsics.checkNotNullParameter((Object)markdown, (String)"markdown");
        Document document3 = Text_formatKt.getMarkdownToHtmlParser().parse(markdown);
        Intrinsics.checkNotNullExpressionValue((Object)document3, (String)"parse(...)");
        Document document4 = document3;
        String string = Text_formatKt.getMarkdownToHtmlRenderer().render(document4);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"render(...)");
        String html = string;
        org.jsoup.nodes.Document $this$markdownToHtml_u24lambda_u242 = document2 = Jsoup.parse((String)html);
        boolean bl = false;
        $this$markdownToHtml_u24lambda_u242.outputSettings().indentAmount(0);
        String formattedHtml = document2.html();
        Intrinsics.checkNotNull((Object)formattedHtml);
        return formattedHtml;
    }

    @NotNull
    public static final String escapeExceptTag(@NotNull String input, @NotNull String tagName) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)tagName, (String)"tagName");
        Regex spanPattern = new Regex("(<" + tagName + "[^>]*>|</" + tagName + ">)");
        StringBuilder builder = new StringBuilder();
        Sequence matches = Regex.findAll$default((Regex)spanPattern, (CharSequence)input, (int)0, (int)2, null);
        int lastEnd = 0;
        Sequence $this$forEach$iv = matches;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MatchResult matchResult = (MatchResult)element$iv;
            boolean bl = false;
            if (matchResult.getRange().getFirst() != lastEnd) {
                String originalText;
                Intrinsics.checkNotNullExpressionValue((Object)input.substring(lastEnd, matchResult.getRange().getFirst()), (String)"substring(...)");
                builder.append(XmlStringUtil.escapeString((String)Text_formatKt.unescape(originalText)));
            }
            builder.append(matchResult.getValue());
            lastEnd = matchResult.getRange().getLast() + 1;
        }
        if (lastEnd < input.length()) {
            String string = input.substring(lastEnd, input.length());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String originalText = string;
            builder.append(XmlStringUtil.escapeString((String)Text_formatKt.unescape(originalText)));
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public static final String escapeContentInTag(@NotNull String data, @NotNull String tagName) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)tagName, (String)"tagName");
        Regex pattern = new Regex("<" + tagName + ">(.*?)</" + tagName + ">");
        CharSequence charSequence = data;
        Function1 function1 = (Function1)new Function1<MatchResult, CharSequence>(tagName){
            final /* synthetic */ String $tagName;
            {
                this.$tagName = $tagName;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull MatchResult matchResult) {
                Intrinsics.checkNotNullParameter((Object)matchResult, (String)"matchResult");
                return "<" + this.$tagName + ">" + Text_formatKt.escapeExceptTag((String)matchResult.getGroupValues().get(1), "span") + "</" + this.$tagName + ">";
            }
        };
        return pattern.replace(charSequence, function1);
    }

    private static final String unescape(String text2) {
        String string = StringUtil.unescapeXmlEntities((String)text2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"unescapeXmlEntities(...)");
        CharSequence charSequence = string;
        Regex regex = new Regex("&nbsp;|&#32;");
        String string2 = " ";
        return regex.replace(charSequence, string2);
    }

    public static final /* synthetic */ FlexmarkHtmlConverter access$createHtmlToMarkdownConverter() {
        return Text_formatKt.createHtmlToMarkdownConverter();
    }
}

