/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.actions;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.ui.InspectionNode;
import com.intellij.codeInspection.ui.InspectionTree;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.actions.InspectionResultsExportActionProvider;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.LineColumn;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.project.ProjectKt;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.JBIterable;
import com.jetbrains.qodana.sarif.SarifUtil;
import com.jetbrains.qodana.sarif.model.ArtifactContent;
import com.jetbrains.qodana.sarif.model.ArtifactLocation;
import com.jetbrains.qodana.sarif.model.Invocation;
import com.jetbrains.qodana.sarif.model.Level;
import com.jetbrains.qodana.sarif.model.Location;
import com.jetbrains.qodana.sarif.model.Message;
import com.jetbrains.qodana.sarif.model.PhysicalLocation;
import com.jetbrains.qodana.sarif.model.Region;
import com.jetbrains.qodana.sarif.model.ReportingDescriptor;
import com.jetbrains.qodana.sarif.model.Result;
import com.jetbrains.qodana.sarif.model.Run;
import com.jetbrains.qodana.sarif.model.SarifReport;
import com.jetbrains.qodana.sarif.model.Tool;
import com.jetbrains.qodana.sarif.model.ToolComponent;
import icons.QodanaIcons;
import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/qodana/actions/ExportToSarifAction;", "Lcom/intellij/codeInspection/ui/actions/InspectionResultsExportActionProvider;", "()V", "progressTitle", "", "getProgressTitle", "()Ljava/lang/String;", "writeResults", "", "tree", "Lcom/intellij/codeInspection/ui/InspectionTree;", "profile", "Lcom/intellij/codeInspection/ex/InspectionProfileImpl;", "globalInspectionContext", "Lcom/intellij/codeInspection/ex/GlobalInspectionContextImpl;", "project", "Lcom/intellij/openapi/project/Project;", "outputPath", "Ljava/nio/file/Path;", "Companion", "intellij.qodana"})
public final class ExportToSarifAction
extends InspectionResultsExportActionProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String progressTitle;

    public ExportToSarifAction() {
        Supplier supplier = 1.INSTANCE;
        Supplier supplier2 = InspectionsBundle.messagePointer((String)"inspection.action.export.sarif.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)supplier2, (String)"messagePointer(...)");
        super(supplier, supplier2, QodanaIcons.Icons.Sarif);
        String string = InspectionsBundle.message((String)"inspection.generating.sarif.progress.title", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.progressTitle = string;
    }

    @NotNull
    public String getProgressTitle() {
        return this.progressTitle;
    }

    public void writeResults(@NotNull InspectionTree tree, @NotNull InspectionProfileImpl profile2, @NotNull GlobalInspectionContextImpl globalInspectionContext, @NotNull Project project, @NotNull Path outputPath) {
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        Intrinsics.checkNotNullParameter((Object)profile2, (String)"profile");
        Intrinsics.checkNotNullParameter((Object)globalInspectionContext, (String)"globalInspectionContext");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)outputPath, (String)"outputPath");
        File file = new File(outputPath.toFile(), "report_" + new SimpleDateFormat("yyyy-MM-dd_hh-mm-ss").format(new Date()) + ".sarif.json");
        SarifUtil.writeReport((Path)file.toPath(), (SarifReport)Companion.createSarifReport(tree, profile2, globalInspectionContext));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\f\u0010\u000b\u001a\u00020\f*\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/qodana/actions/ExportToSarifAction$Companion;", "", "()V", "createSarifReport", "Lcom/jetbrains/qodana/sarif/model/SarifReport;", "tree", "Lcom/intellij/codeInspection/ui/InspectionTree;", "profile", "Lcom/intellij/codeInspection/ex/InspectionProfileImpl;", "globalInspectionContext", "Lcom/intellij/codeInspection/ex/GlobalInspectionContextImpl;", "toLevel", "Lcom/jetbrains/qodana/sarif/model/Level;", "Lcom/intellij/lang/annotation/HighlightSeverity;", "intellij.qodana"})
    @SourceDebugExtension(value={"SMAP\nExportToSarifAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExportToSarifAction.kt\norg/jetbrains/qodana/actions/ExportToSarifAction$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,154:1\n1855#2,2:155\n*S KotlinDebug\n*F\n+ 1 ExportToSarifAction.kt\norg/jetbrains/qodana/actions/ExportToSarifAction$Companion\n*L\n136#1:155,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final SarifReport createSarifReport(@NotNull InspectionTree tree, @NotNull InspectionProfileImpl profile2, @NotNull GlobalInspectionContextImpl globalInspectionContext) {
            Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
            Intrinsics.checkNotNullParameter((Object)profile2, (String)"profile");
            Intrinsics.checkNotNullParameter((Object)globalInspectionContext, (String)"globalInspectionContext");
            ApplicationInfo appInfo = ApplicationInfo.getInstance();
            Project project = globalInspectionContext.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            String string = ProjectKt.getStateStore((Project)project).getProjectBasePath().toUri().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String basePath = string;
            Run run2 = new Run().withTool(new Tool().withDriver(new ToolComponent().withName(appInfo.getVersionName()).withInformationUri(new URI(appInfo.getCompanyURL())).withVersion(appInfo.getBuild().asStringWithoutProductCode()).withRules((List)new ArrayList()))).withInvocations(CollectionsKt.listOf((Object)new Invocation().withExecutionSuccessful(Boolean.valueOf(true)).withWorkingDirectory(new ArtifactLocation().withUri(basePath)))).withResults((List)new ArrayList());
            HashSet<String> addedRules = new HashSet<String>();
            Function1 addResults2 = new Function1<InspectionToolWrapper<?, ?>, List<? extends Boolean>>(globalInspectionContext, addedRules, run2, basePath){
                final /* synthetic */ GlobalInspectionContextImpl $globalInspectionContext;
                final /* synthetic */ HashSet<String> $addedRules;
                final /* synthetic */ Run $run;
                final /* synthetic */ String $basePath;
                {
                    this.$globalInspectionContext = $globalInspectionContext;
                    this.$addedRules = $addedRules;
                    this.$run = $run;
                    this.$basePath = $basePath;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final List<Boolean> invoke(@NotNull InspectionToolWrapper<?, ?> tool) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Intrinsics.checkNotNullParameter(tool, (String)"tool");
                    Collection collection = this.$globalInspectionContext.getPresentation(tool).getProblemDescriptors();
                    Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getProblemDescriptors(...)");
                    Iterable iterable = collection;
                    HashSet<String> hashSet = this.$addedRules;
                    Run run2 = this.$run;
                    String string = this.$basePath;
                    boolean $i$f$map = false;
                    void var7_7 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void descriptor2;
                        CommonProblemDescriptor commonProblemDescriptor = (CommonProblemDescriptor)item$iv$iv;
                        Collection collection2 = destination$iv$iv;
                        boolean bl = false;
                        if (!hashSet.contains(tool.getID())) {
                            run2.getTool().getDriver().getRules().add(new ReportingDescriptor().withName(tool.getDisplayName()).withId(tool.getID()));
                            hashSet.add(tool.getID());
                        }
                        Result result2 = new Result().withMessage(new Message().withText(descriptor2.toString())).withLevel(org.jetbrains.qodana.actions.ExportToSarifAction$Companion.access$toLevel(ExportToSarifAction.Companion, tool.getDefaultLevel().getSeverity())).withRuleId(tool.getID());
                        if (descriptor2 instanceof ProblemDescriptorBase) {
                            PsiElement psiElement;
                            PsiElement psiElement2 = psiElement = ((ProblemDescriptorBase)descriptor2).getPsiElement();
                            if (psiElement2 != null) {
                                Intrinsics.checkNotNull((Object)psiElement2);
                                PsiElement it = psiElement;
                                boolean bl2 = false;
                                LineColumn lineColumn = StringUtil.offsetToLineColumn((CharSequence)it.getContainingFile().getText(), (int)it.getTextOffset());
                                LineColumn lineColumnEnd = StringUtil.offsetToLineColumn((CharSequence)it.getContainingFile().getText(), (int)(it.getTextOffset() + it.getTextLength()));
                                String relativePath = FileUtilRt.getRelativePath((String)string, (String)it.getContainingFile().getVirtualFile().getUrl(), (char)File.separatorChar);
                                CharSequence charSequence = relativePath;
                                result2.setLocations(CollectionsKt.listOf((Object)new Location().withPhysicalLocation(new PhysicalLocation().withArtifactLocation(new ArtifactLocation().withUri(charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? it.getContainingFile().getVirtualFile().getUrl() : relativePath)).withRegion(new Region().withCharOffset(Integer.valueOf(it.getTextOffset())).withCharLength(Integer.valueOf(it.getTextLength())).withStartLine(Integer.valueOf(lineColumn.line + 1)).withStartColumn(Integer.valueOf(lineColumn.column + 1)).withEndLine(Integer.valueOf(lineColumnEnd.line + 1)).withEndColumn(Integer.valueOf(lineColumnEnd.column + 1)).withSnippet(new ArtifactContent().withText(it.getText()))))));
                            }
                        }
                        collection2.add(run2.getResults().add(result2));
                    }
                    return (List)destination$iv$iv;
                }
            };
            if (profile2.getSingleTool() != null) {
                Tools tools = (Tools)globalInspectionContext.getTools().get(profile2.getSingleTool());
                if (tools != null) {
                    Tools it = tools;
                    boolean bl = false;
                    InspectionToolWrapper inspectionToolWrapper = it.getTool();
                    Intrinsics.checkNotNullExpressionValue((Object)inspectionToolWrapper, (String)"getTool(...)");
                    List cfr_ignored_0 = (List)addResults2.invoke((Object)inspectionToolWrapper);
                }
            } else {
                void $this$forEach$iv;
                JBIterable jBIterable = tree.getInspectionTreeModel().traverse((InspectionTreeNode)tree.getInspectionTreeModel().getRoot()).filter(InspectionNode.class);
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
                Iterable iterable = (Iterable)jBIterable;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    InspectionNode node = (InspectionNode)element$iv;
                    boolean bl = false;
                    InspectionToolWrapper inspectionToolWrapper = node.getToolWrapper();
                    Intrinsics.checkNotNullExpressionValue((Object)inspectionToolWrapper, (String)"getToolWrapper(...)");
                    addResults2.invoke((Object)inspectionToolWrapper);
                }
            }
            URI schema = new URI("https://raw.githubusercontent.com/schemastore/schemastore/master/src/schemas/json/sarif-2.1.0-rtm.5.json");
            SarifReport sarifReport = new SarifReport(SarifReport.Version._2_1_0, CollectionsKt.listOf((Object)run2)).with$schema(schema);
            Intrinsics.checkNotNullExpressionValue((Object)sarifReport, (String)"with$schema(...)");
            return sarifReport;
        }

        private final Level toLevel(HighlightSeverity $this$toLevel) {
            HighlightSeverity highlightSeverity = $this$toLevel;
            return Intrinsics.areEqual((Object)highlightSeverity, (Object)HighlightSeverity.ERROR) ? Level.ERROR : (Intrinsics.areEqual((Object)highlightSeverity, (Object)HighlightSeverity.WARNING) ? Level.WARNING : (Intrinsics.areEqual((Object)highlightSeverity, (Object)HighlightSeverity.WEAK_WARNING) ? Level.NOTE : Level.NOTE));
        }

        public static final /* synthetic */ Level access$toLevel(Companion $this, HighlightSeverity $receiver) {
            return $this.toLevel($receiver);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

