/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.embedded.iar;

import com.intellij.clion.embedded.EmbeddedBundle;
import com.intellij.clion.embedded.iar.IarCompilerKind;
import com.intellij.clion.embedded.iar.IarMessagesConsoleFilter;
import com.intellij.clion.embedded.iar.IarSwitchBuilder;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.toolchains.CidrSwitchBuilder;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.lang.workspace.compiler.CompilerInfo;
import com.jetbrains.cidr.lang.workspace.compiler.FeatureParseUtil;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompiler;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerBase;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import com.jetbrains.cidr.lang.workspace.compiler.OCOptionsFilteringCapable;
import com.jetbrains.cidr.lang.workspace.compiler.TempFilesPool;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchPath;
import com.jetbrains.cidr.system.HostMachine;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public class IarCompiler
extends OCCompilerBase
implements OCCompiler,
OCOptionsFilteringCapable {
    private static final List<String> IAR_EXTENDED_KEYWORDS_DEFINES = Arrays.asList("#define __arm", "#define __big_endian", "#define __cc_rom", "#define __cc_version1", "#define __cc_version2", "#define __data16", "#define __data20", "#define __eeprom", "#define __ext_io", "#define __far", "#define __far_func", "#define __farflash", "#define __farfunc", "#define __fiq", "#define __flash", "#define __generic", "#define __huge", "#define __huge_func", "#define __hugeflash", "#define __interwork", "#define __io", "#define __irq", "#define __little_endian", "#define __machine", "#define __monitor", "#define __near", "#define __near_func", "#define __nearfunc", "#define __nested", "#define __no_alloc", "#define __no_alloc16", "#define __no_alloc_str", "#define __no_alloc_str16", "#define __no_init", "#define __no_multiplier", "#define __no_pic", "#define __no_runtime_init", "#define __noreturn", "#define __packed", "#define __persistent", "#define __ramfunc", "#define __raw", "#define __regvar", "#define __ro_placement", "#define __root", "#define __save_reg20", "#define __stackless", "#define __supervisor", "#define __swi", "#define __task", "#define __thumb", "#define __tiny", "#define __tinyflash", "#define __user", "#define __version_1", "#define __version_2", "#define __version_4", "#define __weak", "#define __x", "#define __x_z", "#define __z", "#define __z_x");
    private final String myCppSwitch;

    public IarCompiler(@NotNull File executable, @NotNull File directory, @NotNull CidrToolEnvironment environment, @NotNull TempFilesPool tempFilesPool, @NotNull String cppSwitch) {
        if (executable == null) {
            IarCompiler.$$$reportNull$$$0(0);
        }
        if (directory == null) {
            IarCompiler.$$$reportNull$$$0(1);
        }
        if (environment == null) {
            IarCompiler.$$$reportNull$$$0(2);
        }
        if (tempFilesPool == null) {
            IarCompiler.$$$reportNull$$$0(3);
        }
        if (cppSwitch == null) {
            IarCompiler.$$$reportNull$$$0(4);
        }
        super(executable, directory, environment, tempFilesPool);
        this.myCppSwitch = cppSwitch;
    }

    @NotNull
    public CompilerInfo collectInfo(@NotNull OCLanguageKind languageKind, @NotNull CidrCompilerSwitches switches) throws ExecutionException {
        CompilerInfo result;
        if (languageKind == null) {
            IarCompiler.$$$reportNull$$$0(5);
        }
        if (switches == null) {
            IarCompiler.$$$reportNull$$$0(6);
        }
        HostMachine hostMachine = this.myEnvironment.getHostMachine();
        try {
            Path predefMacroFilePath = this.myTempFilesPool.writeToTempFile(hostMachine, String.valueOf(Math.random()), hostMachine.getTempDirectory(), "macro", ".predef");
            List args = new IarSwitchBuilder(new CidrSwitchBuilder(), this.myCppSwitch).withSyntaxOnly().withLanguageKind(languageKind).withSwitches(switches).withSwitch("--predef_macros").withSwitch(predefMacroFilePath.toString()).withSwitch("--no_wrap_diagnostics").withSwitch("--silent").buildRaw();
            GeneralCommandLine cmdLine = new GeneralCommandLine().withExePath(this.myExecutable.getPath()).withParameters(args).withWorkDirectory(this.myWorkingDirectory);
            Path emptyFile = this.myTempFilesPool.writeToTempFile(hostMachine, "", hostMachine.getTempDirectory(), "empty", ".c");
            cmdLine.addParameter(this.myEnvironment.toEnvPath(emptyFile.toString()));
            this.myEnvironment.prepare(cmdLine, CidrToolEnvironment.PrepareFor.BUILD);
            ProcessOutput output = new OCCompilerBase.CompilerRunner().run(cmdLine, this.myEnvironment);
            if (output.isTimeout() || output.getExitCode() != 0) {
                throw new ExecutionException(EmbeddedBundle.message("compiler.run.failed", output.getStderr(), output.getStdout()));
            }
            String defines = Files.readString(predefMacroFilePath);
            SmartList warnings = new SmartList();
            List<HeadersSearchPath> headersSearchPaths = IarCompiler.searchPaths(languageKind, cmdLine, (List<String>)warnings);
            List<File> implicitIncludes = IarCompiler.collectImplicitIncludes(cmdLine, headersSearchPaths, File::exists, (List<String>)warnings);
            Map<OCCompilerFeatures.Type<?>, Object> features = IarCompiler.collectFeatures(defines);
            IarMessagesConsoleFilter.collectWarnings(output.getStderr(), (List<String>)warnings);
            List<String> defineLines = Arrays.asList(StringUtil.splitByLines((String)defines));
            if (switches.getList(CidrCompilerSwitches.Format.RAW).contains("-e")) {
                defineLines = new ArrayList<String>(defineLines);
                defineLines.addAll(IAR_EXTENDED_KEYWORDS_DEFINES);
                features.put((OCCompilerFeatures.Type<?>)OCCompilerFeatures.Feature.DATA_PLACEMENT_OPERATOR, true);
            }
            result = new CompilerInfo(switches, defineLines, features, headersSearchPaths, implicitIncludes, Collections.emptyList(), (List)warnings);
        }
        catch (IOException e) {
            throw new ExecutionException((Throwable)e);
        }
        CompilerInfo info = result;
        CompilerInfo compilerInfo = Objects.requireNonNull(info);
        if (compilerInfo == null) {
            IarCompiler.$$$reportNull$$$0(7);
        }
        return compilerInfo;
    }

    @NotNull
    public CidrCompilerSwitches filterOptions(@NotNull CidrCompilerSwitches switches, @NotNull Set<String> skipOptions) {
        if (switches == null) {
            IarCompiler.$$$reportNull$$$0(8);
        }
        if (skipOptions == null) {
            IarCompiler.$$$reportNull$$$0(9);
        }
        List switchesRaw = switches.getList(CidrCompilerSwitches.Format.RAW);
        List<String> filteredRaw = IarCompilerKind.INSTANCE.skipLanguageNotRelatedSwitches(switchesRaw);
        return new CidrCompilerSwitches(filteredRaw);
    }

    @NotNull
    static Map<OCCompilerFeatures.Type<?>, Object> collectFeatures(@NotNull String allDefinesText) throws ExecutionException {
        if (allDefinesText == null) {
            IarCompiler.$$$reportNull$$$0(10);
        }
        LinkedHashMap result = new LinkedHashMap();
        HashMap<String, String> defines = new HashMap<String, String>();
        for (String line : StringUtil.splitByLines((String)allDefinesText)) {
            char c;
            int idx;
            if (!line.startsWith("#define")) continue;
            String defineText = line.substring("#define".length()).trim();
            StringBuilder key = new StringBuilder();
            for (idx = 0; idx < defineText.length() && !Character.isWhitespace(c = defineText.charAt(idx)); ++idx) {
                key.append(c);
            }
            defines.put(key.toString(), defineText.substring(idx).trim());
        }
        IarCompiler.collectSizes(result, defines);
        FeatureParseUtil.collectStandardFeatures(defines, result::put);
        LinkedHashMap linkedHashMap = result;
        if (linkedHashMap == null) {
            IarCompiler.$$$reportNull$$$0(11);
        }
        return linkedHashMap;
    }

    private static void collectSizes(Map<OCCompilerFeatures.Type<?>, Object> result, Map<String, String> defines) {
        for (OCCompilerFeatures.TypeSize typeSize : OCCompilerFeatures.TypeSize.values()) {
            String length = defines.get("__" + typeSize.name() + "_SIZE__");
            if (length == null || length.isEmpty()) continue;
            result.put((OCCompilerFeatures.Type<?>)typeSize, Short.parseShort(length));
        }
    }

    @NotNull
    static List<File> collectImplicitIncludes(@NotNull GeneralCommandLine cmdLine, @NotNull List<HeadersSearchPath> searchPaths, @NotNull Predicate<File> fileExists, @NotNull List<String> warnings) {
        if (cmdLine == null) {
            IarCompiler.$$$reportNull$$$0(12);
        }
        if (searchPaths == null) {
            IarCompiler.$$$reportNull$$$0(13);
        }
        if (fileExists == null) {
            IarCompiler.$$$reportNull$$$0(14);
        }
        if (warnings == null) {
            IarCompiler.$$$reportNull$$$0(15);
        }
        List<String> preIncludes = IarCompiler.extractKeyValues(cmdLine, "--preinclude");
        ArrayList<File> files = new ArrayList<File>();
        for (String preInclude : preIncludes) {
            boolean found = false;
            preInclude = preInclude.trim();
            try {
                for (HeadersSearchPath path : searchPaths) {
                    File file = Paths.get(path.getPath(), new String[0]).resolve(preInclude).toFile();
                    found = fileExists.test(file);
                    if (!found) continue;
                    files.add(file);
                    break;
                }
            }
            catch (InvalidPathException e) {
                warnings.add(e.getMessage());
            }
            if (found) continue;
            warnings.add(EmbeddedBundle.message("compiler.implicit.include.not.found", preInclude));
        }
        ArrayList<File> arrayList = files;
        if (arrayList == null) {
            IarCompiler.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    @NotNull
    private static List<String> extractKeyValues(@NotNull GeneralCommandLine commandLine, @NotNull String key) {
        if (commandLine == null) {
            IarCompiler.$$$reportNull$$$0(17);
        }
        if (key == null) {
            IarCompiler.$$$reportNull$$$0(18);
        }
        SmartList result = new SmartList();
        List args = commandLine.getParametersList().getParameters();
        for (int i = 0; i < args.size(); ++i) {
            String arg = (String)args.get(i);
            if (!arg.startsWith(key)) continue;
            if (arg.equals(key)) {
                if (++i < args.size()) {
                    result.add((Object)((String)args.get(i)));
                    continue;
                }
                result.add((Object)"");
                continue;
            }
            result.add((Object)arg.substring(key.length()));
        }
        SmartList smartList = result;
        if (smartList == null) {
            IarCompiler.$$$reportNull$$$0(19);
        }
        return smartList;
    }

    @NotNull
    static List<HeadersSearchPath> searchPaths(@NotNull OCLanguageKind languageKind, @NotNull GeneralCommandLine commandLine, List<String> warnings) {
        if (languageKind == null) {
            IarCompiler.$$$reportNull$$$0(20);
        }
        if (commandLine == null) {
            IarCompiler.$$$reportNull$$$0(21);
        }
        ArrayList<HeadersSearchPath> result = new ArrayList<HeadersSearchPath>();
        String workDirectory = commandLine.getWorkDirectory().getPath();
        for (String string : IarCompiler.extractKeyValues(commandLine, "-I")) {
            IarCompiler.calcPath(workDirectory, string.trim(), HeadersSearchPath.Kind.USER, result::add, warnings::add);
        }
        String envIncludes = (String)commandLine.getEffectiveEnvironment().get("C_INCLUDE");
        if (envIncludes != null) {
            for (String envInclude : envIncludes.split(";")) {
                if (envInclude.isEmpty()) continue;
                IarCompiler.calcPath(workDirectory, envInclude, HeadersSearchPath.Kind.USER, result::add, warnings::add);
            }
        }
        if (!commandLine.getParametersList().hasParameter("--no_system_include")) {
            ArrayList arrayList = new ArrayList();
            IarCompiler.extractKeyValues(commandLine, "--system_include_dir").forEach(s -> IarCompiler.calcPath(workDirectory, s.trim(), systemIncludes::add, warnings::add));
            if (arrayList.isEmpty()) {
                IarCompiler.calcPath(Paths.get(commandLine.getExePath(), new String[0]).getParent().getParent().toString(), "inc", arrayList::add, warnings::add);
            }
            for (String systemInclude : arrayList) {
                result.add(new HeadersSearchPath(systemInclude, false, HeadersSearchPath.Kind.SYSTEM));
                IarCompiler.calcPath(systemInclude, "c", HeadersSearchPath.Kind.SYSTEM, result::add, warnings::add);
                IarCompiler.calcPath(systemInclude, "dlib/c", HeadersSearchPath.Kind.SYSTEM, result::add, warnings::add);
                if (!languageKind.isCpp()) continue;
                IarCompiler.calcPath(systemInclude, "cpp", HeadersSearchPath.Kind.SYSTEM, result::add, warnings::add);
                IarCompiler.calcPath(systemInclude, "ecpp", HeadersSearchPath.Kind.SYSTEM, result::add, warnings::add);
                IarCompiler.calcPath(systemInclude, "dlib/cpp", HeadersSearchPath.Kind.SYSTEM, result::add, warnings::add);
                IarCompiler.calcPath(systemInclude, "dlib/ecpp", HeadersSearchPath.Kind.SYSTEM, result::add, warnings::add);
            }
        }
        ArrayList<HeadersSearchPath> arrayList = result;
        if (arrayList == null) {
            IarCompiler.$$$reportNull$$$0(22);
        }
        return arrayList;
    }

    private static void calcPath(String baseDirectory, String subPath, Consumer<String> result, Consumer<String> warnings) {
        try {
            String s = Paths.get(baseDirectory, new String[0]).resolve(subPath).toString();
            result.accept(s);
        }
        catch (InvalidPathException e) {
            warnings.accept(e.getMessage());
        }
    }

    private static void calcPath(String baseDirectory, String subPath, HeadersSearchPath.Kind kind, Consumer<HeadersSearchPath> result, Consumer<String> warnings) {
        IarCompiler.calcPath(baseDirectory, subPath, s -> result.accept(new HeadersSearchPath(s.trim(), false, kind)), warnings);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 11, 16, 19, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tempFilesPool";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cppSwitch";
                break;
            }
            case 5: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageKind";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switches";
                break;
            }
            case 7: 
            case 11: 
            case 16: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/clion/embedded/iar/IarCompiler";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "skipOptions";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allDefinesText";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmdLine";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchPaths";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileExists";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "warnings";
                break;
            }
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/clion/embedded/iar/IarCompiler";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "collectInfo";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "collectFeatures";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "collectImplicitIncludes";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "extractKeyValues";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "searchPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "collectInfo";
                break;
            }
            case 7: 
            case 11: 
            case 16: 
            case 19: 
            case 22: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "filterOptions";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "collectFeatures";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "collectImplicitIncludes";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "extractKeyValues";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "searchPaths";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 11, 16, 19, 22 -> new IllegalStateException(string);
        };
    }
}

