/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.embedded.execution.wizard;

import com.google.gson.stream.JsonReader;
import com.intellij.clion.embedded.EmbeddedBundle;
import com.intellij.clion.embedded.execution.wizard.Device;
import com.intellij.clion.embedded.execution.wizard.GdbServer;
import com.intellij.clion.embedded.execution.wizard.GdbServerType;
import com.intellij.clion.embedded.execution.wizard.GdbServerWizard;
import com.intellij.clion.embedded.execution.wizard.GdbWizardOptions;
import com.intellij.clion.embedded.execution.wizard.JLinkServer;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.util.EnvironmentUtil;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.swing.tree.DefaultMutableTreeNode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0016J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u0004H\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0004H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/intellij/clion/embedded/execution/wizard/JLinkServer;", "Lcom/intellij/clion/embedded/execution/wizard/GdbServer;", "()V", "findDefaultLocation", "", "gatherData", "", "project", "Lcom/intellij/openapi/project/Project;", "state", "Lcom/intellij/clion/embedded/execution/wizard/GdbWizardOptions;", "generateConnectionString", "port", "", "getDefaultServerExecutableName", "getDialogPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "wizard", "Lcom/intellij/clion/embedded/execution/wizard/GdbServerWizard;", "getDisplayName", "intellij.clion.embedded"})
@SourceDebugExtension(value={"SMAP\nJLinkServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JLinkServer.kt\ncom/intellij/clion/embedded/execution/wizard/JLinkServer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,88:1\n1603#2,9:89\n1855#2:98\n1856#2:100\n1612#2:101\n1549#2:102\n1620#2,3:103\n1360#2:106\n1446#2,5:107\n1549#2:112\n1620#2,3:113\n766#2:116\n857#2,2:117\n1#3:99\n*S KotlinDebug\n*F\n+ 1 JLinkServer.kt\ncom/intellij/clion/embedded/execution/wizard/JLinkServer\n*L\n69#1:89,9\n69#1:98\n69#1:100\n69#1:101\n70#1:102\n70#1:103,3\n74#1:106\n74#1:107,5\n75#1:112\n75#1:113,3\n76#1:116\n76#1:117,2\n69#1:99\n*E\n"})
public final class JLinkServer
extends GdbServer {
    public JLinkServer() {
        super(GdbServerType.JLINK);
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = EmbeddedBundle.message("jlink.gdb.server.displayname", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Override
    @NotNull
    public String getDefaultServerExecutableName() {
        return SystemInfo.isWindows ? "JLinkGDBServerCL.exe" : "JLinkGDBServer";
    }

    @Override
    @NotNull
    public DialogPanel getDialogPanel(@NotNull GdbServerWizard wizard) {
        Intrinsics.checkNotNullParameter((Object)((Object)wizard), (String)"wizard");
        return BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(this, wizard){
            final /* synthetic */ JLinkServer this$0;
            final /* synthetic */ GdbServerWizard $wizard;
            {
                this.this$0 = $receiver;
                this.$wizard = $wizard;
                super(1);
            }

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                String string = EmbeddedBundle.message("label.jlink.gdb.server", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                $this$panel.row(string, (Function1)getDialogPanel.1.INSTANCE);
                Panel.separator$default((Panel)$this$panel, null, (int)1, null);
                this.this$0.interfacesRow($this$panel, this.$wizard);
                String[] stringArray = new String[]{this.this$0.getFREQ_AUTO$intellij_clion_embedded(), this.this$0.getFREQ_ADAPTIVE$intellij_clion_embedded(), "400", "500", "600", "750", "900", "1000", "1333", "1600", "2000", "3200", "4000", "4800", "6000", "8000", "9600", "12000", "16000"};
                this.this$0.speedRow($this$panel, this.$wizard, "8000", stringArray);
                this.this$0.devicesListRows($this$panel, this.$wizard);
            }
        }));
    }

    @Override
    public void gatherData(@NotNull Project project, @NotNull GdbWizardOptions state) throws CommitStepException {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        super.gatherData(project, state);
        InputStream inputStream = this.getClass().getResourceAsStream("segger-devices.json");
        Intrinsics.checkNotNull((Object)inputStream);
        InputStream deviceList = inputStream;
        state.setDevicesTree(new DefaultMutableTreeNode());
        JsonReader jsonReader = new JsonReader((Reader)new InputStreamReader(deviceList));
        jsonReader.beginObject();
        while (jsonReader.hasNext()) {
            String vendorName = jsonReader.nextName();
            DefaultMutableTreeNode vendorNode = new DefaultMutableTreeNode(vendorName);
            state.getDevicesTree().add(vendorNode);
            jsonReader.beginObject();
            while (jsonReader.hasNext()) {
                String groupName = jsonReader.nextName();
                DefaultMutableTreeNode groupNode = new DefaultMutableTreeNode(groupName);
                vendorNode.add(groupNode);
                jsonReader.beginObject();
                while (jsonReader.hasNext()) {
                    String mcuKey = jsonReader.nextName();
                    String description = jsonReader.nextString();
                    Intrinsics.checkNotNull((Object)mcuKey);
                    Intrinsics.checkNotNull((Object)vendorName);
                    groupNode.add(new DefaultMutableTreeNode(new Device(mcuKey, vendorName, null, null, description, 12, null)));
                }
                jsonReader.endObject();
            }
            jsonReader.endObject();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public String findDefaultLocation() {
        String location;
        block10: {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            void $this$flatMapTo$iv$iv;
            List list;
            Iterable<File> iterable;
            Iterable destination$iv$iv;
            location = super.findDefaultLocation();
            if (location != null) break block10;
            if (SystemInfo.isWindows) {
                void $this$mapTo$iv$iv2;
                Iterable $this$mapNotNullTo$iv$iv;
                Object[] objectArray = new String[]{"ProgramFiles", "ProgramFiles(x86)"};
                Iterable $this$mapNotNull$iv = CollectionsKt.listOf((Object[])objectArray);
                boolean $i$f$mapNotNull = false;
                Iterable iterable2 = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Object object = $this$forEach$iv$iv$iv.iterator();
                while (object.hasNext()) {
                    String it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = object.next();
                    boolean bl = false;
                    String p0 = (String)element$iv$iv;
                    boolean bl2 = false;
                    if (EnvironmentUtil.getValue((String)p0) == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                Iterable $this$map$iv2 = (List)destination$iv$iv;
                boolean $i$f$map = false;
                $this$mapNotNullTo$iv$iv = $this$map$iv2;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void s;
                    object = (String)item$iv$iv;
                    iterable = destination$iv$iv;
                    boolean bl = false;
                    iterable.add(new File((String)s, "SEGGER"));
                }
                list = (List)destination$iv$iv;
            } else {
                list = SystemInfo.isMac ? CollectionsKt.listOf((Object)new File("/Applications/SEGGER/")) : CollectionsKt.listOf((Object)new File("/opt/SEGGER/"));
            }
            List baseFolders = list;
            Iterable $this$flatMap$iv = baseFolders;
            boolean $i$f$flatMap = false;
            destination$iv$iv = $this$flatMap$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                Object object;
                block12: {
                    block11: {
                        Object[] objectArray;
                        File it = (File)element$iv$iv;
                        boolean bl = false;
                        object = objectArray = it.listFiles();
                        if (objectArray == null) break block11;
                        Intrinsics.checkNotNull((Object)object);
                        object = ArraysKt.asList((Object[])objectArray);
                        if (object != null) break block12;
                    }
                    object = CollectionsKt.emptyList();
                }
                Iterable list$iv$iv = (Iterable)object;
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv2;
            boolean $i$f$map = false;
            $this$flatMapTo$iv$iv = $this$map$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void dir;
                File list$iv$iv = (File)item$iv$iv;
                iterable = destination$iv$iv2;
                boolean bl = false;
                iterable.add(new File((File)dir, this.getDefaultServerExecutableName()));
            }
            $this$map$iv = (List)destination$iv$iv2;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                File p0 = (File)element$iv$iv;
                boolean bl = false;
                if (!p0.canExecute()) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            File file = (File)CollectionsKt.getOrNull((List)CollectionsKt.sortedWith((Iterable)((List)destination$iv$iv2), (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    File p0 = (File)b;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)p0.toString());
                    p0 = (File)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)p0.toString())));
                }
            }), (int)0);
            location = file != null ? file.toString() : null;
        }
        return location;
    }

    @Override
    @NotNull
    public String generateConnectionString(@NotNull GdbWizardOptions state, int port) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        String string = this.selectedDeviceKey(state);
        String string2 = state.getInterfaceType().toString();
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        return "-device \"" + string + "\" -if " + string3 + " -speed " + state.getFrequency() + " -port " + port + " -nogui -singlerun";
    }
}

