/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.embedded.execution.wizard;

import com.intellij.clion.embedded.EmbeddedBundle;
import com.intellij.clion.embedded.EmbeddedUsagesCollector;
import com.intellij.clion.embedded.execution.custom.CustomGdbServerConfigurationType;
import com.intellij.clion.embedded.execution.wizard.CommonStep;
import com.intellij.clion.embedded.execution.wizard.GdbServersStep;
import com.intellij.clion.embedded.execution.wizard.GdbWizardOptions;
import com.intellij.clion.embedded.execution.wizard.GdbWizardState;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.ide.wizard.AbstractWizard;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.ide.wizard.Step;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0013\u001a\u00020\u0007H\u0014J\b\u0010\u0014\u001a\u00020\u0015H\u0014J\u0006\u0010\u0016\u001a\u00020\u0017R$\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0018"}, d2={"Lcom/intellij/clion/embedded/execution/wizard/GdbServerWizard;", "Lcom/intellij/ide/wizard/AbstractWizard;", "Lcom/intellij/ide/wizard/Step;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "value", "", "finishEnabled", "getFinishEnabled", "()Z", "setFinishEnabled", "(Z)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "state", "Lcom/intellij/clion/embedded/execution/wizard/GdbWizardOptions;", "getState", "()Lcom/intellij/clion/embedded/execution/wizard/GdbWizardOptions;", "canFinish", "getHelpID", "", "verifyName", "", "intellij.clion.embedded"})
public final class GdbServerWizard
extends AbstractWizard<Step> {
    @NotNull
    private final Project project;
    @NotNull
    private final GdbWizardOptions state;
    private boolean finishEnabled;

    public GdbServerWizard(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(EmbeddedBundle.message("dialog.title.configure.gdb.server", new Object[0]), project);
        this.project = project;
        this.state = GdbWizardState.Companion.getState();
        RunnerAndConfigurationSettings cfg = RunManager.Companion.getInstance(this.project).createConfiguration("", CustomGdbServerConfigurationType.class);
        RunManager.Companion.getInstance(this.project).setUniqueNameIfNeeded(cfg);
        this.addStep((Step)new CommonStep(this, cfg));
        this.addStep((Step)new GdbServersStep(this, cfg));
        super.init();
        EmbeddedUsagesCollector.logWizardStart(this.project);
        this.finishEnabled = true;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final GdbWizardOptions getState() {
        return this.state;
    }

    public final boolean getFinishEnabled() {
        return this.finishEnabled;
    }

    public final void setFinishEnabled(boolean value) {
        this.finishEnabled = value;
        this.updateWizardButtons();
    }

    protected boolean canFinish() {
        return this.finishEnabled && this.isLastStep();
    }

    @NotNull
    protected String getHelpID() {
        String string;
        if (this.getCurrentStepObject() instanceof GdbServersStep) {
            Step step = this.getCurrentStepObject();
            Intrinsics.checkNotNull((Object)step, (String)"null cannot be cast to non-null type com.intellij.clion.embedded.execution.wizard.GdbServersStep");
            string = ((GdbServersStep)step).getHelpId();
        } else {
            string = "embedded.gdbserver.wizard";
        }
        return string;
    }

    public final void verifyName() {
        String name = this.state.getConfigurationName();
        if (RunManager.Companion.getInstance(this.project).findConfigurationByName(name) != null) {
            Object[] objectArray = new Object[]{name};
            throw new CommitStepException(EmbeddedBundle.message("run.configuration.name.is.taken", objectArray));
        }
    }
}

