/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.embedded.execution.wizard;

import com.intellij.clion.embedded.CLionEmbeddedIcons;
import com.intellij.clion.embedded.EmbeddedBundle;
import com.intellij.clion.embedded.execution.wizard.Device;
import com.intellij.clion.embedded.execution.wizard.GdbServer;
import com.intellij.clion.embedded.execution.wizard.GdbServerKt;
import com.intellij.clion.embedded.execution.wizard.GdbServerType;
import com.intellij.clion.embedded.execution.wizard.GdbServerWizard;
import com.intellij.clion.embedded.execution.wizard.GdbWizardOptions;
import com.intellij.clion.embedded.execution.wizard.JLinkServer;
import com.intellij.clion.embedded.execution.wizard.PeMicroServer;
import com.intellij.clion.embedded.execution.wizard.PyOcdServer;
import com.intellij.clion.embedded.execution.wizard.Qemu;
import com.intellij.clion.embedded.execution.wizard.ResetStrategy;
import com.intellij.clion.embedded.execution.wizard.StLinkServer;
import com.intellij.clion.embedded.execution.wizard.StUtilServer;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.ButtonsGroup;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.ComboBoxKt;
import com.intellij.ui.dsl.builder.MutableProperty;
import com.intellij.ui.dsl.builder.MutablePropertyKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.tree.TreeUtil;
import com.jetbrains.cidr.execution.CidrRunProcessUtil;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KMutableProperty0;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0083\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005*\u0001\f\b&\u0018\u0000 =2\u00020\u0001:\u0001=B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0006H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J)\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0012\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u001e\"\u00020\u0006H\u0004\u00a2\u0006\u0002\u0010\u001fJ\u0018\u0010 \u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010!\u001a\u00020\"H&J\b\u0010#\u001a\u00020\u0006H&J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H&J\b\u0010(\u001a\u00020\u0006H'J\u0010\u0010)\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u000e\u0010*\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0018J\b\u0010+\u001a\u00020\u0006H\u0016J\u0010\u0010,\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0018H\u0004J\u0010\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020.H\u0004J\u0014\u00100\u001a\u00020\u0014*\u0002012\u0006\u0010&\u001a\u00020'H\u0004J\u0012\u00102\u001a\u000203*\u0002012\u0006\u0010&\u001a\u00020'J+\u00104\u001a\u00020\u0014*\u0002012\u0006\u0010&\u001a\u00020'2\u0012\u00105\u001a\n\u0012\u0006\b\u0001\u0012\u0002060\u001e\"\u000206\u00a2\u0006\u0002\u00107J3\u00108\u001a\u000209*\u0002012\u0006\u0010&\u001a\u00020'2\u0006\u0010:\u001a\u00020\u00062\u0012\u0010;\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u001e\"\u00020\u0006\u00a2\u0006\u0002\u0010<R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0006X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0010\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0011\u0010\u000e\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006>"}, d2={"Lcom/intellij/clion/embedded/execution/wizard/GdbServer;", "", "type", "Lcom/intellij/clion/embedded/execution/wizard/GdbServerType;", "(Lcom/intellij/clion/embedded/execution/wizard/GdbServerType;)V", "FREQ_ADAPTIVE", "", "getFREQ_ADAPTIVE$intellij_clion_embedded", "()Ljava/lang/String;", "FREQ_AUTO", "getFREQ_AUTO$intellij_clion_embedded", "devicesTreeCellRenderer", "com/intellij/clion/embedded/execution/wizard/GdbServer$devicesTreeCellRenderer$1", "Lcom/intellij/clion/embedded/execution/wizard/GdbServer$devicesTreeCellRenderer$1;", "id", "getId", "getType", "()Lcom/intellij/clion/embedded/execution/wizard/GdbServerType;", "findDefaultLocation", "gatherData", "", "project", "Lcom/intellij/openapi/project/Project;", "state", "Lcom/intellij/clion/embedded/execution/wizard/GdbWizardOptions;", "gatherProcessOutput", "Lcom/intellij/execution/process/ProcessOutput;", "ignoreStderr", "", "command", "", "(Z[Ljava/lang/String;)Lcom/intellij/execution/process/ProcessOutput;", "generateConnectionString", "port", "", "getDefaultServerExecutableName", "getDialogPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "wizard", "Lcom/intellij/clion/embedded/execution/wizard/GdbServerWizard;", "getDisplayName", "getGdbserverExe", "getGdbserverLocation", "getResetCommand", "selectedDeviceKey", "validateNonEmptyTree", "Ljavax/swing/tree/DefaultMutableTreeNode;", "rootNode", "devicesListRows", "Lcom/intellij/ui/dsl/builder/Panel;", "interfacesRow", "Lcom/intellij/ui/dsl/builder/ButtonsGroup;", "resetStrategyRow", "variants", "Lcom/intellij/clion/embedded/execution/wizard/ResetStrategy;", "(Lcom/intellij/ui/dsl/builder/Panel;Lcom/intellij/clion/embedded/execution/wizard/GdbServerWizard;[Lcom/intellij/clion/embedded/execution/wizard/ResetStrategy;)V", "speedRow", "Lcom/intellij/ui/dsl/builder/Row;", "defaultSpeed", "speedVariants", "(Lcom/intellij/ui/dsl/builder/Panel;Lcom/intellij/clion/embedded/execution/wizard/GdbServerWizard;Ljava/lang/String;[Ljava/lang/String;)Lcom/intellij/ui/dsl/builder/Row;", "Companion", "intellij.clion.embedded"})
@SourceDebugExtension(value={"SMAP\nGdbServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GdbServer.kt\ncom/intellij/clion/embedded/execution/wizard/GdbServer\n+ 2 ButtonsGroup.kt\ncom/intellij/ui/dsl/builder/ButtonsGroupKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,227:1\n31#2:228\n13#3:229\n1194#4,2:230\n1222#4,4:232\n*S KotlinDebug\n*F\n+ 1 GdbServer.kt\ncom/intellij/clion/embedded/execution/wizard/GdbServer\n*L\n78#1:228\n178#1:229\n113#1:230,2\n113#1:232,4\n*E\n"})
public abstract class GdbServer {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final GdbServerType type;
    @NotNull
    private final String FREQ_AUTO;
    @NotNull
    private final String FREQ_ADAPTIVE;
    @NotNull
    private final devicesTreeCellRenderer.1 devicesTreeCellRenderer;
    @NotNull
    private static final GdbServer DEFAULT_GDBSERVER;
    @NotNull
    private static final Map<String, GdbServer> gdbServerMap;
    @NotNull
    private static final Collection<GdbServer> all;

    public GdbServer(@NotNull GdbServerType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.type = type;
        this.FREQ_AUTO = "AUTO";
        this.FREQ_ADAPTIVE = "ADAPTIVE";
        this.devicesTreeCellRenderer = new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree, @NotNull Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
                Object userObject = node.getUserObject();
                Object object = userObject;
                if (object == null || (object = object.toString()) == null) {
                    object = "";
                }
                this.append((String)object);
                if (userObject instanceof Device) {
                    this.setIcon(CLionEmbeddedIcons.CustomGdbRunConfiguration);
                    this.setToolTipText(((Device)userObject).getDescription());
                } else {
                    this.setToolTipText(null);
                }
            }
        };
    }

    @NotNull
    public final GdbServerType getType() {
        return this.type;
    }

    @NotNull
    public final String getFREQ_AUTO$intellij_clion_embedded() {
        return this.FREQ_AUTO;
    }

    @NotNull
    public final String getFREQ_ADAPTIVE$intellij_clion_embedded() {
        return this.FREQ_ADAPTIVE;
    }

    @NotNull
    public final String getId() {
        return this.type.name();
    }

    @Nls
    @NotNull
    public abstract String getDisplayName();

    @NotNull
    public abstract String generateConnectionString(@NotNull GdbWizardOptions var1, int var2) throws CommitStepException;

    @NotNull
    public abstract DialogPanel getDialogPanel(@NotNull GdbServerWizard var1);

    @NotNull
    public abstract String getDefaultServerExecutableName();

    @Nullable
    public String findDefaultLocation() {
        File file = PathEnvironmentVariableUtil.findInPath((String)this.getDefaultServerExecutableName());
        return file != null ? file.toString() : null;
    }

    @NotNull
    public String getResetCommand() {
        return "monitor reset";
    }

    @NotNull
    public final String getGdbserverLocation(@NotNull GdbWizardOptions state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        String string = state.getGdbserverLocations().get(this.getId());
        if (string == null) {
            string = "";
        }
        return string;
    }

    @NotNull
    public String getGdbserverExe(@NotNull GdbWizardOptions state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        return this.getGdbserverLocation(state);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ButtonsGroup interfacesRow(@NotNull Panel $this$interfacesRow, @NotNull GdbServerWizard wizard) {
        void $this$bind$iv;
        Intrinsics.checkNotNullParameter((Object)$this$interfacesRow, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)wizard), (String)"wizard");
        ButtonsGroup buttonsGroup = Panel.buttonsGroup$default((Panel)$this$interfacesRow, null, (boolean)false, (Function1)interfacesRow.1.INSTANCE, (int)3, null);
        KMutableProperty0 prop$iv = (KMutableProperty0)new MutablePropertyReference0Impl((Object)wizard.getState()){

            @Nullable
            public Object get() {
                return ((GdbWizardOptions)((Object)this.receiver)).getInterfaceType();
            }

            public void set(@Nullable Object value) {
                ((GdbWizardOptions)((Object)this.receiver)).setInterfaceType((GdbWizardOptions.Companion.TransportInterface)((Object)value));
            }
        };
        boolean $i$f$bind = false;
        return $this$bind$iv.bind(MutablePropertyKt.toMutableProperty((KMutableProperty0)prop$iv), GdbWizardOptions.Companion.TransportInterface.class);
    }

    @NotNull
    public final Row speedRow(@NotNull Panel $this$speedRow, @NotNull GdbServerWizard wizard, @NotNull String defaultSpeed, String ... speedVariants) {
        Intrinsics.checkNotNullParameter((Object)$this$speedRow, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)wizard), (String)"wizard");
        Intrinsics.checkNotNullParameter((Object)defaultSpeed, (String)"defaultSpeed");
        Intrinsics.checkNotNullParameter((Object)speedVariants, (String)"speedVariants");
        String string = EmbeddedBundle.message("label.initial.speed", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return $this$speedRow.row(string, (Function1)new Function1<Row, Unit>(speedVariants, defaultSpeed, wizard){
            final /* synthetic */ String[] $speedVariants;
            final /* synthetic */ String $defaultSpeed;
            final /* synthetic */ GdbServerWizard $wizard;
            {
                this.$speedVariants = $speedVariants;
                this.$defaultSpeed = $defaultSpeed;
                this.$wizard = $wizard;
                super(1);
            }

            public final void invoke(@NotNull Row $this$row) {
                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                ComboBoxKt.bindItem((Cell)Row.comboBox$default((Row)$this$row, (ComboBoxModel)((ComboBoxModel)new CollectionComboBoxModel(ArraysKt.toList((Object[])this.$speedVariants), (Object)this.$defaultSpeed)), null, (int)2, null), (MutableProperty)MutablePropertyKt.toNullableProperty((KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl((Object)((Object)this.$wizard.getState())){

                    @Nullable
                    public Object get() {
                        return ((GdbWizardOptions)((Object)this.receiver)).getFrequency();
                    }

                    public void set(@Nullable Object value) {
                        ((GdbWizardOptions)((Object)this.receiver)).setFrequency((String)value);
                    }
                })));
                String string = EmbeddedBundle.message("label.khz", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                $this$row.label(string);
            }
        });
    }

    public final void resetStrategyRow(@NotNull Panel $this$resetStrategyRow, @NotNull GdbServerWizard wizard, ResetStrategy ... variants) {
        Intrinsics.checkNotNullParameter((Object)$this$resetStrategyRow, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)wizard), (String)"wizard");
        Intrinsics.checkNotNullParameter((Object)variants, (String)"variants");
        String string = EmbeddedBundle.message("label.reset.strategy", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$resetStrategyRow.row(string, (Function1)new Function1<Row, Unit>(variants, wizard){
            final /* synthetic */ ResetStrategy[] $variants;
            final /* synthetic */ GdbServerWizard $wizard;
            {
                this.$variants = $variants;
                this.$wizard = $wizard;
                super(1);
            }

            public final void invoke(@NotNull Row $this$row) {
                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                ComboBoxKt.bindItem((Cell)$this$row.comboBox((Collection)ArraysKt.toList((Object[])this.$variants), (ListCellRenderer)GdbServerKt.access$getResetStrategyRenderer$p()), (MutableProperty)MutablePropertyKt.toNullableProperty((KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl((Object)((Object)this.$wizard.getState())){

                    @Nullable
                    public Object get() {
                        return ((GdbWizardOptions)((Object)this.receiver)).getResetStrategy();
                    }

                    public void set(@Nullable Object value) {
                        ((GdbWizardOptions)((Object)this.receiver)).setResetStrategy((ResetStrategy)((Object)value));
                    }
                })));
            }
        });
    }

    public void gatherData(@NotNull Project project, @NotNull GdbWizardOptions state) throws CommitStepException {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        if (!new File(this.getGdbserverLocation(state)).canExecute()) {
            throw new CommitStepException(EmbeddedBundle.message("wrong.gdb.server.location", new Object[0]));
        }
    }

    protected final void devicesListRows(@NotNull Panel $this$devicesListRows, @NotNull GdbServerWizard wizard) {
        Intrinsics.checkNotNullParameter((Object)$this$devicesListRows, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)wizard), (String)"wizard");
        Panel.row$default((Panel)$this$devicesListRows, null, (Function1)devicesListRows.1.INSTANCE, (int)1, null);
        Panel.row$default((Panel)$this$devicesListRows, null, (Function1)((Function1)new Function1<Row, Unit>(wizard, $this$devicesListRows, this){
            final /* synthetic */ GdbServerWizard $wizard;
            final /* synthetic */ Panel $this_devicesListRows;
            final /* synthetic */ GdbServer this$0;
            {
                this.$wizard = $wizard;
                this.$this_devicesListRows = $receiver;
                this.this$0 = $receiver2;
                super(1);
            }

            public final void invoke(@NotNull Row $this$row) {
                Object v3;
                Tree tree;
                block1: {
                    Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                    Tree tree2 = new Tree((TreeNode)this.$wizard.getState().getDevicesTree());
                    Object object = this.this$0;
                    GdbServerWizard gdbServerWizard = this.$wizard;
                    Tree $this$invoke_u24lambda_u241 = tree2;
                    boolean bl = false;
                    $this$invoke_u24lambda_u241.setRootVisible(false);
                    $this$invoke_u24lambda_u241.setVisibleRowCount(6);
                    $this$invoke_u24lambda_u241.addTreeSelectionListener(arg_0 -> devicesListRows.2.invoke$lambda$1$lambda$0(gdbServerWizard, arg_0));
                    $this$invoke_u24lambda_u241.setCellRenderer((TreeCellRenderer)((Object)GdbServer.access$getDevicesTreeCellRenderer$p((GdbServer)object)));
                    tree = tree2;
                    TreeSpeedSearch.installOn((JTree)((JTree)tree), (boolean)true, arg_0 -> devicesListRows.2.invoke$lambda$2(devicesListRows.1.INSTANCE, arg_0));
                    this.$wizard.setFinishEnabled(false);
                    JBTreeTraverser jBTreeTraverser = TreeUtil.treePathTraverser((JTree)((JTree)tree));
                    Intrinsics.checkNotNullExpressionValue((Object)jBTreeTraverser, (String)"treePathTraverser(...)");
                    object = (Iterable)jBTreeTraverser;
                    gdbServerWizard = this.$wizard;
                    Object object2 = object;
                    Iterator<T> iterator = object2.iterator();
                    while (iterator.hasNext()) {
                        Device device;
                        T t = iterator.next();
                        TreePath it = (TreePath)t;
                        boolean bl2 = false;
                        Object object3 = it.getLastPathComponent();
                        DefaultMutableTreeNode defaultMutableTreeNode = object3 instanceof DefaultMutableTreeNode ? (DefaultMutableTreeNode)object3 : null;
                        Object object4 = defaultMutableTreeNode != null ? defaultMutableTreeNode.getUserObject() : null;
                        Device device2 = device = object4 instanceof Device ? (Device)object4 : null;
                        String string = device != null ? device.getMcuName() : null;
                        if (!Intrinsics.areEqual((Object)string, (Object)gdbServerWizard.getState().getSelectedDeviceName())) continue;
                        v3 = t;
                        break block1;
                    }
                    v3 = null;
                }
                TreePath selectionPath = v3;
                tree.setSelectionPath(selectionPath);
                tree.scrollPathToVisible(selectionPath);
                this.$this_devicesListRows.onApply((Function0)new Function0<Unit>(this.$wizard, tree){
                    final /* synthetic */ GdbServerWizard $wizard;
                    final /* synthetic */ Tree $tree;
                    {
                        this.$wizard = $wizard;
                        this.$tree = $tree;
                        super(0);
                    }

                    public final void invoke() {
                        TreePath treePath = this.$tree.getLeadSelectionPath();
                        Object object = treePath != null ? treePath.getLastPathComponent() : null;
                        DefaultMutableTreeNode defaultMutableTreeNode = object instanceof DefaultMutableTreeNode ? (DefaultMutableTreeNode)object : null;
                        Object object2 = defaultMutableTreeNode != null ? defaultMutableTreeNode.getUserObject() : null;
                        this.$wizard.getState().setSelectedDevice(object2 instanceof Device ? (Device)object2 : null);
                    }
                });
                $this$row.scrollCell((JComponent)tree).align(Align.FILL).resizableColumn();
            }

            private static final void invoke$lambda$1$lambda$0(GdbServerWizard $wizard, TreeSelectionEvent e) {
                Intrinsics.checkNotNullParameter((Object)((Object)$wizard), (String)"$wizard");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                TreePath treePath = e.getNewLeadSelectionPath();
                Object $this$asSafely$iv = treePath != null ? treePath.getLastPathComponent() : null;
                boolean $i$f$asSafely = false;
                Object object = $this$asSafely$iv;
                if (!(object instanceof DefaultMutableTreeNode)) {
                    object = null;
                }
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
                Object selectedObject = defaultMutableTreeNode != null ? defaultMutableTreeNode.getUserObject() : null;
                $wizard.setFinishEnabled(selectedObject instanceof Device);
            }

            private static final String invoke$lambda$2(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (String)$tmp0.invoke(p0);
            }
        }), (int)1, null).resizableRow();
    }

    @NotNull
    protected final ProcessOutput gatherProcessOutput(boolean ignoreStderr, String ... command) {
        ProcessOutput output;
        block4: {
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            GeneralCommandLine cmd = new GeneralCommandLine(Arrays.copyOf(command, command.length));
            output = null;
            try {
                CapturingProcessHandler processHandler = new CapturingProcessHandler(cmd);
                ProcessOutput processOutput = CidrRunProcessUtil.runWithProgress((BaseProcessHandler)((BaseProcessHandler)processHandler), (int)10000);
                Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"runWithProgress(...)");
                output = processOutput;
                if (!output.isTimeout()) {
                    String string = output.getStderr();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStderr(...)");
                    if (!(((CharSequence)string).length() > 0) || ignoreStderr) break block4;
                }
                Object[] objectArray = new Object[]{command[0]};
                throw new CommitStepException(EmbeddedBundle.message("gdbserver.app.cannot.report.supported.devices", objectArray));
            }
            catch (ExecutionException e) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(GdbServer.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn(e.getMessage());
                Object[] objectArray = new Object[2];
                objectArray[0] = command[0];
                String string = e.getLocalizedMessage();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLocalizedMessage(...)");
                objectArray[1] = CollectionsKt.joinToString$default((Iterable)StringsKt.chunked((CharSequence)string, (int)80), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
                throw new CommitStepException(EmbeddedBundle.message("gdb.servers.wizard.exception.occurred.while.executable.invoke", objectArray));
            }
        }
        return output;
    }

    @NotNull
    protected final DefaultMutableTreeNode validateNonEmptyTree(@NotNull DefaultMutableTreeNode rootNode) throws CommitStepException {
        Intrinsics.checkNotNullParameter((Object)rootNode, (String)"rootNode");
        if (rootNode.getChildCount() == 0) {
            throw new CommitStepException(EmbeddedBundle.message("gdbserver.cannot.report.supported.devices", new Object[0]));
        }
        return rootNode;
    }

    @NotNull
    protected final String selectedDeviceKey(@NotNull GdbWizardOptions state) throws CommitStepException {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        Device device = state.getSelectedDevice();
        if (device == null) {
            throw new CommitStepException(EmbeddedBundle.message("target.device.is.not.selected", new Object[0]));
        }
        return device.getMcuKey();
    }

    public static final /* synthetic */ devicesTreeCellRenderer.1 access$getDevicesTreeCellRenderer$p(GdbServer $this) {
        return $this.devicesTreeCellRenderer;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$associateByTo$iv$iv;
        Companion = new Companion(null);
        DEFAULT_GDBSERVER = new JLinkServer();
        Object[] objectArray = new GdbServer[]{DEFAULT_GDBSERVER, new Qemu(), new PyOcdServer(), new StUtilServer(), new StLinkServer(), new PeMicroServer()};
        Iterable $this$associateBy$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            GdbServer gdbServer = (GdbServer)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getId(), element$iv$iv);
        }
        gdbServerMap = destination$iv$iv;
        all = gdbServerMap.values();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00040\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/clion/embedded/execution/wizard/GdbServer$Companion;", "", "()V", "DEFAULT_GDBSERVER", "Lcom/intellij/clion/embedded/execution/wizard/GdbServer;", "all", "", "getAll", "()Ljava/util/Collection;", "gdbServerMap", "", "", "byId", "id", "intellij.clion.embedded"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final GdbServer byId(@Nullable String id) {
            return gdbServerMap.getOrDefault(id, DEFAULT_GDBSERVER);
        }

        @NotNull
        public final Collection<GdbServer> getAll() {
            return all;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

