/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.embedded.execution.rtos.freertos;

import com.intellij.clion.embedded.execution.rtos.freertos.AddressAsLongSerializer;
import com.intellij.clion.embedded.execution.rtos.freertos.FreeRtosDataManagerKt;
import com.intellij.clion.embedded.execution.rtos.freertos.HeapBlock$;
import com.intellij.clion.embedded.execution.rtos.freertos.HeapBlockStatus;
import com.intellij.clion.embedded.execution.rtos.freertos.HeapRegion;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import java.io.PrintWriter;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.EnumsKt;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 52\u00020\u0001:\u000245BI\b\u0011\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u000fB)\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u0010J\t\u0010\u001c\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\tH\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u000bH\u00c6\u0003J1\u0010 \u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u000e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'J\u000e\u0010(\u001a\u00020\"2\u0006\u0010)\u001a\u00020*J\t\u0010+\u001a\u00020\u0003H\u00d6\u0001J\t\u0010,\u001a\u00020\u0005H\u00d6\u0001J&\u0010-\u001a\u00020%2\u0006\u0010.\u001a\u00020\u00002\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202H\u00c1\u0001\u00a2\u0006\u0002\b3R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0011\u0010\f\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0016R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u00066"}, d2={"Lcom/intellij/clion/embedded/execution/rtos/freertos/HeapBlock;", "", "seen1", "", "details", "", "start", "Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "size", "", "status", "Lcom/intellij/clion/embedded/execution/rtos/freertos/HeapBlockStatus;", "end", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;Lcom/jetbrains/cidr/execution/debugger/memory/Address;JLcom/intellij/clion/embedded/execution/rtos/freertos/HeapBlockStatus;Lcom/jetbrains/cidr/execution/debugger/memory/Address;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "(Ljava/lang/String;Lcom/jetbrains/cidr/execution/debugger/memory/Address;JLcom/intellij/clion/embedded/execution/rtos/freertos/HeapBlockStatus;)V", "getDetails", "()Ljava/lang/String;", "setDetails", "(Ljava/lang/String;)V", "getEnd", "()Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "getSize", "()J", "getStart", "getStatus", "()Lcom/intellij/clion/embedded/execution/rtos/freertos/HeapBlockStatus;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "exportCsv", "", "writer", "Ljava/io/PrintWriter;", "fits", "region", "Lcom/intellij/clion/embedded/execution/rtos/freertos/HeapRegion;", "hashCode", "toString", "write$Self", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$intellij_clion_embedded", "$serializer", "Companion", "intellij.clion.embedded"})
public final class HeapBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String details;
    @NotNull
    private final Address start;
    private final long size;
    @NotNull
    private final HeapBlockStatus status;
    @NotNull
    private final Address end;
    @JvmField
    @NotNull
    private static final KSerializer<Object>[] $childSerializers;
    @NotNull
    private static final String[] columnNames;

    public HeapBlock(@NotNull String details, @NotNull Address start, long size, @NotNull HeapBlockStatus status) {
        Intrinsics.checkNotNullParameter((Object)details, (String)"details");
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
        this.details = details;
        this.start = start;
        this.size = size;
        this.status = status;
        this.end = this.start.plus((Number)this.size).minus((Number)1);
    }

    public /* synthetic */ HeapBlock(String string, Address address, long l, HeapBlockStatus heapBlockStatus, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "Free";
        }
        if ((n & 8) != 0) {
            heapBlockStatus = HeapBlockStatus.FREE;
        }
        this(string, address, l, heapBlockStatus);
    }

    @NotNull
    public final String getDetails() {
        return this.details;
    }

    public final void setDetails(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.details = string;
    }

    @NotNull
    public final Address getStart() {
        return this.start;
    }

    public final long getSize() {
        return this.size;
    }

    @NotNull
    public final HeapBlockStatus getStatus() {
        return this.status;
    }

    @NotNull
    public final Address getEnd() {
        return this.end;
    }

    public final boolean fits(@NotNull HeapRegion region) {
        Intrinsics.checkNotNullParameter((Object)region, (String)"region");
        return this.start.compareTo(region.getStart()) >= 0 && this.end.compareTo(region.getEnd()) <= 0;
    }

    public final void exportCsv(@NotNull PrintWriter writer) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        String[] stringArray = new String[]{FreeRtosDataManagerKt.to32BitString(this.start), String.valueOf(this.size), this.status.toString(), this.details};
        FreeRtosDataManagerKt.writeCsv(writer, stringArray);
    }

    @NotNull
    public final String component1() {
        return this.details;
    }

    @NotNull
    public final Address component2() {
        return this.start;
    }

    public final long component3() {
        return this.size;
    }

    @NotNull
    public final HeapBlockStatus component4() {
        return this.status;
    }

    @NotNull
    public final HeapBlock copy(@NotNull String details, @NotNull Address start, long size, @NotNull HeapBlockStatus status) {
        Intrinsics.checkNotNullParameter((Object)details, (String)"details");
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
        return new HeapBlock(details, start, size, status);
    }

    public static /* synthetic */ HeapBlock copy$default(HeapBlock heapBlock, String string, Address address, long l, HeapBlockStatus heapBlockStatus, int n, Object object) {
        if ((n & 1) != 0) {
            string = heapBlock.details;
        }
        if ((n & 2) != 0) {
            address = heapBlock.start;
        }
        if ((n & 4) != 0) {
            l = heapBlock.size;
        }
        if ((n & 8) != 0) {
            heapBlockStatus = heapBlock.status;
        }
        return heapBlock.copy(string, address, l, heapBlockStatus);
    }

    @NotNull
    public String toString() {
        return "HeapBlock(details=" + this.details + ", start=" + this.start + ", size=" + this.size + ", status=" + this.status + ")";
    }

    public int hashCode() {
        int result = this.details.hashCode();
        result = result * 31 + this.start.hashCode();
        result = result * 31 + Long.hashCode(this.size);
        result = result * 31 + this.status.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HeapBlock)) {
            return false;
        }
        HeapBlock heapBlock = (HeapBlock)other;
        if (!Intrinsics.areEqual((Object)this.details, (Object)heapBlock.details)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.start, (Object)heapBlock.start)) {
            return false;
        }
        if (this.size != heapBlock.size) {
            return false;
        }
        return this.status == heapBlock.status;
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$intellij_clion_embedded(HeapBlock self, CompositeEncoder output, SerialDescriptor serialDesc) {
        KSerializer<Object>[] kSerializerArray = $childSerializers;
        if (output.shouldEncodeElementDefault(serialDesc, 0) ? true : !Intrinsics.areEqual((Object)self.details, (Object)"Free")) {
            output.encodeStringElement(serialDesc, 0, self.details);
        }
        output.encodeSerializableElement(serialDesc, 1, (SerializationStrategy)AddressAsLongSerializer.INSTANCE, (Object)self.start);
        output.encodeLongElement(serialDesc, 2, self.size);
        if (output.shouldEncodeElementDefault(serialDesc, 3) ? true : self.status != HeapBlockStatus.FREE) {
            output.encodeSerializableElement(serialDesc, 3, (SerializationStrategy)kSerializerArray[3], (Object)self.status);
        }
        if (output.shouldEncodeElementDefault(serialDesc, 4) ? true : !Intrinsics.areEqual((Object)self.end, (Object)self.start.plus((Number)self.size).minus((Number)1))) {
            output.encodeSerializableElement(serialDesc, 4, (SerializationStrategy)AddressAsLongSerializer.INSTANCE, (Object)self.end);
        }
    }

    @Deprecated(message="This synthesized declaration should not be used directly", replaceWith=@ReplaceWith(expression="", imports={}), level=DeprecationLevel.HIDDEN)
    public /* synthetic */ HeapBlock(int seen1, String details, Address start, long size, HeapBlockStatus status, Address end, SerializationConstructorMarker serializationConstructorMarker) {
        if (6 != (6 & seen1)) {
            PluginExceptionsKt.throwMissingFieldException((int)seen1, (int)6, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        this.details = (seen1 & 1) == 0 ? "Free" : details;
        this.start = start;
        this.size = size;
        this.status = (seen1 & 8) == 0 ? HeapBlockStatus.FREE : status;
        this.end = (seen1 & 0x10) == 0 ? this.start.plus((Number)this.size).minus((Number)1) : end;
    }

    public static final /* synthetic */ KSerializer[] access$get$childSerializers$cp() {
        return $childSerializers;
    }

    static {
        Object[] objectArray = new KSerializer[]{null, null, null, EnumsKt.createSimpleEnumSerializer((String)"com.intellij.clion.embedded.execution.rtos.freertos.HeapBlockStatus", (Enum[])HeapBlockStatus.values()), null};
        $childSerializers = objectArray;
        objectArray = new String[]{"Start address", "Size", "Status", "Details"};
        columnNames = objectArray;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u00c6\u0001R\u0019\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/intellij/clion/embedded/execution/rtos/freertos/HeapBlock$Companion;", "", "()V", "columnNames", "", "", "getColumnNames", "()[Ljava/lang/String;", "[Ljava/lang/String;", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/intellij/clion/embedded/execution/rtos/freertos/HeapBlock;", "intellij.clion.embedded"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String[] getColumnNames() {
            return columnNames;
        }

        @NotNull
        public final KSerializer<HeapBlock> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

