/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.embedded.execution.rtos.freertos;

import com.intellij.clion.embedded.execution.rtos.freertos.AddressAsLongSerializer;
import com.intellij.clion.embedded.execution.rtos.freertos.FreeRtosDataManagerKt;
import com.intellij.ui.content.Content;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.ui.XDebugSessionTab;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.MemoryViewPanel;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import com.jetbrains.cidr.execution.debugger.memory.AddressRange;
import com.jetbrains.cidr.execution.debugger.memory.GotoAddressPanel;
import java.io.PrintWriter;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.UseSerializers;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\n\u0010\u0005\u001a\u00020\u0006*\u00020\u0007\u001a#\u0010\b\u001a\u00020\u0001*\u00020\t2\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u000b\"\u00020\u0006\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"showMemoryRange", "", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "addressRange", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "to32BitString", "", "Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "writeCsv", "Ljava/io/PrintWriter;", "values", "", "(Ljava/io/PrintWriter;[Ljava/lang/String;)V", "intellij.clion.embedded"})
@UseSerializers(serializerClasses={AddressAsLongSerializer.class})
public final class FreeRtosDataManagerKt {
    public static final void showMemoryRange(@NotNull CidrDebugProcess $this$showMemoryRange, @NotNull AddressRange addressRange) {
        XDebugSessionTab sessionTab;
        Intrinsics.checkNotNullParameter((Object)$this$showMemoryRange, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)addressRange, (String)"addressRange");
        MemoryViewPanel memoryViewPanel = $this$showMemoryRange.getHexdumpViewPanel();
        if (memoryViewPanel == null) {
            return;
        }
        MemoryViewPanel memoryViewPanel2 = memoryViewPanel;
        GotoAddressPanel gotoAddressPanel = memoryViewPanel2.getGotoAddressPanel();
        Intrinsics.checkNotNullExpressionValue((Object)gotoAddressPanel, (String)"getGotoAddressPanel(...)");
        GotoAddressPanel gotoAddressPanel2 = gotoAddressPanel;
        XDebugSession debugSession = $this$showMemoryRange.getSession();
        if (debugSession instanceof XDebugSessionImpl && (sessionTab = ((XDebugSessionImpl)debugSession).getSessionTab()) != null) {
            Content memoryViewContent = sessionTab.getUi().findContent("DEBUGGER_MEMORY_VIEW");
            JComponent memoryViewComponent = memoryViewPanel2.getPreferredFocusableComponent();
            sessionTab.getUi().selectAndFocus(memoryViewContent, true, true).doWhenDone(() -> FreeRtosDataManagerKt.showMemoryRange$lambda$0(memoryViewComponent));
        }
        gotoAddressPanel2.getInputComponent().getExpressionInput().setExpression((XExpression)new XExpressionImpl(FreeRtosDataManagerKt.to32BitString(addressRange.getStart()), null, String.valueOf(addressRange.getSize()), EvaluationMode.EXPRESSION));
        gotoAddressPanel2.getInputComponent().performEvaluateAction();
    }

    @NotNull
    public static final String to32BitString(@NotNull Address $this$to32BitString) {
        Intrinsics.checkNotNullParameter((Object)$this$to32BitString, (String)"<this>");
        String string = Long.toUnsignedString($this$to32BitString.getUnsignedLongValue(), 16);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUnsignedString(...)");
        return "0x" + StringsKt.padStart((String)string, (int)8, (char)'0');
    }

    public static final void writeCsv(@NotNull PrintWriter $this$writeCsv, String ... values) {
        Intrinsics.checkNotNullParameter((Object)$this$writeCsv, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        $this$writeCsv.println(ArraysKt.joinToString$default((Object[])values, null, null, null, (int)0, null, (Function1)writeCsv.1.INSTANCE, (int)31, null));
    }

    private static final void showMemoryRange$lambda$0(JComponent $memoryViewComponent) {
        $memoryViewComponent.requestFocus();
    }
}

