/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsonpath.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.impl.ContentManagerWatcher;
import com.intellij.json.psi.JsonFile;
import com.intellij.jsonpath.JsonPathBundle;
import com.intellij.jsonpath.ui.JsonPathEvaluateFileView;
import com.intellij.jsonpath.ui.JsonPathEvaluateSnippetView;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.wm.RegisterToolWindowTask;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.ui.EDT;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u0005\u001a\u0013\u0012\t\u0012\u00070\u0007\u00a2\u0006\u0002\b\b\u0012\u0004\u0012\u00020\t0\u00062\u000b\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\bH\u0002J\u0012\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012J\u0015\u0010\u0013\u001a\u00070\u000f\u00a2\u0006\u0002\b\u00142\u0006\u0010\n\u001a\u00020\u000bH\u0003J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/jsonpath/ui/JsonPathEvaluateManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "addSnippetTab", "Lkotlin/Pair;", "Lcom/intellij/ui/content/Content;", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/jsonpath/ui/JsonPathEvaluateSnippetView;", "cm", "Lcom/intellij/ui/content/ContentManager;", "evaluateExpression", "", "jsonPathExpr", "", "evaluateFromJson", "file", "Lcom/intellij/json/psi/JsonFile;", "findNextSnippetTitle", "Lcom/intellij/openapi/util/NlsContexts$TabTitle;", "initToolwindow", "Lcom/intellij/openapi/wm/ToolWindow;", "registerToolwindow", "toolWindowManager", "Lcom/intellij/openapi/wm/ToolWindowManager;", "Companion", "intellij.jsonpath"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nJsonPathEvaluateManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonPathEvaluateManager.kt\ncom/intellij/jsonpath/ui/JsonPathEvaluateManager\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,148:1\n18717#2,2:149\n12474#2,2:151\n*S KotlinDebug\n*F\n+ 1 JsonPathEvaluateManager.kt\ncom/intellij/jsonpath/ui/JsonPathEvaluateManager\n*L\n117#1:149,2\n122#1:151,2\n*E\n"})
public final class JsonPathEvaluateManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    public static final String EVALUATE_TOOLWINDOW_ID = "JSONPathEvaluate";
    @NotNull
    public static final String JSON_PATH_EVALUATE_HISTORY = "JSONPathEvaluateHistory";
    @JvmField
    @NotNull
    public static final Key<Boolean> JSON_PATH_EVALUATE_EXPRESSION_KEY;
    @ApiStatus.Internal
    @JvmField
    @NotNull
    public static final Key<Supplier<JsonFile>> JSON_PATH_EVALUATE_SOURCE_KEY;
    @JvmField
    @NotNull
    public static final Key<Boolean> JSON_PATH_EVALUATE_RESULT_KEY;

    public JsonPathEvaluateManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    public final void evaluateExpression(@Nullable String jsonPathExpr) {
        Pair pair;
        Object object;
        ContentManager cm;
        ToolWindow toolWindow;
        block5: {
            toolWindow = this.initToolwindow();
            ContentManager contentManager = toolWindow.getContentManager();
            Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"getContentManager(...)");
            cm = contentManager;
            Content[] contentArray = cm.getContents();
            Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"getContents(...)");
            Object[] objectArray = contentArray;
            int n = objectArray.length + -1;
            if (0 <= n) {
                do {
                    int n2 = n--;
                    Object object2 = objectArray[n2];
                    Content it = (Content)object2;
                    boolean bl = false;
                    if (!(it.getComponent() instanceof JsonPathEvaluateSnippetView && !it.isPinned())) continue;
                    object = object2;
                    break block5;
                } while (0 <= n);
            }
            object = null;
        }
        Content content = (Content)object;
        if (content != null) {
            Content it = content;
            boolean bl = false;
            JComponent jComponent = it.getComponent();
            Intrinsics.checkNotNull((Object)jComponent, (String)"null cannot be cast to non-null type com.intellij.jsonpath.ui.JsonPathEvaluateSnippetView");
            pair = new Pair((Object)it, (Object)((JsonPathEvaluateSnippetView)((Object)jComponent)));
        } else {
            pair = this.addSnippetTab(cm);
        }
        Pair pair2 = pair;
        Content content2 = (Content)pair2.component1();
        JsonPathEvaluateSnippetView view = (JsonPathEvaluateSnippetView)((Object)pair2.component2());
        toolWindow.show();
        cm.setSelectedContent(content2, true);
        if (jsonPathExpr != null) {
            view.setExpression(jsonPathExpr);
        }
    }

    public static /* synthetic */ void evaluateExpression$default(JsonPathEvaluateManager jsonPathEvaluateManager, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        jsonPathEvaluateManager.evaluateExpression(string);
    }

    public final void evaluateFromJson(@NotNull JsonFile file) {
        Object object;
        ContentManager cm;
        ToolWindow toolWindow;
        block2: {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            toolWindow = this.initToolwindow();
            ContentManager contentManager = toolWindow.getContentManager();
            Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"getContentManager(...)");
            cm = contentManager;
            Content[] contentArray = cm.getContents();
            Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"getContents(...)");
            for (Object object2 : (Object[])contentArray) {
                JComponent component;
                Content it = (Content)object2;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it.getComponent(), (String)"getComponent(...)");
                if (!(component instanceof JsonPathEvaluateFileView && Intrinsics.areEqual((Object)((JsonPathEvaluateFileView)((Object)component)).getJsonFile(), (Object)file))) continue;
                object = object2;
                break block2;
            }
            object = null;
        }
        Content existingContent = (Content)object;
        if (existingContent != null) {
            toolWindow.show();
            cm.setSelectedContent(existingContent, true);
            return;
        }
        JsonPathEvaluateFileView newView = new JsonPathEvaluateFileView(this.project, file);
        Object[] objectArray = new Object[]{file.getName()};
        Content content = cm.getFactory().createContent(newView.getComponent(), JsonPathBundle.message("jsonpath.toolwindow.evaluate.on.file", objectArray), false);
        Intrinsics.checkNotNullExpressionValue((Object)content, (String)"createContent(...)");
        Content newContent = content;
        newContent.setCloseable(true);
        newContent.setPinnable(true);
        newContent.setPreferredFocusableComponent(newView.getSearchComponent());
        cm.addContent(newContent);
        toolWindow.show();
        cm.setSelectedContent(newContent, true);
    }

    private final ToolWindow initToolwindow() {
        Ref.ObjectRef toolWindow;
        block1: {
            EDT.assertIsEdt();
            ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(this.project);
            toolWindow = new Ref.ObjectRef();
            toolWindow.element = toolWindowManager.getToolWindow(EVALUATE_TOOLWINDOW_ID);
            if (toolWindow.element != null) break block1;
            toolWindow.element = this.registerToolwindow(toolWindowManager);
            AnAction[] anActionArray = toolWindow.element;
            ToolWindowEx toolWindowEx = anActionArray instanceof ToolWindowEx ? (ToolWindowEx)anActionArray : null;
            if (toolWindowEx != null) {
                anActionArray = new AnAction[1];
                String string = JsonPathBundle.message("jsonpath.evaluate.add.tab.text", new Object[0]);
                Icon icon = AllIcons.General.Add;
                anActionArray[0] = new DumbAwareAction(this, (Ref.ObjectRef<ToolWindow>)toolWindow, string, icon){
                    final /* synthetic */ JsonPathEvaluateManager this$0;
                    final /* synthetic */ Ref.ObjectRef<ToolWindow> $toolWindow;
                    {
                        this.this$0 = $receiver;
                        this.$toolWindow = $toolWindow;
                        super($super_call_param$1, null, $super_call_param$2);
                    }

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        ContentManager contentManager = ((ToolWindowEx)this.$toolWindow.element).getContentManager();
                        Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"getContentManager(...)");
                        Content content = (Content)JsonPathEvaluateManager.access$addSnippetTab(this.this$0, contentManager).component1();
                        ((ToolWindowEx)this.$toolWindow.element).getContentManager().setSelectedContent(content, true);
                    }
                };
                toolWindowEx.setTabActions(anActionArray);
            }
        }
        return (ToolWindow)toolWindow.element;
    }

    private final ToolWindow registerToolwindow(ToolWindowManager toolWindowManager) {
        ToolWindowAnchor toolWindowAnchor = ToolWindowAnchor.RIGHT;
        Intrinsics.checkNotNullExpressionValue((Object)toolWindowAnchor, (String)"RIGHT");
        ToolWindow toolWindow = toolWindowManager.registerToolWindow(new RegisterToolWindowTask(EVALUATE_TOOLWINDOW_ID, toolWindowAnchor, null, false, false, false, false, null, AllIcons.Toolwindows.ToolWindowJsonPath, JsonPathBundle.messagePointer("jsonpath.toolwindow.evaluate.stripe", new Object[0]), 248, null));
        ContentManagerWatcher.watchContentManager((ToolWindow)toolWindow, (ContentManager)toolWindow.getContentManager());
        return toolWindow;
    }

    private final Pair<Content, JsonPathEvaluateSnippetView> addSnippetTab(ContentManager cm) {
        JsonPathEvaluateSnippetView newView = new JsonPathEvaluateSnippetView(this.project);
        Content content = cm.getFactory().createContent(newView.getComponent(), this.findNextSnippetTitle(cm), false);
        Intrinsics.checkNotNullExpressionValue((Object)content, (String)"createContent(...)");
        Content newContent = content;
        newContent.setCloseable(true);
        newContent.setPinnable(true);
        newContent.setPreferredFocusableComponent(newView.getSearchComponent());
        cm.addContent(newContent);
        return new Pair((Object)newContent, (Object)newView);
    }

    @NlsContexts.TabTitle
    private final String findNextSnippetTitle(ContentManager cm) {
        boolean bl;
        String defaultTitle;
        block4: {
            String string = JsonPathBundle.message("jsonpath.toolwindow.evaluate.on.snippet", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            defaultTitle = string;
            Content[] contentArray = cm.getContents();
            Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"getContents(...)");
            Object[] $this$none$iv = contentArray;
            boolean $i$f$none = false;
            int n = $this$none$iv.length;
            for (int i = 0; i < n; ++i) {
                Object element$iv = $this$none$iv[i];
                Content it = (Content)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getTabName(), (Object)defaultTitle)) continue;
                bl = false;
                break block4;
            }
            bl = true;
        }
        if (bl) {
            return defaultTitle;
        }
        int index = 0;
        index = 2;
        while (true) {
            boolean bl3;
            block5: {
                Content[] contentArray = cm.getContents();
                Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"getContents(...)");
                Object[] $this$any$iv = contentArray;
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    Content it = (Content)element$iv;
                    boolean bl4 = false;
                    Object[] objectArray = new Object[]{index};
                    if (!Intrinsics.areEqual((Object)it.getTabName(), (Object)JsonPathBundle.message("jsonpath.toolwindow.evaluate.on.snippet.n", objectArray))) continue;
                    bl3 = true;
                    break block5;
                }
                bl3 = false;
            }
            if (!bl3) break;
            int n = index;
            index = n + 1;
        }
        Object[] objectArray = new Object[]{index};
        String string = JsonPathBundle.message("jsonpath.toolwindow.evaluate.on.snippet.n", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final JsonPathEvaluateManager getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    public static final /* synthetic */ Pair access$addSnippetTab(JsonPathEvaluateManager $this, ContentManager cm) {
        return $this.addSnippetTab(cm);
    }

    static {
        Key key = Key.create((String)"JSON_PATH_EVALUATE_EXPRESSION");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        JSON_PATH_EVALUATE_EXPRESSION_KEY = key;
        Key key2 = Key.create((String)"JSON_PATH_EVALUATE_SOURCE");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        JSON_PATH_EVALUATE_SOURCE_KEY = key2;
        Key key3 = Key.create((String)"JSON_PATH_EVALUATE_RESULT");
        Intrinsics.checkNotNullExpressionValue((Object)key3, (String)"create(...)");
        JSON_PATH_EVALUATE_RESULT_KEY = key3;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b0\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/jsonpath/ui/JsonPathEvaluateManager$Companion;", "", "()V", "EVALUATE_TOOLWINDOW_ID", "", "JSON_PATH_EVALUATE_EXPRESSION_KEY", "Lcom/intellij/openapi/util/Key;", "", "JSON_PATH_EVALUATE_HISTORY", "JSON_PATH_EVALUATE_RESULT_KEY", "JSON_PATH_EVALUATE_SOURCE_KEY", "Ljava/util/function/Supplier;", "Lcom/intellij/json/psi/JsonFile;", "getInstance", "Lcom/intellij/jsonpath/ui/JsonPathEvaluateManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.jsonpath"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final JsonPathEvaluateManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(JsonPathEvaluateManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (JsonPathEvaluateManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

