/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.precision;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.util.GeometryTransformer;

class PointwisePrecisionReducerTransformer
extends GeometryTransformer {
    private PrecisionModel targetPM;

    public static Geometry reduce(Geometry geom, PrecisionModel targetPM) {
        PointwisePrecisionReducerTransformer trans = new PointwisePrecisionReducerTransformer(targetPM);
        return trans.transform(geom);
    }

    PointwisePrecisionReducerTransformer(PrecisionModel targetPM) {
        this.targetPM = targetPM;
    }

    @Override
    protected CoordinateSequence transformCoordinates(CoordinateSequence coordinates, Geometry parent2) {
        if (coordinates.size() == 0) {
            return null;
        }
        Coordinate[] coordsReduce = this.reducePointwise(coordinates);
        return this.factory.getCoordinateSequenceFactory().create(coordsReduce);
    }

    private Coordinate[] reducePointwise(CoordinateSequence coordinates) {
        Coordinate[] coordReduce = new Coordinate[coordinates.size()];
        for (int i2 = 0; i2 < coordinates.size(); ++i2) {
            Coordinate coord = coordinates.getCoordinate(i2).copy();
            this.targetPM.makePrecise(coord);
            coordReduce[i2] = coord;
        }
        return coordReduce;
    }
}

