/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.index.intervalrtree;

import org.locationtech.jts.index.ItemVisitor;
import org.locationtech.jts.index.intervalrtree.IntervalRTreeNode;

public class IntervalRTreeBranchNode
extends IntervalRTreeNode {
    private IntervalRTreeNode node1;
    private IntervalRTreeNode node2;

    public IntervalRTreeBranchNode(IntervalRTreeNode n12, IntervalRTreeNode n22) {
        this.node1 = n12;
        this.node2 = n22;
        this.buildExtent(this.node1, this.node2);
    }

    private void buildExtent(IntervalRTreeNode n12, IntervalRTreeNode n22) {
        this.min = Math.min(n12.min, n22.min);
        this.max = Math.max(n12.max, n22.max);
    }

    @Override
    public void query(double queryMin, double queryMax, ItemVisitor visitor2) {
        if (!this.intersects(queryMin, queryMax)) {
            return;
        }
        if (this.node1 != null) {
            this.node1.query(queryMin, queryMax, visitor2);
        }
        if (this.node2 != null) {
            this.node2.query(queryMin, queryMax, visitor2);
        }
    }
}

