/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.index.bintree;

import org.locationtech.jts.index.bintree.Interval;
import org.locationtech.jts.index.bintree.Key;
import org.locationtech.jts.index.bintree.NodeBase;
import org.locationtech.jts.util.Assert;

public class Node
extends NodeBase {
    private Interval interval;
    private double centre;
    private int level;

    public static Node createNode(Interval itemInterval) {
        Key key2 = new Key(itemInterval);
        Node node2 = new Node(key2.getInterval(), key2.getLevel());
        return node2;
    }

    public static Node createExpanded(Node node2, Interval addInterval) {
        Interval expandInt = new Interval(addInterval);
        if (node2 != null) {
            expandInt.expandToInclude(node2.interval);
        }
        Node largerNode = Node.createNode(expandInt);
        if (node2 != null) {
            largerNode.insert(node2);
        }
        return largerNode;
    }

    public Node(Interval interval, int level) {
        this.interval = interval;
        this.level = level;
        this.centre = (interval.getMin() + interval.getMax()) / 2.0;
    }

    public Interval getInterval() {
        return this.interval;
    }

    @Override
    protected boolean isSearchMatch(Interval itemInterval) {
        return itemInterval.overlaps(this.interval);
    }

    public Node getNode(Interval searchInterval) {
        int subnodeIndex = Node.getSubnodeIndex(searchInterval, this.centre);
        if (subnodeIndex != -1) {
            Node node2 = this.getSubnode(subnodeIndex);
            return node2.getNode(searchInterval);
        }
        return this;
    }

    public NodeBase find(Interval searchInterval) {
        int subnodeIndex = Node.getSubnodeIndex(searchInterval, this.centre);
        if (subnodeIndex == -1) {
            return this;
        }
        if (this.subnode[subnodeIndex] != null) {
            Node node2 = this.subnode[subnodeIndex];
            return node2.find(searchInterval);
        }
        return this;
    }

    void insert(Node node2) {
        Assert.isTrue(this.interval == null || this.interval.contains(node2.interval));
        int index2 = Node.getSubnodeIndex(node2.interval, this.centre);
        if (node2.level == this.level - 1) {
            this.subnode[index2] = node2;
        } else {
            Node childNode = this.createSubnode(index2);
            childNode.insert(node2);
            this.subnode[index2] = childNode;
        }
    }

    private Node getSubnode(int index2) {
        if (this.subnode[index2] == null) {
            this.subnode[index2] = this.createSubnode(index2);
        }
        return this.subnode[index2];
    }

    private Node createSubnode(int index2) {
        double min = 0.0;
        double max = 0.0;
        switch (index2) {
            case 0: {
                min = this.interval.getMin();
                max = this.centre;
                break;
            }
            case 1: {
                min = this.centre;
                max = this.interval.getMax();
            }
        }
        Interval subInt = new Interval(min, max);
        Node node2 = new Node(subInt, this.level - 1);
        return node2;
    }
}

