/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geomgraph.index;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geomgraph.Edge;
import org.locationtech.jts.geomgraph.index.EdgeSetIntersector;
import org.locationtech.jts.geomgraph.index.SegmentIntersector;
import org.locationtech.jts.geomgraph.index.SweepLineEvent;
import org.locationtech.jts.geomgraph.index.SweepLineSegment;

public class SimpleSweepLineIntersector
extends EdgeSetIntersector {
    List events = new ArrayList();
    int nOverlaps;

    @Override
    public void computeIntersections(List edges, SegmentIntersector si2, boolean testAllSegments) {
        if (testAllSegments) {
            this.add(edges, null);
        } else {
            this.add(edges);
        }
        this.computeIntersections(si2);
    }

    @Override
    public void computeIntersections(List edges0, List edges1, SegmentIntersector si2) {
        this.add(edges0, (Object)edges0);
        this.add(edges1, (Object)edges1);
        this.computeIntersections(si2);
    }

    private void add(List edges) {
        for (Edge edge : edges) {
            this.add(edge, (Object)edge);
        }
    }

    private void add(List edges, Object edgeSet) {
        for (Edge edge : edges) {
            this.add(edge, edgeSet);
        }
    }

    private void add(Edge edge, Object edgeSet) {
        Coordinate[] pts = edge.getCoordinates();
        for (int i2 = 0; i2 < pts.length - 1; ++i2) {
            SweepLineSegment ss2 = new SweepLineSegment(edge, i2);
            SweepLineEvent insertEvent = new SweepLineEvent(edgeSet, ss2.getMinX(), null);
            this.events.add(insertEvent);
            this.events.add(new SweepLineEvent(ss2.getMaxX(), insertEvent));
        }
    }

    private void prepareEvents() {
        Collections.sort(this.events);
        for (int i2 = 0; i2 < this.events.size(); ++i2) {
            SweepLineEvent ev = (SweepLineEvent)this.events.get(i2);
            if (!ev.isDelete()) continue;
            ev.getInsertEvent().setDeleteEventIndex(i2);
        }
    }

    private void computeIntersections(SegmentIntersector si2) {
        this.nOverlaps = 0;
        this.prepareEvents();
        for (int i2 = 0; i2 < this.events.size(); ++i2) {
            SweepLineEvent ev = (SweepLineEvent)this.events.get(i2);
            if (!ev.isInsert()) continue;
            this.processOverlaps(i2, ev.getDeleteEventIndex(), ev, si2);
        }
    }

    private void processOverlaps(int start2, int end, SweepLineEvent ev0, SegmentIntersector si2) {
        SweepLineSegment ss0 = (SweepLineSegment)ev0.getObject();
        for (int i2 = start2; i2 < end; ++i2) {
            SweepLineEvent ev1 = (SweepLineEvent)this.events.get(i2);
            if (!ev1.isInsert()) continue;
            SweepLineSegment ss1 = (SweepLineSegment)ev1.getObject();
            if (ev0.isSameLabel(ev1)) continue;
            ss0.computeIntersections(ss1, si2);
            ++this.nOverlaps;
        }
    }
}

