/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm.construct;

import java.util.PriorityQueue;
import org.locationtech.jts.algorithm.locate.IndexedPointInAreaLocator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.operation.distance.IndexedFacetDistance;

public class MaximumInscribedCircle {
    private Geometry inputGeom;
    private double tolerance;
    private GeometryFactory factory;
    private IndexedPointInAreaLocator ptLocater;
    private IndexedFacetDistance indexedDistance;
    private Cell centerCell = null;
    private Coordinate centerPt = null;
    private Coordinate radiusPt;
    private Point centerPoint;
    private Point radiusPoint;

    public static Point getCenter(Geometry polygonal, double tolerance) {
        MaximumInscribedCircle mic = new MaximumInscribedCircle(polygonal, tolerance);
        return mic.getCenter();
    }

    public static LineString getRadiusLine(Geometry polygonal, double tolerance) {
        MaximumInscribedCircle mic = new MaximumInscribedCircle(polygonal, tolerance);
        return mic.getRadiusLine();
    }

    public MaximumInscribedCircle(Geometry polygonal, double tolerance) {
        if (tolerance <= 0.0) {
            throw new IllegalArgumentException("Tolerance must be positive");
        }
        if (!(polygonal instanceof Polygon) && !(polygonal instanceof MultiPolygon)) {
            throw new IllegalArgumentException("Input geometry must be a Polygon or MultiPolygon");
        }
        if (polygonal.isEmpty()) {
            throw new IllegalArgumentException("Empty input geometry is not supported");
        }
        this.inputGeom = polygonal;
        this.factory = polygonal.getFactory();
        this.tolerance = tolerance;
        this.ptLocater = new IndexedPointInAreaLocator(polygonal);
        this.indexedDistance = new IndexedFacetDistance(polygonal.getBoundary());
    }

    public Point getCenter() {
        this.compute();
        return this.centerPoint;
    }

    public Point getRadiusPoint() {
        this.compute();
        return this.radiusPoint;
    }

    public LineString getRadiusLine() {
        this.compute();
        LineString radiusLine = this.factory.createLineString(new Coordinate[]{this.centerPt.copy(), this.radiusPt.copy()});
        return radiusLine;
    }

    private double distanceToBoundary(Point p2) {
        boolean isOutide;
        double dist = this.indexedDistance.distance(p2);
        boolean bl = isOutide = 2 == this.ptLocater.locate(p2.getCoordinate());
        if (isOutide) {
            return -dist;
        }
        return dist;
    }

    private double distanceToBoundary(double x, double y) {
        Coordinate coord = new Coordinate(x, y);
        Point pt = this.factory.createPoint(coord);
        return this.distanceToBoundary(pt);
    }

    private void compute() {
        if (this.centerCell != null) {
            return;
        }
        PriorityQueue<Cell> cellQueue = new PriorityQueue<Cell>();
        this.createInitialGrid(this.inputGeom.getEnvelopeInternal(), cellQueue);
        Cell farthestCell = this.createCentroidCell(this.inputGeom);
        while (!cellQueue.isEmpty()) {
            double potentialIncrease;
            Cell cell = (Cell)cellQueue.remove();
            if (cell.getDistance() > farthestCell.getDistance()) {
                farthestCell = cell;
            }
            if (!((potentialIncrease = cell.getMaxDistance() - farthestCell.getDistance()) > this.tolerance)) continue;
            double h2 = cell.getHSide() / 2.0;
            cellQueue.add(this.createCell(cell.getX() - h2, cell.getY() - h2, h2));
            cellQueue.add(this.createCell(cell.getX() + h2, cell.getY() - h2, h2));
            cellQueue.add(this.createCell(cell.getX() - h2, cell.getY() + h2, h2));
            cellQueue.add(this.createCell(cell.getX() + h2, cell.getY() + h2, h2));
        }
        this.centerCell = farthestCell;
        this.centerPt = new Coordinate(this.centerCell.getX(), this.centerCell.getY());
        this.centerPoint = this.factory.createPoint(this.centerPt);
        Coordinate[] nearestPts = this.indexedDistance.nearestPoints(this.centerPoint);
        this.radiusPt = nearestPts[0].copy();
        this.radiusPoint = this.factory.createPoint(this.radiusPt);
    }

    private void createInitialGrid(Envelope env, PriorityQueue<Cell> cellQueue) {
        double height;
        double minX = env.getMinX();
        double maxX = env.getMaxX();
        double minY = env.getMinY();
        double maxY = env.getMaxY();
        double width = env.getWidth();
        double cellSize = Math.min(width, height = env.getHeight());
        if (cellSize == 0.0) {
            return;
        }
        double hSide = cellSize / 2.0;
        for (double x = minX; x < maxX; x += cellSize) {
            for (double y = minY; y < maxY; y += cellSize) {
                cellQueue.add(this.createCell(x + hSide, y + hSide, hSide));
            }
        }
    }

    private Cell createCell(double x, double y, double hSide) {
        return new Cell(x, y, hSide, this.distanceToBoundary(x, y));
    }

    private Cell createCentroidCell(Geometry geom) {
        Point p2 = geom.getCentroid();
        return new Cell(p2.getX(), p2.getY(), 0.0, this.distanceToBoundary(p2));
    }

    private static class Cell
    implements Comparable<Cell> {
        private static final double SQRT2 = 1.4142135623730951;
        private double x;
        private double y;
        private double hSide;
        private double distance;
        private double maxDist;

        Cell(double x, double y, double hSide, double distanceToBoundary) {
            this.x = x;
            this.y = y;
            this.hSide = hSide;
            this.distance = distanceToBoundary;
            this.maxDist = this.distance + hSide * 1.4142135623730951;
        }

        public Envelope getEnvelope() {
            return new Envelope(this.x - this.hSide, this.x + this.hSide, this.y - this.hSide, this.y + this.hSide);
        }

        public double getMaxDistance() {
            return this.maxDist;
        }

        public double getDistance() {
            return this.distance;
        }

        public double getHSide() {
            return this.hSide;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        @Override
        public int compareTo(Cell o2) {
            return (int)(o2.maxDist - this.maxDist);
        }
    }
}

