/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.wire;

import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.Key;
import com.google.inject.spi.BindingTargetVisitor;
import com.google.inject.spi.DefaultElementVisitor;
import com.google.inject.spi.Element;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.sisu.inject.Logs;
import org.eclipse.sisu.wire.DependencyVerifier;

final class ElementMerger
extends DefaultElementVisitor<Void> {
    private final DependencyVerifier verifier = new DependencyVerifier();
    private final Set<Key<?>> localKeys = new HashSet();
    private final Binder binder;

    ElementMerger(Binder binder) {
        this.binder = binder;
    }

    public <T> Void visit(Binding<T> binding) {
        Key key2 = binding.getKey();
        if (!this.localKeys.contains(key2)) {
            if (Boolean.TRUE.equals(binding.acceptTargetVisitor((BindingTargetVisitor)this.verifier))) {
                this.localKeys.add(key2);
                binding.applyTo(this.binder);
            } else {
                Logs.trace("Discard binding: {}", binding, null);
            }
        }
        return null;
    }

    public Void visitOther(Element element2) {
        element2.applyTo(this.binder);
        return null;
    }
}

