/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.space;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.eclipse.sisu.space.FileEntryIterator;
import org.eclipse.sisu.space.Streams;

final class ZipEntryIterator
implements Iterator<String> {
    private String[] entryNames;
    private int index;

    ZipEntryIterator(URL url) {
        try {
            this.entryNames = "file".equals(url.getProtocol()) ? ZipEntryIterator.getEntryNames(new ZipFile(FileEntryIterator.toFile(url))) : ZipEntryIterator.getEntryNames(new ZipInputStream(Streams.open(url)));
        }
        catch (IOException iOException) {
            this.entryNames = new String[0];
        }
    }

    @Override
    public boolean hasNext() {
        return this.index < this.entryNames.length;
    }

    @Override
    public String next() {
        return this.entryNames[this.index++];
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private static String[] getEntryNames(ZipFile zipFile) throws IOException {
        try {
            String[] names2 = new String[zipFile.size()];
            Enumeration<? extends ZipEntry> e2 = zipFile.entries();
            int i2 = 0;
            while (i2 < names2.length) {
                names2[i2] = e2.nextElement().getName();
                ++i2;
            }
            String[] stringArray = names2;
            return stringArray;
        }
        finally {
            zipFile.close();
        }
    }

    private static String[] getEntryNames(ZipInputStream zipStream) throws IOException {
        try {
            ArrayList<String> names2 = new ArrayList<String>(64);
            ZipEntry e2 = zipStream.getNextEntry();
            while (e2 != null) {
                names2.add(e2.getName());
                e2 = zipStream.getNextEntry();
            }
            String[] stringArray = names2.toArray(new String[names2.size()]);
            return stringArray;
        }
        finally {
            zipStream.close();
        }
    }
}

