/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.osgi;

import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import org.eclipse.sisu.inject.BindingPublisher;
import org.eclipse.sisu.inject.BindingSubscriber;
import org.eclipse.sisu.inject.Logs;
import org.eclipse.sisu.osgi.BindingTracker;
import org.osgi.framework.BundleContext;

public final class ServiceBindings
implements BindingPublisher {
    private static final Pattern GLOB_SYNTAX = Pattern.compile("(?:\\w+|\\*)(?:\\.?(?:\\w+|\\*))*");
    private final ConcurrentMap<String, BindingTracker<?>> trackers = new ConcurrentHashMap();
    private final BundleContext context;
    private final Pattern[] allowed;
    private final Pattern[] ignored;
    private final int maxRank;

    public ServiceBindings(BundleContext context, String allow, String ignore, int maxRank) {
        this.context = context;
        this.maxRank = maxRank;
        this.allowed = ServiceBindings.parseGlobs(allow);
        this.ignored = ServiceBindings.parseGlobs(ignore);
    }

    public ServiceBindings(BundleContext context) {
        this(context, ServiceBindings.defaultAllow(), ServiceBindings.defaultIgnore(), Integer.MIN_VALUE);
    }

    public static String defaultAllow() {
        return System.getProperty(String.valueOf(ServiceBindings.class.getName()) + ".allow", "");
    }

    public static String defaultIgnore() {
        return System.getProperty(String.valueOf(ServiceBindings.class.getName()) + ".ignore", "");
    }

    @Override
    public <T> void subscribe(BindingSubscriber<T> subscriber) {
        String clazzName = subscriber.type().getRawType().getName();
        if (this.shouldTrack(clazzName)) {
            BindingTracker oldTracker;
            BindingTracker<T> tracker = (BindingTracker<T>)((Object)this.trackers.get(clazzName));
            if (tracker == null && (oldTracker = this.trackers.putIfAbsent(clazzName, tracker = new BindingTracker<T>(this.context, this.maxRank, clazzName))) != null) {
                tracker = oldTracker;
            }
            tracker.subscribe(subscriber);
        }
    }

    @Override
    public <T> void unsubscribe(BindingSubscriber<T> subscriber) {
        String clazzName = subscriber.type().getRawType().getName();
        BindingTracker tracker = (BindingTracker)((Object)this.trackers.get(clazzName));
        if (tracker != null) {
            tracker.unsubscribe(subscriber);
        }
    }

    @Override
    public int maxBindingRank() {
        return this.maxRank;
    }

    private boolean shouldTrack(String clazzName) {
        Pattern[] patternArray = this.allowed;
        int n = this.allowed.length;
        int n3 = 0;
        while (n3 < n) {
            Pattern allow = patternArray[n3];
            if (allow.matcher(clazzName).matches()) {
                Pattern[] patternArray2 = this.ignored;
                int n4 = this.ignored.length;
                int n5 = 0;
                while (n5 < n4) {
                    Pattern ignore = patternArray2[n5];
                    if (ignore.matcher(clazzName).matches()) {
                        return false;
                    }
                    ++n5;
                }
                return true;
            }
            ++n3;
        }
        return false;
    }

    private static Pattern[] parseGlobs(String globs) {
        ArrayList<Pattern> patterns2 = new ArrayList<Pattern>();
        String[] stringArray = globs.split("\\s*,\\s*");
        int n = stringArray.length;
        int n3 = 0;
        while (n3 < n) {
            String glob = stringArray[n3];
            if (GLOB_SYNTAX.matcher(glob).matches()) {
                patterns2.add(Pattern.compile(glob.replace(".", "\\.").replace("*", ".*")));
            } else if (glob.length() > 0) {
                Logs.warn("Ignoring malformed glob pattern: {}", glob, null);
            }
            ++n3;
        }
        return patterns2.toArray(new Pattern[patterns2.size()]);
    }
}

