/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether;

import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.aether.SessionData;

public final class DefaultSessionData
implements SessionData {
    private final ConcurrentMap<Object, Object> data = new ConcurrentHashMap<Object, Object>();

    @Override
    public void set(Object key2, Object value2) {
        Objects.requireNonNull(key2, "key cannot be null");
        if (value2 != null) {
            this.data.put(key2, value2);
        } else {
            this.data.remove(key2);
        }
    }

    @Override
    public boolean set(Object key2, Object oldValue, Object newValue) {
        Objects.requireNonNull(key2, "key cannot be null");
        if (newValue != null) {
            if (oldValue == null) {
                return this.data.putIfAbsent(key2, newValue) == null;
            }
            return this.data.replace(key2, oldValue, newValue);
        }
        if (oldValue == null) {
            return !this.data.containsKey(key2);
        }
        return this.data.remove(key2, oldValue);
    }

    @Override
    public Object get(Object key2) {
        Objects.requireNonNull(key2, "key cannot be null");
        return this.data.get(key2);
    }
}

