/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jettison.json;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jettison.JSONSequenceTooLargeException;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONString;
import org.codehaus.jettison.json.JSONTokener;

public class JSONObject
implements Serializable {
    static final int DEFAULT_RECURSION_DEPTH_LIMIT = 500;
    static int RECURSION_DEPTH_LIMIT = 500;
    private LinkedHashMap<Object, Object> myHashMap;
    private boolean dropRootElement;
    private List ignoredElements;
    private boolean writeNullAsString = true;
    private boolean escapeForwardSlashAlways = true;
    public static final Object NULL = new Null();
    public static final Object EXPLICIT_NULL = new Null(true);

    public JSONObject() {
        this(false, null, true, true);
    }

    public JSONObject(List ignoredElements) {
        this(false, ignoredElements, true, true);
    }

    public JSONObject(boolean dropRootElement, List ignoredElements, boolean writeNullAsString, boolean escapeForwardSlash) {
        this.myHashMap = new LinkedHashMap();
        this.dropRootElement = dropRootElement;
        this.ignoredElements = ignoredElements;
        this.writeNullAsString = writeNullAsString;
        this.escapeForwardSlashAlways = escapeForwardSlash;
    }

    public JSONObject(JSONObject jo, String[] sa) throws JSONException {
        this();
        for (int i2 = 0; i2 < sa.length; ++i2) {
            this.putOpt(sa[i2], jo.opt(sa[i2]));
        }
    }

    public JSONObject(JSONTokener x) throws JSONException {
        this();
        if (x.nextClean() != '{') {
            throw x.syntaxError("A JSONObject text must begin with '{'");
        }
        block9: while (true) {
            char c2 = x.nextClean();
            switch (c2) {
                case '\u0000': {
                    throw x.syntaxError("A JSONObject text must end with '}'");
                }
                case '}': {
                    return;
                }
                case '{': {
                    throw x.syntaxError("Expected a key");
                }
            }
            x.back();
            String key2 = x.nextValue().toString();
            c2 = x.nextClean();
            if (c2 == '=') {
                if (x.next() != '>') {
                    x.back();
                }
            } else if (c2 != ':') {
                throw x.syntaxError("Expected a ':' after a key");
            }
            this.doPut(key2, x.nextValue(), x.getThreshold(), true);
            switch (x.nextClean()) {
                case ',': 
                case ';': {
                    if (x.nextClean() == '}') {
                        return;
                    }
                    x.back();
                    continue block9;
                }
                case '}': {
                    return;
                }
            }
            break;
        }
        throw x.syntaxError("Expected a ',' or '}'");
    }

    public JSONObject(Map map2) throws JSONException {
        this(map2, 0);
    }

    private JSONObject(Map map2, int recursionDepth) throws JSONException {
        if (recursionDepth > RECURSION_DEPTH_LIMIT) {
            throw new JSONException("JSONObject has reached recursion depth limit of " + RECURSION_DEPTH_LIMIT);
        }
        this.myHashMap = map2 == null ? new LinkedHashMap() : new LinkedHashMap(map2);
        for (Map.Entry<Object, Object> entry : this.myHashMap.entrySet()) {
            Object v2 = entry.getValue();
            if (v2 instanceof Collection) {
                this.myHashMap.put(entry.getKey(), new JSONArray((Collection)v2));
            }
            if (!(v2 instanceof Map) || v2 == map2) continue;
            this.myHashMap.put(entry.getKey(), new JSONObject((Map)v2, recursionDepth + 1));
        }
    }

    public JSONObject(Object object, String[] names2) {
        this();
        Class<?> c2 = object.getClass();
        for (int i2 = 0; i2 < names2.length; ++i2) {
            try {
                String name2 = names2[i2];
                Field field = c2.getField(name2);
                Object value2 = field.get(object);
                this.put(name2, value2);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public JSONObject(String string) throws JSONException {
        this(new JSONTokener(string));
    }

    public JSONObject accumulate(String key2, Object value2) throws JSONException {
        JSONObject.testValidity(value2);
        Object o2 = this.opt(key2);
        if (o2 == null) {
            this.put(key2, value2);
        } else if (o2 instanceof JSONArray) {
            ((JSONArray)o2).put(value2);
        } else {
            this.put(key2, new JSONArray().put(o2).put(value2));
        }
        return this;
    }

    public JSONObject append(String key2, Object value2) throws JSONException {
        JSONObject.testValidity(value2);
        Object o2 = this.opt(key2);
        if (o2 == null) {
            this.put(key2, new JSONArray().put(value2));
        } else {
            if (!(o2 instanceof JSONArray)) {
                throw new JSONException("JSONObject[" + key2 + "] is not a JSONArray.");
            }
            ((JSONArray)o2).put(value2);
        }
        return this;
    }

    public static String doubleToString(double d2) {
        if (Double.isInfinite(d2) || Double.isNaN(d2)) {
            return "null";
        }
        String s2 = Double.toString(d2);
        if (s2.indexOf(46) > 0 && s2.indexOf(101) < 0 && s2.indexOf(69) < 0) {
            while (s2.endsWith("0")) {
                s2 = s2.substring(0, s2.length() - 1);
            }
            if (s2.endsWith(".")) {
                s2 = s2.substring(0, s2.length() - 1);
            }
        }
        return s2;
    }

    public Object get(String key2) throws JSONException {
        Object o2 = this.opt(key2);
        if (o2 == null) {
            throw new JSONException("JSONObject[" + JSONObject.quote(key2) + "] not found.");
        }
        return o2;
    }

    public boolean getBoolean(String key2) throws JSONException {
        return this.doGetBoolean(key2, this.get(key2));
    }

    private boolean doGetBoolean(String key2, Object o2) throws JSONException {
        if (o2.equals(Boolean.FALSE) || o2 instanceof String && ((String)o2).equalsIgnoreCase("false")) {
            return false;
        }
        if (o2.equals(Boolean.TRUE) || o2 instanceof String && ((String)o2).equalsIgnoreCase("true")) {
            return true;
        }
        throw new JSONException("JSONObject[" + JSONObject.quote(key2) + "] is not a Boolean.");
    }

    public double getDouble(String key2) throws JSONException {
        return this.doGetDouble(key2, this.get(key2));
    }

    private double doGetDouble(String key2, Object o2) throws JSONException {
        try {
            return o2 instanceof Number ? ((Number)o2).doubleValue() : Double.valueOf((String)o2).doubleValue();
        }
        catch (Exception e2) {
            throw new JSONException("JSONObject[" + JSONObject.quote(key2) + "] is not a number.");
        }
    }

    public int getInt(String key2) throws JSONException {
        return this.doGetInt(key2, this.get(key2));
    }

    private int doGetInt(String key2, Object o2) throws JSONException {
        return o2 instanceof Number ? ((Number)o2).intValue() : (int)this.getDouble(key2);
    }

    public JSONArray getJSONArray(String key2) throws JSONException {
        Object o2 = this.get(key2);
        if (o2 instanceof JSONArray) {
            return (JSONArray)o2;
        }
        throw new JSONException("JSONObject[" + JSONObject.quote(key2) + "] is not a JSONArray.");
    }

    public JSONObject getJSONObject(String key2) throws JSONException {
        Object o2 = this.get(key2);
        if (o2 instanceof JSONObject) {
            return (JSONObject)o2;
        }
        throw new JSONException("JSONObject[" + JSONObject.quote(key2) + "] is not a JSONObject.");
    }

    public long getLong(String key2) throws JSONException {
        return this.doGetLong(key2, this.get(key2));
    }

    private long doGetLong(String key2, Object o2) throws JSONException {
        return o2 instanceof String ? Long.parseLong((String)o2) : (o2 instanceof Number ? ((Number)o2).longValue() : (long)this.getDouble(key2));
    }

    public String getString(String key2) throws JSONException {
        return this.get(key2).toString();
    }

    public boolean has(String key2) {
        return this.myHashMap.containsKey(key2);
    }

    public boolean isNull(String key2) {
        return NULL.equals(this.opt(key2)) || EXPLICIT_NULL.equals(this.opt(key2));
    }

    public Iterator keys() {
        return this.myHashMap.keySet().iterator();
    }

    public int length() {
        return this.myHashMap.size();
    }

    public JSONArray names() {
        JSONArray ja = new JSONArray();
        Iterator keys2 = this.keys();
        while (keys2.hasNext()) {
            ja.put(keys2.next());
        }
        return ja.length() == 0 ? null : ja;
    }

    public static String numberToString(Number n) throws JSONException {
        if (n == null) {
            throw new JSONException("Null pointer");
        }
        JSONObject.testValidity(n);
        String s2 = n.toString();
        if (s2.indexOf(46) > 0 && s2.indexOf(101) < 0 && s2.indexOf(69) < 0) {
            while (s2.endsWith("0")) {
                s2 = s2.substring(0, s2.length() - 1);
            }
            if (s2.endsWith(".")) {
                s2 = s2.substring(0, s2.length() - 1);
            }
        }
        return s2;
    }

    public Object opt(String key2) {
        return key2 == null ? null : this.myHashMap.get(key2);
    }

    public boolean optBoolean(String key2) {
        return this.optBoolean(key2, false);
    }

    public boolean optBoolean(String key2, boolean defaultValue) {
        Object o2 = this.opt(key2);
        if (o2 == null) {
            return defaultValue;
        }
        try {
            return this.doGetBoolean(key2, o2);
        }
        catch (JSONException ex) {
            throw new RuntimeException(ex);
        }
    }

    public JSONObject put(String key2, Collection value2) throws JSONException {
        this.put(key2, new JSONArray(value2));
        return this;
    }

    public double optDouble(String key2) {
        return this.optDouble(key2, Double.NaN);
    }

    public double optDouble(String key2, double defaultValue) {
        Object o2 = this.opt(key2);
        if (o2 == null) {
            return defaultValue;
        }
        try {
            return this.doGetDouble(key2, o2);
        }
        catch (JSONException ex) {
            throw new RuntimeException(ex);
        }
    }

    public int optInt(String key2) {
        return this.optInt(key2, 0);
    }

    public int optInt(String key2, int defaultValue) {
        Object o2 = this.opt(key2);
        if (o2 == null) {
            return defaultValue;
        }
        try {
            return this.doGetInt(key2, o2);
        }
        catch (JSONException ex) {
            throw new RuntimeException(ex);
        }
    }

    public JSONArray optJSONArray(String key2) {
        Object o2 = this.opt(key2);
        return o2 instanceof JSONArray ? (JSONArray)o2 : null;
    }

    public JSONObject optJSONObject(String key2) {
        Object o2 = this.opt(key2);
        return o2 instanceof JSONObject ? (JSONObject)o2 : null;
    }

    public long optLong(String key2) {
        return this.optLong(key2, 0L);
    }

    public long optLong(String key2, long defaultValue) {
        Object o2 = this.opt(key2);
        if (o2 == null) {
            return defaultValue;
        }
        try {
            return this.doGetLong(key2, o2);
        }
        catch (JSONException ex) {
            throw new RuntimeException(ex);
        }
    }

    public String optString(String key2) {
        return this.optString(key2, "");
    }

    public String optString(String key2, String defaultValue) {
        Object o2 = this.opt(key2);
        return o2 != null ? o2.toString() : defaultValue;
    }

    public JSONObject put(String key2, boolean value2) throws JSONException {
        this.put(key2, value2 ? Boolean.TRUE : Boolean.FALSE);
        return this;
    }

    public JSONObject put(String key2, double value2) throws JSONException {
        this.put(key2, new Double(value2));
        return this;
    }

    public JSONObject put(String key2, int value2) throws JSONException {
        this.put(key2, (Object)value2);
        return this;
    }

    public JSONObject put(String key2, long value2) throws JSONException {
        this.put(key2, (Object)value2);
        return this;
    }

    public JSONObject put(String key2, Map value2) throws JSONException {
        this.put(key2, new JSONObject(value2));
        return this;
    }

    public JSONObject put(String key2, Object value2) throws JSONException {
        return this.doPut(key2, value2, -1, false);
    }

    protected JSONObject doPut(String key2, Object value2, int threshold, boolean checkExistingValue) throws JSONException {
        if (key2 == null) {
            throw new JSONException("Null key.");
        }
        if (value2 != null) {
            JSONObject.testValidity(value2);
            if (!checkExistingValue || !this.myHashMap.containsKey(key2)) {
                this.myHashMap.put(key2, value2);
                if (threshold > 0 && this.myHashMap.size() >= threshold) {
                    throw new JSONSequenceTooLargeException("Threshold has been exceeded");
                }
            } else {
                JSONArray array = null;
                Object existingValue = this.myHashMap.get(key2);
                if (existingValue instanceof JSONArray) {
                    array = (JSONArray)existingValue;
                } else {
                    array = new JSONArray(Collections.singletonList(existingValue));
                    this.myHashMap.put(key2, array);
                }
                array.put(value2);
            }
        } else if (!this.writeNullAsString) {
            this.myHashMap.put(key2, null);
        } else {
            this.remove(key2);
        }
        return this;
    }

    public JSONObject putOpt(String key2, Object value2) throws JSONException {
        if (key2 != null && value2 != null) {
            this.put(key2, value2);
        }
        return this;
    }

    public static String quote(String string) {
        return JSONObject.quote(string, true);
    }

    public static String quote(String string, boolean escapeForwardSlashAlways) {
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        char c2 = '\u0000';
        int len = string.length();
        StringBuilder sb = new StringBuilder(len + 4);
        sb.append('\"');
        block12: for (int i2 = 0; i2 < len; ++i2) {
            c2 = string.charAt(i2);
            switch (c2) {
                case '\\': {
                    sb.append("\\\\");
                    continue block12;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block12;
                }
                case '/': {
                    if (escapeForwardSlashAlways || i2 > 0 && string.charAt(i2 - 1) == '<') {
                        sb.append('\\');
                    }
                    sb.append(c2);
                    continue block12;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block12;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block12;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block12;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block12;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block12;
                }
                case '\u2028': {
                    sb.append("\\u2028");
                    continue block12;
                }
                case '\u2029': {
                    sb.append("\\u2029");
                    continue block12;
                }
                default: {
                    if (c2 < ' ') {
                        String t = "000" + Integer.toHexString(c2);
                        sb.append("\\u" + t.substring(t.length() - 4));
                        continue block12;
                    }
                    sb.append(c2);
                }
            }
        }
        sb.append('\"');
        return sb.toString();
    }

    public Object remove(String key2) {
        return this.myHashMap.remove(key2);
    }

    static void testValidity(Object o2) throws JSONException {
        if (o2 != null) {
            if (o2 instanceof Double) {
                if (((Double)o2).isInfinite() || ((Double)o2).isNaN()) {
                    throw new JSONException("JSON does not allow non-finite numbers");
                }
            } else if (o2 instanceof Float && (((Float)o2).isInfinite() || ((Float)o2).isNaN())) {
                throw new JSONException("JSON does not allow non-finite numbers.");
            }
        }
    }

    public JSONArray toJSONArray(JSONArray names2) throws JSONException {
        if (names2 == null || names2.length() == 0) {
            return null;
        }
        JSONArray ja = new JSONArray();
        for (int i2 = 0; i2 < names2.length(); ++i2) {
            ja.put(this.opt(names2.getString(i2)));
        }
        return ja;
    }

    public int hashCode() {
        return this.myHashMap.hashCode();
    }

    public boolean equals(Object obj2) {
        if (obj2 instanceof JSONObject) {
            return this.myHashMap.equals(((JSONObject)obj2).myHashMap);
        }
        return false;
    }

    public String toString() {
        try {
            Iterator keys2 = this.keys();
            StringBuilder sb = new StringBuilder("{");
            while (keys2.hasNext()) {
                if (sb.length() > 1) {
                    sb.append(',');
                }
                Object o2 = keys2.next();
                sb.append(JSONObject.quote(o2.toString(), this.escapeForwardSlashAlways));
                sb.append(':');
                sb.append(JSONObject.valueToString(this.myHashMap.get(o2), this.escapeForwardSlashAlways));
            }
            sb.append('}');
            return sb.toString();
        }
        catch (Exception e2) {
            return null;
        }
    }

    public String toString(int indentFactor) throws JSONException {
        return this.toString(indentFactor, 0);
    }

    String toString(int indentFactor, int indent) throws JSONException {
        int i2;
        int n = this.length();
        if (n == 0) {
            return "{}";
        }
        Iterator keys2 = this.keys();
        StringBuilder sb = new StringBuilder("{");
        int newindent = indent + indentFactor;
        while (keys2.hasNext()) {
            Object o2 = keys2.next();
            if (sb.length() > 1) {
                sb.append(",\n");
            } else {
                sb.append('\n');
            }
            for (i2 = 0; i2 < newindent; ++i2) {
                sb.append(' ');
            }
            sb.append(JSONObject.quote(o2.toString()));
            sb.append(": ");
            sb.append(JSONObject.valueToString(this.myHashMap.get(o2), indentFactor, newindent, this.escapeForwardSlashAlways));
        }
        if (sb.length() > 1) {
            sb.append('\n');
            for (i2 = 0; i2 < indent; ++i2) {
                sb.append(' ');
            }
        }
        sb.append('}');
        return sb.toString();
    }

    static String valueToString(Object value2, boolean escapeForwardSlash) throws JSONException {
        if (value2 == null || value2.equals(null)) {
            return "null";
        }
        if (value2 instanceof JSONString) {
            String o2;
            try {
                o2 = ((JSONString)value2).toJSONString();
            }
            catch (Exception e2) {
                throw new JSONException(e2);
            }
            if (o2 != null) {
                return o2;
            }
            throw new JSONException("Bad value from toJSONString: " + o2);
        }
        if (value2 instanceof Number) {
            return JSONObject.numberToString((Number)value2);
        }
        if (value2 instanceof Boolean || value2 instanceof JSONObject || value2 instanceof JSONArray) {
            return value2.toString();
        }
        return JSONObject.quote(value2.toString(), escapeForwardSlash);
    }

    static String valueToString(Object value2, int indentFactor, int indent, boolean escapeForwardSlash) throws JSONException {
        if (value2 == null || value2.equals(null)) {
            return "null";
        }
        try {
            if (value2 instanceof JSONString) {
                return ((JSONString)value2).toJSONString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (value2 instanceof Number) {
            return JSONObject.numberToString((Number)value2);
        }
        if (value2 instanceof Boolean) {
            return value2.toString();
        }
        if (value2 instanceof JSONObject) {
            return ((JSONObject)value2).toString(indentFactor, indent);
        }
        if (value2 instanceof JSONArray) {
            return ((JSONArray)value2).toString(indentFactor, indent);
        }
        return JSONObject.quote(value2.toString(), escapeForwardSlash);
    }

    public static void setGlobalRecursionDepthLimit(int newRecursionDepthLimit) {
        RECURSION_DEPTH_LIMIT = newRecursionDepthLimit;
    }

    @Deprecated
    public void setRecursionDepthLimit(int newRecursionDepthLimit) {
        RECURSION_DEPTH_LIMIT = newRecursionDepthLimit;
    }

    public static int getGlobalRecursionDepthLimit() {
        return RECURSION_DEPTH_LIMIT;
    }

    @Deprecated
    public int getRecursionDepthLimit() {
        return RECURSION_DEPTH_LIMIT;
    }

    public Writer write(Writer writer) throws JSONException {
        try {
            int hashMapSize = this.myHashMap.size();
            boolean dropObjectKeyName = false;
            if (hashMapSize == 1) {
                boolean bl = dropObjectKeyName = this.dropRootElement || this.ignoredElements != null && this.ignoredElements.contains(this.keys().next());
            }
            if (!dropObjectKeyName) {
                writer.write(123);
            }
            boolean b2 = false;
            Iterator keys2 = this.keys();
            while (keys2.hasNext()) {
                if (b2) {
                    writer.write(44);
                    b2 = false;
                }
                String k = keys2.next().toString();
                Object v2 = this.myHashMap.get(k);
                boolean mayBeDropSimpleElement = false;
                if (!dropObjectKeyName) {
                    boolean bl = mayBeDropSimpleElement = hashMapSize > 1 && this.ignoredElements != null && this.ignoredElements.contains(k);
                    if (!mayBeDropSimpleElement) {
                        writer.write(JSONObject.quote(k, this.escapeForwardSlashAlways));
                        writer.write(58);
                    }
                }
                if (v2 instanceof JSONObject) {
                    ((JSONObject)v2).write(writer);
                } else if (v2 instanceof JSONArray) {
                    ((JSONArray)v2).write(writer);
                } else if (!mayBeDropSimpleElement) {
                    writer.write(JSONObject.valueToString(v2, this.escapeForwardSlashAlways));
                }
                if (mayBeDropSimpleElement) continue;
                b2 = true;
            }
            if (!dropObjectKeyName) {
                writer.write(125);
            }
            return writer;
        }
        catch (IOException e2) {
            throw new JSONException(e2);
        }
    }

    public boolean isEscapeForwardSlashAlways() {
        return this.escapeForwardSlashAlways;
    }

    public void setEscapeForwardSlashAlways(boolean escapeForwardSlashAlways) {
        this.escapeForwardSlashAlways = escapeForwardSlashAlways;
    }

    public Map toMap() {
        return Collections.unmodifiableMap(this.myHashMap);
    }

    private static final class Null {
        boolean explicitNull;

        public Null() {
        }

        public Null(boolean explicitNull) {
            this.explicitNull = explicitNull;
        }

        protected final Object clone() {
            return this;
        }

        public boolean equals(Object object) {
            return object == null || object == this;
        }

        public String toString() {
            return this.isExplicitNull() ? null : "null";
        }

        public boolean isExplicitNull() {
            return this.explicitNull;
        }
    }
}

