/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.repository.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.maven.repository.internal.VersionsMetadata;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.deployment.DeployRequest;
import org.eclipse.aether.impl.MetadataGenerator;
import org.eclipse.aether.installation.InstallRequest;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.util.ConfigUtils;

class VersionsMetadataGenerator
implements MetadataGenerator {
    private Map<Object, VersionsMetadata> versions = new LinkedHashMap<Object, VersionsMetadata>();
    private Map<Object, VersionsMetadata> processedVersions = new LinkedHashMap<Object, VersionsMetadata>();
    private final Date timestamp;

    VersionsMetadataGenerator(RepositorySystemSession session2, InstallRequest request2) {
        this(session2, request2.getMetadata());
    }

    VersionsMetadataGenerator(RepositorySystemSession session2, DeployRequest request2) {
        this(session2, request2.getMetadata());
    }

    private VersionsMetadataGenerator(RepositorySystemSession session2, Collection<? extends Metadata> metadatas) {
        this.timestamp = (Date)ConfigUtils.getObject(session2, (Object)new Date(), "maven.startTime");
        Iterator<? extends Metadata> it2 = metadatas.iterator();
        while (it2.hasNext()) {
            Metadata metadata = it2.next();
            if (!(metadata instanceof VersionsMetadata)) continue;
            it2.remove();
            VersionsMetadata versionsMetadata = (VersionsMetadata)metadata;
            this.processedVersions.put(versionsMetadata.getKey(), versionsMetadata);
        }
    }

    @Override
    public Collection<? extends Metadata> prepare(Collection<? extends Artifact> artifacts) {
        return Collections.emptyList();
    }

    @Override
    public Artifact transformArtifact(Artifact artifact) {
        return artifact;
    }

    @Override
    public Collection<? extends Metadata> finish(Collection<? extends Artifact> artifacts) {
        for (Artifact artifact : artifacts) {
            VersionsMetadata versionsMetadata;
            Object key2 = VersionsMetadata.getKey(artifact);
            if (this.processedVersions.get(key2) != null || (versionsMetadata = this.versions.get(key2)) != null) continue;
            versionsMetadata = new VersionsMetadata(artifact, this.timestamp);
            this.versions.put(key2, versionsMetadata);
        }
        return this.versions.values();
    }
}

