/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.merge;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.maven.model.Activation;
import org.apache.maven.model.Build;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.CiManagement;
import org.apache.maven.model.ConfigurationContainer;
import org.apache.maven.model.Contributor;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.DeploymentRepository;
import org.apache.maven.model.Developer;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Extension;
import org.apache.maven.model.FileSet;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.IssueManagement;
import org.apache.maven.model.License;
import org.apache.maven.model.MailingList;
import org.apache.maven.model.Model;
import org.apache.maven.model.ModelBase;
import org.apache.maven.model.Notifier;
import org.apache.maven.model.Organization;
import org.apache.maven.model.Parent;
import org.apache.maven.model.PatternSet;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginConfiguration;
import org.apache.maven.model.PluginContainer;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.Prerequisites;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Relocation;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.ReportSet;
import org.apache.maven.model.Reporting;
import org.apache.maven.model.Repository;
import org.apache.maven.model.RepositoryBase;
import org.apache.maven.model.RepositoryPolicy;
import org.apache.maven.model.Resource;
import org.apache.maven.model.Scm;
import org.apache.maven.model.Site;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class ModelMerger {
    public void merge(Model target2, Model source, boolean sourceDominant, Map<?, ?> hints) {
        Objects.requireNonNull(target2, "target cannot be null");
        if (source == null) {
            return;
        }
        HashMap<Object, Object> context = new HashMap<Object, Object>();
        if (hints != null) {
            context.putAll(hints);
        }
        this.mergeModel(target2, source, sourceDominant, context);
    }

    protected void mergeModel(Model target2, Model source, boolean sourceDominant, Map<Object, Object> context) {
        this.mergeModelBase(target2, source, sourceDominant, context);
        this.mergeModel_ChildProjectUrlInheritAppendPath(target2, source, sourceDominant, context);
        this.mergeModel_ModelVersion(target2, source, sourceDominant, context);
        this.mergeModel_Parent(target2, source, sourceDominant, context);
        this.mergeModel_GroupId(target2, source, sourceDominant, context);
        this.mergeModel_ArtifactId(target2, source, sourceDominant, context);
        this.mergeModel_Version(target2, source, sourceDominant, context);
        this.mergeModel_Packaging(target2, source, sourceDominant, context);
        this.mergeModel_Name(target2, source, sourceDominant, context);
        this.mergeModel_Description(target2, source, sourceDominant, context);
        this.mergeModel_Url(target2, source, sourceDominant, context);
        this.mergeModel_InceptionYear(target2, source, sourceDominant, context);
        this.mergeModel_Organization(target2, source, sourceDominant, context);
        this.mergeModel_Licenses(target2, source, sourceDominant, context);
        this.mergeModel_MailingLists(target2, source, sourceDominant, context);
        this.mergeModel_Developers(target2, source, sourceDominant, context);
        this.mergeModel_Contributors(target2, source, sourceDominant, context);
        this.mergeModel_IssueManagement(target2, source, sourceDominant, context);
        this.mergeModel_Scm(target2, source, sourceDominant, context);
        this.mergeModel_CiManagement(target2, source, sourceDominant, context);
        this.mergeModel_Prerequisites(target2, source, sourceDominant, context);
        this.mergeModel_Build(target2, source, sourceDominant, context);
        this.mergeModel_Profiles(target2, source, sourceDominant, context);
    }

    protected void mergeModel_ModelVersion(Model target2, Model source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getModelVersion();
        if (src2 != null && (sourceDominant || target2.getModelVersion() == null)) {
            target2.setModelVersion(src2);
            target2.setLocation("modelVersion", source.getLocation("modelVersion"));
        }
    }

    protected void mergeModel_Parent(Model target2, Model source, boolean sourceDominant, Map<Object, Object> context) {
        Parent src2 = source.getParent();
        if (src2 != null) {
            Parent tgt = target2.getParent();
            if (tgt == null) {
                tgt = new Parent();
                tgt.setRelativePath(null);
                target2.setParent(tgt);
            }
            this.mergeParent(tgt, src2, sourceDominant, context);
        }
    }

    protected void mergeModel_GroupId(Model target2, Model source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getGroupId();
        if (src2 != null && (sourceDominant || target2.getGroupId() == null)) {
            target2.setGroupId(src2);
            target2.setLocation("groupId", source.getLocation("groupId"));
        }
    }

    protected void mergeModel_ArtifactId(Model target2, Model source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getArtifactId();
        if (src2 != null && (sourceDominant || target2.getArtifactId() == null)) {
            target2.setArtifactId(src2);
            target2.setLocation("artifactId", source.getLocation("artifactId"));
        }
    }

    protected void mergeModel_ChildProjectUrlInheritAppendPath(Model target2, Model source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getChildProjectUrlInheritAppendPath();
        if (src2 != null && (sourceDominant || target2.getChildProjectUrlInheritAppendPath() == null)) {
            target2.setChildProjectUrlInheritAppendPath(src2);
            target2.setLocation("child.project.url.inherit.append.path", source.getLocation("child.project.url.inherit.append.path"));
        }
    }

    protected void mergeModel_Version(Model target2, Model source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getVersion();
        if (src2 != null && (sourceDominant || target2.getVersion() == null)) {
            target2.setVersion(src2);
            target2.setLocation("version", source.getLocation("version"));
        }
    }

    protected void mergeModel_Packaging(Model target2, Model source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getPackaging();
        if (src2 != null && (sourceDominant || target2.getPackaging() == null)) {
            target2.setPackaging(src2);
            target2.setLocation("packaging", source.getLocation("packaging"));
        }
    }

    protected void mergeModel_Name(Model target2, Model source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getName();
        if (src2 != null && (sourceDominant || target2.getName() == null)) {
            target2.setName(src2);
            target2.setLocation("name", source.getLocation("name"));
        }
    }

    protected void mergeModel_Description(Model target2, Model source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getDescription();
        if (src2 != null && (sourceDominant || target2.getDescription() == null)) {
            target2.setDescription(src2);
            target2.setLocation("description", source.getLocation("description"));
        }
    }

    protected void mergeModel_Url(Model target2, Model source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getUrl();
        if (src2 != null && (sourceDominant || target2.getUrl() == null)) {
            target2.setUrl(src2);
            target2.setLocation("url", source.getLocation("url"));
        }
    }

    protected void mergeModel_InceptionYear(Model target2, Model source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getInceptionYear();
        if (src2 != null && (sourceDominant || target2.getInceptionYear() == null)) {
            target2.setInceptionYear(src2);
            target2.setLocation("inceptionYear", source.getLocation("inceptionYear"));
        }
    }

    protected void mergeModel_Organization(Model target2, Model source, boolean sourceDominant, Map<Object, Object> context) {
        Organization src2 = source.getOrganization();
        if (src2 != null) {
            Organization tgt = target2.getOrganization();
            if (tgt == null) {
                tgt = new Organization();
                target2.setOrganization(tgt);
            }
            this.mergeOrganization(tgt, src2, sourceDominant, context);
        }
    }

    protected void mergeModel_Licenses(Model target2, Model source, boolean sourceDominant, Map<Object, Object> context) {
        target2.setLicenses(ModelMerger.merge(target2.getLicenses(), source.getLicenses(), sourceDominant, new LicenseKeyComputer()));
    }

    protected void mergeModel_MailingLists(Model target2, Model source, boolean sourceDominant, Map<Object, Object> context) {
        target2.setMailingLists(ModelMerger.merge(target2.getMailingLists(), source.getMailingLists(), sourceDominant, new MailingListKeyComputer()));
    }

    protected void mergeModel_Developers(Model target2, Model source, boolean sourceDominant, Map<Object, Object> context) {
        target2.setDevelopers(ModelMerger.merge(target2.getDevelopers(), source.getDevelopers(), sourceDominant, new DeveloperKeyComputer()));
    }

    protected void mergeModel_Contributors(Model target2, Model source, boolean sourceDominant, Map<Object, Object> context) {
        target2.setContributors(ModelMerger.merge(target2.getContributors(), source.getContributors(), sourceDominant, new ContributorKeyComputer()));
    }

    protected void mergeModel_IssueManagement(Model target2, Model source, boolean sourceDominant, Map<Object, Object> context) {
        IssueManagement src2 = source.getIssueManagement();
        if (src2 != null) {
            IssueManagement tgt = target2.getIssueManagement();
            if (tgt == null) {
                tgt = new IssueManagement();
                target2.setIssueManagement(tgt);
            }
            this.mergeIssueManagement(tgt, src2, sourceDominant, context);
        }
    }

    protected void mergeModel_Scm(Model target2, Model source, boolean sourceDominant, Map<Object, Object> context) {
        Scm src2 = source.getScm();
        if (src2 != null) {
            Scm tgt = target2.getScm();
            if (tgt == null) {
                tgt = new Scm();
                tgt.setTag(null);
                target2.setScm(tgt);
            }
            this.mergeScm(tgt, src2, sourceDominant, context);
        }
    }

    protected void mergeModel_CiManagement(Model target2, Model source, boolean sourceDominant, Map<Object, Object> context) {
        CiManagement src2 = source.getCiManagement();
        if (src2 != null) {
            CiManagement tgt = target2.getCiManagement();
            if (tgt == null) {
                tgt = new CiManagement();
                target2.setCiManagement(tgt);
            }
            this.mergeCiManagement(tgt, src2, sourceDominant, context);
        }
    }

    protected void mergeModel_Prerequisites(Model target2, Model source, boolean sourceDominant, Map<Object, Object> context) {
        Prerequisites src2 = source.getPrerequisites();
        if (src2 != null) {
            Prerequisites tgt = target2.getPrerequisites();
            if (tgt == null) {
                tgt = new Prerequisites();
                tgt.setMaven(null);
                target2.setPrerequisites(tgt);
            }
            this.mergePrerequisites(tgt, src2, sourceDominant, context);
        }
    }

    protected void mergeModel_Build(Model target2, Model source, boolean sourceDominant, Map<Object, Object> context) {
        Build src2 = source.getBuild();
        if (src2 != null) {
            Build tgt = target2.getBuild();
            if (tgt == null) {
                tgt = new Build();
                target2.setBuild(tgt);
            }
            this.mergeBuild(tgt, src2, sourceDominant, context);
        }
    }

    protected void mergeModel_Profiles(Model target2, Model source, boolean sourceDominant, Map<Object, Object> context) {
        target2.setProfiles(ModelMerger.merge(target2.getProfiles(), source.getProfiles(), sourceDominant, new ProfileKeyComputer()));
    }

    protected void mergeModelBase(ModelBase target2, ModelBase source, boolean sourceDominant, Map<Object, Object> context) {
        this.mergeModelBase_DistributionManagement(target2, source, sourceDominant, context);
        this.mergeModelBase_Modules(target2, source, sourceDominant, context);
        this.mergeModelBase_Repositories(target2, source, sourceDominant, context);
        this.mergeModelBase_PluginRepositories(target2, source, sourceDominant, context);
        this.mergeModelBase_Dependencies(target2, source, sourceDominant, context);
        this.mergeModelBase_Reporting(target2, source, sourceDominant, context);
        this.mergeModelBase_DependencyManagement(target2, source, sourceDominant, context);
        this.mergeModelBase_Properties(target2, source, sourceDominant, context);
    }

    protected void mergeModelBase_Modules(ModelBase target2, ModelBase source, boolean sourceDominant, Map<Object, Object> context) {
        List<String> src2 = source.getModules();
        if (!src2.isEmpty()) {
            List<String> tgt = target2.getModules();
            ArrayList<String> merged = new ArrayList<String>(tgt.size() + src2.size());
            merged.addAll(tgt);
            merged.addAll(src2);
            target2.setModules(merged);
        }
    }

    protected void mergeModelBase_Dependencies(ModelBase target2, ModelBase source, boolean sourceDominant, Map<Object, Object> context) {
        target2.setDependencies(ModelMerger.merge(target2.getDependencies(), source.getDependencies(), sourceDominant, new DependencyKeyComputer()));
    }

    protected void mergeModelBase_Repositories(ModelBase target2, ModelBase source, boolean sourceDominant, Map<Object, Object> context) {
        target2.setRepositories(ModelMerger.merge(target2.getRepositories(), source.getRepositories(), sourceDominant, new RepositoryKeyComputer()));
    }

    protected void mergeModelBase_PluginRepositories(ModelBase target2, ModelBase source, boolean sourceDominant, Map<Object, Object> context) {
        target2.setPluginRepositories(ModelMerger.merge(target2.getPluginRepositories(), source.getPluginRepositories(), sourceDominant, new RepositoryKeyComputer()));
    }

    protected void mergeModelBase_DistributionManagement(ModelBase target2, ModelBase source, boolean sourceDominant, Map<Object, Object> context) {
        DistributionManagement src2 = source.getDistributionManagement();
        if (src2 != null) {
            DistributionManagement tgt = target2.getDistributionManagement();
            if (tgt == null) {
                tgt = new DistributionManagement();
                target2.setDistributionManagement(tgt);
            }
            this.mergeDistributionManagement(tgt, src2, sourceDominant, context);
        }
    }

    protected void mergeModelBase_Reporting(ModelBase target2, ModelBase source, boolean sourceDominant, Map<Object, Object> context) {
        Reporting src2 = source.getReporting();
        if (src2 != null) {
            Reporting tgt = target2.getReporting();
            if (tgt == null) {
                tgt = new Reporting();
                target2.setReporting(tgt);
            }
            this.mergeReporting(tgt, src2, sourceDominant, context);
        }
    }

    protected void mergeModelBase_DependencyManagement(ModelBase target2, ModelBase source, boolean sourceDominant, Map<Object, Object> context) {
        DependencyManagement src2 = source.getDependencyManagement();
        if (src2 != null) {
            DependencyManagement tgt = target2.getDependencyManagement();
            if (tgt == null) {
                tgt = new DependencyManagement();
                target2.setDependencyManagement(tgt);
            }
            this.mergeDependencyManagement(tgt, src2, sourceDominant, context);
        }
    }

    protected void mergeModelBase_Properties(ModelBase target2, ModelBase source, boolean sourceDominant, Map<Object, Object> context) {
        Properties merged = new Properties();
        if (sourceDominant) {
            merged.putAll((Map<?, ?>)target2.getProperties());
            merged.putAll((Map<?, ?>)source.getProperties());
        } else {
            merged.putAll((Map<?, ?>)source.getProperties());
            merged.putAll((Map<?, ?>)target2.getProperties());
        }
        target2.setProperties(merged);
        target2.setLocation("properties", InputLocation.merge(target2.getLocation("properties"), source.getLocation("properties"), sourceDominant));
    }

    protected void mergeDistributionManagement(DistributionManagement target2, DistributionManagement source, boolean sourceDominant, Map<Object, Object> context) {
        this.mergeDistributionManagement_Repository(target2, source, sourceDominant, context);
        this.mergeDistributionManagement_SnapshotRepository(target2, source, sourceDominant, context);
        this.mergeDistributionManagement_Site(target2, source, sourceDominant, context);
        this.mergeDistributionManagement_Status(target2, source, sourceDominant, context);
        this.mergeDistributionManagement_DownloadUrl(target2, source, sourceDominant, context);
    }

    protected void mergeDistributionManagement_Repository(DistributionManagement target2, DistributionManagement source, boolean sourceDominant, Map<Object, Object> context) {
        DeploymentRepository src2 = source.getRepository();
        if (src2 != null) {
            DeploymentRepository tgt = target2.getRepository();
            if (tgt == null) {
                tgt = new DeploymentRepository();
                target2.setRepository(tgt);
            }
            this.mergeDeploymentRepository(tgt, src2, sourceDominant, context);
        }
    }

    protected void mergeDistributionManagement_SnapshotRepository(DistributionManagement target2, DistributionManagement source, boolean sourceDominant, Map<Object, Object> context) {
        DeploymentRepository src2 = source.getSnapshotRepository();
        if (src2 != null) {
            DeploymentRepository tgt = target2.getSnapshotRepository();
            if (tgt == null) {
                tgt = new DeploymentRepository();
                target2.setSnapshotRepository(tgt);
            }
            this.mergeDeploymentRepository(tgt, src2, sourceDominant, context);
        }
    }

    protected void mergeDistributionManagement_Site(DistributionManagement target2, DistributionManagement source, boolean sourceDominant, Map<Object, Object> context) {
        Site src2 = source.getSite();
        if (src2 != null) {
            Site tgt = target2.getSite();
            if (tgt == null) {
                tgt = new Site();
                target2.setSite(tgt);
            }
            this.mergeSite(tgt, src2, sourceDominant, context);
        }
    }

    protected void mergeDistributionManagement_Status(DistributionManagement target2, DistributionManagement source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getStatus();
        if (src2 != null && (sourceDominant || target2.getStatus() == null)) {
            target2.setStatus(src2);
            target2.setLocation("status", source.getLocation("status"));
        }
    }

    protected void mergeDistributionManagement_DownloadUrl(DistributionManagement target2, DistributionManagement source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getDownloadUrl();
        if (src2 != null && (sourceDominant || target2.getDownloadUrl() == null)) {
            target2.setDownloadUrl(src2);
            target2.setLocation("downloadUrl", source.getLocation("downloadUrl"));
        }
    }

    protected void mergeRelocation(Relocation target2, Relocation source, boolean sourceDominant, Map<Object, Object> context) {
        this.mergeRelocation_GroupId(target2, source, sourceDominant, context);
        this.mergeRelocation_ArtifactId(target2, source, sourceDominant, context);
        this.mergeRelocation_Version(target2, source, sourceDominant, context);
        this.mergeRelocation_Message(target2, source, sourceDominant, context);
    }

    protected void mergeRelocation_GroupId(Relocation target2, Relocation source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getGroupId();
        if (src2 != null && (sourceDominant || target2.getGroupId() == null)) {
            target2.setGroupId(src2);
            target2.setLocation("groupId", source.getLocation("groupId"));
        }
    }

    protected void mergeRelocation_ArtifactId(Relocation target2, Relocation source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getArtifactId();
        if (src2 != null && (sourceDominant || target2.getArtifactId() == null)) {
            target2.setArtifactId(src2);
            target2.setLocation("artifactId", source.getLocation("artifactId"));
        }
    }

    protected void mergeRelocation_Version(Relocation target2, Relocation source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getVersion();
        if (src2 != null && (sourceDominant || target2.getVersion() == null)) {
            target2.setVersion(src2);
            target2.setLocation("version", source.getLocation("version"));
        }
    }

    protected void mergeRelocation_Message(Relocation target2, Relocation source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getMessage();
        if (src2 != null && (sourceDominant || target2.getMessage() == null)) {
            target2.setMessage(src2);
            target2.setLocation("message", source.getLocation("message"));
        }
    }

    protected void mergeDeploymentRepository(DeploymentRepository target2, DeploymentRepository source, boolean sourceDominant, Map<Object, Object> context) {
        this.mergeRepository(target2, source, sourceDominant, context);
        this.mergeDeploymentRepository_UniqueVersion(target2, source, sourceDominant, context);
    }

    protected void mergeDeploymentRepository_UniqueVersion(DeploymentRepository target2, DeploymentRepository source, boolean sourceDominant, Map<Object, Object> context) {
        if (sourceDominant) {
            target2.setUniqueVersion(source.isUniqueVersion());
            target2.setLocation("uniqueVersion", source.getLocation("uniqueVersion"));
        }
    }

    protected void mergeSite(Site target2, Site source, boolean sourceDominant, Map<Object, Object> context) {
        this.mergeSite_ChildSiteUrlInheritAppendPath(target2, source, sourceDominant, context);
        this.mergeSite_Id(target2, source, sourceDominant, context);
        this.mergeSite_Name(target2, source, sourceDominant, context);
        this.mergeSite_Url(target2, source, sourceDominant, context);
    }

    protected void mergeSite_ChildSiteUrlInheritAppendPath(Site target2, Site source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getChildSiteUrlInheritAppendPath();
        if (src2 != null && (sourceDominant || target2.getChildSiteUrlInheritAppendPath() == null)) {
            target2.setChildSiteUrlInheritAppendPath(src2);
            target2.setLocation("child.site.url.inherit.append.path", source.getLocation("child.site.url.inherit.append.path"));
        }
    }

    protected void mergeSite_Id(Site target2, Site source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getId();
        if (src2 != null && (sourceDominant || target2.getId() == null)) {
            target2.setId(src2);
            target2.setLocation("id", source.getLocation("id"));
        }
    }

    protected void mergeSite_Name(Site target2, Site source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getName();
        if (src2 != null && (sourceDominant || target2.getName() == null)) {
            target2.setName(src2);
            target2.setLocation("name", source.getLocation("name"));
        }
    }

    protected void mergeSite_Url(Site target2, Site source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getUrl();
        if (src2 != null && (sourceDominant || target2.getUrl() == null)) {
            target2.setUrl(src2);
            target2.setLocation("url", source.getLocation("url"));
        }
    }

    protected void mergeRepository(Repository target2, Repository source, boolean sourceDominant, Map<Object, Object> context) {
        this.mergeRepositoryBase(target2, source, sourceDominant, context);
        this.mergeRepository_Releases(target2, source, sourceDominant, context);
        this.mergeRepository_Snapshots(target2, source, sourceDominant, context);
    }

    protected void mergeRepository_Releases(Repository target2, Repository source, boolean sourceDominant, Map<Object, Object> context) {
        RepositoryPolicy src2 = source.getReleases();
        if (src2 != null) {
            RepositoryPolicy tgt = target2.getReleases();
            if (tgt == null) {
                tgt = new RepositoryPolicy();
                target2.setReleases(tgt);
            }
            this.mergeRepositoryPolicy(tgt, src2, sourceDominant, context);
        }
    }

    protected void mergeRepository_Snapshots(Repository target2, Repository source, boolean sourceDominant, Map<Object, Object> context) {
        RepositoryPolicy src2 = source.getSnapshots();
        if (src2 != null) {
            RepositoryPolicy tgt = target2.getSnapshots();
            if (tgt == null) {
                tgt = new RepositoryPolicy();
                target2.setSnapshots(tgt);
            }
            this.mergeRepositoryPolicy(tgt, src2, sourceDominant, context);
        }
    }

    protected void mergeRepositoryBase(RepositoryBase target2, RepositoryBase source, boolean sourceDominant, Map<Object, Object> context) {
        this.mergeRepositoryBase_Id(target2, source, sourceDominant, context);
        this.mergeRepositoryBase_Name(target2, source, sourceDominant, context);
        this.mergeRepositoryBase_Url(target2, source, sourceDominant, context);
        this.mergeRepositoryBase_Layout(target2, source, sourceDominant, context);
    }

    protected void mergeRepositoryBase_Id(RepositoryBase target2, RepositoryBase source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getId();
        if (src2 != null && (sourceDominant || target2.getId() == null)) {
            target2.setId(src2);
            target2.setLocation("id", source.getLocation("id"));
        }
    }

    protected void mergeRepositoryBase_Url(RepositoryBase target2, RepositoryBase source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getUrl();
        if (src2 != null && (sourceDominant || target2.getUrl() == null)) {
            target2.setUrl(src2);
            target2.setLocation("url", source.getLocation("url"));
        }
    }

    protected void mergeRepositoryBase_Name(RepositoryBase target2, RepositoryBase source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getName();
        if (src2 != null && (sourceDominant || target2.getName() == null)) {
            target2.setName(src2);
            target2.setLocation("name", source.getLocation("name"));
        }
    }

    protected void mergeRepositoryBase_Layout(RepositoryBase target2, RepositoryBase source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getLayout();
        if (src2 != null && (sourceDominant || target2.getLayout() == null)) {
            target2.setLayout(src2);
            target2.setLocation("layout", source.getLocation("layout"));
        }
    }

    protected void mergeRepositoryPolicy(RepositoryPolicy target2, RepositoryPolicy source, boolean sourceDominant, Map<Object, Object> context) {
        this.mergeRepositoryPolicy_Enabled(target2, source, sourceDominant, context);
        this.mergeRepositoryPolicy_UpdatePolicy(target2, source, sourceDominant, context);
        this.mergeRepositoryPolicy_ChecksumPolicy(target2, source, sourceDominant, context);
    }

    protected void mergeRepositoryPolicy_Enabled(RepositoryPolicy target2, RepositoryPolicy source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getEnabled();
        if (src2 != null && (sourceDominant || target2.getEnabled() == null)) {
            target2.setEnabled(src2);
            target2.setLocation("enabled", source.getLocation("enabled"));
        }
    }

    protected void mergeRepositoryPolicy_UpdatePolicy(RepositoryPolicy target2, RepositoryPolicy source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getUpdatePolicy();
        if (src2 != null && (sourceDominant || target2.getUpdatePolicy() == null)) {
            target2.setUpdatePolicy(src2);
            target2.setLocation("updatePolicy", source.getLocation("updatePolicy"));
        }
    }

    protected void mergeRepositoryPolicy_ChecksumPolicy(RepositoryPolicy target2, RepositoryPolicy source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getChecksumPolicy();
        if (src2 != null && (sourceDominant || target2.getChecksumPolicy() == null)) {
            target2.setChecksumPolicy(src2);
            target2.setLocation("checksumPolicy", source.getLocation("checksumPolicy"));
        }
    }

    protected void mergeDependency(Dependency target2, Dependency source, boolean sourceDominant, Map<Object, Object> context) {
        this.mergeDependency_GroupId(target2, source, sourceDominant, context);
        this.mergeDependency_ArtifactId(target2, source, sourceDominant, context);
        this.mergeDependency_Version(target2, source, sourceDominant, context);
        this.mergeDependency_Type(target2, source, sourceDominant, context);
        this.mergeDependency_Classifier(target2, source, sourceDominant, context);
        this.mergeDependency_Scope(target2, source, sourceDominant, context);
        this.mergeDependency_SystemPath(target2, source, sourceDominant, context);
        this.mergeDependency_Optional(target2, source, sourceDominant, context);
        this.mergeDependency_Exclusions(target2, source, sourceDominant, context);
    }

    protected void mergeDependency_GroupId(Dependency target2, Dependency source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getGroupId();
        if (src2 != null && (sourceDominant || target2.getGroupId() == null)) {
            target2.setGroupId(src2);
            target2.setLocation("groupId", source.getLocation("groupId"));
        }
    }

    protected void mergeDependency_ArtifactId(Dependency target2, Dependency source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getArtifactId();
        if (src2 != null && (sourceDominant || target2.getArtifactId() == null)) {
            target2.setArtifactId(src2);
            target2.setLocation("artifactId", source.getLocation("artifactId"));
        }
    }

    protected void mergeDependency_Version(Dependency target2, Dependency source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getVersion();
        if (src2 != null && (sourceDominant || target2.getVersion() == null)) {
            target2.setVersion(src2);
            target2.setLocation("version", source.getLocation("version"));
        }
    }

    protected void mergeDependency_Type(Dependency target2, Dependency source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getType();
        if (src2 != null && (sourceDominant || target2.getType() == null)) {
            target2.setType(src2);
            target2.setLocation("type", source.getLocation("type"));
        }
    }

    protected void mergeDependency_Classifier(Dependency target2, Dependency source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getClassifier();
        if (src2 != null && (sourceDominant || target2.getClassifier() == null)) {
            target2.setClassifier(src2);
            target2.setLocation("classifier", source.getLocation("classifier"));
        }
    }

    protected void mergeDependency_Scope(Dependency target2, Dependency source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getScope();
        if (src2 != null && (sourceDominant || target2.getScope() == null)) {
            target2.setScope(src2);
            target2.setLocation("scope", source.getLocation("scope"));
        }
    }

    protected void mergeDependency_SystemPath(Dependency target2, Dependency source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getSystemPath();
        if (src2 != null && (sourceDominant || target2.getSystemPath() == null)) {
            target2.setSystemPath(src2);
            target2.setLocation("systemPath", source.getLocation("systemPath"));
        }
    }

    protected void mergeDependency_Optional(Dependency target2, Dependency source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getOptional();
        if (src2 != null && (sourceDominant || target2.getOptional() == null)) {
            target2.setOptional(src2);
            target2.setLocation("optional", source.getLocation("optional"));
        }
    }

    protected void mergeDependency_Exclusions(Dependency target2, Dependency source, boolean sourceDominant, Map<Object, Object> context) {
        target2.setExclusions(ModelMerger.merge(target2.getExclusions(), source.getExclusions(), sourceDominant, new ExclusionKeyComputer()));
    }

    protected void mergeExclusion(Exclusion target2, Exclusion source, boolean sourceDominant, Map<Object, Object> context) {
        this.mergeExclusion_GroupId(target2, source, sourceDominant, context);
        this.mergeExclusion_ArtifactId(target2, source, sourceDominant, context);
    }

    protected void mergeExclusion_GroupId(Exclusion target2, Exclusion source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getGroupId();
        if (src2 != null && (sourceDominant || target2.getGroupId() == null)) {
            target2.setGroupId(src2);
            target2.setLocation("groupId", source.getLocation("groupId"));
        }
    }

    protected void mergeExclusion_ArtifactId(Exclusion target2, Exclusion source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getArtifactId();
        if (src2 != null && (sourceDominant || target2.getArtifactId() == null)) {
            target2.setArtifactId(src2);
            target2.setLocation("artifactId", source.getLocation("artifactId"));
        }
    }

    protected void mergeReporting(Reporting target2, Reporting source, boolean sourceDominant, Map<Object, Object> context) {
        this.mergeReporting_OutputDirectory(target2, source, sourceDominant, context);
        this.mergeReporting_ExcludeDefaults(target2, source, sourceDominant, context);
        this.mergeReporting_Plugins(target2, source, sourceDominant, context);
    }

    protected void mergeReporting_OutputDirectory(Reporting target2, Reporting source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getOutputDirectory();
        if (src2 != null && (sourceDominant || target2.getOutputDirectory() == null)) {
            target2.setOutputDirectory(src2);
            target2.setLocation("outputDirectory", source.getLocation("outputDirectory"));
        }
    }

    protected void mergeReporting_ExcludeDefaults(Reporting target2, Reporting source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getExcludeDefaults();
        if (src2 != null && (sourceDominant || target2.getExcludeDefaults() == null)) {
            target2.setExcludeDefaults(src2);
            target2.setLocation("excludeDefaults", source.getLocation("excludeDefaults"));
        }
    }

    protected void mergeReporting_Plugins(Reporting target2, Reporting source, boolean sourceDominant, Map<Object, Object> context) {
        target2.setPlugins(ModelMerger.merge(target2.getPlugins(), source.getPlugins(), sourceDominant, new ReportPluginKeyComputer()));
    }

    protected void mergeReportPlugin(ReportPlugin target2, ReportPlugin source, boolean sourceDominant, Map<Object, Object> context) {
        this.mergeConfigurationContainer(target2, source, sourceDominant, context);
        this.mergeReportPlugin_GroupId(target2, source, sourceDominant, context);
        this.mergeReportPlugin_ArtifactId(target2, source, sourceDominant, context);
        this.mergeReportPlugin_Version(target2, source, sourceDominant, context);
        this.mergeReportPlugin_ReportSets(target2, source, sourceDominant, context);
    }

    protected void mergeReportPlugin_GroupId(ReportPlugin target2, ReportPlugin source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getGroupId();
        if (src2 != null && (sourceDominant || target2.getGroupId() == null)) {
            target2.setGroupId(src2);
            target2.setLocation("groupId", source.getLocation("groupId"));
        }
    }

    protected void mergeReportPlugin_ArtifactId(ReportPlugin target2, ReportPlugin source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getArtifactId();
        if (src2 != null && (sourceDominant || target2.getArtifactId() == null)) {
            target2.setArtifactId(src2);
            target2.setLocation("artifactId", source.getLocation("artifactId"));
        }
    }

    protected void mergeReportPlugin_Version(ReportPlugin target2, ReportPlugin source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getVersion();
        if (src2 != null && (sourceDominant || target2.getVersion() == null)) {
            target2.setVersion(src2);
            target2.setLocation("version", source.getLocation("version"));
        }
    }

    protected void mergeReportPlugin_ReportSets(ReportPlugin target2, ReportPlugin source, boolean sourceDominant, Map<Object, Object> context) {
        target2.setReportSets(ModelMerger.merge(target2.getReportSets(), source.getReportSets(), sourceDominant, new ReportSetKeyComputer()));
    }

    protected void mergeReportSet(ReportSet target2, ReportSet source, boolean sourceDominant, Map<Object, Object> context) {
        this.mergeConfigurationContainer(target2, source, sourceDominant, context);
        this.mergeReportSet_Id(target2, source, sourceDominant, context);
        this.mergeReportSet_Reports(target2, source, sourceDominant, context);
    }

    protected void mergeReportSet_Id(ReportSet target2, ReportSet source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getId();
        if (src2 != null && (sourceDominant || target2.getId() == null)) {
            target2.setId(src2);
            target2.setLocation("id", source.getLocation("id"));
        }
    }

    protected void mergeReportSet_Reports(ReportSet target2, ReportSet source, boolean sourceDominant, Map<Object, Object> context) {
        List<String> src2 = source.getReports();
        if (!src2.isEmpty()) {
            List<String> tgt = target2.getReports();
            ArrayList<String> merged = new ArrayList<String>(tgt.size() + src2.size());
            merged.addAll(tgt);
            merged.addAll(src2);
            target2.setReports(merged);
            InputLocation sourceLocation = source.getLocation("reports");
            if (sourceLocation != null) {
                InputLocation targetLocation = target2.getLocation("reports");
                if (targetLocation == null) {
                    target2.setLocation("reports", sourceLocation);
                } else {
                    for (int i2 = 0; i2 < src2.size(); ++i2) {
                        targetLocation.setLocation(tgt.size() + i2, sourceLocation.getLocation(i2));
                    }
                }
            }
        }
    }

    protected void mergeDependencyManagement(DependencyManagement target2, DependencyManagement source, boolean sourceDominant, Map<Object, Object> context) {
        this.mergeDependencyManagement_Dependencies(target2, source, sourceDominant, context);
    }

    protected void mergeDependencyManagement_Dependencies(DependencyManagement target2, DependencyManagement source, boolean sourceDominant, Map<Object, Object> context) {
        target2.setDependencies(ModelMerger.merge(target2.getDependencies(), source.getDependencies(), sourceDominant, new DependencyKeyComputer()));
    }

    protected void mergeParent(Parent target2, Parent source, boolean sourceDominant, Map<Object, Object> context) {
        this.mergeParent_GroupId(target2, source, sourceDominant, context);
        this.mergeParent_ArtifactId(target2, source, sourceDominant, context);
        this.mergeParent_Version(target2, source, sourceDominant, context);
        this.mergeParent_RelativePath(target2, source, sourceDominant, context);
    }

    protected void mergeParent_GroupId(Parent target2, Parent source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getGroupId();
        if (src2 != null && (sourceDominant || target2.getGroupId() == null)) {
            target2.setGroupId(src2);
            target2.setLocation("groupId", source.getLocation("groupId"));
        }
    }

    protected void mergeParent_ArtifactId(Parent target2, Parent source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getArtifactId();
        if (src2 != null && (sourceDominant || target2.getArtifactId() == null)) {
            target2.setArtifactId(src2);
            target2.setLocation("artifactId", source.getLocation("artifactId"));
        }
    }

    protected void mergeParent_Version(Parent target2, Parent source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getVersion();
        if (src2 != null && (sourceDominant || target2.getVersion() == null)) {
            target2.setVersion(src2);
            target2.setLocation("version", source.getLocation("version"));
        }
    }

    protected void mergeParent_RelativePath(Parent target2, Parent source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getRelativePath();
        if (src2 != null && (sourceDominant || target2.getRelativePath() == null)) {
            target2.setRelativePath(src2);
            target2.setLocation("relativePath", source.getLocation("relativePath"));
        }
    }

    protected void mergeOrganization(Organization target2, Organization source, boolean sourceDominant, Map<Object, Object> context) {
        this.mergeOrganization_Name(target2, source, sourceDominant, context);
        this.mergeOrganization_Url(target2, source, sourceDominant, context);
    }

    protected void mergeOrganization_Name(Organization target2, Organization source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getName();
        if (src2 != null && (sourceDominant || target2.getName() == null)) {
            target2.setName(src2);
            target2.setLocation("name", source.getLocation("name"));
        }
    }

    protected void mergeOrganization_Url(Organization target2, Organization source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getUrl();
        if (src2 != null && (sourceDominant || target2.getUrl() == null)) {
            target2.setUrl(src2);
            target2.setLocation("url", source.getLocation("url"));
        }
    }

    protected void mergeLicense(License target2, License source, boolean sourceDominant, Map<Object, Object> context) {
        this.mergeLicense_Name(target2, source, sourceDominant, context);
        this.mergeLicense_Url(target2, source, sourceDominant, context);
        this.mergeLicense_Distribution(target2, source, sourceDominant, context);
        this.mergeLicense_Comments(target2, source, sourceDominant, context);
    }

    protected void mergeLicense_Name(License target2, License source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getName();
        if (src2 != null && (sourceDominant || target2.getName() == null)) {
            target2.setName(src2);
            target2.setLocation("name", source.getLocation("name"));
        }
    }

    protected void mergeLicense_Url(License target2, License source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getUrl();
        if (src2 != null && (sourceDominant || target2.getUrl() == null)) {
            target2.setUrl(src2);
            target2.setLocation("url", source.getLocation("url"));
        }
    }

    protected void mergeLicense_Distribution(License target2, License source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getDistribution();
        if (src2 != null && (sourceDominant || target2.getDistribution() == null)) {
            target2.setDistribution(src2);
            target2.setLocation("distribution", source.getLocation("distribution"));
        }
    }

    protected void mergeLicense_Comments(License target2, License source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getComments();
        if (src2 != null && (sourceDominant || target2.getComments() == null)) {
            target2.setComments(src2);
            target2.setLocation("comments", source.getLocation("comments"));
        }
    }

    protected void mergeMailingList(MailingList target2, MailingList source, boolean sourceDominant, Map<Object, Object> context) {
        this.mergeMailingList_Name(target2, source, sourceDominant, context);
        this.mergeMailingList_Subscribe(target2, source, sourceDominant, context);
        this.mergeMailingList_Unsubscribe(target2, source, sourceDominant, context);
        this.mergeMailingList_Post(target2, source, sourceDominant, context);
        this.mergeMailingList_OtherArchives(target2, source, sourceDominant, context);
    }

    protected void mergeMailingList_Name(MailingList target2, MailingList source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getName();
        if (src2 != null && (sourceDominant || target2.getName() == null)) {
            target2.setName(src2);
            target2.setLocation("name", source.getLocation("name"));
        }
    }

    protected void mergeMailingList_Subscribe(MailingList target2, MailingList source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getSubscribe();
        if (src2 != null && (sourceDominant || target2.getSubscribe() == null)) {
            target2.setSubscribe(src2);
            target2.setLocation("subscribe", source.getLocation("subscribe"));
        }
    }

    protected void mergeMailingList_Unsubscribe(MailingList target2, MailingList source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getUnsubscribe();
        if (src2 != null && (sourceDominant || target2.getUnsubscribe() == null)) {
            target2.setUnsubscribe(src2);
            target2.setLocation("unsubscribe", source.getLocation("unsubscribe"));
        }
    }

    protected void mergeMailingList_Post(MailingList target2, MailingList source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getPost();
        if (src2 != null && (sourceDominant || target2.getPost() == null)) {
            target2.setPost(src2);
            target2.setLocation("post", source.getLocation("post"));
        }
    }

    protected void mergeMailingList_Archive(MailingList target2, MailingList source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getArchive();
        if (src2 != null && (sourceDominant || target2.getArchive() == null)) {
            target2.setArchive(src2);
            target2.setLocation("archive", source.getLocation("archive"));
        }
    }

    protected void mergeMailingList_OtherArchives(MailingList target2, MailingList source, boolean sourceDominant, Map<Object, Object> context) {
        List<String> src2 = source.getOtherArchives();
        if (!src2.isEmpty()) {
            List<String> tgt = target2.getOtherArchives();
            ArrayList<String> merged = new ArrayList<String>(tgt.size() + src2.size());
            merged.addAll(tgt);
            merged.addAll(src2);
            target2.setOtherArchives(merged);
        }
    }

    protected void mergeDeveloper(Developer target2, Developer source, boolean sourceDominant, Map<Object, Object> context) {
        this.mergeContributor(target2, source, sourceDominant, context);
        this.mergeDeveloper_Id(target2, source, sourceDominant, context);
    }

    protected void mergeDeveloper_Id(Developer target2, Developer source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getId();
        if (src2 != null && (sourceDominant || target2.getId() == null)) {
            target2.setId(src2);
            target2.setLocation("id", source.getLocation("id"));
        }
    }

    protected void mergeContributor(Contributor target2, Contributor source, boolean sourceDominant, Map<Object, Object> context) {
        this.mergeContributor_Name(target2, source, sourceDominant, context);
        this.mergeContributor_Email(target2, source, sourceDominant, context);
        this.mergeContributor_Url(target2, source, sourceDominant, context);
        this.mergeContributor_Organization(target2, source, sourceDominant, context);
        this.mergeContributor_OrganizationUrl(target2, source, sourceDominant, context);
        this.mergeContributor_Timezone(target2, source, sourceDominant, context);
        this.mergeContributor_Roles(target2, source, sourceDominant, context);
        this.mergeContributor_Properties(target2, source, sourceDominant, context);
    }

    protected void mergeContributor_Name(Contributor target2, Contributor source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getName();
        if (src2 != null && (sourceDominant || target2.getName() == null)) {
            target2.setName(src2);
            target2.setLocation("name", source.getLocation("name"));
        }
    }

    protected void mergeContributor_Email(Contributor target2, Contributor source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getEmail();
        if (src2 != null && (sourceDominant || target2.getEmail() == null)) {
            target2.setEmail(src2);
            target2.setLocation("email", source.getLocation("email"));
        }
    }

    protected void mergeContributor_Url(Contributor target2, Contributor source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getUrl();
        if (src2 != null && (sourceDominant || target2.getUrl() == null)) {
            target2.setUrl(src2);
            target2.setLocation("url", source.getLocation("url"));
        }
    }

    protected void mergeContributor_Organization(Contributor target2, Contributor source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getOrganization();
        if (src2 != null && (sourceDominant || target2.getOrganization() == null)) {
            target2.setOrganization(src2);
            target2.setLocation("organization", source.getLocation("organization"));
        }
    }

    protected void mergeContributor_OrganizationUrl(Contributor target2, Contributor source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getOrganizationUrl();
        if (src2 != null && (sourceDominant || target2.getOrganizationUrl() == null)) {
            target2.setOrganizationUrl(src2);
            target2.setLocation("organizationUrl", source.getLocation("organizationUrl"));
        }
    }

    protected void mergeContributor_Timezone(Contributor target2, Contributor source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getTimezone();
        if (src2 != null && (sourceDominant || target2.getTimezone() == null)) {
            target2.setTimezone(src2);
            target2.setLocation("timezone", source.getLocation("timezone"));
        }
    }

    protected void mergeContributor_Roles(Contributor target2, Contributor source, boolean sourceDominant, Map<Object, Object> context) {
        List<String> src2 = source.getRoles();
        if (!src2.isEmpty()) {
            List<String> tgt = target2.getRoles();
            ArrayList<String> merged = new ArrayList<String>(tgt.size() + src2.size());
            merged.addAll(tgt);
            merged.addAll(src2);
            target2.setRoles(merged);
        }
    }

    protected void mergeContributor_Properties(Contributor target2, Contributor source, boolean sourceDominant, Map<Object, Object> context) {
        Properties merged = new Properties();
        if (sourceDominant) {
            merged.putAll((Map<?, ?>)target2.getProperties());
            merged.putAll((Map<?, ?>)source.getProperties());
        } else {
            merged.putAll((Map<?, ?>)source.getProperties());
            merged.putAll((Map<?, ?>)target2.getProperties());
        }
        target2.setProperties(merged);
        target2.setLocation("properties", InputLocation.merge(target2.getLocation("properties"), source.getLocation("properties"), sourceDominant));
    }

    protected void mergeIssueManagement(IssueManagement target2, IssueManagement source, boolean sourceDominant, Map<Object, Object> context) {
        this.mergeIssueManagement_Url(target2, source, sourceDominant, context);
        this.mergeIssueManagement_System(target2, source, sourceDominant, context);
    }

    protected void mergeIssueManagement_System(IssueManagement target2, IssueManagement source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getSystem();
        if (src2 != null && (sourceDominant || target2.getSystem() == null)) {
            target2.setSystem(src2);
            target2.setLocation("system", source.getLocation("system"));
        }
    }

    protected void mergeIssueManagement_Url(IssueManagement target2, IssueManagement source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getUrl();
        if (src2 != null && (sourceDominant || target2.getUrl() == null)) {
            target2.setUrl(src2);
            target2.setLocation("url", source.getLocation("url"));
        }
    }

    protected void mergeScm(Scm target2, Scm source, boolean sourceDominant, Map<Object, Object> context) {
        this.mergeScm_ChildScmConnectionInheritAppendPath(target2, source, sourceDominant, context);
        this.mergeScm_ChildScmDeveloperConnectionInheritAppendPath(target2, source, sourceDominant, context);
        this.mergeScm_ChildScmUrlInheritAppendPath(target2, source, sourceDominant, context);
        this.mergeScm_Url(target2, source, sourceDominant, context);
        this.mergeScm_Connection(target2, source, sourceDominant, context);
        this.mergeScm_DeveloperConnection(target2, source, sourceDominant, context);
        this.mergeScm_Tag(target2, source, sourceDominant, context);
    }

    protected void mergeScm_ChildScmConnectionInheritAppendPath(Scm target2, Scm source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getChildScmConnectionInheritAppendPath();
        if (src2 != null && (sourceDominant || target2.getChildScmConnectionInheritAppendPath() == null)) {
            target2.setChildScmConnectionInheritAppendPath(src2);
            target2.setLocation("child.scm.connection.inherit.append.path", source.getLocation("child.scm.connection.inherit.append.path"));
        }
    }

    protected void mergeScm_ChildScmDeveloperConnectionInheritAppendPath(Scm target2, Scm source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getChildScmDeveloperConnectionInheritAppendPath();
        if (src2 != null && (sourceDominant || target2.getChildScmDeveloperConnectionInheritAppendPath() == null)) {
            target2.setChildScmDeveloperConnectionInheritAppendPath(src2);
            target2.setLocation("child.scm.developerConnection.inherit.append.path", source.getLocation("child.scm.developerConnection.inherit.append.path"));
        }
    }

    protected void mergeScm_ChildScmUrlInheritAppendPath(Scm target2, Scm source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getChildScmUrlInheritAppendPath();
        if (src2 != null && (sourceDominant || target2.getChildScmUrlInheritAppendPath() == null)) {
            target2.setChildScmUrlInheritAppendPath(src2);
            target2.setLocation("child.scm.url.inherit.append.path", source.getLocation("child.scm.url.inherit.append.path"));
        }
    }

    protected void mergeScm_Url(Scm target2, Scm source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getUrl();
        if (src2 != null && (sourceDominant || target2.getUrl() == null)) {
            target2.setUrl(src2);
            target2.setLocation("url", source.getLocation("url"));
        }
    }

    protected void mergeScm_Connection(Scm target2, Scm source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getConnection();
        if (src2 != null && (sourceDominant || target2.getConnection() == null)) {
            target2.setConnection(src2);
            target2.setLocation("connection", source.getLocation("connection"));
        }
    }

    protected void mergeScm_DeveloperConnection(Scm target2, Scm source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getDeveloperConnection();
        if (src2 != null && (sourceDominant || target2.getDeveloperConnection() == null)) {
            target2.setDeveloperConnection(src2);
            target2.setLocation("developerConnection", source.getLocation("developerConnection"));
        }
    }

    protected void mergeScm_Tag(Scm target2, Scm source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getTag();
        if (src2 != null && (sourceDominant || target2.getTag() == null)) {
            target2.setTag(src2);
            target2.setLocation("tag", source.getLocation("tag"));
        }
    }

    protected void mergeCiManagement(CiManagement target2, CiManagement source, boolean sourceDominant, Map<Object, Object> context) {
        this.mergeCiManagement_System(target2, source, sourceDominant, context);
        this.mergeCiManagement_Url(target2, source, sourceDominant, context);
        this.mergeCiManagement_Notifiers(target2, source, sourceDominant, context);
    }

    protected void mergeCiManagement_System(CiManagement target2, CiManagement source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getSystem();
        if (src2 != null && (sourceDominant || target2.getSystem() == null)) {
            target2.setSystem(src2);
            target2.setLocation("system", source.getLocation("system"));
        }
    }

    protected void mergeCiManagement_Url(CiManagement target2, CiManagement source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getUrl();
        if (src2 != null && (sourceDominant || target2.getUrl() == null)) {
            target2.setUrl(src2);
            target2.setLocation("url", source.getLocation("url"));
        }
    }

    protected void mergeCiManagement_Notifiers(CiManagement target2, CiManagement source, boolean sourceDominant, Map<Object, Object> context) {
        target2.setNotifiers(ModelMerger.merge(target2.getNotifiers(), source.getNotifiers(), sourceDominant, new NotifierKeyComputer()));
    }

    protected void mergeNotifier(Notifier target2, Notifier source, boolean sourceDominant, Map<Object, Object> context) {
        this.mergeNotifier_Type(target2, source, sourceDominant, context);
        this.mergeNotifier_Address(target2, source, sourceDominant, context);
        this.mergeNotifier_Configuration(target2, source, sourceDominant, context);
        this.mergeNotifier_SendOnError(target2, source, sourceDominant, context);
        this.mergeNotifier_SendOnFailure(target2, source, sourceDominant, context);
        this.mergeNotifier_SendOnSuccess(target2, source, sourceDominant, context);
        this.mergeNotifier_SendOnWarning(target2, source, sourceDominant, context);
    }

    protected void mergeNotifier_Type(Notifier target2, Notifier source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getType();
        if (src2 != null && (sourceDominant || target2.getType() == null)) {
            target2.setType(src2);
        }
    }

    protected void mergeNotifier_Address(Notifier target2, Notifier source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getAddress();
        if (src2 != null && (sourceDominant || target2.getAddress() == null)) {
            target2.setAddress(src2);
        }
    }

    protected void mergeNotifier_Configuration(Notifier target2, Notifier source, boolean sourceDominant, Map<Object, Object> context) {
        Properties merged = new Properties();
        if (sourceDominant) {
            merged.putAll((Map<?, ?>)target2.getConfiguration());
            merged.putAll((Map<?, ?>)source.getConfiguration());
        } else {
            merged.putAll((Map<?, ?>)source.getConfiguration());
            merged.putAll((Map<?, ?>)target2.getConfiguration());
        }
        target2.setConfiguration(merged);
    }

    protected void mergeNotifier_SendOnError(Notifier target2, Notifier source, boolean sourceDominant, Map<Object, Object> context) {
        if (sourceDominant) {
            target2.setSendOnError(source.isSendOnError());
        }
    }

    protected void mergeNotifier_SendOnFailure(Notifier target2, Notifier source, boolean sourceDominant, Map<Object, Object> context) {
        if (sourceDominant) {
            target2.setSendOnFailure(source.isSendOnFailure());
        }
    }

    protected void mergeNotifier_SendOnSuccess(Notifier target2, Notifier source, boolean sourceDominant, Map<Object, Object> context) {
        if (sourceDominant) {
            target2.setSendOnSuccess(source.isSendOnSuccess());
        }
    }

    protected void mergeNotifier_SendOnWarning(Notifier target2, Notifier source, boolean sourceDominant, Map<Object, Object> context) {
        if (sourceDominant) {
            target2.setSendOnWarning(source.isSendOnWarning());
        }
    }

    protected void mergePrerequisites(Prerequisites target2, Prerequisites source, boolean sourceDominant, Map<Object, Object> context) {
        this.mergePrerequisites_Maven(target2, source, sourceDominant, context);
    }

    protected void mergePrerequisites_Maven(Prerequisites target2, Prerequisites source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getMaven();
        if (src2 != null && (sourceDominant || target2.getMaven() == null)) {
            target2.setMaven(src2);
            target2.setLocation("maven", source.getLocation("maven"));
        }
    }

    protected void mergeBuild(Build target2, Build source, boolean sourceDominant, Map<Object, Object> context) {
        this.mergeBuildBase(target2, source, sourceDominant, context);
        this.mergeBuild_SourceDirectory(target2, source, sourceDominant, context);
        this.mergeBuild_ScriptSourceDirectory(target2, source, sourceDominant, context);
        this.mergeBuild_TestSourceDirectory(target2, source, sourceDominant, context);
        this.mergeBuild_OutputDirectory(target2, source, sourceDominant, context);
        this.mergeBuild_TestOutputDirectory(target2, source, sourceDominant, context);
        this.mergeBuild_Extensions(target2, source, sourceDominant, context);
    }

    protected void mergeBuild_SourceDirectory(Build target2, Build source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getSourceDirectory();
        if (src2 != null && (sourceDominant || target2.getSourceDirectory() == null)) {
            target2.setSourceDirectory(src2);
            target2.setLocation("sourceDirectory", source.getLocation("sourceDirectory"));
        }
    }

    protected void mergeBuild_ScriptSourceDirectory(Build target2, Build source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getScriptSourceDirectory();
        if (src2 != null && (sourceDominant || target2.getScriptSourceDirectory() == null)) {
            target2.setScriptSourceDirectory(src2);
            target2.setLocation("scriptSourceDirectory", source.getLocation("scriptSourceDirectory"));
        }
    }

    protected void mergeBuild_TestSourceDirectory(Build target2, Build source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getTestSourceDirectory();
        if (src2 != null && (sourceDominant || target2.getTestSourceDirectory() == null)) {
            target2.setTestSourceDirectory(src2);
            target2.setLocation("testSourceDirectory", source.getLocation("testSourceDirectory"));
        }
    }

    protected void mergeBuild_OutputDirectory(Build target2, Build source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getOutputDirectory();
        if (src2 != null && (sourceDominant || target2.getOutputDirectory() == null)) {
            target2.setOutputDirectory(src2);
            target2.setLocation("outputDirectory", source.getLocation("outputDirectory"));
        }
    }

    protected void mergeBuild_TestOutputDirectory(Build target2, Build source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getTestOutputDirectory();
        if (src2 != null && (sourceDominant || target2.getTestOutputDirectory() == null)) {
            target2.setTestOutputDirectory(src2);
            target2.setLocation("testOutputDirectory", source.getLocation("testOutputDirectory"));
        }
    }

    protected void mergeBuild_Extensions(Build target2, Build source, boolean sourceDominant, Map<Object, Object> context) {
        target2.setExtensions(ModelMerger.merge(target2.getExtensions(), source.getExtensions(), sourceDominant, new ExtensionKeyComputer()));
    }

    protected void mergeExtension(Extension target2, Extension source, boolean sourceDominant, Map<Object, Object> context) {
        this.mergeExtension_GroupId(target2, source, sourceDominant, context);
        this.mergeExtension_ArtifactId(target2, source, sourceDominant, context);
        this.mergeExtension_Version(target2, source, sourceDominant, context);
    }

    protected void mergeExtension_GroupId(Extension target2, Extension source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getGroupId();
        if (src2 != null && (sourceDominant || target2.getGroupId() == null)) {
            target2.setGroupId(src2);
            target2.setLocation("groupId", source.getLocation("groupId"));
        }
    }

    protected void mergeExtension_ArtifactId(Extension target2, Extension source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getArtifactId();
        if (src2 != null && (sourceDominant || target2.getArtifactId() == null)) {
            target2.setArtifactId(src2);
            target2.setLocation("artifactId", source.getLocation("artifactId"));
        }
    }

    protected void mergeExtension_Version(Extension target2, Extension source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getVersion();
        if (src2 != null && (sourceDominant || target2.getVersion() == null)) {
            target2.setVersion(src2);
            target2.setLocation("version", source.getLocation("version"));
        }
    }

    protected void mergeBuildBase(BuildBase target2, BuildBase source, boolean sourceDominant, Map<Object, Object> context) {
        this.mergePluginConfiguration(target2, source, sourceDominant, context);
        this.mergeBuildBase_DefaultGoal(target2, source, sourceDominant, context);
        this.mergeBuildBase_FinalName(target2, source, sourceDominant, context);
        this.mergeBuildBase_Directory(target2, source, sourceDominant, context);
        this.mergeBuildBase_Resources(target2, source, sourceDominant, context);
        this.mergeBuildBase_TestResources(target2, source, sourceDominant, context);
        this.mergeBuildBase_Filters(target2, source, sourceDominant, context);
    }

    protected void mergeBuildBase_DefaultGoal(BuildBase target2, BuildBase source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getDefaultGoal();
        if (src2 != null && (sourceDominant || target2.getDefaultGoal() == null)) {
            target2.setDefaultGoal(src2);
            target2.setLocation("defaultGoal", source.getLocation("defaultGoal"));
        }
    }

    protected void mergeBuildBase_Directory(BuildBase target2, BuildBase source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getDirectory();
        if (src2 != null && (sourceDominant || target2.getDirectory() == null)) {
            target2.setDirectory(src2);
            target2.setLocation("directory", source.getLocation("directory"));
        }
    }

    protected void mergeBuildBase_FinalName(BuildBase target2, BuildBase source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getFinalName();
        if (src2 != null && (sourceDominant || target2.getFinalName() == null)) {
            target2.setFinalName(src2);
            target2.setLocation("finalName", source.getLocation("finalName"));
        }
    }

    protected void mergeBuildBase_Filters(BuildBase target2, BuildBase source, boolean sourceDominant, Map<Object, Object> context) {
        List<String> src2 = source.getFilters();
        if (!src2.isEmpty()) {
            List<String> tgt = target2.getFilters();
            ArrayList<String> merged = new ArrayList<String>(tgt.size() + src2.size());
            merged.addAll(tgt);
            merged.addAll(src2);
            target2.setFilters(merged);
        }
    }

    protected void mergeBuildBase_Resources(BuildBase target2, BuildBase source, boolean sourceDominant, Map<Object, Object> context) {
        target2.setResources(ModelMerger.merge(target2.getResources(), source.getResources(), sourceDominant, new ResourceKeyComputer()));
    }

    protected void mergeBuildBase_TestResources(BuildBase target2, BuildBase source, boolean sourceDominant, Map<Object, Object> context) {
        target2.setTestResources(ModelMerger.merge(target2.getTestResources(), source.getTestResources(), sourceDominant, new ResourceKeyComputer()));
    }

    protected void mergePluginConfiguration(PluginConfiguration target2, PluginConfiguration source, boolean sourceDominant, Map<Object, Object> context) {
        this.mergePluginContainer(target2, source, sourceDominant, context);
        this.mergePluginConfiguration_PluginManagement(target2, source, sourceDominant, context);
    }

    protected void mergePluginConfiguration_PluginManagement(PluginConfiguration target2, PluginConfiguration source, boolean sourceDominant, Map<Object, Object> context) {
        PluginManagement src2 = source.getPluginManagement();
        if (src2 != null) {
            PluginManagement tgt = target2.getPluginManagement();
            if (tgt == null) {
                tgt = new PluginManagement();
                target2.setPluginManagement(tgt);
            }
            this.mergePluginManagement(tgt, src2, sourceDominant, context);
        }
    }

    protected void mergePluginContainer(PluginContainer target2, PluginContainer source, boolean sourceDominant, Map<Object, Object> context) {
        this.mergePluginContainer_Plugins(target2, source, sourceDominant, context);
    }

    protected void mergePluginContainer_Plugins(PluginContainer target2, PluginContainer source, boolean sourceDominant, Map<Object, Object> context) {
        target2.setPlugins(ModelMerger.merge(target2.getPlugins(), source.getPlugins(), sourceDominant, new PluginKeyComputer()));
    }

    protected void mergePluginManagement(PluginManagement target2, PluginManagement source, boolean sourceDominant, Map<Object, Object> context) {
        this.mergePluginContainer(target2, source, sourceDominant, context);
    }

    protected void mergePlugin(Plugin target2, Plugin source, boolean sourceDominant, Map<Object, Object> context) {
        this.mergeConfigurationContainer(target2, source, sourceDominant, context);
        this.mergePlugin_GroupId(target2, source, sourceDominant, context);
        this.mergePlugin_ArtifactId(target2, source, sourceDominant, context);
        this.mergePlugin_Version(target2, source, sourceDominant, context);
        this.mergePlugin_Extensions(target2, source, sourceDominant, context);
        this.mergePlugin_Dependencies(target2, source, sourceDominant, context);
        this.mergePlugin_Executions(target2, source, sourceDominant, context);
    }

    protected void mergePlugin_GroupId(Plugin target2, Plugin source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getGroupId();
        if (src2 != null && (sourceDominant || target2.getGroupId() == null)) {
            target2.setGroupId(src2);
            target2.setLocation("groupId", source.getLocation("groupId"));
        }
    }

    protected void mergePlugin_ArtifactId(Plugin target2, Plugin source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getArtifactId();
        if (src2 != null && (sourceDominant || target2.getArtifactId() == null)) {
            target2.setArtifactId(src2);
            target2.setLocation("artifactId", source.getLocation("artifactId"));
        }
    }

    protected void mergePlugin_Version(Plugin target2, Plugin source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getVersion();
        if (src2 != null && (sourceDominant || target2.getVersion() == null)) {
            target2.setVersion(src2);
            target2.setLocation("version", source.getLocation("version"));
        }
    }

    protected void mergePlugin_Extensions(Plugin target2, Plugin source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getExtensions();
        if (src2 != null && (sourceDominant || target2.getExtensions() == null)) {
            target2.setExtensions(src2);
            target2.setLocation("extensions", source.getLocation("extensions"));
        }
    }

    protected void mergePlugin_Dependencies(Plugin target2, Plugin source, boolean sourceDominant, Map<Object, Object> context) {
        target2.setDependencies(ModelMerger.merge(target2.getDependencies(), source.getDependencies(), sourceDominant, new DependencyKeyComputer()));
    }

    protected void mergePlugin_Executions(Plugin target2, Plugin source, boolean sourceDominant, Map<Object, Object> context) {
        target2.setExecutions(ModelMerger.merge(target2.getExecutions(), source.getExecutions(), sourceDominant, new ExecutionKeyComputer()));
    }

    protected void mergeConfigurationContainer(ConfigurationContainer target2, ConfigurationContainer source, boolean sourceDominant, Map<Object, Object> context) {
        this.mergeConfigurationContainer_Inherited(target2, source, sourceDominant, context);
        this.mergeConfigurationContainer_Configuration(target2, source, sourceDominant, context);
    }

    protected void mergeConfigurationContainer_Inherited(ConfigurationContainer target2, ConfigurationContainer source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getInherited();
        if (src2 != null && (sourceDominant || target2.getInherited() == null)) {
            target2.setInherited(src2);
            target2.setLocation("inherited", source.getLocation("inherited"));
        }
    }

    protected void mergeConfigurationContainer_Configuration(ConfigurationContainer target2, ConfigurationContainer source, boolean sourceDominant, Map<Object, Object> context) {
        Xpp3Dom src2 = (Xpp3Dom)source.getConfiguration();
        if (src2 != null) {
            Xpp3Dom tgt = (Xpp3Dom)target2.getConfiguration();
            tgt = sourceDominant || tgt == null ? Xpp3Dom.mergeXpp3Dom(new Xpp3Dom(src2), tgt) : Xpp3Dom.mergeXpp3Dom(tgt, src2);
            target2.setConfiguration(tgt);
        }
    }

    protected void mergePluginExecution(PluginExecution target2, PluginExecution source, boolean sourceDominant, Map<Object, Object> context) {
        this.mergeConfigurationContainer(target2, source, sourceDominant, context);
        this.mergePluginExecution_Id(target2, source, sourceDominant, context);
        this.mergePluginExecution_Phase(target2, source, sourceDominant, context);
        this.mergePluginExecution_Goals(target2, source, sourceDominant, context);
    }

    protected void mergePluginExecution_Id(PluginExecution target2, PluginExecution source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getId();
        if (src2 != null && (sourceDominant || target2.getId() == null)) {
            target2.setId(src2);
            target2.setLocation("id", source.getLocation("id"));
        }
    }

    protected void mergePluginExecution_Phase(PluginExecution target2, PluginExecution source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getPhase();
        if (src2 != null && (sourceDominant || target2.getPhase() == null)) {
            target2.setPhase(src2);
            target2.setLocation("phase", source.getLocation("phase"));
        }
    }

    protected void mergePluginExecution_Goals(PluginExecution target2, PluginExecution source, boolean sourceDominant, Map<Object, Object> context) {
        List<String> src2 = source.getGoals();
        if (!src2.isEmpty()) {
            List<String> tgt = target2.getGoals();
            ArrayList<String> merged = new ArrayList<String>(tgt.size() + src2.size());
            merged.addAll(tgt);
            merged.addAll(src2);
            target2.setGoals(merged);
        }
    }

    protected void mergeResource(Resource target2, Resource source, boolean sourceDominant, Map<Object, Object> context) {
        this.mergeFileSet(target2, source, sourceDominant, context);
        this.mergeResource_TargetPath(target2, source, sourceDominant, context);
        this.mergeResource_Filtering(target2, source, sourceDominant, context);
        this.mergeResource_MergeId(target2, source, sourceDominant, context);
    }

    protected void mergeResource_TargetPath(Resource target2, Resource source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getTargetPath();
        if (src2 != null && (sourceDominant || target2.getTargetPath() == null)) {
            target2.setTargetPath(src2);
            target2.setLocation("targetPath", source.getLocation("targetPath"));
        }
    }

    protected void mergeResource_Filtering(Resource target2, Resource source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getFiltering();
        if (src2 != null && (sourceDominant || target2.getFiltering() == null)) {
            target2.setFiltering(src2);
            target2.setLocation("filtering", source.getLocation("filtering"));
        }
    }

    protected void mergeResource_MergeId(Resource target2, Resource source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getMergeId();
        if (src2 != null && (sourceDominant || target2.getMergeId() == null)) {
            target2.setMergeId(src2);
        }
    }

    protected void mergeFileSet(FileSet target2, FileSet source, boolean sourceDominant, Map<Object, Object> context) {
        this.mergePatternSet(target2, source, sourceDominant, context);
        this.mergeFileSet_Directory(target2, source, sourceDominant, context);
    }

    protected void mergeFileSet_Directory(FileSet target2, FileSet source, boolean sourceDominant, Map<Object, Object> context) {
        String src2 = source.getDirectory();
        if (src2 != null && (sourceDominant || target2.getDirectory() == null)) {
            target2.setDirectory(src2);
            target2.setLocation("directory", source.getLocation("directory"));
        }
    }

    protected void mergePatternSet(PatternSet target2, PatternSet source, boolean sourceDominant, Map<Object, Object> context) {
        this.mergePatternSet_Includes(target2, source, sourceDominant, context);
        this.mergePatternSet_Excludes(target2, source, sourceDominant, context);
    }

    protected void mergePatternSet_Includes(PatternSet target2, PatternSet source, boolean sourceDominant, Map<Object, Object> context) {
        List<String> src2 = source.getIncludes();
        if (!src2.isEmpty()) {
            List<String> tgt = target2.getIncludes();
            ArrayList<String> merged = new ArrayList<String>(tgt.size() + src2.size());
            merged.addAll(tgt);
            merged.addAll(src2);
            target2.setIncludes(merged);
        }
    }

    protected void mergePatternSet_Excludes(PatternSet target2, PatternSet source, boolean sourceDominant, Map<Object, Object> context) {
        List<String> src2 = source.getExcludes();
        if (!src2.isEmpty()) {
            List<String> tgt = target2.getExcludes();
            ArrayList<String> merged = new ArrayList<String>(tgt.size() + src2.size());
            merged.addAll(tgt);
            merged.addAll(src2);
            target2.setExcludes(merged);
        }
    }

    protected void mergeProfile(Profile target2, Profile source, boolean sourceDominant, Map<Object, Object> context) {
        this.mergeModelBase(target2, source, sourceDominant, context);
    }

    protected void mergeActivation(Activation target2, Activation source, boolean sourceDominant, Map<Object, Object> context) {
    }

    protected Object getDependencyKey(Dependency dependency) {
        return dependency;
    }

    protected Object getPluginKey(Plugin plugin) {
        return plugin;
    }

    protected Object getPluginExecutionKey(PluginExecution pluginExecution) {
        return pluginExecution;
    }

    protected Object getReportPluginKey(ReportPlugin reportPlugin) {
        return reportPlugin;
    }

    protected Object getReportSetKey(ReportSet reportSet) {
        return reportSet;
    }

    protected Object getLicenseKey(License license) {
        return license;
    }

    protected Object getMailingListKey(MailingList mailingList) {
        return mailingList;
    }

    protected Object getDeveloperKey(Developer developer) {
        return developer;
    }

    protected Object getContributorKey(Contributor contributor) {
        return contributor;
    }

    protected Object getProfileKey(Profile profile2) {
        return profile2;
    }

    protected Object getRepositoryKey(Repository repository) {
        return this.getRepositoryBaseKey(repository);
    }

    protected Object getRepositoryBaseKey(RepositoryBase repositoryBase) {
        return repositoryBase;
    }

    protected Object getNotifierKey(Notifier notifier) {
        return notifier;
    }

    protected Object getResourceKey(Resource resource) {
        return resource;
    }

    protected Object getExtensionKey(Extension extension) {
        return extension;
    }

    protected Object getExclusionKey(Exclusion exclusion) {
        return exclusion;
    }

    private static <T> List<T> merge(List<T> tgt, List<T> src2, boolean sourceDominant, KeyComputer<T> computer) {
        return ModelMerger.merge(tgt, src2, computer, new SourceDominant(sourceDominant));
    }

    private static <T> List<T> merge(List<T> tgt, List<T> src2, KeyComputer<T> computer, Remapping<T> remapping) {
        MergingList<T> list;
        if (src2.isEmpty()) {
            return tgt;
        }
        if (tgt instanceof MergingList) {
            list = (MergingList<T>)tgt;
        } else {
            list = new MergingList<T>(computer, src2.size() + tgt.size());
            list.mergeAll(tgt, new SourceDominant(true));
        }
        list.mergeAll(src2, remapping);
        return list;
    }

    private static class MergingList<V>
    extends AbstractList<V>
    implements Serializable {
        private final KeyComputer<V> keyComputer;
        private Map<Object, V> map;
        private List<V> list;

        MergingList(KeyComputer<V> keyComputer, int initialCapacity) {
            this.map = new LinkedHashMap<Object, V>(initialCapacity);
            this.keyComputer = keyComputer;
        }

        Object writeReplace() throws ObjectStreamException {
            return new ArrayList(this);
        }

        @Override
        public Iterator<V> iterator() {
            if (this.map != null) {
                return this.map.values().iterator();
            }
            return this.list.iterator();
        }

        void mergeAll(Collection<V> vs, Remapping<V> remapping) {
            if (this.map == null) {
                this.map = new LinkedHashMap<Object, V>(this.list.size() + vs.size());
                for (Object object : this.list) {
                    this.map.put(this.keyComputer.key(object), object);
                }
                this.list = null;
            }
            if (vs instanceof MergingList && ((MergingList)vs).map != null) {
                for (Map.Entry entry : ((MergingList)vs).map.entrySet()) {
                    Object newValue;
                    Object key2 = entry.getKey();
                    V oldValue = this.map.get(key2);
                    Object v2 = newValue = oldValue == null ? entry.getValue() : remapping.merge(oldValue, entry.getValue());
                    if (newValue == null) {
                        this.remove(key2);
                        continue;
                    }
                    if (newValue == oldValue) continue;
                    this.map.put(key2, newValue);
                }
            } else {
                for (V v3 : vs) {
                    V newValue;
                    Object key3 = this.keyComputer.key(v3);
                    V oldValue = this.map.get(key3);
                    V v4 = newValue = oldValue == null ? v3 : remapping.merge(oldValue, v3);
                    if (newValue == null) {
                        this.remove(key3);
                        continue;
                    }
                    this.map.put(key3, newValue);
                }
            }
        }

        @Override
        public boolean contains(Object o2) {
            if (this.map != null) {
                return this.map.containsValue(o2);
            }
            return this.list.contains(o2);
        }

        private List<V> asList() {
            if (this.list == null) {
                this.list = new ArrayList<V>(this.map.values());
                this.map = null;
            }
            return this.list;
        }

        @Override
        public void add(int index2, V element2) {
            this.asList().add(index2, element2);
        }

        @Override
        public V remove(int index2) {
            return this.asList().remove(index2);
        }

        @Override
        public V get(int index2) {
            return this.asList().get(index2);
        }

        @Override
        public int size() {
            if (this.map != null) {
                return this.map.size();
            }
            return this.list.size();
        }
    }

    private static class SourceDominant<T>
    implements Remapping<T> {
        private final boolean sourceDominant;

        SourceDominant(boolean sourceDominant) {
            this.sourceDominant = sourceDominant;
        }

        @Override
        public T merge(T u, T v2) {
            return this.sourceDominant ? v2 : u;
        }
    }

    private class ExclusionKeyComputer
    implements KeyComputer<Exclusion> {
        private ExclusionKeyComputer() {
        }

        @Override
        public Object key(Exclusion exclusion) {
            return ModelMerger.this.getExclusionKey(exclusion);
        }
    }

    private class ExecutionKeyComputer
    implements KeyComputer<PluginExecution> {
        private ExecutionKeyComputer() {
        }

        @Override
        public Object key(PluginExecution pluginExecution) {
            return ModelMerger.this.getPluginExecutionKey(pluginExecution);
        }
    }

    private class ResourceKeyComputer
    implements KeyComputer<Resource> {
        private ResourceKeyComputer() {
        }

        @Override
        public Object key(Resource resource) {
            return ModelMerger.this.getResourceKey(resource);
        }
    }

    private class ExtensionKeyComputer
    implements KeyComputer<Extension> {
        private ExtensionKeyComputer() {
        }

        @Override
        public Object key(Extension extension) {
            return ModelMerger.this.getExtensionKey(extension);
        }
    }

    private class NotifierKeyComputer
    implements KeyComputer<Notifier> {
        private NotifierKeyComputer() {
        }

        @Override
        public Object key(Notifier notifier) {
            return ModelMerger.this.getNotifierKey(notifier);
        }
    }

    private class ReportSetKeyComputer
    implements KeyComputer<ReportSet> {
        private ReportSetKeyComputer() {
        }

        @Override
        public Object key(ReportSet reportSet) {
            return ModelMerger.this.getReportSetKey(reportSet);
        }
    }

    private class PluginKeyComputer
    implements KeyComputer<Plugin> {
        private PluginKeyComputer() {
        }

        @Override
        public Object key(Plugin plugin) {
            return ModelMerger.this.getPluginKey(plugin);
        }
    }

    private class ReportPluginKeyComputer
    implements KeyComputer<ReportPlugin> {
        private ReportPluginKeyComputer() {
        }

        @Override
        public Object key(ReportPlugin plugin) {
            return ModelMerger.this.getReportPluginKey(plugin);
        }
    }

    private class RepositoryKeyComputer
    implements KeyComputer<Repository> {
        private RepositoryKeyComputer() {
        }

        @Override
        public Object key(Repository repository) {
            return ModelMerger.this.getRepositoryKey(repository);
        }
    }

    private class ProfileKeyComputer
    implements KeyComputer<Profile> {
        private ProfileKeyComputer() {
        }

        @Override
        public Object key(Profile profile2) {
            return ModelMerger.this.getProfileKey(profile2);
        }
    }

    private class ContributorKeyComputer
    implements KeyComputer<Contributor> {
        private ContributorKeyComputer() {
        }

        @Override
        public Object key(Contributor contributor) {
            return ModelMerger.this.getContributorKey(contributor);
        }
    }

    private class DeveloperKeyComputer
    implements KeyComputer<Developer> {
        private DeveloperKeyComputer() {
        }

        @Override
        public Object key(Developer developer) {
            return ModelMerger.this.getDeveloperKey(developer);
        }
    }

    private class MailingListKeyComputer
    implements KeyComputer<MailingList> {
        private MailingListKeyComputer() {
        }

        @Override
        public Object key(MailingList mailingList) {
            return ModelMerger.this.getMailingListKey(mailingList);
        }
    }

    private class LicenseKeyComputer
    implements KeyComputer<License> {
        private LicenseKeyComputer() {
        }

        @Override
        public Object key(License license) {
            return ModelMerger.this.getLicenseKey(license);
        }
    }

    private final class DependencyKeyComputer
    implements KeyComputer<Dependency> {
        private DependencyKeyComputer() {
        }

        @Override
        public Object key(Dependency dependency) {
            return ModelMerger.this.getDependencyKey(dependency);
        }
    }

    private static interface Remapping<T> {
        public T merge(T var1, T var2);
    }

    private static interface KeyComputer<T> {
        public Object key(T var1);
    }
}

