/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.InputLocationTracker;

public class Contributor
implements Serializable,
Cloneable,
InputLocationTracker {
    private String name;
    private String email;
    private String url;
    private String organization;
    private String organizationUrl;
    private List<String> roles;
    private String timezone;
    private Properties properties;
    private Map<Object, InputLocation> locations;
    private InputLocation location;
    private InputLocation nameLocation;
    private InputLocation emailLocation;
    private InputLocation urlLocation;
    private InputLocation organizationLocation;
    private InputLocation organizationUrlLocation;
    private InputLocation rolesLocation;
    private InputLocation timezoneLocation;
    private InputLocation propertiesLocation;

    public void addProperty(String key2, String value2) {
        this.getProperties().put(key2, value2);
    }

    public void addRole(String string) {
        this.getRoles().add(string);
    }

    public Contributor clone() {
        try {
            Contributor copy = (Contributor)super.clone();
            if (this.roles != null) {
                copy.roles = new ArrayList<String>();
                copy.roles.addAll(this.roles);
            }
            if (this.properties != null) {
                copy.properties = (Properties)this.properties.clone();
            }
            if (copy.locations != null) {
                copy.locations = new LinkedHashMap<Object, InputLocation>(copy.locations);
            }
            return copy;
        }
        catch (Exception ex) {
            throw (RuntimeException)new UnsupportedOperationException(this.getClass().getName() + " does not support clone()").initCause(ex);
        }
    }

    public String getEmail() {
        return this.email;
    }

    @Override
    public InputLocation getLocation(Object key2) {
        if (key2 instanceof String) {
            switch ((String)key2) {
                case "": {
                    return this.location;
                }
                case "name": {
                    return this.nameLocation;
                }
                case "email": {
                    return this.emailLocation;
                }
                case "url": {
                    return this.urlLocation;
                }
                case "organization": {
                    return this.organizationLocation;
                }
                case "organizationUrl": {
                    return this.organizationUrlLocation;
                }
                case "roles": {
                    return this.rolesLocation;
                }
                case "timezone": {
                    return this.timezoneLocation;
                }
                case "properties": {
                    return this.propertiesLocation;
                }
            }
            return this.getOtherLocation(key2);
        }
        return this.getOtherLocation(key2);
    }

    public String getName() {
        return this.name;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getOrganizationUrl() {
        return this.organizationUrl;
    }

    @Override
    public void setLocation(Object key2, InputLocation location) {
        if (key2 instanceof String) {
            switch ((String)key2) {
                case "": {
                    this.location = location;
                    return;
                }
                case "name": {
                    this.nameLocation = location;
                    return;
                }
                case "email": {
                    this.emailLocation = location;
                    return;
                }
                case "url": {
                    this.urlLocation = location;
                    return;
                }
                case "organization": {
                    this.organizationLocation = location;
                    return;
                }
                case "organizationUrl": {
                    this.organizationUrlLocation = location;
                    return;
                }
                case "roles": {
                    this.rolesLocation = location;
                    return;
                }
                case "timezone": {
                    this.timezoneLocation = location;
                    return;
                }
                case "properties": {
                    this.propertiesLocation = location;
                    return;
                }
            }
            this.setOtherLocation(key2, location);
            return;
        }
        this.setOtherLocation(key2, location);
    }

    public void setOtherLocation(Object key2, InputLocation location) {
        if (location != null) {
            if (this.locations == null) {
                this.locations = new LinkedHashMap<Object, InputLocation>();
            }
            this.locations.put(key2, location);
        }
    }

    private InputLocation getOtherLocation(Object key2) {
        return this.locations != null ? this.locations.get(key2) : null;
    }

    public Properties getProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        return this.properties;
    }

    public List<String> getRoles() {
        if (this.roles == null) {
            this.roles = new ArrayList<String>();
        }
        return this.roles;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public String getUrl() {
        return this.url;
    }

    public void removeRole(String string) {
        this.getRoles().remove(string);
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setName(String name2) {
        this.name = name2;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public void setOrganizationUrl(String organizationUrl) {
        this.organizationUrl = organizationUrl;
    }

    public void setProperties(Properties properties2) {
        this.properties = properties2;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String toString() {
        return "Contributor {name=" + this.name + ", email=" + this.email + "}";
    }
}

