/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.core.util;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.ErrorWritingException;
import com.thoughtworks.xstream.converters.reflection.ObjectAccessException;
import com.thoughtworks.xstream.core.util.Pool;
import java.beans.PropertyEditor;

public class ThreadSafePropertyEditor {
    private final Class editorType;
    private final Pool pool;

    public ThreadSafePropertyEditor(Class type2, int initialPoolSize, int maxPoolSize) {
        if (!PropertyEditor.class.isAssignableFrom(type2)) {
            throw new IllegalArgumentException(type2.getName() + " is not a " + PropertyEditor.class.getName());
        }
        this.editorType = type2;
        this.pool = new Pool(initialPoolSize, maxPoolSize, new Pool.Factory(){

            public Object newInstance() {
                ErrorWritingException ex = null;
                try {
                    return ThreadSafePropertyEditor.this.editorType.newInstance();
                }
                catch (InstantiationException e2) {
                    ex = new ConversionException("Faild to call default constructor", e2);
                }
                catch (IllegalAccessException e3) {
                    ex = new ObjectAccessException("Cannot call default constructor", e3);
                }
                ex.add("construction-type", ThreadSafePropertyEditor.this.editorType.getName());
                throw ex;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAsText(Object object) {
        PropertyEditor editor2 = this.fetchFromPool();
        try {
            editor2.setValue(object);
            String string = editor2.getAsText();
            return string;
        }
        finally {
            this.pool.putInPool(editor2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object setAsText(String str) {
        PropertyEditor editor2 = this.fetchFromPool();
        try {
            editor2.setAsText(str);
            Object object = editor2.getValue();
            return object;
        }
        finally {
            this.pool.putInPool(editor2);
        }
    }

    private PropertyEditor fetchFromPool() {
        PropertyEditor editor2 = (PropertyEditor)this.pool.fetchFromPool();
        return editor2;
    }
}

