/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.extended;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.ExtendedHierarchicalStreamWriterHelper;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.awt.Color;
import java.util.HashMap;

public class ColorConverter
implements Converter {
    public boolean canConvert(Class type2) {
        return type2 != null && type2.getName().equals("java.awt.Color");
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        Color color = (Color)source;
        this.write("red", color.getRed(), writer);
        this.write("green", color.getGreen(), writer);
        this.write("blue", color.getBlue(), writer);
        this.write("alpha", color.getAlpha(), writer);
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        HashMap<String, Integer> elements2 = new HashMap<String, Integer>();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            elements2.put(reader.getNodeName(), Integer.valueOf(reader.getValue()));
            reader.moveUp();
        }
        return new Color((Integer)elements2.get("red"), (Integer)elements2.get("green"), (Integer)elements2.get("blue"), (Integer)elements2.get("alpha"));
    }

    private void write(String fieldName, int value2, HierarchicalStreamWriter writer) {
        ExtendedHierarchicalStreamWriterHelper.startNode(writer, fieldName, Integer.TYPE);
        writer.setValue(String.valueOf(value2));
        writer.endNode();
    }
}

