/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.enums;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

public class EnumConverter
implements Converter {
    public boolean canConvert(Class type2) {
        return type2 != null && type2.isEnum() || Enum.class.isAssignableFrom(type2);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        writer.setValue(((Enum)source).name());
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Class type2 = context.getRequiredType();
        if (type2.getSuperclass() != Enum.class) {
            type2 = type2.getSuperclass();
        }
        String name2 = reader.getValue();
        try {
            return Enum.valueOf(type2, name2);
        }
        catch (IllegalArgumentException e2) {
            for (Enum c2 : (Enum[])type2.getEnumConstants()) {
                if (!c2.name().equalsIgnoreCase(name2)) continue;
                return c2;
            }
            throw e2;
        }
    }
}

