/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.collections;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.collections.AbstractCollectionConverter;
import com.thoughtworks.xstream.core.SecurityUtils;
import com.thoughtworks.xstream.io.ExtendedHierarchicalStreamWriterHelper;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

public class MapConverter
extends AbstractCollectionConverter {
    private final Class type;

    public MapConverter(Mapper mapper) {
        this(mapper, null);
    }

    public MapConverter(Mapper mapper, Class type2) {
        super(mapper);
        this.type = type2;
        if (type2 != null && !Map.class.isAssignableFrom(type2)) {
            throw new IllegalArgumentException(type2 + " not of type " + Map.class);
        }
    }

    public boolean canConvert(Class type2) {
        if (this.type != null) {
            return type2.equals(this.type);
        }
        return type2.equals(HashMap.class) || type2.equals(Hashtable.class) || type2.getName().equals("java.util.LinkedHashMap") || type2.getName().equals("java.util.concurrent.ConcurrentHashMap") || type2.getName().equals("sun.font.AttributeMap");
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        Map map2 = (Map)source;
        String entryName = this.mapper().serializedClass(Map.Entry.class);
        Iterator iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            ExtendedHierarchicalStreamWriterHelper.startNode(writer, entryName, entry.getClass());
            this.writeCompleteItem(entry.getKey(), context, writer);
            this.writeCompleteItem(entry.getValue(), context, writer);
            writer.endNode();
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Map map2 = (Map)this.createCollection(context.getRequiredType());
        this.populateMap(reader, context, map2);
        return map2;
    }

    protected void populateMap(HierarchicalStreamReader reader, UnmarshallingContext context, Map map2) {
        this.populateMap(reader, context, map2, map2);
    }

    protected void populateMap(HierarchicalStreamReader reader, UnmarshallingContext context, Map map2, Map target2) {
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            this.putCurrentEntryIntoMap(reader, context, map2, target2);
            reader.moveUp();
        }
    }

    protected void putCurrentEntryIntoMap(HierarchicalStreamReader reader, UnmarshallingContext context, Map map2, Map target2) {
        Object key2 = this.readCompleteItem(reader, context, map2);
        Object value2 = this.readCompleteItem(reader, context, map2);
        long now = System.currentTimeMillis();
        target2.put(key2, value2);
        SecurityUtils.checkForCollectionDoSAttack(context, now);
    }

    protected Object createCollection(Class type2) {
        return super.createCollection(this.type != null ? this.type : type2);
    }
}

