/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters;

import com.thoughtworks.xstream.XStreamException;
import com.thoughtworks.xstream.converters.ErrorWriter;
import com.thoughtworks.xstream.core.util.OrderRetainingMap;
import java.util.Iterator;
import java.util.Map;

public abstract class ErrorWritingException
extends XStreamException
implements ErrorWriter {
    private static final String SEPARATOR = "\n-------------------------------";
    private final Map stuff = new OrderRetainingMap();

    public ErrorWritingException(String message2) {
        super(message2);
        this.addData(message2, null);
    }

    public ErrorWritingException(Throwable cause) {
        super(cause);
        this.addData(null, cause);
    }

    public ErrorWritingException(String message2, Throwable cause) {
        super(message2, cause);
        this.addData(message2, cause);
    }

    private void addData(String msg, Throwable cause) {
        if (msg != null) {
            this.add("message", msg);
        }
        if (cause != null) {
            this.add("cause-exception", cause.getClass().getName());
            this.add("cause-message", cause instanceof ErrorWritingException ? ((ErrorWritingException)cause).getShortMessage() : cause.getMessage());
        }
    }

    public String get(String errorKey) {
        return (String)this.stuff.get(errorKey);
    }

    public void add(String name2, String information) {
        String key2 = name2;
        int i2 = 0;
        while (this.stuff.containsKey(key2)) {
            String value2 = (String)this.stuff.get(key2);
            if (information.equals(value2)) {
                return;
            }
            key2 = name2 + "[" + ++i2 + "]";
        }
        this.stuff.put(key2, information);
    }

    public void set(String name2, String information) {
        String key2 = name2;
        int i2 = 0;
        this.stuff.put(key2, information);
        while (this.stuff.containsKey(key2)) {
            if (i2 != 0) {
                this.stuff.remove(key2);
            }
            key2 = name2 + "[" + ++i2 + "]";
        }
    }

    public Iterator keys() {
        return this.stuff.keySet().iterator();
    }

    public String getMessage() {
        StringBuffer result2 = new StringBuffer();
        if (super.getMessage() != null) {
            result2.append(super.getMessage());
        }
        if (!result2.toString().endsWith(SEPARATOR)) {
            result2.append("\n---- Debugging information ----");
        }
        Iterator iterator = this.keys();
        while (iterator.hasNext()) {
            String k = (String)iterator.next();
            String v2 = this.get(k);
            result2.append('\n').append(k);
            result2.append("                    ".substring(Math.min(20, k.length())));
            result2.append(": ").append(v2);
        }
        result2.append(SEPARATOR);
        return result2.toString();
    }

    public String getShortMessage() {
        return super.getMessage();
    }
}

