/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.script;

import com.intellij.database.settings.DatabaseSettings;
import com.intellij.lang.Language;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.EvaluationHelper;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.util.Function;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.TreeTraversal;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqlScriptTraverserCreatorImpl {
    private static final Key<Object> PSI_SCRIPT_NODE_PARENT = Key.create((String)"PSI_SCRIPT_NODE_PARENT");
    private static final Key<JBIterable<?>> PSI_SCRIPT_NODE_CHILDREN = Key.create((String)"PSI_SCRIPT_NODE_CHILDREN");

    private SqlScriptTraverserCreatorImpl() {
    }

    public static SyntaxTraverser<Object> getScriptTraverser(@NotNull PsiFile root2, @NotNull SyntaxTraverser.ApiEx<PsiElement> api, @NotNull Language language, @NotNull CharSequence text2, @NotNull DatabaseSettings.SplitScriptMode splitScriptMode, @NotNull IElementType fakeStatementType) {
        if (root2 == null) {
            SqlScriptTraverserCreatorImpl.$$$reportNull$$$0(0);
        }
        if (api == null) {
            SqlScriptTraverserCreatorImpl.$$$reportNull$$$0(1);
        }
        if (language == null) {
            SqlScriptTraverserCreatorImpl.$$$reportNull$$$0(2);
        }
        if (text2 == null) {
            SqlScriptTraverserCreatorImpl.$$$reportNull$$$0(3);
        }
        if (splitScriptMode == null) {
            SqlScriptTraverserCreatorImpl.$$$reportNull$$$0(4);
        }
        if (fakeStatementType == null) {
            SqlScriptTraverserCreatorImpl.$$$reportNull$$$0(5);
        }
        Object scriptRoot = SqlScriptTraverserCreatorImpl.createScriptRoot(root2, api, language, text2, splitScriptMode, fakeStatementType);
        return (SyntaxTraverser)SyntaxTraverser.syntaxTraverser((SyntaxTraverser.Api)new ScriptNodeApi((SyntaxTraverser.Api<PsiElement>)api)).withRoot(scriptRoot);
    }

    private static Object createScriptRoot(@NotNull PsiFile root2, @NotNull SyntaxTraverser.ApiEx<PsiElement> api, @NotNull Language language, @NotNull CharSequence text2, @NotNull DatabaseSettings.SplitScriptMode splitScriptMode, @NotNull IElementType fakeStatementType) {
        if (root2 == null) {
            SqlScriptTraverserCreatorImpl.$$$reportNull$$$0(6);
        }
        if (api == null) {
            SqlScriptTraverserCreatorImpl.$$$reportNull$$$0(7);
        }
        if (language == null) {
            SqlScriptTraverserCreatorImpl.$$$reportNull$$$0(8);
        }
        if (text2 == null) {
            SqlScriptTraverserCreatorImpl.$$$reportNull$$$0(9);
        }
        if (splitScriptMode == null) {
            SqlScriptTraverserCreatorImpl.$$$reportNull$$$0(10);
        }
        if (fakeStatementType == null) {
            SqlScriptTraverserCreatorImpl.$$$reportNull$$$0(11);
        }
        EvaluationHelper helper = (EvaluationHelper)EvaluationHelper.EP.forLanguage(language);
        Condition requiredSplitCond = Conditions.or((Condition)helper.isStatementSeparator(api, language), (Condition)helper.canContainStatements(api));
        Condition skipInsideBlockStatementCond = e2 -> {
            PsiElement parent2 = (PsiElement)api.parent(e2);
            if (parent2 == null) {
                return false;
            }
            return api.typeOf((Object)parent2) == SqlCompositeElementTypes.SQL_BLOCK_STATEMENT && (StringUtil.toUpperCase((String)api.textOf(e2).toString()).equals("BEGIN") && e2.equals(api.first((Object)parent2)) || StringUtil.toUpperCase((String)api.textOf(e2).toString()).equals("END") && e2.equals(api.last((Object)parent2)));
        };
        Condition requiredSkipInsideCond = Conditions.or((Condition)Conditions.or((Condition)Conditions.or((Condition)helper.isWsOrComment(api), (Condition)Conditions.compose((Function)api.TO_TYPE, (Condition)Conditions.equalTo((Object)TokenType.ERROR_ELEMENT))), (Condition)skipInsideBlockStatementCond), (Condition)requiredSplitCond);
        if (splitScriptMode == DatabaseSettings.SplitScriptMode.BY_SEPARATOR) {
            return SqlScriptTraverserCreatorImpl.createScriptNode((PsiElement)root2, api, text2, fakeStatementType, (Condition<PsiElement>)requiredSplitCond, (Condition<PsiElement>)requiredSkipInsideCond, helper);
        }
        if (splitScriptMode == DatabaseSettings.SplitScriptMode.COMBINED) {
            Condition isCorrectNode = node2 -> ((SyntaxTraverser)SyntaxTraverser.syntaxTraverser((SyntaxTraverser.Api)api).withRoot(node2)).filterTypes(Conditions.equalTo((Object)TokenType.ERROR_ELEMENT)).traverse().isEmpty();
            Condition smartSplitCond = Conditions.or((Condition)requiredSplitCond, (Condition)Conditions.and((Condition)helper.isStatement(api), (Condition)isCorrectNode));
            return SqlScriptTraverserCreatorImpl.createScriptNode((PsiElement)root2, api, text2, fakeStatementType, (Condition<PsiElement>)smartSplitCond, (Condition<PsiElement>)requiredSkipInsideCond, helper);
        }
        return root2;
    }

    private static Object createScriptNode(@NotNull PsiElement node2, @NotNull SyntaxTraverser.Api<PsiElement> api, @NotNull CharSequence text2, @NotNull IElementType fakeStatementType, @NotNull Condition<PsiElement> splitCond, @NotNull Condition<PsiElement> skipInsideCond, @NotNull EvaluationHelper helper) {
        if (node2 == null) {
            SqlScriptTraverserCreatorImpl.$$$reportNull$$$0(12);
        }
        if (api == null) {
            SqlScriptTraverserCreatorImpl.$$$reportNull$$$0(13);
        }
        if (text2 == null) {
            SqlScriptTraverserCreatorImpl.$$$reportNull$$$0(14);
        }
        if (fakeStatementType == null) {
            SqlScriptTraverserCreatorImpl.$$$reportNull$$$0(15);
        }
        if (splitCond == null) {
            SqlScriptTraverserCreatorImpl.$$$reportNull$$$0(16);
        }
        if (skipInsideCond == null) {
            SqlScriptTraverserCreatorImpl.$$$reportNull$$$0(17);
        }
        if (helper == null) {
            SqlScriptTraverserCreatorImpl.$$$reportNull$$$0(18);
        }
        if (!helper.canContainStatements(api).value((Object)node2)) {
            return node2;
        }
        JBIterable statementChildren = ((SyntaxTraverser)((SyntaxTraverser)((SyntaxTraverser)SyntaxTraverser.syntaxTraverser(api).withRoot((Object)node2)).forceDisregardTypes(Conditions.oneOf((Object[])new IElementType[]{SqlElementTypes.SQL_DUMMY_BLOCK, TokenType.ERROR_ELEMENT})).expandAndSkip(Conditions.equalTo((Object)node2))).withTraversal(TreeTraversal.LEAVES_DFS)).traverse();
        JBIterable statementChildrenSplitted = statementChildren.split(JBIterable.Split.AFTER, splitCond);
        JBIterable children2 = statementChildrenSplitted.map(stChildren -> stChildren.collect()).flatMap(stChildren -> {
            JBIterable stChildrenFiltered = stChildren.filter(Conditions.not((Condition)skipInsideCond));
            if (stChildrenFiltered.isEmpty() || stChildrenFiltered.size() == 1 && helper.isStatement(api).value((Object)((PsiElement)stChildrenFiltered.single()))) {
                return stChildren.map(child -> SqlScriptTraverserCreatorImpl.createScriptNode(child, api, text2, fakeStatementType, splitCond, skipInsideCond, helper));
            }
            PsiElement fakeStatementStart = (PsiElement)stChildrenFiltered.first();
            PsiElement fakeStatementEnd = (PsiElement)stChildrenFiltered.last();
            boolean inFakeInterval = false;
            ArrayList<Object> resultChildrenList = new ArrayList<Object>();
            ArrayList fakeStatementChildrenList = new ArrayList();
            for (PsiElement element2 : stChildren) {
                if (element2 == fakeStatementStart) {
                    inFakeInterval = true;
                }
                if (inFakeInterval) {
                    JBIterable innerChildren = helper.isStatement(api).value((Object)element2) ? api.children((Object)element2) : JBIterable.of((Object)element2);
                    fakeStatementChildrenList.addAll(innerChildren.map(child -> SqlScriptTraverserCreatorImpl.createScriptNode(child, api, text2, fakeStatementType, splitCond, skipInsideCond, helper)).toList());
                    if (element2 != fakeStatementEnd) continue;
                    inFakeInterval = false;
                    TextRange textRange = new TextRange(api.rangeOf((Object)fakeStatementStart).getStartOffset(), api.rangeOf((Object)fakeStatementEnd).getEndOffset());
                    JBIterable fakeStatementChildren = JBIterable.from(fakeStatementChildrenList);
                    FakeScriptNode fakeStatementNode = new FakeScriptNode(fakeStatementType, textRange, textRange.subSequence(text2));
                    SqlScriptTraverserCreatorImpl.createLinks(fakeStatementNode, fakeStatementChildren);
                    resultChildrenList.add(fakeStatementNode);
                    continue;
                }
                resultChildrenList.add(SqlScriptTraverserCreatorImpl.createScriptNode(element2, api, text2, fakeStatementType, splitCond, skipInsideCond, helper));
            }
            return JBIterable.from(resultChildrenList);
        });
        SqlScriptTraverserCreatorImpl.createLinks(node2, children2);
        return node2;
    }

    private static void createLinks(@NotNull Object parent2, @NotNull JBIterable<?> rawChildren) {
        if (parent2 == null) {
            SqlScriptTraverserCreatorImpl.$$$reportNull$$$0(19);
        }
        if (rawChildren == null) {
            SqlScriptTraverserCreatorImpl.$$$reportNull$$$0(20);
        }
        JBIterable children2 = rawChildren.filter(c2 -> c2 instanceof PsiElement || c2 instanceof FakeScriptNode).collect();
        for (Object child : children2) {
            if (child instanceof PsiElement) {
                ((PsiElement)child).putUserData(PSI_SCRIPT_NODE_PARENT, parent2);
            }
            if (!(child instanceof FakeScriptNode)) continue;
            ((FakeScriptNode)child).setParent(parent2);
        }
        if (parent2 instanceof PsiElement) {
            ((PsiElement)parent2).putUserData(PSI_SCRIPT_NODE_CHILDREN, (Object)children2);
        }
        if (parent2 instanceof FakeScriptNode) {
            ((FakeScriptNode)parent2).setChildren(children2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: 
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "api";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 3: 
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "splitScriptMode";
                break;
            }
            case 5: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fakeStatementType";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "splitCond";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "skipInsideCond";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawChildren";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sql/script/SqlScriptTraverserCreatorImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getScriptTraverser";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "createScriptRoot";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "createScriptNode";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "createLinks";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ScriptNodeApi
    extends SyntaxTraverser.Api<Object> {
        private static final IElementType DEFAULT_TYPE = IElementType.find((short)0);
        private static final TextRange DEFAULT_RANGE = TextRange.EMPTY_RANGE;
        private static final CharSequence DEFAULT_TEXT = "";
        private final SyntaxTraverser.Api<PsiElement> psiApiDelegate;

        ScriptNodeApi(@NotNull SyntaxTraverser.Api<PsiElement> psiApiDelegate) {
            if (psiApiDelegate == null) {
                ScriptNodeApi.$$$reportNull$$$0(0);
            }
            this.psiApiDelegate = psiApiDelegate;
        }

        @NotNull
        public IElementType typeOf(@NotNull Object scriptNode) {
            if (scriptNode == null) {
                ScriptNodeApi.$$$reportNull$$$0(1);
            }
            if (scriptNode instanceof PsiElement) {
                IElementType iElementType = this.psiApiDelegate.typeOf((Object)((PsiElement)scriptNode));
                if (iElementType == null) {
                    ScriptNodeApi.$$$reportNull$$$0(2);
                }
                return iElementType;
            }
            if (scriptNode instanceof FakeScriptNode) {
                IElementType iElementType = ((FakeScriptNode)scriptNode).getType();
                if (iElementType == null) {
                    ScriptNodeApi.$$$reportNull$$$0(3);
                }
                return iElementType;
            }
            IElementType iElementType = DEFAULT_TYPE;
            if (iElementType == null) {
                ScriptNodeApi.$$$reportNull$$$0(4);
            }
            return iElementType;
        }

        @NotNull
        public TextRange rangeOf(@NotNull Object scriptNode) {
            if (scriptNode == null) {
                ScriptNodeApi.$$$reportNull$$$0(5);
            }
            if (scriptNode instanceof PsiElement) {
                TextRange textRange = this.psiApiDelegate.rangeOf((Object)((PsiElement)scriptNode));
                if (textRange == null) {
                    ScriptNodeApi.$$$reportNull$$$0(6);
                }
                return textRange;
            }
            if (scriptNode instanceof FakeScriptNode) {
                TextRange textRange = ((FakeScriptNode)scriptNode).getRange();
                if (textRange == null) {
                    ScriptNodeApi.$$$reportNull$$$0(7);
                }
                return textRange;
            }
            TextRange textRange = DEFAULT_RANGE;
            if (textRange == null) {
                ScriptNodeApi.$$$reportNull$$$0(8);
            }
            return textRange;
        }

        @NotNull
        public CharSequence textOf(@NotNull Object scriptNode) {
            if (scriptNode == null) {
                ScriptNodeApi.$$$reportNull$$$0(9);
            }
            if (scriptNode instanceof PsiElement) {
                CharSequence charSequence = this.psiApiDelegate.textOf((Object)((PsiElement)scriptNode));
                if (charSequence == null) {
                    ScriptNodeApi.$$$reportNull$$$0(10);
                }
                return charSequence;
            }
            if (scriptNode instanceof FakeScriptNode) {
                CharSequence charSequence = ((FakeScriptNode)scriptNode).getText();
                if (charSequence == null) {
                    ScriptNodeApi.$$$reportNull$$$0(11);
                }
                return charSequence;
            }
            CharSequence charSequence = DEFAULT_TEXT;
            if (charSequence == null) {
                ScriptNodeApi.$$$reportNull$$$0(12);
            }
            return charSequence;
        }

        @Nullable
        public Object parent(@NotNull Object scriptNode) {
            if (scriptNode == null) {
                ScriptNodeApi.$$$reportNull$$$0(13);
            }
            if (scriptNode instanceof PsiElement) {
                Object parent2 = ((PsiElement)scriptNode).getUserData(PSI_SCRIPT_NODE_PARENT);
                return parent2 != null ? parent2 : this.psiApiDelegate.parent((Object)((PsiElement)scriptNode));
            }
            if (scriptNode instanceof FakeScriptNode) {
                return ((FakeScriptNode)scriptNode).getParent();
            }
            return null;
        }

        @NotNull
        public JBIterable<?> children(@NotNull Object scriptNode) {
            if (scriptNode == null) {
                ScriptNodeApi.$$$reportNull$$$0(14);
            }
            if (scriptNode instanceof PsiElement) {
                JBIterable children2 = (JBIterable)((PsiElement)scriptNode).getUserData(PSI_SCRIPT_NODE_CHILDREN);
                JBIterable jBIterable = children2 != null ? children2 : this.psiApiDelegate.children((Object)((PsiElement)scriptNode));
                if (jBIterable == null) {
                    ScriptNodeApi.$$$reportNull$$$0(15);
                }
                return jBIterable;
            }
            if (scriptNode instanceof FakeScriptNode) {
                JBIterable<?> jBIterable = ((FakeScriptNode)scriptNode).getChildren();
                if (jBIterable == null) {
                    ScriptNodeApi.$$$reportNull$$$0(16);
                }
                return jBIterable;
            }
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                ScriptNodeApi.$$$reportNull$$$0(17);
            }
            return jBIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4, 6, 7, 8, 10, 11, 12, 15, 16, 17 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiApiDelegate";
                    break;
                }
                case 1: 
                case 5: 
                case 9: 
                case 13: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scriptNode";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 11: 
                case 12: 
                case 15: 
                case 16: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/script/SqlScriptTraverserCreatorImpl$ScriptNodeApi";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/script/SqlScriptTraverserCreatorImpl$ScriptNodeApi";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "typeOf";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "rangeOf";
                    break;
                }
                case 10: 
                case 11: 
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "textOf";
                    break;
                }
                case 15: 
                case 16: 
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "children";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "typeOf";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 11: 
                case 12: 
                case 15: 
                case 16: 
                case 17: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "rangeOf";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "textOf";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "parent";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "children";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4, 6, 7, 8, 10, 11, 12, 15, 16, 17 -> new IllegalStateException(string);
            };
        }
    }

    private static class FakeScriptNode {
        @NotNull
        private final IElementType myType;
        @NotNull
        private final TextRange myRange;
        @NotNull
        private final CharSequence myText;
        @Nullable
        private Object myParent;
        @Nullable
        private JBIterable<?> myChildren;

        FakeScriptNode(@NotNull IElementType type2, @NotNull TextRange range, @NotNull CharSequence text2) {
            if (type2 == null) {
                FakeScriptNode.$$$reportNull$$$0(0);
            }
            if (range == null) {
                FakeScriptNode.$$$reportNull$$$0(1);
            }
            if (text2 == null) {
                FakeScriptNode.$$$reportNull$$$0(2);
            }
            this.myType = type2;
            this.myRange = range;
            this.myText = text2;
        }

        @NotNull
        public IElementType getType() {
            IElementType iElementType = this.myType;
            if (iElementType == null) {
                FakeScriptNode.$$$reportNull$$$0(3);
            }
            return iElementType;
        }

        @NotNull
        public TextRange getRange() {
            TextRange textRange = this.myRange;
            if (textRange == null) {
                FakeScriptNode.$$$reportNull$$$0(4);
            }
            return textRange;
        }

        @NotNull
        public CharSequence getText() {
            CharSequence charSequence = this.myText;
            if (charSequence == null) {
                FakeScriptNode.$$$reportNull$$$0(5);
            }
            return charSequence;
        }

        private void setParent(@NotNull Object parent2) {
            if (parent2 == null) {
                FakeScriptNode.$$$reportNull$$$0(6);
            }
            this.myParent = parent2;
        }

        @Nullable
        public Object getParent() {
            return this.myParent;
        }

        private void setChildren(@NotNull JBIterable<?> children2) {
            if (children2 == null) {
                FakeScriptNode.$$$reportNull$$$0(7);
            }
            this.myChildren = children2;
        }

        @NotNull
        public JBIterable<?> getChildren() {
            JBIterable<?> jBIterable = this.myChildren != null ? this.myChildren : JBIterable.empty();
            if (jBIterable == null) {
                FakeScriptNode.$$$reportNull$$$0(8);
            }
            return jBIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5, 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/script/SqlScriptTraverserCreatorImpl$FakeScriptNode";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "children";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/script/SqlScriptTraverserCreatorImpl$FakeScriptNode";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRange";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 8: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "setParent";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "setChildren";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5, 8 -> new IllegalStateException(string);
            };
        }
    }
}

