/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl.support;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactoryRegistrar;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.database.Dbms;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.editor.SqlCodeBlockProviderUtils;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlElseClause;
import com.intellij.sql.psi.SqlExceptionClause;
import com.intellij.sql.psi.SqlExceptionWhenClause;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlIfStatement;
import com.intellij.sql.psi.SqlThenClause;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class SqlBlockHighlighterFactory
implements TextEditorHighlightingPassFactory,
TextEditorHighlightingPassFactoryRegistrar {
    private static final HighlightInfoType MATCHED = new HighlightInfoType.HighlightInfoTypeImpl(HighlightInfoType.SYMBOL_TYPE_SEVERITY, CodeInsightColors.MATCHED_BRACE_ATTRIBUTES);
    private static final HighlightInfoType UNMATCHED = new HighlightInfoType.HighlightInfoTypeImpl(HighlightSeverity.ERROR, CodeInsightColors.UNMATCHED_BRACE_ATTRIBUTES);

    public void registerHighlightingPassFactory(@NotNull TextEditorHighlightingPassRegistrar registrar, @NotNull Project project) {
        if (registrar == null) {
            SqlBlockHighlighterFactory.$$$reportNull$$$0(0);
        }
        if (project == null) {
            SqlBlockHighlighterFactory.$$$reportNull$$$0(1);
        }
        registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, null, new int[]{4}, false, -1);
    }

    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file, @NotNull Editor editor2) {
        if (file == null) {
            SqlBlockHighlighterFactory.$$$reportNull$$$0(2);
        }
        if (editor2 == null) {
            SqlBlockHighlighterFactory.$$$reportNull$$$0(3);
        }
        return file instanceof SqlFile ? new SqlBlockHighlightingPass(file, editor2) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sql/psi/impl/support/SqlBlockHighlighterFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerHighlightingPassFactory";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createHighlightingPass";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class SqlBlockHighlightingPass
    extends TextEditorHighlightingPass {
        private final PsiFile myFile;
        private final Editor myEditor;
        private final List<TextRange> myRanges = new ArrayList<TextRange>();
        private boolean myIsMatched;

        public SqlBlockHighlightingPass(PsiFile file, Editor editor2) {
            super(file.getProject(), editor2.getDocument(), false);
            this.myFile = file;
            this.myEditor = editor2;
        }

        public void doCollectInformation(@NotNull ProgressIndicator progress) {
            if (progress == null) {
                SqlBlockHighlightingPass.$$$reportNull$$$0(0);
            }
            this.findPair(this.myEditor.getCaretModel().getOffset());
        }

        private boolean isMatchingRequired(int offset) {
            IElementType type2;
            SqlLanguageDialect dialect = (SqlLanguageDialect)ObjectUtils.tryCast((Object)this.myFile.getLanguage(), SqlLanguageDialect.class);
            if (dialect == null) {
                return true;
            }
            Dbms dbms = dialect.getDbms();
            PsiElement element2 = this.myFile.findElementAt(offset);
            if (SqlBlockHighlightingPass.isExceptionWhenClauseAnchor(element2, type2 = PsiUtilCore.getElementType((PsiElement)element2))) {
                return false;
            }
            if (dbms.isMicrosoft()) {
                SqlElseClause elseClause;
                if (type2 == SqlCommonKeywords.SQL_IF || type2 == SqlCommonKeywords.SQL_WHILE) {
                    return false;
                }
                return type2 != SqlCommonKeywords.SQL_ELSE || (elseClause = (SqlElseClause)ObjectUtils.tryCast((Object)element2.getParent(), SqlElseClause.class)) == null || !(elseClause.getParent() instanceof SqlIfStatement);
            }
            if (dbms.isSybase()) {
                if (type2 == SqlCommonKeywords.SQL_WHILE) {
                    return false;
                }
                if (type2 == SqlCommonKeywords.SQL_IF || type2 == SqlCommonKeywords.SQL_ELSE) {
                    SqlIfStatement ifStatement;
                    if (type2 == SqlCommonKeywords.SQL_ELSE) {
                        SqlElseClause elseClause = (SqlElseClause)ObjectUtils.tryCast((Object)element2.getParent(), SqlElseClause.class);
                        SqlIfStatement sqlIfStatement = ifStatement = elseClause != null ? (SqlIfStatement)ObjectUtils.tryCast((Object)elseClause.getParent(), SqlIfStatement.class) : null;
                        if (ifStatement == null) {
                            return true;
                        }
                    } else {
                        ifStatement = (SqlIfStatement)ObjectUtils.tryCast((Object)element2.getParent(), SqlIfStatement.class);
                    }
                    SqlThenClause thenClause = ifStatement != null ? (SqlThenClause)ifStatement.getBranches().filter(SqlThenClause.class).first() : null;
                    return SqlImplUtil.getChildOfType(thenClause, (IElementType)SqlCommonKeywords.SQL_THEN) != null;
                }
            }
            return true;
        }

        private static boolean isExceptionWhenClauseAnchor(PsiElement element2, IElementType type2) {
            SqlThenClause thenClause;
            if (type2 == SqlCommonKeywords.SQL_WHEN && element2.getParent() instanceof SqlExceptionWhenClause) {
                return true;
            }
            return type2 == SqlCommonKeywords.SQL_THEN && (thenClause = (SqlThenClause)ObjectUtils.tryCast((Object)element2.getParent(), SqlThenClause.class)) != null && thenClause.getParent() instanceof SqlExceptionWhenClause;
        }

        public void findPair(int offset) {
            this.myRanges.clear();
            int endIdx = -1;
            for (PsiElement element2 : SqlCodeBlockProviderUtils.processBlock(this.myFile, offset)) {
                PsiElement elementToAdd;
                if (PsiUtilCore.getElementType((PsiElement)element2) == SqlCommonKeywords.SQL_END) {
                    endIdx = this.myRanges.size();
                }
                if ((elementToAdd = element2) instanceof SqlExceptionClause) {
                    elementToAdd = ((SqlExceptionClause)elementToAdd).getKeyword();
                }
                if (elementToAdd == null) continue;
                this.myRanges.add(elementToAdd.getTextRange());
            }
            this.myIsMatched = !this.isMatchingRequired(offset) || endIdx >= 1;
        }

        @TestOnly
        public List<TextRange> getRanges() {
            return this.myRanges;
        }

        public void doApplyInformationToEditor() {
            List infos;
            if (this.myRanges.isEmpty()) {
                infos = Collections.emptyList();
            } else {
                infos = new ArrayList();
                HighlightInfoType type2 = this.isMatched() ? MATCHED : UNMATCHED;
                for (TextRange range : this.myRanges) {
                    ContainerUtil.addIfNotNull(infos, (Object)HighlightInfo.newHighlightInfo((HighlightInfoType)type2).range(range).create());
                }
            }
            UpdateHighlightersUtil.setHighlightersToSingleEditor((Project)this.myFile.getProject(), (Editor)this.myEditor, (int)0, (int)this.myFile.getTextLength(), infos, (EditorColorsScheme)this.getColorsScheme(), (int)this.getId());
        }

        public boolean isMatched() {
            return this.myIsMatched;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/sql/psi/impl/support/SqlBlockHighlighterFactory$SqlBlockHighlightingPass", "doCollectInformation"));
        }
    }
}

