/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections.dataflow.sql.inst;

import com.intellij.codeInspection.dataFlow.interpreter.DataFlowInterpreter;
import com.intellij.codeInspection.dataFlow.lang.DfaAnchor;
import com.intellij.codeInspection.dataFlow.lang.ir.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.lang.ir.ExpressionPushingInstruction;
import com.intellij.codeInspection.dataFlow.memory.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.psi.PsiElement;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.dataflow.sql.anchor.SqlExpressionAnchor;
import com.intellij.sql.inspections.dataflow.types.SqlDfTypesKt;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J#\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/intellij/sql/inspections/dataflow/sql/inst/SqlNotInstruction;", "Lcom/intellij/codeInspection/dataFlow/lang/ir/ExpressionPushingInstruction;", "expression", "Lcom/intellij/sql/psi/SqlExpression;", "(Lcom/intellij/sql/psi/SqlExpression;)V", "getExpression", "()Lcom/intellij/sql/psi/SqlExpression;", "accept", "", "Lcom/intellij/codeInspection/dataFlow/lang/ir/DfaInstructionState;", "interpreter", "Lcom/intellij/codeInspection/dataFlow/interpreter/DataFlowInterpreter;", "stateBefore", "Lcom/intellij/codeInspection/dataFlow/memory/DfaMemoryState;", "(Lcom/intellij/codeInspection/dataFlow/interpreter/DataFlowInterpreter;Lcom/intellij/codeInspection/dataFlow/memory/DfaMemoryState;)[Lcom/intellij/codeInspection/dataFlow/lang/ir/DfaInstructionState;", "toString", "", "intellij.database.sql.core.impl"})
public final class SqlNotInstruction
extends ExpressionPushingInstruction {
    @NotNull
    private final SqlExpression expression;

    public SqlNotInstruction(@NotNull SqlExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super((DfaAnchor)SqlExpressionAnchor.Companion.getAnchor(expression));
        this.expression = expression;
    }

    @NotNull
    public final SqlExpression getExpression() {
        return this.expression;
    }

    @NotNull
    public DfaInstructionState[] accept(@NotNull DataFlowInterpreter interpreter, @NotNull DfaMemoryState stateBefore) {
        DfType dfType;
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        Intrinsics.checkNotNullParameter((Object)stateBefore, (String)"stateBefore");
        DfType dfType2 = stateBefore.getDfType(stateBefore.pop());
        Intrinsics.checkNotNullExpressionValue((Object)dfType2, (String)"getDfType(...)");
        DfType operand = dfType2;
        if (Intrinsics.areEqual((Object)operand, (Object)SqlDfTypesKt.getNULL())) {
            this.pushResult(interpreter, stateBefore, SqlDfTypesKt.getNULL(), new DfaValue[0]);
            DfaInstructionState[] dfaInstructionStateArray = this.nextStates(interpreter, stateBefore);
            Intrinsics.checkNotNullExpressionValue((Object)dfaInstructionStateArray, (String)"nextStates(...)");
            return dfaInstructionStateArray;
        }
        SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe((PsiElement)this.expression);
        Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialectEx, (String)"getSqlDialectSafe(...)");
        DfType booleanType2 = SqlDfTypesKt.tryCastToBoolean(operand, sqlLanguageDialectEx);
        if (Intrinsics.areEqual((Object)booleanType2, (Object)SqlDfTypesKt.getFALSE()) || Intrinsics.areEqual((Object)booleanType2, (Object)SqlDfTypesKt.getTRUE())) {
            DfType dfType3 = booleanType2.tryNegate();
            dfType = dfType3;
            Intrinsics.checkNotNull((Object)dfType3);
        } else {
            dfType = SqlDfTypesKt.unknown(SqlDfTypesKt.nullability(operand));
        }
        DfType dfType4 = dfType;
        Intrinsics.checkNotNull((Object)dfType4);
        DfType result2 = dfType4;
        this.pushResult(interpreter, stateBefore, result2, new DfaValue[0]);
        DfaInstructionState[] dfaInstructionStateArray = this.nextStates(interpreter, stateBefore);
        Intrinsics.checkNotNullExpressionValue((Object)dfaInstructionStateArray, (String)"nextStates(...)");
        return dfaInstructionStateArray;
    }

    @NotNull
    public String toString() {
        return "NOT";
    }
}

