/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections.dataflow.sql.inst;

import com.intellij.codeInspection.dataFlow.lang.DfaAnchor;
import com.intellij.codeInspection.dataFlow.lang.ir.EvalInstruction;
import com.intellij.codeInspection.dataFlow.memory.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.psi.PsiElement;
import com.intellij.sql.inspections.dataflow.SqlDfaJoinType;
import com.intellij.sql.inspections.dataflow.SqlDfaNullability;
import com.intellij.sql.inspections.dataflow.SqlDfaUtilKt;
import com.intellij.sql.inspections.dataflow.sql.anchor.SqlExpressionAnchor;
import com.intellij.sql.inspections.dataflow.sql.inst.SqlCrossJoinInstruction;
import com.intellij.sql.inspections.dataflow.types.SqlDfTableType;
import com.intellij.sql.inspections.dataflow.types.SqlDfTypesKt;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlJoinExpression;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J1\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\u0010\"\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/sql/inspections/dataflow/sql/inst/SqlJoinByConditionInstruction;", "Lcom/intellij/codeInspection/dataFlow/lang/ir/EvalInstruction;", "expression", "Lcom/intellij/sql/psi/SqlJoinExpression;", "joinType", "Lcom/intellij/sql/inspections/dataflow/SqlDfaJoinType;", "(Lcom/intellij/sql/psi/SqlJoinExpression;Lcom/intellij/sql/inspections/dataflow/SqlDfaJoinType;)V", "getExpression", "()Lcom/intellij/sql/psi/SqlJoinExpression;", "eval", "Lcom/intellij/codeInspection/dataFlow/value/DfaValue;", "factory", "Lcom/intellij/codeInspection/dataFlow/value/DfaValueFactory;", "state", "Lcom/intellij/codeInspection/dataFlow/memory/DfaMemoryState;", "arguments", "", "(Lcom/intellij/codeInspection/dataFlow/value/DfaValueFactory;Lcom/intellij/codeInspection/dataFlow/memory/DfaMemoryState;[Lcom/intellij/codeInspection/dataFlow/value/DfaValue;)Lcom/intellij/codeInspection/dataFlow/value/DfaValue;", "toString", "", "intellij.database.sql.core.impl"})
public final class SqlJoinByConditionInstruction
extends EvalInstruction {
    @NotNull
    private final SqlJoinExpression expression;
    @NotNull
    private final SqlDfaJoinType joinType;

    public SqlJoinByConditionInstruction(@NotNull SqlJoinExpression expression, @NotNull SqlDfaJoinType joinType) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)((Object)joinType), (String)"joinType");
        super((DfaAnchor)SqlExpressionAnchor.Companion.getAnchor((SqlExpression)expression), 3);
        this.expression = expression;
        this.joinType = joinType;
    }

    @NotNull
    public final SqlJoinExpression getExpression() {
        return this.expression;
    }

    @NotNull
    public DfaValue eval(@NotNull DfaValueFactory factory, @NotNull DfaMemoryState state, DfaValue ... arguments) {
        DfType dfType;
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        DfaValue left = arguments[0];
        DfaValue right = arguments[1];
        DfaValue condition2 = arguments[2];
        DfType dfType2 = state.getDfType(right);
        SqlDfTableType sqlDfTableType = dfType2 instanceof SqlDfTableType ? (SqlDfTableType)dfType2 : null;
        if (sqlDfTableType == null) {
            DfaTypeValue dfaTypeValue = factory.getUnknown();
            Intrinsics.checkNotNullExpressionValue((Object)dfaTypeValue, (String)"getUnknown(...)");
            return (DfaValue)dfaTypeValue;
        }
        SqlDfTableType rightType = sqlDfTableType;
        DfType dfType3 = state.getDfType(left);
        SqlDfTableType sqlDfTableType2 = dfType3 instanceof SqlDfTableType ? (SqlDfTableType)dfType3 : null;
        if (sqlDfTableType2 == null) {
            DfaTypeValue dfaTypeValue = factory.getUnknown();
            Intrinsics.checkNotNullExpressionValue((Object)dfaTypeValue, (String)"getUnknown(...)");
            return (DfaValue)dfaTypeValue;
        }
        SqlDfTableType leftType = sqlDfTableType2;
        dfType3 = state.getDfType(condition2);
        if (Intrinsics.areEqual((Object)dfType3, (Object)SqlDfTypesKt.getFALSE()) ? true : Intrinsics.areEqual((Object)dfType3, (Object)SqlDfTypesKt.getNULL())) {
            DfType dfType4 = leftType.join(rightType);
            Intrinsics.checkNotNull((Object)dfType4, (String)"null cannot be cast to non-null type com.intellij.sql.inspections.dataflow.types.SqlDfTableType");
            dfType = ((SqlDfTableType)dfType4).empty();
        } else if (Intrinsics.areEqual((Object)dfType3, (Object)SqlDfTypesKt.getTRUE())) {
            dfType = SqlCrossJoinInstruction.Companion.crossJoin(leftType, rightType);
        } else {
            switch (WhenMappings.$EnumSwitchMapping$0[this.joinType.ordinal()]) {
                case 1: {
                    dfType = leftType.join(rightType);
                    break;
                }
                case 2: {
                    rightType = rightType.setNullability(SqlDfaNullability.NULLABLE);
                    state.setDfType(right, (DfType)rightType);
                    dfType = leftType.join(rightType);
                    break;
                }
                case 3: {
                    leftType = leftType.setNullability(SqlDfaNullability.NULLABLE);
                    state.setDfType(left, (DfType)leftType);
                    dfType = leftType.join(rightType);
                    break;
                }
                case 4: {
                    rightType = rightType.setNullability(SqlDfaNullability.NULLABLE);
                    leftType = leftType.setNullability(SqlDfaNullability.NULLABLE);
                    state.setDfType(right, (DfType)rightType);
                    state.setDfType(left, (DfType)leftType);
                    dfType = leftType.join(rightType);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        DfType resultType = dfType;
        return SqlDfaUtilKt.createTableValue((PsiElement)this.expression, null, factory, state, resultType);
    }

    @NotNull
    public String toString() {
        return this.joinType + "_JOIN";
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SqlDfaJoinType.values().length];
            try {
                nArray[SqlDfaJoinType.INNER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqlDfaJoinType.LEFT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqlDfaJoinType.RIGHT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqlDfaJoinType.FULL.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

