/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.Dbms;
import com.intellij.database.types.DasType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlCommitStatement;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCompositeElement;
import com.intellij.sql.psi.SqlCreateProcedureStatement;
import com.intellij.sql.psi.SqlCreateTriggerStatement;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlRollbackStatement;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.impl.SqlImplUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014\u00a8\u0006\u0010"}, d2={"Lcom/intellij/sql/inspections/SqlTransactionStatementInTriggerInspection;", "Lcom/intellij/sql/inspections/SqlInspectionBase;", "()V", "createAnnotationVisitor", "Lcom/intellij/sql/inspections/SqlInspectionBase$SqlAnnotationVisitor;", "file", "Lcom/intellij/sql/psi/SqlFile;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "result", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "onTheFly", "", "intellij.database.sql.impl"})
public final class SqlTransactionStatementInTriggerInspection
extends SqlInspectionBase {
    @Override
    @Nullable
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlFile file, @NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, boolean onTheFly) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        Dbms dbms = dialect.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        Dbms dbms2 = dbms;
        if (dbms2.isCassandra() || dbms2.isDerby() || dbms2.isH2() || dbms2.isHive() || dbms2.isSqlite()) {
            return null;
        }
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result2, dbms2, onTheFly){
            final /* synthetic */ SqlLanguageDialectEx $dialect;
            final /* synthetic */ Dbms $dbms;
            final /* synthetic */ boolean $onTheFly;
            {
                this.$dialect = $dialect;
                this.$dbms = $dbms;
                this.$onTheFly = $onTheFly;
                super($manager, $dialect, (Collection<ProblemDescriptor>)$result);
            }

            public void visitSqlCreateProcedureStatement(@NotNull SqlCreateProcedureStatement o2) {
                Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
                if (this.$dbms.isPostgres()) {
                    boolean bl;
                    Object object = o2.getReturnArgument();
                    if (object != null && (object = object.getDasType()) != null) {
                        Object object2 = object;
                        SqlLanguageDialectEx sqlLanguageDialectEx = this.$dialect;
                        Object it2 = object2;
                        boolean bl2 = false;
                        bl = sqlLanguageDialectEx.getTypeSystem().isTriggerFunctionType((DasType)it2);
                    } else {
                        bl = false;
                    }
                    if (bl) {
                        this.processTrigger((PsiElement)o2);
                    }
                }
            }

            public void visitSqlCreateTriggerStatement(@NotNull SqlCreateTriggerStatement o2) {
                Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
                if (!this.$dbms.isPostgres()) {
                    this.processTrigger((PsiElement)o2);
                }
            }

            private final void processTrigger(PsiElement root2) {
                for (PsiElement e2 : SqlImplUtil.sqlTraverser(root2).bfsTraversal()) {
                    IElementType pragmaType;
                    if (!(e2 instanceof SqlCompositeElement)) continue;
                    IElementType elementType = PsiUtilCore.getElementType((PsiElement)((SqlCompositeElement)e2).getFirstChild());
                    if (this.$dbms.isOracle() && Intrinsics.areEqual((Object)elementType, (Object)SqlCommonKeywords.SQL_PRAGMA) && Intrinsics.areEqual((Object)(pragmaType = PsiUtilCore.getElementType((PsiElement)PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)((SqlCompositeElement)e2).getFirstChild()))), (Object)SqlCommonKeywords.SQL_AUTONOMOUS_TRANSACTION)) break;
                    if (!(e2 instanceof SqlCommitStatement) && !(e2 instanceof SqlRollbackStatement)) continue;
                    this.reportProblem((SqlStatement)e2);
                }
            }

            private final void reportProblem(SqlStatement statement2) {
                this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)statement2, (PsiElement)statement2, SqlBundle.message((String)"inspection.message.this.statement.should.not.be.used.in.trigger.since.it.s.executed.in.context.enclosing.transaction", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.$onTheFly, new LocalQuickFix[0]));
            }
        };
    }
}

