/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inlays;

import com.intellij.codeInsight.hints.declarative.InlayHintsProvider;
import com.intellij.codeInsight.hints.declarative.InlayPosition;
import com.intellij.codeInsight.hints.declarative.InlayTreeSink;
import com.intellij.codeInsight.hints.declarative.InlineInlayPosition;
import com.intellij.codeInsight.hints.declarative.PresentationTreeBuilder;
import com.intellij.codeInsight.hints.declarative.SharedBypassCollector;
import com.intellij.database.model.DasArgument;
import com.intellij.database.types.DasType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlValuesToColumnMapper;
import com.intellij.sql.inlays.InlayUtilsKt;
import com.intellij.sql.inlays.SqlColumnNamesInlayHintsProvider;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlLiteralExpression;
import com.intellij.sql.psi.SqlOperatorExpression;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlSetOperatorExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlValuesExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlNamedParameterValueExpression;
import com.intellij.sql.slicer.SqlPsiUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002JH\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u001326\u0010\u0014\u001a2\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0018\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0019\u0012\u0004\u0012\u00020\u00110\u0015H\u0002JP\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e26\u0010\u0014\u001a2\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0018\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0019\u0012\u0004\u0012\u00020\u00110\u0015H\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u00a8\u0006!"}, d2={"Lcom/intellij/sql/inlays/SqlColumnNamesInlayHintsProvider;", "Lcom/intellij/codeInsight/hints/declarative/InlayHintsProvider;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "createCollector", "Lcom/intellij/codeInsight/hints/declarative/SharedBypassCollector;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "guessExpressionName", "", "selectClause", "Lcom/intellij/sql/psi/SqlSelectClause;", "index", "", "processCallHints", "", "callExpression", "Lcom/intellij/sql/psi/SqlFunctionCallExpression;", "action", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "offset", "text", "processResultSetHints", "element", "Lcom/intellij/psi/PsiElement;", "sink", "Lcom/intellij/codeInsight/hints/declarative/InlayTreeSink;", "shouldShowHintsForExpression", "", "intellij.database.sql.impl"})
public final class SqlColumnNamesInlayHintsProvider
implements InlayHintsProvider,
DumbAware {
    @NotNull
    public SharedBypassCollector createCollector(@NotNull PsiFile file, @NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        return new SharedBypassCollector(this){
            final /* synthetic */ SqlColumnNamesInlayHintsProvider this$0;
            {
                this.this$0 = $receiver;
            }

            public void collectFromElement(@NotNull PsiElement element2, @NotNull InlayTreeSink sink) {
                Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
                Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                if (element2 instanceof SqlFunctionCallExpression) {
                    SqlColumnNamesInlayHintsProvider.access$processCallHints(this.this$0, (SqlFunctionCallExpression)element2, (Function2)new Function2<Integer, String, Unit>(sink){
                        final /* synthetic */ InlayTreeSink $sink;
                        {
                            this.$sink = $sink;
                            super(2, Intrinsics.Kotlin.class, "addHint", "collectFromElement$addHint(Lcom/intellij/codeInsight/hints/declarative/InlayTreeSink;ILjava/lang/String;)V", 0);
                        }

                        public final void invoke(int p0, @NotNull String p1) {
                            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                            createCollector.1.access$collectFromElement$addHint(this.$sink, p0, p1);
                        }
                    });
                } else {
                    SqlColumnNamesInlayHintsProvider.access$processResultSetHints(this.this$0, element2, sink, (Function2)new Function2<Integer, String, Unit>(sink){
                        final /* synthetic */ InlayTreeSink $sink;
                        {
                            this.$sink = $sink;
                            super(2, Intrinsics.Kotlin.class, "addHint", "collectFromElement$addHint(Lcom/intellij/codeInsight/hints/declarative/InlayTreeSink;ILjava/lang/String;)V", 0);
                        }

                        public final void invoke(int p0, @NotNull String p1) {
                            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                            createCollector.1.access$collectFromElement$addHint(this.$sink, p0, p1);
                        }
                    });
                }
            }

            private static final void collectFromElement$addHint(InlayTreeSink $sink, int offset, String text2) {
                if (((CharSequence)text2).length() == 0) {
                    return;
                }
                InlayTreeSink.addPresentation$default((InlayTreeSink)$sink, (InlayPosition)((InlayPosition)new InlineInlayPosition(offset, true, 0, 4, null)), null, null, (boolean)true, (Function1)((Function1)new Function1<PresentationTreeBuilder, Unit>(text2){
                    final /* synthetic */ String $text;
                    {
                        this.$text = $text;
                        super(1);
                    }

                    public final void invoke(@NotNull PresentationTreeBuilder $this$addPresentation) {
                        Intrinsics.checkNotNullParameter((Object)$this$addPresentation, (String)"$this$addPresentation");
                        PresentationTreeBuilder.text$default((PresentationTreeBuilder)$this$addPresentation, (String)this.$text, null, (int)2, null);
                    }
                }), (int)6, null);
            }

            public static final /* synthetic */ void access$collectFromElement$addHint(InlayTreeSink $sink, int offset, String text2) {
                createCollector.1.collectFromElement$addHint($sink, offset, text2);
            }
        };
    }

    private final void processCallHints(SqlFunctionCallExpression callExpression, Function2<? super Integer, ? super String, Unit> action) {
        SqlReferenceExpression sqlReferenceExpression = callExpression.getNameElement();
        if (sqlReferenceExpression == null) {
            return;
        }
        SqlReferenceExpression calleeExpression = sqlReferenceExpression;
        if (SqlImplUtil.resolveVisible(calleeExpression).filter(arg_0 -> SqlColumnNamesInlayHintsProvider.processCallHints$lambda$0(processCallHints.1.INSTANCE, arg_0)).isEmpty()) {
            return;
        }
        SqlExpressionList sqlExpressionList = callExpression.getParameterList();
        if (sqlExpressionList == null) {
            return;
        }
        SqlExpressionList expressionList = sqlExpressionList;
        for (SqlExpression expression : expressionList.getExpressionList()) {
            String name2;
            DasArgument dasArgument;
            if (expression instanceof SqlNamedParameterValueExpression) continue;
            Intrinsics.checkNotNull((Object)expression);
            if (SqlPsiUtilKt.findParameterDefinition(expression, false) == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)dasArgument.getName(), (String)"getName(...)");
            if (StringUtil.isEmpty((String)name2)) continue;
            action.invoke((Object)expression.getTextRange().getStartOffset(), (Object)name2);
        }
    }

    private final void processResultSetHints(PsiElement element2, InlayTreeSink sink, Function2<? super Integer, ? super String, Unit> action) {
        List expressions2 = null;
        String optionId = null;
        PsiElement psiElement = element2;
        if (psiElement instanceof SqlExpressionList) {
            if (!(SqlImplUtil.sqlParent(element2) instanceof SqlValuesExpression)) {
                return;
            }
            optionId = "sql.show.column.names.in.insert.values";
            List list = ((SqlExpressionList)element2).getExpressionList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getExpressionList(...)");
            expressions2 = list;
        } else if (psiElement instanceof SqlSelectClause) {
            optionId = "sql.show.column.names.in.select";
            List list = ((SqlSelectClause)element2).getExpressions();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getExpressions(...)");
            expressions2 = list;
        } else {
            return;
        }
        sink.whenOptionEnabled(optionId, (Function0)new Function0<Unit>((List<? extends SqlExpression>)expressions2, sink, element2, this, action){
            final /* synthetic */ List<SqlExpression> $expressions;
            final /* synthetic */ InlayTreeSink $sink;
            final /* synthetic */ PsiElement $element;
            final /* synthetic */ SqlColumnNamesInlayHintsProvider this$0;
            final /* synthetic */ Function2<Integer, String, Unit> $action;
            {
                this.$expressions = $expressions;
                this.$sink = $sink;
                this.$element = $element;
                this.this$0 = $receiver;
                this.$action = $action;
                super(0);
            }

            public final void invoke() {
                Iterator<SqlExpression> iterator = this.$expressions.iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    int i2 = n++;
                    SqlExpression expression = iterator.next();
                    String string = "sql.show.column.names.for.asterisk";
                    PsiElement psiElement = this.$element;
                    String string2 = string;
                    InlayTreeSink inlayTreeSink = this.$sink;
                    boolean bl = false;
                    boolean bl2 = SqlImplUtil.isAsteriskRef(psiElement);
                    InlayUtilsKt.whenOptionEnabledOrNull(inlayTreeSink, bl2 ? string : null, (Function0<Unit>)((Function0)new Function0<Unit>(this.this$0, expression, this.$element, this.$sink, this.$action, i2){
                        final /* synthetic */ SqlColumnNamesInlayHintsProvider this$0;
                        final /* synthetic */ SqlExpression $expression;
                        final /* synthetic */ PsiElement $element;
                        final /* synthetic */ InlayTreeSink $sink;
                        final /* synthetic */ Function2<Integer, String, Unit> $action;
                        final /* synthetic */ int $i;
                        {
                            this.this$0 = $receiver;
                            this.$expression = $expression;
                            this.$element = $element;
                            this.$sink = $sink;
                            this.$action = $action;
                            this.$i = $i;
                            super(0);
                        }

                        public final void invoke() {
                            SqlExpression sqlExpression = this.$expression;
                            Intrinsics.checkNotNullExpressionValue((Object)sqlExpression, (String)"$expression");
                            if (!SqlColumnNamesInlayHintsProvider.access$shouldShowHintsForExpression(this.this$0, (PsiElement)sqlExpression)) {
                                return;
                            }
                            List names2 = null;
                            SqlExpression sqlExpression2 = this.$expression;
                            Intrinsics.checkNotNullExpressionValue((Object)sqlExpression2, (String)"$expression");
                            SqlValuesToColumnMapper mapper = SqlValuesToColumnMapper.Companion.getInstance$default(SqlValuesToColumnMapper.Companion, (PsiElement)sqlExpression2, false, 2, null);
                            if (mapper != null) {
                                IntRange indexRange = mapper.getIndexRange();
                                names2 = new ArrayList<E>(indexRange.getLast() - indexRange.getFirst() + 1);
                                mapper.processColumnElements((Function2<? super PsiElement, ? super String, Unit>)((Function2)new Function2<PsiElement, String, Unit>((List<String>)names2){
                                    final /* synthetic */ List<String> $names;
                                    {
                                        this.$names = $names;
                                        super(2);
                                    }

                                    public final void invoke(@Nullable PsiElement psiElement, @Nullable String name2) {
                                        if (name2 != null) {
                                            ((ArrayList)this.$names).add(name2);
                                        }
                                    }
                                }));
                            } else {
                                names2 = CollectionsKt.emptyList();
                            }
                            if (this.$expression instanceof SqlReferenceExpression && Intrinsics.areEqual((Object)((SqlReferenceExpression)this.$expression).getName(), (Object)CollectionsKt.singleOrNull((List)names2))) {
                                return;
                            }
                            int inlayOffset = this.$expression.getTextRange().getStartOffset();
                            if (names2.isEmpty() && this.$element instanceof SqlSelectClause) {
                                this.$sink.whenOptionEnabled("sql.show.column.names.for.set.operations", (Function0)new Function0<Unit>(this.this$0, this.$element, this.$i, this.$action, inlayOffset){
                                    final /* synthetic */ SqlColumnNamesInlayHintsProvider this$0;
                                    final /* synthetic */ PsiElement $element;
                                    final /* synthetic */ int $i;
                                    final /* synthetic */ Function2<Integer, String, Unit> $action;
                                    final /* synthetic */ int $inlayOffset;
                                    {
                                        this.this$0 = $receiver;
                                        this.$element = $element;
                                        this.$i = $i;
                                        this.$action = $action;
                                        this.$inlayOffset = $inlayOffset;
                                        super(0);
                                    }

                                    public final void invoke() {
                                        String name2 = SqlColumnNamesInlayHintsProvider.access$guessExpressionName(this.this$0, (SqlSelectClause)this.$element, this.$i);
                                        if (name2 != null) {
                                            this.$action.invoke((Object)this.$inlayOffset, (Object)name2);
                                        }
                                    }
                                });
                            } else {
                                Integer n = inlayOffset;
                                String string = StringUtil.join((Collection)names2, (String)", ");
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"join(...)");
                                this.$action.invoke((Object)n, (Object)string);
                            }
                        }
                    }));
                }
            }
        });
    }

    private final String guessExpressionName(SqlSelectClause selectClause, int index2) {
        PsiElement pp;
        PsiElement p2 = selectClause.getParent();
        while (p2 instanceof SqlQueryExpression) {
            p2 = p2.getParent();
        }
        while ((pp = p2.getParent()) instanceof SqlSetOperatorExpression) {
            p2 = pp;
        }
        if (p2 instanceof SqlSetOperatorExpression) {
            SqlQueryExpression sqlQueryExpression = (SqlQueryExpression)PsiTreeUtil.findChildOfType((PsiElement)p2, SqlQueryExpression.class);
            if (sqlQueryExpression == null) {
                return null;
            }
            SqlQueryExpression firstQuery = sqlQueryExpression;
            if (Intrinsics.areEqual((Object)firstQuery.getSelectClause(), (Object)selectClause)) {
                return null;
            }
            DasType dasType = firstQuery.getDasType();
            SqlTableType sqlTableType = dasType instanceof SqlTableType ? (SqlTableType)dasType : null;
            if (sqlTableType == null) {
                return null;
            }
            SqlTableType type2 = sqlTableType;
            return StringUtil.trimMiddle((String)type2.getColumnName(index2), (int)20);
        }
        return null;
    }

    private final boolean shouldShowHintsForExpression(PsiElement element2) {
        return element2 instanceof SqlLiteralExpression || element2 instanceof SqlOperatorExpression || element2 instanceof SqlFunctionCallExpression || element2 instanceof SqlReferenceExpression;
    }

    private static final boolean processCallHints$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$processCallHints(SqlColumnNamesInlayHintsProvider $this, SqlFunctionCallExpression callExpression, Function2 action) {
        $this.processCallHints(callExpression, (Function2<? super Integer, ? super String, Unit>)action);
    }

    public static final /* synthetic */ void access$processResultSetHints(SqlColumnNamesInlayHintsProvider $this, PsiElement element2, InlayTreeSink sink, Function2 action) {
        $this.processResultSetHints(element2, sink, (Function2<? super Integer, ? super String, Unit>)action);
    }

    public static final /* synthetic */ boolean access$shouldShowHintsForExpression(SqlColumnNamesInlayHintsProvider $this, PsiElement element2) {
        return $this.shouldShowHintsForExpression(element2);
    }

    public static final /* synthetic */ String access$guessExpressionName(SqlColumnNamesInlayHintsProvider $this, SqlSelectClause selectClause, int index2) {
        return $this.guessExpressionName(selectClause, index2);
    }
}

