/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.highlighting;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandler;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dataFlow.FlowUtilKt;
import com.intellij.sql.dataFlow.instructions.SqlFlowGraph;
import com.intellij.sql.dataFlow.instructions.SqlInstruction;
import com.intellij.sql.dataFlow.instructions.SqlInstructionWithSource;
import com.intellij.sql.psi.SqlRaiseStatement;
import com.intellij.sql.psi.SqlReturnStatement;
import com.intellij.sql.psi.SqlRoutineDefinition;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.util.Consumer;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\fH\u0016J,\u0010\u0010\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\f2\u0014\u0010\u0011\u001a\u0010\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00020\u00020\f0\u0012H\u0014R\u000e\u0010\u0007\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/sql/highlighting/SqlHighlightExitPointsHandler;", "Lcom/intellij/codeInsight/highlighting/HighlightUsagesHandlerBase;", "Lcom/intellij/psi/PsiElement;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "target", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/psi/PsiFile;Lcom/intellij/psi/PsiElement;)V", "computeUsages", "", "targets", "", "getFeatureId", "", "getTargets", "selectTargets", "selectionConsumer", "Lcom/intellij/util/Consumer;", "intellij.database.sql.impl"})
public final class SqlHighlightExitPointsHandler
extends HighlightUsagesHandlerBase<PsiElement> {
    @NotNull
    private final PsiElement target;

    public SqlHighlightExitPointsHandler(@NotNull Editor editor2, @NotNull PsiFile file, @NotNull PsiElement target2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        super(editor2, file);
        this.target = target2;
    }

    @NotNull
    public String getFeatureId() {
        return "codeassists.highlight.return";
    }

    @NotNull
    public List<PsiElement> getTargets() {
        return CollectionsKt.listOf((Object)this.target);
    }

    protected void selectTargets(@NotNull List<? extends PsiElement> targets2, @NotNull Consumer<? super List<? extends PsiElement>> selectionConsumer) {
        Intrinsics.checkNotNullParameter(targets2, (String)"targets");
        Intrinsics.checkNotNullParameter(selectionConsumer, (String)"selectionConsumer");
        selectionConsumer.consume(targets2);
    }

    public void computeUsages(@NotNull List<? extends PsiElement> targets2) {
        Intrinsics.checkNotNullParameter(targets2, (String)"targets");
        SqlRoutineDefinition sqlRoutineDefinition = (SqlRoutineDefinition)PsiTreeUtil.getParentOfType((PsiElement)this.target, SqlRoutineDefinition.class);
        if (sqlRoutineDefinition == null) {
            return;
        }
        SqlRoutineDefinition routine2 = sqlRoutineDefinition;
        SqlFlowGraph flowGraph = FlowUtilKt.buildFlowGraph(routine2);
        int count = 0;
        for (SqlInstruction instruction2 : FlowUtilKt.findExitPoints(flowGraph)) {
            SqlInstructionWithSource sqlInstructionWithSource = instruction2 instanceof SqlInstructionWithSource ? (SqlInstructionWithSource)instruction2 : null;
            Object e2 = sqlInstructionWithSource != null ? sqlInstructionWithSource.getSource() : null;
            SqlStatement sqlStatement = e2 instanceof SqlStatement ? (SqlStatement)e2 : null;
            if (sqlStatement == null) {
                return;
            }
            SqlStatement statement2 = sqlStatement;
            if (!(statement2 instanceof SqlReturnStatement) && !(statement2 instanceof SqlRaiseStatement)) continue;
            this.addOccurrence((PsiElement)statement2);
            ++count;
        }
        Object[] objectArray = new Object[]{count, HighlightUsagesHandler.getShortcutText()};
        this.myStatusText = CodeInsightBundle.message((String)"status.bar.exit.points.highlighted.message", (Object[])objectArray);
    }
}

