/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.postgres;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.database.Dbms;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlDialectImplUtilCore;
import com.intellij.sql.dialects.base.TokensHelper;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.dialects.postgres.Pg83Dialect;
import com.intellij.sql.dialects.postgres.PgElementFactory;
import com.intellij.sql.dialects.postgres.PgElementTypes;
import com.intellij.sql.dialects.postgres.PgTokens;
import com.intellij.sql.dialects.postgres.PgValidationDelegate;
import com.intellij.sql.editor.SqlValidatingHighlightVisitor;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDeleteStatement;
import com.intellij.sql.psi.SqlInsertStatement;
import com.intellij.sql.psi.SqlMergeStatement;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlUpdateStatement;
import com.intellij.sql.psi.impl.SqlCommentStatementImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlReferenceImpl;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PgDialect
extends Pg83Dialect {
    public static final PgDialect INSTANCE = new PgDialect();

    private PgDialect() {
        super("PostgreSQL");
    }

    @Override
    @NotNull
    protected TokensHelper createTokensHelper() {
        TokensHelper tokensHelper = this.createTokensHelper(PgTokens.class);
        if (tokensHelper == null) {
            PgDialect.$$$reportNull$$$0(0);
        }
        return tokensHelper;
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.POSTGRES;
        if (dbms == null) {
            PgDialect.$$$reportNull$$$0(1);
        }
        return dbms;
    }

    public boolean isOperatorSupported(@Nullable IElementType tokenType) {
        return tokenType != null && LazyData.ourSupportedOperators.contains(tokenType);
    }

    @NotNull
    public Set<String> getSystemVariables() {
        Set<String> set = LazyData.ourSystemVars;
        if (set == null) {
            PgDialect.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    public Set<String> getExceptionNames() {
        Set<String> set = LazyData.ourExceptionNames;
        if (set == null) {
            PgDialect.$$$reportNull$$$0(3);
        }
        return set;
    }

    @Override
    @NotNull
    public JBIterable<ObjectKind> getExtraKindsStrict(@NotNull SqlReferenceImpl reference) {
        if (reference == null) {
            PgDialect.$$$reportNull$$$0(4);
        }
        if (reference.getReferenceElementType().getTargetKind() == ObjectKind.COLUMN && reference.getElement().getParent() instanceof SqlCommentStatementImpl) {
            JBIterable jBIterable = JBIterable.of((Object)ObjectKind.OBJECT_ATTRIBUTE);
            if (jBIterable == null) {
                PgDialect.$$$reportNull$$$0(5);
            }
            return jBIterable;
        }
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            PgDialect.$$$reportNull$$$0(6);
        }
        return jBIterable;
    }

    @Override
    public boolean processReservedEntitiesWithType(@Nullable String name2, @NotNull PsiElement place, boolean resolve2, @NotNull SqlScopeProcessor processor2) {
        if (place == null) {
            PgDialect.$$$reportNull$$$0(7);
        }
        if (processor2 == null) {
            PgDialect.$$$reportNull$$$0(8);
        }
        if (!super.processReservedEntitiesWithType(name2, place, resolve2, processor2)) {
            return false;
        }
        if (!SqlImplUtil.processExcludedRefInInsertConflict(name2, place, resolve2, processor2, LazyData.RE_EXCLUDED)) {
            return false;
        }
        if (PgDialect.isSamplingMethodRef(place)) {
            for (ReservedEntity sm : LazyData.RE_SAMPLING_METHODS) {
                if (PgDialect.processReservedEntitiesWithTypeSimple(sm, DasTypeSystemBase.REFERENCE, name2, place, resolve2, processor2, false, null)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isSamplingMethodRef(@Nullable PsiElement place) {
        SqlReferenceExpression ref2 = (SqlReferenceExpression)ObjectUtils.tryCast((Object)place, SqlReferenceExpression.class);
        SqlReferenceElementType refType = ref2 == null ? null : ref2.getReferenceElementType();
        return refType == PgElementTypes.Extra.PG_SAMPLING_METHOD_REFERENCE;
    }

    public boolean isResolveTargetNotAccepted(@Nullable DasSymbol symbol, ObjectKind type2, @NotNull Set<ObjectKind> expectedTypes, @Nullable PsiElement place, boolean strict, boolean isCompletion) {
        if (expectedTypes == null) {
            PgDialect.$$$reportNull$$$0(9);
        }
        if (expectedTypes.contains(SqlDbElementType.ROUTINE) && symbol != null && PgDialect.isSamplingMethodRef(place) && !PgDialect.isSamplingMethod(symbol)) {
            return true;
        }
        return super.isResolveTargetNotAccepted(symbol, type2, expectedTypes, place, strict, isCompletion);
    }

    @Override
    @NotNull
    public Collection<ObjectKind> getMajorChildKinds() {
        Collection<ObjectKind> collection2 = LazyData.MAJOR_CHILD_KINDS;
        if (collection2 == null) {
            PgDialect.$$$reportNull$$$0(10);
        }
        return collection2;
    }

    @Override
    public boolean shouldSkipFromQualification(@NotNull ObjectKind kind) {
        if (kind == null) {
            PgDialect.$$$reportNull$$$0(11);
        }
        return super.shouldSkipFromQualification(kind) || kind == SqlDbElementType.FOREIGN_DATA_WRAPPER;
    }

    @Override
    @Nullable
    public IElementType getFunctionParserExtension(@NotNull String name2) {
        IElementType res2;
        if (name2 == null) {
            PgDialect.$$$reportNull$$$0(12);
        }
        return (res2 = PgElementFactory.findComposite(name2)) == null ? super.getFunctionParserExtension(name2) : res2;
    }

    @Override
    public boolean isTableAliasAllowedAt(@NotNull PsiElement element2) {
        if (element2 == null) {
            PgDialect.$$$reportNull$$$0(13);
        }
        return super.isTableAliasAllowedAt(element2) || PsiTreeUtil.getContextOfType((PsiElement)element2, (Class[])new Class[]{SqlDeleteStatement.class, SqlUpdateStatement.class, SqlInsertStatement.class, SqlMergeStatement.class}) != null;
    }

    @Override
    @Nullable
    public SqlValidatingHighlightVisitor.Delegate createValidationDelegate(@NotNull HighlightInfoHolder holder) {
        if (holder == null) {
            PgDialect.$$$reportNull$$$0(14);
        }
        return new PgValidationDelegate(this, holder);
    }

    private static boolean isSamplingMethod(@NotNull DasSymbol symbol) {
        DasObject dasObject;
        if (symbol == null) {
            PgDialect.$$$reportNull$$$0(15);
        }
        if ((dasObject = symbol.getDasObject()) instanceof ReservedEntity && LazyData.RE_SAMPLING_METHODS.contains((ReservedEntity)dasObject)) {
            return true;
        }
        DasRoutine foo = (DasRoutine)ObjectUtils.tryCast((Object)dasObject, DasRoutine.class);
        if (foo == null) {
            return false;
        }
        DasArgument arg = (DasArgument)SqlFunctionsUtil.getAcceptedArguments(foo).single();
        DasArgument ret = foo.getReturnArgument();
        if (arg == null || ret == null || foo.getRoutineKind() != DasRoutine.Kind.FUNCTION) {
            return false;
        }
        return "internal".equalsIgnoreCase(arg.getDasType().getSpecification()) && "tsm_handler".equalsIgnoreCase(ret.getDasType().getSpecification());
    }

    @Override
    @NotNull
    protected List<ReservedEntity> getReservedObjects() {
        List<ReservedEntity> list = LazyData.ourObjects;
        if (list == null) {
            PgDialect.$$$reportNull$$$0(16);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4, 7, 8, 9, 11, 12, 13, 14, 15 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/postgres/PgDialect";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypes";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createTokensHelper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemVariables";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExceptionNames";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/postgres/PgDialect";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtraKindsStrict";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getMajorChildKinds";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getReservedObjects";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getExtraKindsStrict";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processReservedEntitiesWithType";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isResolveTargetNotAccepted";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "shouldSkipFromQualification";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionParserExtension";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isTableAliasAllowedAt";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createValidationDelegate";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isSamplingMethod";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 4, 7, 8, 9, 11, 12, 13, 14, 15 -> new IllegalArgumentException(string);
        };
    }

    static final class LazyData {
        static final ObjectName PUBLIC_NAME = ObjectName.quoted("public");
        static final Set<String> ourSystemVars = Collections.unmodifiableSet(SqlDialectImplUtilCore.loadSystemVars(INSTANCE));
        static final Set<String> ourExceptionNames = Collections.unmodifiableSet(SqlDialectImplUtilCore.loadTokens(INSTANCE, "exceptions.txt"));
        static final List<ReservedEntity> ourObjects = SqlDialectImplUtilCore.loadObjects(INSTANCE, "fallback.txt");
        static final Set<IElementType> ourSupportedOperators = Set.of(SqlTokens.SQL_QUESTION_MARK, SqlTokens.PG_OP_ABS, SqlTokens.SQL_OP_NOT2, SqlTokens.PG_OP_BITWISE_XOR, SqlTokens.SQL_OP_INVERT, SqlTokens.SQL_OP_LOGICAL_AND, SqlTokens.SQL_OP_CONCAT, SqlTokens.SQL_OP_NULLSAFE_EQ, SqlTokens.SQL_OP_LEFT_SHIFT, SqlTokens.SQL_OP_RIGHT_SHIFT, SqlTokens.SQL_OP_BITWISE_AND, SqlTokens.SQL_OP_BITWISE_OR, SqlTokens.PG_OP_PRIME, SqlTokens.PG_OP_CUSTOM, SqlTokens.SQL_OP_PLUS, SqlTokens.SQL_OP_MINUS, SqlTokens.SQL_OP_MUL, SqlTokens.SQL_OP_DIV, SqlTokens.SQL_OP_LT, SqlTokens.SQL_OP_GT, SqlTokens.SQL_OP_PLUS_EQ, SqlTokens.SQL_OP_MINUS_EQ, SqlTokens.SQL_OP_MUL_EQ, SqlTokens.SQL_OP_DIV_EQ, SqlTokens.SQL_OP_LE, SqlTokens.SQL_OP_GE, SqlTokens.SQL_OP_EQEQ, SqlTokens.SQL_OP_NEQ3, SqlTokens.SQL_OP_MODULO_EQ, SqlTokens.SQL_OP_BITWISE_AND_EQ, SqlTokens.SQL_OP_BITWISE_OR_EQ, SqlTokens.SQL_OP_EQ, SqlTokens.SQL_OP_MODULO, SqlTokens.SQL_OP_BITWISE_XOR, SqlTokens.SQL_OP_NEQ, SqlTokens.SQL_OP_NEQ2);
        static final ReservedEntity RE_EXCLUDED = new ReservedEntity(Dbms.POSTGRES, "excluded", SqlDbElementType.TABLE);
        static final List<ReservedEntity> RE_SAMPLING_METHODS = Arrays.asList(new ReservedEntity(Dbms.POSTGRES, "bernoulli", SqlDbElementType.ROUTINE), new ReservedEntity(Dbms.POSTGRES, "system", SqlDbElementType.ROUTINE));
        private static final Collection<ObjectKind> MAJOR_CHILD_KINDS = Arrays.asList(SqlDbElementType.KEY, SqlDbElementType.INDEX, SqlDbElementType.TRIGGER, SqlDbElementType.RULE, SqlDbElementType.POLICY, SqlDbElementType.SERVER);

        LazyData() {
        }
    }
}

